/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.attachment;

import com.vicmatskiv.pointblank.Nameable;
import com.vicmatskiv.pointblank.attachment.Attachment;
import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.feature.FeatureProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public interface AttachmentHost
extends ItemLike,
Nameable,
FeatureProvider {
    public static final int DEFAULT_MAX_ATTACHMENT_CATEGORIES = 6;

    public Collection<Attachment> getCompatibleAttachments();

    default public Collection<Attachment> getDefaultAttachments() {
        return Collections.emptyList();
    }

    default public Collection<AttachmentCategory> getCompatibleAttachmentCategories() {
        return this.getCompatibleAttachments().stream().map(a -> a.getCategory()).toList();
    }

    default public int getMaxAttachmentCategories() {
        return 6;
    }

    default public List<Component> getCompatibleAttachmentTooltipLines(ItemStack itemStack) {
        ArrayList<Component> tooltipLines = new ArrayList<Component>();
        tooltipLines.add((Component)Component.m_237119_());
        Collection<Attachment> compatibleAttachments = this.getCompatibleAttachments();
        if (compatibleAttachments.isEmpty()) {
            tooltipLines.add((Component)Component.m_237115_((String)"label.pointblank.noCompatibleAttachments").m_6270_(Style.f_131099_.m_178520_(0xAAAAAA).m_131155_(Boolean.valueOf(true)).m_131162_(Boolean.valueOf(false))));
        } else {
            tooltipLines.add((Component)Component.m_237115_((String)"label.pointblank.compatibleAttachments").m_130946_(":").m_130940_(ChatFormatting.WHITE).m_130940_(ChatFormatting.ITALIC));
            for (Attachment attachment : compatibleAttachments) {
                tooltipLines.add((Component)Component.m_237115_((String)attachment.m_5456_().m_5524_()).m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.ITALIC));
            }
        }
        return tooltipLines;
    }
}

