/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.vicmatskiv.pointblank.client.ClientSystem;
import com.vicmatskiv.pointblank.client.render.RenderTypeKey;
import com.vicmatskiv.pointblank.client.render.RenderTypeProvider;
import com.vicmatskiv.pointblank.compat.iris.IrisCompat;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;

public class DefaultRenderTypeProvider
extends RenderStateShard
implements RenderTypeProvider {
    private static DefaultRenderTypeProvider instance;
    private static Optional<ShaderInstance> posTexColorShader;
    private static Optional<ShaderInstance> auxShader;
    private Function<RenderTypeKey, RenderType> pipRenderTypes = Util.m_143827_(key -> DefaultRenderTypeProvider.createPipRenderType(key));
    private final Function<RenderTypeKey, RenderType> pipOverlayRenderTypes = Util.m_143827_(DefaultRenderTypeProvider::createPipOverlayRenderType);
    private final Function<RenderTypeKey, RenderType> pipShutterOverlayRenderTypes = Util.m_143827_(DefaultRenderTypeProvider::createPipShutterOverlayRenderType);
    private final Function<RenderTypeKey, RenderType> pipMaskRenderTypes = Util.m_143827_(DefaultRenderTypeProvider::createPipMaskRenderType);
    private Function<ResourceLocation, RenderType> muzzleFlashRenderTypes = Util.m_143827_(texture -> DefaultRenderTypeProvider.createMuzzleFlashRenderType(texture));
    private Function<ResourceLocation, RenderType> reticleRenderTypes = Util.m_143827_(texture -> DefaultRenderTypeProvider.createReticleRenderType(texture));
    private Function<ResourceLocation, RenderType> reticleRenderTypesWithParallax = Util.m_143827_(texture -> DefaultRenderTypeProvider.createReticleRenderType(texture, ClientSystem.getInstance()::getTexColorShaderInstance));
    private Function<ResourceLocation, RenderType> glowEntityRenderTypes = Util.m_143827_(texture -> GlowEntityRenderType.createRenderType(texture));
    private final Function<RenderTypeKey, RenderType> defaultItemRenderTypes = Util.m_143827_(DefaultRenderTypeProvider::createDefaultItemRenderType);
    private static final PipTextureStateShard PIP_TEXTURE_STATE_SHARD;

    public static DefaultRenderTypeProvider getInstance() {
        if (instance == null) {
            instance = new DefaultRenderTypeProvider();
        }
        return instance;
    }

    public DefaultRenderTypeProvider() {
        super(null, null, null);
    }

    @Override
    public RenderType getDefaultItemRenderType(RenderTypeKey key) {
        return this.defaultItemRenderTypes.apply(key);
    }

    @Override
    public RenderType getPipRenderType(RenderTypeKey key) {
        return this.pipRenderTypes.apply(key);
    }

    @Override
    public RenderType getPipOverlayRenderType(RenderTypeKey key) {
        return this.pipOverlayRenderTypes.apply(key);
    }

    @Override
    public RenderType getPipShutterOverlayRenderType(RenderTypeKey key) {
        return this.pipShutterOverlayRenderTypes.apply(key);
    }

    @Override
    public RenderType getPipMaskRenderType(RenderTypeKey key) {
        return this.pipMaskRenderTypes.apply(key);
    }

    @Override
    public RenderType getGlowRenderType(ResourceLocation texture) {
        return RenderType.m_234335_((ResourceLocation)texture, (boolean)true);
    }

    @Override
    public RenderType getMuzzleFlashRenderType(ResourceLocation texture) {
        return this.muzzleFlashRenderTypes.apply(texture);
    }

    @Override
    public RenderType getReticleRenderType(ResourceLocation texture, boolean isParallaxEnabled) {
        return isParallaxEnabled ? this.reticleRenderTypesWithParallax.apply(texture) : this.reticleRenderTypes.apply(texture);
    }

    @Override
    public RenderType getGlowBlockEntityRenderType(ResourceLocation texture) {
        if (IrisCompat.getInstance().isIrisLoaded()) {
            return RenderType.m_110473_((ResourceLocation)texture);
        }
        return this.glowEntityRenderTypes.apply(texture);
    }

    private static ShaderInstance getPosTexColorShader() {
        if (posTexColorShader != null) {
            return posTexColorShader.orElse(null);
        }
        String shaderName = "pointblank_position_tex_color";
        try {
            Minecraft mc = Minecraft.m_91087_();
            posTexColorShader = Optional.of(new ShaderInstance((ResourceProvider)mc.m_91098_(), shaderName, DefaultVertexFormat.f_85819_));
        }
        catch (Exception e) {
            e.printStackTrace();
            posTexColorShader = Optional.empty();
        }
        return posTexColorShader.get();
    }

    private static ShaderInstance getAuxShader() {
        if (auxShader != null) {
            return auxShader.orElse(null);
        }
        String shaderName = "pointblank_aux";
        try {
            Minecraft mc = Minecraft.m_91087_();
            auxShader = Optional.of(new ShaderInstance((ResourceProvider)mc.m_91098_(), shaderName, DefaultVertexFormat.f_85819_));
        }
        catch (Exception e) {
            e.printStackTrace();
            auxShader = Optional.empty();
        }
        return auxShader.get();
    }

    private static RenderType createDefaultItemRenderType(RenderTypeKey key) {
        Consumer<RenderTypeKey> setup = key.isStencilEnabled() ? SETUP_STENCIL_RENDER : k -> {};
        Consumer<RenderTypeKey> clear = key.isStencilEnabled() ? CLEAR_STENCIL_RENDER : k -> {};
        return RenderTypeProvider.wrapAsCompositeRenderType(RenderType.m_110458_((ResourceLocation)key.texture()), () -> setup.accept(key), () -> clear.accept(key));
    }

    private static RenderType createPipRenderType(RenderTypeKey key) {
        Consumer<RenderTypeKey> setup = key.isStencilEnabled() ? SETUP_STENCIL_RENDER : k -> {};
        Consumer<RenderTypeKey> clear = key.isStencilEnabled() ? CLEAR_STENCIL_RENDER : k -> {};
        return RenderTypeProvider.wrapAsCompositeRenderType((RenderType)RenderType.m_173215_((String)("pointblank:pip_" + key), (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(DefaultRenderTypeProvider::getAuxShader)).m_173290_((RenderStateShard.EmptyTextureStateShard)PIP_TEXTURE_STATE_SHARD).m_110685_(f_110134_).m_110663_(f_110113_).m_110671_(f_110153_).m_110677_(f_110155_).m_110661_(f_110110_).m_110691_(true)), () -> setup.accept(key), () -> clear.accept(key));
    }

    private static RenderType createPipMaskRenderType(RenderTypeKey key) {
        return RenderTypeProvider.wrapAsCompositeRenderType((RenderType)RenderType.CompositeRenderType.m_173215_((String)("pointblank:pip_mask_" + key), (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(f_110134_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(key.texture(), false, false)).m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172820_)).m_110691_(false)), () -> RenderTypeProvider.SETUP_STENCIL_MASK_RENDER.accept(key), () -> RenderTypeProvider.CLEAR_STENCIL_MASK_RENDER.accept(key));
    }

    private static RenderType createPipOverlayRenderType(RenderTypeKey key) {
        Consumer<RenderTypeKey> setup = key.isStencilEnabled() ? SETUP_STENCIL_RENDER : k -> {};
        Consumer<RenderTypeKey> clear = key.isStencilEnabled() ? CLEAR_STENCIL_RENDER : k -> {};
        return RenderTypeProvider.wrapAsCompositeRenderType((RenderType)RenderType.m_173215_((String)("pointblank:pip_overlay_" + key), (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110153_).m_110677_(f_110155_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(key.texture(), false, false)).m_173292_(new RenderStateShard.ShaderStateShard(DefaultRenderTypeProvider::getPosTexColorShader)).m_110691_(false)), () -> setup.accept(key), () -> clear.accept(key));
    }

    private static RenderType createPipShutterOverlayRenderType(RenderTypeKey key) {
        return RenderTypeProvider.wrapAsCompositeRenderType((RenderType)RenderType.CompositeRenderType.m_173215_((String)("pointblank:pip_shutter_" + key), (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(f_110134_).m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172811_)).m_110691_(false)), () -> RenderTypeProvider.SETUP_STENCIL_MASK_UPDATE_RENDER.accept(key), () -> RenderTypeProvider.CLEAR_STENCIL_MASK_RENDER.accept(key));
    }

    private static RenderType createMuzzleFlashRenderType(ResourceLocation texture) {
        return RenderType.m_173215_((String)"pointblank:muzzle_flash", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(f_110136_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110152_).m_110677_(f_110154_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(ClientSystem.getInstance()::getColorTexLightmapShaderInstance)).m_110691_(false));
    }

    private static RenderType createReticleRenderType(ResourceLocation texture, Supplier<ShaderInstance> shaderSupplier) {
        return RenderType.m_173215_((String)"pointblank:reticle_parallax", (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110153_).m_110677_(f_110155_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(shaderSupplier::get)).m_110691_(false));
    }

    private static RenderType createReticleRenderType(ResourceLocation reticleResource) {
        return RenderType.m_173215_((String)"pointblank:reticle", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(f_110139_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110152_).m_110677_(f_110154_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(reticleResource, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(ClientSystem.getInstance()::getColorTexLightmapShaderInstance)).m_110691_(false));
    }

    static {
        PIP_TEXTURE_STATE_SHARD = new PipTextureStateShard();
    }

    private static class PipTextureStateShard
    extends RenderStateShard.EmptyTextureStateShard {
        public PipTextureStateShard() {
            super(() -> {
                int textureId = ClientSystem.getInstance().getAuxLevelRenderer().getRenderTarget().m_83975_();
                RenderSystem.setShaderTexture((int)0, (int)textureId);
            }, () -> {});
        }
    }

    private static final class GlowEntityRenderType
    extends RenderType {
        public GlowEntityRenderType(String renderTypeName, VertexFormat p_173179_, VertexFormat.Mode p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
            super(renderTypeName, p_173179_, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
        }

        private static RenderType createRenderType(ResourceLocation texture) {
            return RenderType.m_173215_((String)"pointblank:glowy_entity_block", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(f_110136_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(RenderStateShard.f_173101_).m_110691_(false));
        }
    }
}

