/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.client.ClientSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;

public class RenderUtil {
    private static final double FOV_NORMAL_DEGREES = 70.0;
    private static Matrix4f projectionMatrix;
    private static Matrix4f projectionMatrixInverted;
    private static Matrix4f modelViewMatrix;
    private static Matrix4f modelViewMatrixInverted;

    public static void renderQuad(PoseStack poseStack, GeoQuad quad, VertexConsumer buffer, float dx, float dy, float red, float green, float blue, float alpha) {
        Matrix4f poseState = poseStack.m_85850_().m_252922_();
        float[][] texUV = new float[][]{{1.0f + dx, 0.0f + dy}, {0.0f + dx, 0.0f + dy}, {0.0f + dx, 1.0f + dy}, {1.0f + dx, 1.0f + dy}};
        for (int i = 0; i < 4; ++i) {
            GeoVertex vertex = quad.vertices()[i];
            float u = Mth.m_14036_((float)texUV[i][0], (float)0.0f, (float)1.0f);
            float v = Mth.m_14036_((float)texUV[i][1], (float)0.0f, (float)1.0f);
            buffer.m_252986_(poseState, vertex.position().x, vertex.position().y, vertex.position().z).m_7421_(u, v).m_85950_(red, green, blue, alpha).m_5752_();
        }
    }

    public static float estimateQuadScreenHeightFraction(PoseStack poseStack, GeoQuad quad) {
        if (poseStack == null || quad == null) {
            return -1.0f;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.m_91268_() == null) {
            return -1.0f;
        }
        int framebufferHeight = mc.m_91268_().m_85442_();
        int framebufferWidth = mc.m_91268_().m_85441_();
        if (framebufferWidth <= 0 || framebufferHeight <= 0) {
            return -1.0f;
        }
        Matrix4f projection = RenderSystem.getProjectionMatrix();
        if (projection == null) {
            return -1.0f;
        }
        Matrix4f mvp = new Matrix4f((Matrix4fc)projection).mul((Matrix4fc)poseStack.m_85850_().m_252922_());
        float minY = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        boolean any = false;
        GeoVertex[] vertices = quad.vertices();
        if (vertices == null || vertices.length < 4) {
            return -1.0f;
        }
        for (int i = 0; i < 4; ++i) {
            GeoVertex v = vertices[i];
            if (v == null || v.position() == null) continue;
            Vector3f p = v.position();
            Vector4f clip = mvp.transform(new Vector4f(p.x, p.y, p.z, 1.0f));
            float w = clip.w();
            if (Math.abs(w) < 1.0E-5f) continue;
            float ndcY = clip.y() / w;
            float yPx = (1.0f - (ndcY * 0.5f + 0.5f)) * (float)framebufferHeight;
            minY = Math.min(minY, yPx);
            maxY = Math.max(maxY, yPx);
            any = true;
        }
        if (!any) {
            return -1.0f;
        }
        float heightPx = maxY - minY;
        if (!Float.isFinite(heightPx) || heightPx <= 0.0f) {
            return -1.0f;
        }
        float frac = heightPx / (float)framebufferHeight;
        if (!Float.isFinite(frac)) {
            return -1.0f;
        }
        return Mth.m_14036_((float)frac, (float)0.01f, (float)1.0f);
    }

    public static void renderQuadColorTex(PoseStack poseStack, GeoQuad quad, VertexConsumer buffer, float dx, float dy, float red, float green, float blue, float alpha) {
        Matrix4f poseState = poseStack.m_85850_().m_252922_();
        float[][] texUV = new float[][]{{1.0f + dx, 0.0f + dy}, {0.0f + dx, 0.0f + dy}, {0.0f + dx, 1.0f + dy}, {1.0f + dx, 1.0f + dy}};
        for (int i = 0; i < 4; ++i) {
            GeoVertex vertex = quad.vertices()[i];
            float u = Mth.m_14036_((float)texUV[i][0], (float)0.0f, (float)1.0f);
            float v = Mth.m_14036_((float)texUV[i][1], (float)0.0f, (float)1.0f);
            buffer.m_252986_(poseState, vertex.position().x, vertex.position().y, vertex.position().z).m_85950_(red, green, blue, alpha).m_7421_(u, v).m_86008_(655360).m_85969_(0xF00000).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        }
    }

    public static void renderColoredQuad(PoseStack poseStack, GeoQuad quad, VertexConsumer buffer, float red, float green, float blue, float alpha) {
        Matrix4f poseState = poseStack.m_85850_().m_252922_();
        for (int i = 0; i < 4; ++i) {
            GeoVertex v = quad.vertices()[i];
            buffer.m_252986_(poseState, v.position().x, v.position().y, v.position().z).m_85950_(red, green, blue, alpha).m_5752_();
        }
    }

    public static GeoQuad resizeQuad(GeoQuad inputQuad, float size) {
        GeoVertex[] inputVertices;
        Vector3f center = new Vector3f();
        for (GeoVertex vertex : inputVertices = inputQuad.vertices()) {
            center.add((Vector3fc)vertex.position());
        }
        center.div((float)inputVertices.length);
        GeoVertex[] newVertices = new GeoVertex[inputVertices.length];
        for (int i = 0; i < inputVertices.length; ++i) {
            GeoVertex vertex = inputVertices[i];
            Vector3f direction = new Vector3f((Vector3fc)vertex.position()).sub((Vector3fc)center);
            Vector3f newPosition = new Vector3f((Vector3fc)center).add((Vector3fc)direction.mul(size));
            newVertices[i] = new GeoVertex(newPosition, vertex.texU(), vertex.texV());
        }
        return new GeoQuad(newVertices, inputQuad.normal(), inputQuad.direction());
    }

    public static void blit(GuiGraphics guiGraphics, ResourceLocation textureResource, float posX, float posY, int zLevel, float minU, float minV, int width, int height, int actualWidth, int actualHeight) {
        RenderUtil.blit(guiGraphics, textureResource, posX, posX + (float)width, posY, posY + (float)height, zLevel, width, height, minU, minV, actualWidth, actualHeight);
    }

    public static void blit(GuiGraphics guiGraphics, ResourceLocation textureResource, float posXStart, float posXEnd, float posYStart, float posYEnd, int zLevel, int width, int height, float minU, float minV, int actualWidth, int actualHeight) {
        RenderUtil.blit(guiGraphics, textureResource, posXStart, posXEnd, posYStart, posYEnd, (float)zLevel, (minU + 0.0f) / (float)actualWidth, (minU + (float)width) / (float)actualWidth, (minV + 0.0f) / (float)actualHeight, (minV + (float)height) / (float)actualHeight);
    }

    public static void blit(GuiGraphics guiGraphics, ResourceLocation textureResource, float posXStart, float posXEnd, float posYStart, float posYEnd, float zLevel, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureResource);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, posXStart, posYStart, zLevel).m_7421_(minU, minV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, posXStart, posYEnd, zLevel).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, posXEnd, posYEnd, zLevel).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, posXEnd, posYStart, zLevel).m_7421_(maxU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void blit(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int startX, int endX, int startY, int endY, int zLevel, float minU, float maxU, float minV, float maxV, float colorR, float colorG, float colorB, float alpha) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
        RenderSystem.setShader(Config.customShadersEnabled ? ClientSystem.getInstance()::getTexColorShaderInstance : GameRenderer::m_172820_);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_252986_(matrix4f, (float)startX, (float)startY, (float)zLevel).m_7421_(minU, minV).m_85950_(colorR, colorG, colorB, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)startX, (float)endY, (float)zLevel).m_7421_(minU, maxV).m_85950_(colorR, colorG, colorB, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)endX, (float)endY, (float)zLevel).m_7421_(maxU, maxV).m_85950_(colorR, colorG, colorB, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)endX, (float)startY, (float)zLevel).m_7421_(maxU, minV).m_85950_(colorR, colorG, colorB, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static Matrix4f getProjectionMatrixInverted() {
        Matrix4f projectionMatrixNew = RenderSystem.getProjectionMatrix();
        if (projectionMatrixNew == null || projectionMatrixNew != projectionMatrix) {
            projectionMatrix = projectionMatrixNew;
            projectionMatrixInverted = new Matrix4f((Matrix4fc)projectionMatrixNew).invert();
        }
        return projectionMatrixInverted;
    }

    public static Matrix4f getModelViewMatrixInverted() {
        Matrix4f modelViewMatrixNew = RenderSystem.getModelViewMatrix();
        if (modelViewMatrixNew == null || modelViewMatrixNew != modelViewMatrix) {
            modelViewMatrix = modelViewMatrixNew;
            modelViewMatrixInverted = new Matrix4f((Matrix4fc)modelViewMatrixNew).invert();
        }
        return modelViewMatrixInverted;
    }

    public static Matrix4f getProjectionMatrixNormalFov() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91063_.m_253088_(70.0);
    }
}

