/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.network;

import com.vicmatskiv.pointblank.attachment.AttachmentHost;
import com.vicmatskiv.pointblank.inventory.AttachmentContainerMenu;
import com.vicmatskiv.pointblank.inventory.CraftingContainerMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class ServerBoundOpenScreenPacket {
    private ScreenType screenType;

    public ServerBoundOpenScreenPacket(ScreenType sreenType) {
        this.screenType = sreenType;
    }

    public ServerBoundOpenScreenPacket() {
    }

    public static void encode(ServerBoundOpenScreenPacket packet, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)packet.screenType);
    }

    public static ServerBoundOpenScreenPacket decode(FriendlyByteBuf buf) {
        return new ServerBoundOpenScreenPacket((ScreenType)buf.m_130066_(ScreenType.class));
    }

    public static void handle(ServerBoundOpenScreenPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            switch (packet.screenType) {
                case CRAFTING: {
                    NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, p) -> new CraftingContainerMenu(windowId, playerInventory), (Component)Component.m_237115_((String)"screen.pointblank.crafting")));
                    break;
                }
                case ATTACHMENTS: {
                    ItemStack heldItem = player.m_21205_();
                    if (player == null || !(heldItem.m_41720_() instanceof AttachmentHost)) break;
                    NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, p) -> new AttachmentContainerMenu(windowId, playerInventory, heldItem), (Component)Component.m_237115_((String)"screen.pointblank.attachments")));
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static enum ScreenType {
        ATTACHMENTS,
        CRAFTING;

    }
}

