/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.Enableable;
import com.vicmatskiv.pointblank.Nameable;
import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.attachment.Attachment;
import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.attachment.AttachmentHost;
import com.vicmatskiv.pointblank.attachment.AttachmentModelInfo;
import com.vicmatskiv.pointblank.attachment.Attachments;
import com.vicmatskiv.pointblank.client.BiDirectionalInterpolator;
import com.vicmatskiv.pointblank.client.ClientSystem;
import com.vicmatskiv.pointblank.client.FirstPersonWalkingAnimationHandler;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.GunStateTicker;
import com.vicmatskiv.pointblank.client.LockableTarget;
import com.vicmatskiv.pointblank.client.RealtimeLinearEaser;
import com.vicmatskiv.pointblank.client.ThrowableClientState;
import com.vicmatskiv.pointblank.client.controller.AbstractProceduralAnimationController;
import com.vicmatskiv.pointblank.client.controller.GunJumpAnimationController;
import com.vicmatskiv.pointblank.client.controller.GunRandomizingAnimationController;
import com.vicmatskiv.pointblank.client.controller.GunRecoilAnimationController;
import com.vicmatskiv.pointblank.client.controller.InertiaController;
import com.vicmatskiv.pointblank.client.controller.PostPassEffectController;
import com.vicmatskiv.pointblank.client.controller.PryAnimationController;
import com.vicmatskiv.pointblank.client.controller.TimerController;
import com.vicmatskiv.pointblank.client.controller.ViewShakeAnimationController2;
import com.vicmatskiv.pointblank.client.gui.AttachmentManagerScreen;
import com.vicmatskiv.pointblank.client.gui.GunItemOverlay;
import com.vicmatskiv.pointblank.client.render.CrosshairRenderer;
import com.vicmatskiv.pointblank.client.render.RenderUtil;
import com.vicmatskiv.pointblank.compat.playeranimator.PlayerAnimatorCompat;
import com.vicmatskiv.pointblank.event.InputEvent;
import com.vicmatskiv.pointblank.event.LevelEvent;
import com.vicmatskiv.pointblank.event.LivingEvent;
import com.vicmatskiv.pointblank.event.RenderGuiEventPost;
import com.vicmatskiv.pointblank.event.RenderGuiOverlayEvent;
import com.vicmatskiv.pointblank.event.RenderHandEvent;
import com.vicmatskiv.pointblank.event.RenderHandsEvent;
import com.vicmatskiv.pointblank.event.RenderLevelEvent;
import com.vicmatskiv.pointblank.event.RenderLivingEvent;
import com.vicmatskiv.pointblank.event.RenderTooltipEvent;
import com.vicmatskiv.pointblank.event.SubscribeEvent2;
import com.vicmatskiv.pointblank.event.TickEvent;
import com.vicmatskiv.pointblank.event.ViewportEvent;
import com.vicmatskiv.pointblank.explosion.ExplosionEvent;
import com.vicmatskiv.pointblank.feature.AimingFeature;
import com.vicmatskiv.pointblank.feature.FeatureProvider;
import com.vicmatskiv.pointblank.item.ExplosionDescriptor;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.item.ItemExtra;
import com.vicmatskiv.pointblank.item.ThrowableItem;
import com.vicmatskiv.pointblank.network.AimingChangeRequestPacket;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.HitScan;
import com.vicmatskiv.pointblank.util.LazyOptional;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.UpDownCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5498;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_922;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionf;
import org.joml.Vector2ic;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.ClientUtils;

public class ClientEventHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    public static final Supplier<class_304> RELOAD_KEY = LazyOptional.of(() -> new class_304("key.pointblack.reload", class_3675.class_307.field_1668, 82, "key.categories.pointblank"));
    public static final Supplier<class_304> FIRE_MODE_KEY = LazyOptional.of(() -> new class_304("key.pointblack.firemode", class_3675.class_307.field_1668, 66, "key.categories.pointblank"));
    public static final Supplier<class_304> INSPECT_KEY = LazyOptional.of(() -> new class_304("key.pointblack.inspect", class_3675.class_307.field_1668, 73, "key.categories.pointblank"));
    public static final Supplier<class_304> ATTACHMENT_KEY = LazyOptional.of(() -> new class_304("key.pointblack.attachments", class_3675.class_307.field_1668, 89, "key.categories.pointblank"));
    public static final Supplier<class_304> SCOPE_SWITCH_KEY = LazyOptional.of(() -> new class_304("key.pointblack.scope_switch", class_3675.class_307.field_1668, 86, "key.categories.pointblank"));
    private static ReentrantLock mainLoopLock = new ReentrantLock();
    private InertiaController scopeInertiaController = new InertiaController(0.06, 0.2, 0.1);
    private InertiaController inertiaController = new InertiaController(0.01, 0.1, 1.2217304706573486);
    public static InertiaController reticleInertiaController = new InertiaController(0.005, 0.05, 1.0);
    private GunJumpAnimationController jumpController = new GunJumpAnimationController(0.3, 0.8, 1.3, 0.05, 2000L);
    private ViewShakeAnimationController2 sharedViewShakeController = new ViewShakeAnimationController2(0.15, 0.3, 1.0, 0.01, 500L);
    private int currentInventorySlot;
    private int previousInventorySlot;
    private boolean inventorySlotChanged;
    private boolean currentSlotHasGun;
    private boolean currentSlotHasGunChanged;
    private boolean leftMouseButtonDown = false;
    private boolean rightMouseButtonDown = false;
    private float previousPlayerXRot;
    private float previousPlayerYRot;
    private float playerDeltaXRot;
    private float playerDeltaYRot;
    private double previousPlayerPosX;
    private double previousPlayerPosY;
    private double previousPlayerPosZ;
    private double playerDeltaX;
    private double playerDeltaY;
    private double playerDeltaZ;
    private static class_1309 currentEntityLiving;
    private RealtimeLinearEaser bobbingValue = new RealtimeLinearEaser(200L);
    private RealtimeLinearEaser bobbingYawValue = new RealtimeLinearEaser(200L);
    private RealtimeLinearEaser zoomValue = new RealtimeLinearEaser(200L);
    private RealtimeLinearEaser crossHairExp = new RealtimeLinearEaser(100L);
    private LockableTarget lockableTarget = new LockableTarget();
    private static PostPassEffectController postPassEffectController;
    private static final class_2960 crossHairOverlay;
    private final FirstPersonWalkingAnimationHandler firstPersonWalkingAnimationHandler = new FirstPersonWalkingAnimationHandler();

    public ClientEventHandler() {
        this.startTicker();
    }

    private void startTicker() {
        GunStateTicker gunStateTicker = new GunStateTicker(this);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> gunStateTicker.shutdown()));
        gunStateTicker.start();
    }

    @SubscribeEvent2
    public void onWorldLoad(LevelEvent.Load event) {
        if (event.getLevel().method_8608()) {
            this.currentInventorySlot = -1;
        }
    }

    @SubscribeEvent2
    public void onExplosion(ExplosionEvent event) {
        double distanceToPlayer = event.getLocation().method_1022(ClientUtil.getClientPlayer().method_19538());
        ExplosionDescriptor descriptor = event.getExplosionDescriptor();
        distanceToPlayer = class_3532.method_15350((double)distanceToPlayer, (double)1.0, (double)Double.MAX_VALUE);
        double lambda = 0.2;
        double adjustedPower = (double)descriptor.power() * Math.exp(-lambda * distanceToPlayer);
        this.sharedViewShakeController.reset(adjustedPower, 0.5, 1.5, 0.01);
    }

    @SubscribeEvent2
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        class_1657 player = ClientUtils.getClientPlayer();
        if (event.getPhase() == TickEvent.Phase.START) {
            GunClientState state;
            mainLoopLock.lock();
            if (player != null && (state = GunClientState.getMainHeldState()) != null) {
                class_1799 gunStack = GunItem.getMainHeldGunItemStack((class_1309)player);
                class_310 mc = class_310.method_1551();
                state.renderTick((class_1309)player, gunStack, event.getPartialTick());
                if (!mc.field_1690.method_31044().method_31034()) {
                    return;
                }
                GunItem gunItem = state.getGunItem();
                class_811 itemDisplayContext = class_811.field_4322;
                this.inertiaController.onRenderTick((class_1309)player, state, gunStack, itemDisplayContext, event.getPartialTick());
                if (gunItem.getScopeOverlay() != null && state.isAiming() && state.isFiring()) {
                    this.scopeInertiaController.setDynamicModifier(0.01f);
                } else {
                    this.scopeInertiaController.setDynamicModifier(1.0f);
                }
                this.scopeInertiaController.onRenderTick((class_1309)player, state, gunStack, itemDisplayContext, event.getPartialTick());
                this.jumpController.onRenderTick((class_1309)player, state, gunStack, itemDisplayContext, event.getPartialTick());
                postPassEffectController.onRenderTick((class_1309)player, state, gunStack, itemDisplayContext, event.getPartialTick());
                this.sharedViewShakeController.onRenderTick((class_1309)player, state, gunStack, itemDisplayContext, event.getPartialTick());
            }
        } else if (event.getPhase() == TickEvent.Phase.END && mainLoopLock.isLocked()) {
            mainLoopLock.unlock();
        }
    }

    public static PostPassEffectController getPostPassEffectController() {
        return postPassEffectController;
    }

    private boolean autoReloadEnabled(class_1657 player) {
        Config.AutoReload autoReload = Config.autoReload;
        return autoReload == Config.AutoReload.ENABLED || autoReload == Config.AutoReload.CREATIVE && player.method_7337() || autoReload == Config.AutoReload.SURVIVAL && !player.method_7337();
    }

    @SubscribeEvent2
    public void onClientTick(TickEvent.ClientTickEvent event) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (event.getPhase() == TickEvent.Phase.START) {
            mainLoopLock.lock();
        } else if (event.getPhase() == TickEvent.Phase.END) {
            if (player != null) {
                GunClientState state;
                Enableable e;
                boolean isEnabled;
                boolean updatedSlotHasGun;
                this.playerDeltaX = player.method_23317() - this.previousPlayerPosX;
                this.playerDeltaY = player.method_23318() - this.previousPlayerPosY;
                this.playerDeltaZ = player.method_23321() - this.previousPlayerPosZ;
                this.previousPlayerPosX = player.method_23317();
                this.previousPlayerPosY = player.method_23318();
                this.previousPlayerPosZ = player.method_23321();
                this.playerDeltaXRot = player.method_36455() - this.previousPlayerXRot;
                this.playerDeltaYRot = player.method_36454() - this.previousPlayerYRot;
                this.previousPlayerXRot = player.method_36455();
                this.previousPlayerYRot = player.method_36454();
                class_1799 heldItem = player.method_6047();
                int activeSlot = player.method_31548().field_7545;
                if (activeSlot != this.currentInventorySlot) {
                    this.inventorySlotChanged = true;
                    this.previousInventorySlot = this.currentInventorySlot;
                    this.currentInventorySlot = activeSlot;
                } else {
                    this.inventorySlotChanged = false;
                }
                boolean bl = updatedSlotHasGun = heldItem != null && heldItem.method_7909() instanceof GunItem;
                if (updatedSlotHasGun != this.currentSlotHasGun) {
                    this.currentSlotHasGun = updatedSlotHasGun;
                    this.currentSlotHasGunChanged = true;
                } else {
                    this.currentSlotHasGunChanged = false;
                }
                class_1792 class_17922 = heldItem.method_7909();
                boolean bl2 = isEnabled = !(class_17922 instanceof Enableable) || (e = (Enableable)class_17922).isEnabled();
                if (isEnabled && this.autoReloadEnabled((class_1657)player) && heldItem.method_7909() instanceof GunItem && !this.inventorySlotChanged) {
                    Optional<Integer> optionalAmmo = GunItem.getClientSideAmmo((class_1657)player, heldItem, this.currentInventorySlot);
                    optionalAmmo.ifPresent(ammo -> {
                        if (ammo <= 0) {
                            ((GunItem)heldItem.method_7909()).tryReload((class_1657)player, heldItem);
                        }
                    });
                }
                while (isEnabled && RELOAD_KEY.get().method_1436() && !this.inventorySlotChanged) {
                    if (!(heldItem.method_7909() instanceof GunItem)) continue;
                    ((GunItem)heldItem.method_7909()).tryReload((class_1657)player, heldItem);
                }
                while (FIRE_MODE_KEY.get().method_1436()) {
                    state = GunClientState.getMainHeldState();
                    if (state == null) continue;
                    state.tryChangeFireMode((class_1309)player, player.method_6047());
                }
                while (INSPECT_KEY.get().method_1436() && !this.inventorySlotChanged) {
                    state = GunClientState.getMainHeldState();
                    if (state == null) continue;
                    state.tryInspect((class_1309)player, player.method_6047());
                }
                while (ATTACHMENT_KEY.get().method_1436()) {
                    if (heldItem == null || !(heldItem.method_7909() instanceof AttachmentHost)) continue;
                    Attachments.tryAttachmentMode((class_1657)player, heldItem);
                }
                boolean leftMouseButtonDown = mc.field_1690.field_1886.method_1434();
                if (leftMouseButtonDown && !this.leftMouseButtonDown) {
                    this.leftMouseDown();
                } else if (!leftMouseButtonDown && this.leftMouseButtonDown) {
                    this.leftMouseButtonRelease();
                }
                this.leftMouseButtonDown = leftMouseButtonDown;
                boolean rightMouseButtonDown = mc.field_1690.field_1904.method_1434();
                if (rightMouseButtonDown && !this.rightMouseButtonDown) {
                    this.rightMouseButtonDown();
                } else if (!rightMouseButtonDown && this.rightMouseButtonDown) {
                    this.rightMouseButtonRelease();
                }
                GunClientState state2 = GunClientState.getMainHeldState();
                while (SCOPE_SWITCH_KEY.get().method_1436()) {
                    if (heldItem == null || !(heldItem.method_7909() instanceof GunItem) || state2 == null || !state2.isAiming()) continue;
                    Attachments.tryNextAttachment((class_1657)player, heldItem, AttachmentCategory.SCOPE, AimingFeature.class);
                }
                if (heldItem.method_7909() instanceof LockableTarget.TargetLocker) {
                    this.lockableTarget.setLocker((LockableTarget.TargetLocker)heldItem.method_7909());
                } else {
                    this.lockableTarget.setLocker(null);
                }
                if (state2 != null && state2.isAiming() && state2.isIdle() && this.lockableTarget.getLockTimeTicks() > 0L) {
                    class_239 hitResult = HitScan.getNearestObjectInCrosshair((class_1309)player, 0.0f, 400.0, b -> false, b -> false, new ArrayList<class_2338>());
                    if (hitResult.method_17783() == class_239.class_240.field_1331) {
                        class_1297 hitScanEntity = ((class_3966)hitResult).method_17782();
                        if (MiscUtil.isProtected(hitScanEntity) || !this.lockableTarget.tryLock(hitScanEntity)) {
                            this.lockableTarget.unlock(hitScanEntity);
                        }
                    } else {
                        this.lockableTarget.unlock(null);
                    }
                } else {
                    this.lockableTarget.unlock(null);
                }
                if (this.inventorySlotChanged) {
                    Object previousState;
                    this.lockableTarget.unlock(null);
                    this.inertiaController.reset((class_1657)player);
                    this.scopeInertiaController.reset();
                    reticleInertiaController.reset();
                    if (this.previousInventorySlot >= 0) {
                        class_1792 class_17923;
                        class_1799 previousStack = player.method_31548().method_5438(this.previousInventorySlot);
                        if (previousStack != null && (class_17923 = previousStack.method_7909()) instanceof GunItem) {
                            AnimationController<GeoAnimatable> walkingController;
                            GunItem previousGunItem = (GunItem)class_17923;
                            previousState = GunClientState.getState((class_1657)player, previousStack, this.previousInventorySlot, false);
                            if (previousState != null) {
                                ((GunClientState)previousState).tryDeactivate((class_1309)player, previousStack);
                            }
                            if ((walkingController = previousGunItem.getGeoAnimationController("walking", previousStack)) != null) {
                                walkingController.tryTriggerAnimation("animation.model.standing");
                            }
                        } else if (previousStack != null && previousStack.method_7909() instanceof ThrowableItem && (previousState = ThrowableClientState.getState((class_1657)player, previousStack, this.previousInventorySlot, false)) != null) {
                            ((ThrowableClientState)previousState).tryDeactivate((class_1309)player, previousStack);
                        }
                    }
                    class_1799 mainHeldItem = player.method_6047();
                    if (state2 != null) {
                        state2.tryDraw((class_1309)player, mainHeldItem);
                        if (heldItem.method_7909() instanceof GunItem) {
                            this.firstPersonWalkingAnimationHandler.reset((class_1657)player, heldItem);
                        }
                    } else {
                        previousState = mainHeldItem.method_7909();
                        if (previousState instanceof ThrowableItem) {
                            ThrowableItem throwableItem = (ThrowableItem)previousState;
                            ThrowableClientState throwableState = ThrowableClientState.getMainHeldState();
                            if (throwableState != null) {
                                throwableState.tryDraw((class_1309)player, mainHeldItem);
                            }
                        }
                    }
                }
                if (this.inventorySlotChanged || this.currentSlotHasGunChanged) {
                    this.jumpController.reset();
                }
                this.leftMouseButtonDown = leftMouseButtonDown;
                this.rightMouseButtonDown = rightMouseButtonDown;
            }
            mainLoopLock.unlock();
        }
    }

    @SubscribeEvent2
    public void onRenderLivingEvent(RenderLivingEvent.Pre<class_1309, class_583<class_1309>> e) {
        currentEntityLiving = e.getEntity();
        if (e.getEntity() instanceof class_1657) {
            class_1657 player = (class_1657)e.getEntity();
            class_1799 itemStack = player.method_6047();
            int activeSlot = player.method_31548().field_7545;
            if (itemStack != null && itemStack.method_7909() instanceof GunItem && !PlayerAnimatorCompat.getInstance().isEnabled()) {
                class_922 r;
                class_583 model;
                GunClientState gunClientState = GunClientState.getState(player, itemStack, activeSlot, false);
                if ((Config.thirdPersonArmPoseAlwaysOn || gunClientState != null && (gunClientState.isAiming() || gunClientState.isFiring())) && (model = (r = e.getRenderer()).method_4038()) instanceof class_591) {
                    class_591 playerModel = (class_591)model;
                    playerModel.field_3395 = class_572.class_573.field_3403;
                }
            }
            class_310 mc = class_310.method_1551();
            this.handlePlayerFirstPersonMovement(player, itemStack);
            if (Config.thirdPersonAnimationsEnabled) {
                PlayerAnimatorCompat.getInstance().handlePlayerThirdPersonMovement(player, mc.field_1728.field_1970);
            } else {
                PlayerAnimatorCompat.getInstance().clearAll(player);
            }
        }
    }

    public static class_1309 getCurrentEntityLiving() {
        return currentEntityLiving;
    }

    @SubscribeEvent2
    public void onRenderGameOverlay(RenderGuiEventPost event) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        if (mc.field_1755 instanceof AttachmentManagerScreen) {
            return;
        }
        class_1799 stack = mc.field_1724.method_6047();
        class_332 guiGraphics = event.getGuiGraphics();
        if (stack != null && stack.method_7909() instanceof GunItem) {
            GunItemOverlay.renderGunOverlay2(guiGraphics, stack);
        }
    }

    @SubscribeEvent2
    public void onFovUpdate(ViewportEvent.ComputeFov event) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null || minecraft.field_1724.method_6047().method_7960() || minecraft.field_1690.method_31044() != class_5498.field_26664) {
            return;
        }
        class_1799 itemStack = minecraft.field_1724.method_6047();
        if (!(itemStack.method_7909() instanceof GunItem)) {
            return;
        }
        int activeSlot = minecraft.field_1724.method_31548().field_7545;
        GunClientState gunClientState = GunClientState.getState((class_1657)minecraft.field_1724, itemStack, activeSlot, false);
        if (gunClientState != null) {
            float aimingZoom = this.zoomValue.update(AimingFeature.getZoom(itemStack));
            BiDirectionalInterpolator aimingController = (BiDirectionalInterpolator)gunClientState.getAnimationController("aiming");
            float zoomAdj = aimingZoom * (float)aimingController.getValue();
            event.setFOV(event.getFOV() - event.getFOV() * (double)zoomAdj - (double)((float)this.sharedViewShakeController.getRoll()));
        }
    }

    @SubscribeEvent2
    public void onRenderHandEvent(RenderHandEvent event) {
        class_1792 class_17922;
        class_1799 heldItem = event.getItemStack();
        if (event.getHand() == class_1268.field_5808 && (class_17922 = heldItem.method_7909()) instanceof GunItem) {
            GunItem gunItem = (GunItem)class_17922;
            int slot = ClientUtil.getClientPlayer().method_31548().method_7395(heldItem);
            class_310 minecraft = class_310.method_1551();
            GunClientState gunClientState = GunClientState.getState((class_1657)minecraft.field_1724, heldItem, slot, false);
            if (gunClientState != null) {
                GunRecoilAnimationController recoilController;
                GunRandomizingAnimationController randomizerController;
                class_1657 player;
                if (((Boolean)minecraft.field_1690.method_42448().method_41753()).booleanValue() && minecraft.method_1560() instanceof class_1657) {
                    player = (class_1657)minecraft.method_1560();
                    class_4587 poseStack = event.getPoseStack();
                    float f = player.field_5973 - player.field_6039;
                    float partialTick = event.getPartialTick();
                    float walkDistance = -(player.field_5973 + f * partialTick);
                    float bobbing = class_3532.method_16439((float)partialTick, (float)player.field_7505, (float)player.field_7483);
                    poseStack.method_22907(class_7833.field_40714.rotationDegrees(-Math.abs(class_3532.method_15362((float)(walkDistance * (float)Math.PI - 0.2f)) * bobbing) * 5.0f));
                    poseStack.method_22907(class_7833.field_40718.rotationDegrees(-class_3532.method_15374((float)(walkDistance * (float)Math.PI)) * bobbing * 3.0f));
                    poseStack.method_46416(-class_3532.method_15374((float)(walkDistance * (float)Math.PI)) * bobbing * 0.5f, Math.abs(class_3532.method_15362((float)(walkDistance * (float)Math.PI)) * bobbing), 0.0f);
                    if (!Config.firstPersonAnimationsEnabled) {
                        float targetYaw;
                        float randomPitch = 0.0f;
                        float randomYaw = 0.0f;
                        float targetBobbing = 1.0f;
                        if (player.method_5624()) {
                            targetYaw = 10.0f;
                            targetBobbing = gunItem.getBobbing();
                        } else if (gunClientState.isAiming()) {
                            targetBobbing = gunItem.getBobbingOnAim();
                            float afc = AimingFeature.getViewBobbing(heldItem);
                            targetYaw = 5.0f * afc;
                            targetBobbing *= afc;
                        } else {
                            targetBobbing = gunItem.getBobbing();
                            targetYaw = 5.0f;
                        }
                        float bobbingRoll = (bobbing *= this.bobbingValue.update(targetBobbing)) * 10.0f * gunItem.getBobbingRollMultiplier();
                        float bobbingPitch = bobbing * 5.0f;
                        float bobbingYaw = bobbing * this.bobbingYawValue.update(targetYaw);
                        poseStack.method_22904((double)(-class_3532.method_15374((float)(walkDistance * (float)Math.PI)) * bobbing * 0.5f), (double)Math.abs(class_3532.method_15362((float)(walkDistance * (float)Math.PI)) * bobbing) * 0.35 + (double)(randomPitch * 0.01f), (double)(randomYaw * 0.0f));
                        poseStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_15374((float)(walkDistance * (float)Math.PI)) * bobbingRoll));
                        poseStack.method_22907(class_7833.field_40714.rotationDegrees(Math.abs(class_3532.method_15362((float)(walkDistance * (float)Math.PI - 0.2f))) * bobbingPitch));
                        poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_15374((float)(walkDistance * (float)Math.PI)) * bobbingYaw));
                    }
                }
                if (Config.firstPersonAnimationsEnabled) {
                    player = ClientUtil.getClientPlayer();
                    this.handlePlayerFirstPersonMovement(player, player.method_6047());
                }
                if ((randomizerController = (GunRandomizingAnimationController)gunClientState.getAnimationController("randomizer")) != null) {
                    if (this.inventorySlotChanged || this.currentSlotHasGunChanged) {
                        randomizerController.reset();
                    }
                    double posX = randomizerController.getPosX();
                    double posY = randomizerController.getPosY();
                    double posZ = randomizerController.getPosZ();
                    double roll = randomizerController.getRoll();
                    double yaw = randomizerController.getYaw();
                    double pitch = randomizerController.getPitch();
                    class_4587 poseStack = event.getPoseStack();
                    Quaternionf q = new Quaternionf(pitch, yaw, roll, 1.0);
                    poseStack.method_22904(posX, posY, posZ);
                    poseStack.method_22907(q);
                }
                if ((recoilController = (GunRecoilAnimationController)gunClientState.getAnimationController("recoil2")) != null) {
                    if (this.inventorySlotChanged || this.currentSlotHasGunChanged) {
                        recoilController.reset();
                    }
                    double posX = recoilController.getPosX();
                    double posY = recoilController.getPosY();
                    double posZ = recoilController.getPosZ();
                    double roll = recoilController.getRoll();
                    double pitch = recoilController.getPitch();
                    class_4587 poseStack = event.getPoseStack();
                    Quaternionf q = new Quaternionf(pitch, 0.0, roll, 1.0);
                    poseStack.method_22904(posX, posY, posZ);
                    poseStack.method_22907(q);
                }
                if (this.jumpController != null) {
                    double jumpMultiplier = gunItem.getJumpMultiplier();
                    double posX = this.jumpController.getPosX() * jumpMultiplier;
                    double posY = this.jumpController.getPosY() * jumpMultiplier;
                    double posZ = this.jumpController.getPosZ() * jumpMultiplier;
                    double roll = this.jumpController.getRoll() * jumpMultiplier;
                    double pitch = this.jumpController.getPitch() * jumpMultiplier;
                    double yaw = this.jumpController.getYaw() * jumpMultiplier;
                    class_4587 poseStack = event.getPoseStack();
                    Quaternionf q = new Quaternionf(pitch, yaw, roll, 1.0);
                    poseStack.method_22904(posX, posY, posZ);
                    poseStack.method_22907(q);
                }
                if (this.inertiaController != null) {
                    double roll = this.inertiaController.getRoll();
                    double yaw = 0.0;
                    class_4587 poseStack = event.getPoseStack();
                    Quaternionf q = new Quaternionf(0.0, yaw, roll, 1.0);
                    poseStack.method_22907(q);
                }
            }
        }
    }

    private void handlePlayerFirstPersonMovement(class_1657 player, class_1799 itemStack) {
        this.firstPersonWalkingAnimationHandler.handlePlayerFirstPersonMovement(player, itemStack);
    }

    @SubscribeEvent2
    public void onClickEvent(InputEvent.InteractionKeyMappingTriggered event) {
        class_1657 player = event.getPlayer();
        if (player == null && Platform.getInstance().isClientThread()) {
            player = ClientUtil.getClientPlayer();
        }
        if (player == null) {
            return;
        }
        class_1799 heldItem = player.method_6047();
        if (heldItem.method_7909() instanceof ItemExtra) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent2
    public void onPreRenderHandEvent(RenderHandsEvent.Pre event) {
        GeoBone cameraBone;
        Nameable gunItem;
        BakedGeoModel model;
        class_1792 class_17922;
        class_1799 itemStack = GunItem.getMainHeldGunItemStack((class_1309)ClientUtil.getClientPlayer());
        if (itemStack != null && (class_17922 = itemStack.method_7909()) instanceof Nameable && (model = AttachmentModelInfo.getModel((gunItem = (Nameable)class_17922).getName())) != null && (cameraBone = (GeoBone)model.getBone("_camera_").orElse(null)) != null) {
            class_4587 poseStack = event.getPoseStack();
            if (cameraBone.getRotY() != 0.0f) {
                poseStack.method_22907(class_7833.field_40716.rotation(-cameraBone.getRotY()));
            }
            if (cameraBone.getRotX() != 0.0f) {
                poseStack.method_22907(class_7833.field_40714.rotation(-cameraBone.getRotX()));
            }
            if (cameraBone.getRotZ() != 0.0f) {
                poseStack.method_22907(class_7833.field_40718.rotation(-cameraBone.getRotZ()));
            }
        }
    }

    @SubscribeEvent2
    public void onComputeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        GeoBone cameraBone;
        Nameable gunItem;
        BakedGeoModel model;
        class_1799 itemStack;
        class_1792 roll2;
        class_310 mc = class_310.method_1551();
        if (!mc.field_1690.method_31044().method_31034()) {
            return;
        }
        GunClientState state = GunClientState.getMainHeldState();
        if (state != null) {
            TimerController reloadTimer;
            PryAnimationController shakeAnimationController = (PryAnimationController)state.getAnimationController("shake");
            if (shakeAnimationController != null) {
                float yawModifier = state.isAiming() ? 0.1f : 1.0f;
                float rollModifier = state.isAiming() ? 1.5f : 1.0f;
                event.setRoll(event.getRoll() + (float)shakeAnimationController.getRoll() * rollModifier);
                event.setYaw(event.getYaw() + (float)shakeAnimationController.getYaw() * yawModifier);
            }
            if ((reloadTimer = (TimerController)state.getAnimationController("reloadTimer")) != null && !reloadTimer.isDone()) {
                for (AbstractProceduralAnimationController activeHandler : reloadTimer.getActiveHandlers(ClientUtil.getClientPlayer(), state, ClientUtil.getClientPlayer().method_6047())) {
                    event.setRoll(event.getRoll() + (float)activeHandler.getRoll());
                    event.setPitch(event.getPitch() + (float)activeHandler.getPitch());
                }
            }
            if (this.sharedViewShakeController != null) {
                event.setRoll(event.getRoll() + (float)this.sharedViewShakeController.getRoll() * 0.5f);
            }
            if (this.inertiaController != null) {
                double roll2 = this.inertiaController.getYaw();
                double yaw = this.inertiaController.getYaw();
                event.setRoll(event.getRoll() + (float)roll2 * 15.0f);
                event.setYaw(event.getYaw() + (float)yaw * 15.0f);
            }
        }
        if ((roll2 = (itemStack = ClientUtil.getClientPlayer().method_6047()).method_7909()) instanceof Nameable && (model = AttachmentModelInfo.getModel((gunItem = (Nameable)roll2).getName())) != null && (cameraBone = (GeoBone)model.getBone("_camera_").orElse(null)) != null) {
            event.setPitch(event.getPitch() - cameraBone.getRotX() * 57.295776f);
            event.setYaw(event.getYaw() - cameraBone.getRotY() * 57.295776f);
            event.setRoll(event.getRoll() - cameraBone.getRotZ() * 57.295776f);
        }
    }

    @SubscribeEvent2
    public void onRenderOverlay(RenderGuiOverlayEvent event) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null) {
            return;
        }
        class_1799 itemStack = minecraft.field_1724.method_6047();
        if (!(itemStack.method_7909() instanceof GunItem)) {
            return;
        }
        if (event.isHotbarType() && minecraft.field_1755 instanceof AttachmentManagerScreen) {
            event.setCanceled(true);
            return;
        }
        if (!minecraft.field_1690.method_31044().method_31034()) {
            return;
        }
        int activeSlot = minecraft.field_1724.method_31548().field_7545;
        GunClientState gunClientState = GunClientState.getState((class_1657)minecraft.field_1724, itemStack, activeSlot, false);
        if (gunClientState == null) {
            return;
        }
        GunItem item = (GunItem)itemStack.method_7909();
        if (event.isCrosshairType()) {
            if (Config.crosshairType == Config.CrosshairType.DEFAULT && !gunClientState.isAiming() && (gunClientState.isFiring() || gunClientState.isIdle())) {
                int height;
                double scaleFactor;
                float crossHairExpansionRate = this.getCrosshairExpansionRatio((class_1657)minecraft.field_1724, gunClientState);
                double originalAspectRatio = 1.0;
                int width = event.getWindow().method_4486();
                int renderWidth = (int)((double)width * (scaleFactor = 3.3));
                int renderHeight = (int)((double)renderWidth / originalAspectRatio);
                if (renderHeight > (height = event.getWindow().method_4502())) {
                    renderHeight = (int)((double)height * scaleFactor);
                    renderWidth = (int)((double)renderHeight * originalAspectRatio);
                }
                renderWidth = 80;
                renderHeight = 80;
                float posX = (float)(width - renderWidth) / 2.0f;
                float posY = (float)(height - renderHeight) / 2.0f;
                CrosshairRenderer.renderCrosshairOverlay3(event.getGuiGraphics(), event.getPartialTick(), crossHairOverlay, crossHairExpansionRate - 1.0f, posX, posY, renderWidth, renderHeight);
            }
            if (Config.crosshairType == Config.CrosshairType.DEFAULT || Config.crosshairType == Config.CrosshairType.DISABLED) {
                event.setCanceled(true);
            }
        }
        class_2960 scopeOverlay = item.getScopeOverlay();
        if (gunClientState.isAiming()) {
            boolean pipZoomEnabled = MiscUtil.isGreaterThanZero(gunClientState.getGunItem().getPipScopeZoom());
            if (scopeOverlay != null && !pipZoomEnabled) {
                event.setCanceled(true);
            }
            if (!pipZoomEnabled || !Config.pipScopesEnabled) {
                BiDirectionalInterpolator aimingController = (BiDirectionalInterpolator)gunClientState.getAnimationController("aiming");
                double aimingProgress = aimingController.getValue();
                if (aimingController != null && scopeOverlay != null && !gunClientState.isReloading()) {
                    this.renderTextureOverlay(item, gunClientState, event.getGuiGraphics(), event.getPartialTick(), item.getScopeOverlay(), event.getWindow().method_4486(), event.getWindow().method_4502(), (float)aimingProgress);
                }
            }
        }
    }

    protected void renderTextureOverlay(GunItem gunItem, GunClientState gunClientState, class_332 guiGraphics, float partialTick, class_2960 textureLocation, int width, int height, float alpha) {
        GunRecoilAnimationController recoilController;
        double scaleFactor = 3.3;
        int renderWidth = (int)((double)width * scaleFactor);
        double originalAspectRatio = 1.0;
        int renderHeight = (int)((double)renderWidth / originalAspectRatio);
        if (renderHeight > height) {
            renderHeight = (int)((double)height * scaleFactor);
            renderWidth = (int)((double)renderHeight * originalAspectRatio);
        }
        float posX = (float)(width - renderWidth) / 2.0f;
        float posY = (float)(height - renderHeight) / 2.0f;
        if (this.scopeInertiaController != null) {
            double yaw = this.scopeInertiaController.getYaw();
            double pitch = this.scopeInertiaController.getPitch();
            posX = (float)((double)posX - yaw * 5000.0);
            posY = (float)((double)posY - pitch * 5000.0);
        }
        if ((recoilController = (GunRecoilAnimationController)gunClientState.getAnimationController("recoil2")) != null) {
            if (this.inventorySlotChanged || this.currentSlotHasGunChanged) {
                recoilController.reset();
            }
            double posZ1 = recoilController.getPosZ();
            posY = (float)((double)posY + posZ1 * 50.0);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, alpha);
        RenderUtil.blit(guiGraphics, textureLocation, posX, posY, -90, 0.0f, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight);
        class_2960 targetLockOverlay = gunItem.getTargetLockOverlay();
        if (targetLockOverlay != null) {
            this.renderTargetLockOverlay(guiGraphics, partialTick, targetLockOverlay, posX, posY, renderWidth, renderHeight);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderTargetLockOverlay(class_332 guiGraphics, float partialTick, class_2960 targetLockonOverlay, float posX, float posY, int renderWidth, int renderHeight) {
        UpDownCounter lockCounter = this.lockableTarget.getLockCounter();
        float targetLockCount = class_3532.method_16439((float)partialTick, (float)lockCounter.getPreviousValue(), (float)lockCounter.getCurrentValue()) / (float)lockCounter.getMaxValue();
        float lockProgress2 = 1.0f - targetLockCount;
        float lockRatio = 0.2f;
        int halfLockWidth = (int)((float)renderWidth * lockRatio * 0.5f);
        int halfLockHeight = (int)((float)renderHeight * lockRatio * 0.5f);
        float centerX = posX + (float)renderWidth * 0.5f;
        float centerY = posY + (float)renderHeight * 0.5f;
        float xOffset = (float)halfLockWidth * 0.4f * lockProgress2;
        float yOffset = (float)halfLockHeight * 0.4f * lockProgress2;
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 0.5f;
        float maxV = 0.5f;
        float posXStart = centerX - (float)halfLockWidth - xOffset;
        float posXEnd = centerX - xOffset;
        float posYStart = centerY - (float)halfLockHeight - yOffset;
        float posYEnd = centerY - yOffset;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, minU, maxU, minV, maxV);
        float posXStart2 = centerX + xOffset;
        float posXEnd2 = centerX + (float)halfLockWidth + xOffset;
        float posYStart2 = centerY - (float)halfLockHeight - yOffset;
        float posYEnd2 = centerY - yOffset;
        float minU2 = 0.5f;
        float minV2 = 0.0f;
        float maxU2 = 1.0f;
        float maxV2 = 0.5f;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart2, posXEnd2, posYStart2, posYEnd2, -90.0f, minU2, maxU2, minV2, maxV2);
        posXStart2 = centerX + xOffset;
        posXEnd2 = centerX + (float)halfLockWidth + xOffset;
        posYStart2 = centerY + yOffset;
        posYEnd2 = centerY + (float)halfLockHeight + yOffset;
        minU2 = 0.5f;
        minV2 = 0.5f;
        maxU2 = 1.0f;
        maxV2 = 1.0f;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart2, posXEnd2, posYStart2, posYEnd2, -90.0f, minU2, maxU2, minV2, maxV2);
        posXStart2 = centerX - (float)halfLockWidth - xOffset;
        posXEnd2 = centerX - xOffset;
        posYStart2 = centerY + yOffset;
        posYEnd2 = centerY + (float)halfLockHeight + yOffset;
        minU2 = 0.0f;
        minV2 = 0.5f;
        maxU2 = 0.5f;
        maxV2 = 1.0f;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart2, posXEnd2, posYStart2, posYEnd2, -90.0f, minU2, maxU2, minV2, maxV2);
    }

    private void setTriggerOff(class_746 player) {
        class_1799 heldItem = player.method_6047();
        class_1792 class_17922 = heldItem.method_7909();
        if (class_17922 instanceof GunItem) {
            GunItem gunItem = (GunItem)class_17922;
            if (player.method_5624()) {
                player.method_5728(false);
            } else {
                gunItem.setTriggerOff((class_1657)player, heldItem);
            }
        } else {
            class_17922 = heldItem.method_7909();
            if (class_17922 instanceof ThrowableItem) {
                ThrowableItem throwableItem = (ThrowableItem)class_17922;
                throwableItem.setTriggerOff((class_1657)player, heldItem);
            }
        }
    }

    private void leftMouseDown() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        this.tryFire(player);
    }

    private void rightMouseButtonDown() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        if (player.method_5624()) {
            player.method_5728(false);
        }
        MiscUtil.getMainHeldGun((class_1309)player).ifPresent(item -> {
            if (item.isAimingEnabled()) {
                this.toggleAiming(player, true);
            }
        });
    }

    private void rightMouseButtonRelease() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        this.toggleAiming(player, false);
    }

    private void leftMouseButtonRelease() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        this.setTriggerOff(player);
    }

    public void tickMainHeldGun() {
        GunClientState state;
        class_1657 player = ClientUtil.getClientPlayer();
        if (player != null && (state = GunClientState.getMainHeldState()) != null) {
            state.stateTick((class_1309)player, player.method_6047(), true);
            this.scopeInertiaController.onUpdateState((class_1309)player, state);
            reticleInertiaController.onUpdateState((class_1309)player, state);
            this.inertiaController.onUpdateState((class_1309)player, state);
        }
    }

    public static void runSyncTick(Runnable runnable) {
        mainLoopLock.lock();
        try {
            runnable.run();
        }
        catch (Exception e) {
            LOGGER.error("Client sync tick failed: {}", (Throwable)e);
        }
        finally {
            mainLoopLock.unlock();
        }
    }

    public static <T> T runSyncCompute(Supplier<T> resultSupplier) {
        T result;
        mainLoopLock.lock();
        try {
            result = resultSupplier.get();
        }
        catch (Exception e) {
            LOGGER.error("Run sync compute failed: {}", (Throwable)e);
            throw e;
        }
        finally {
            mainLoopLock.unlock();
        }
        return result;
    }

    private boolean toggleAiming(class_746 player, boolean isAiming) {
        int activeSlot;
        GunClientState gunClientState;
        boolean toggled = false;
        class_1799 itemStack = player.method_6047();
        if (itemStack != null && itemStack.method_7909() instanceof GunItem && (gunClientState = GunClientState.getState((class_1657)player, itemStack, activeSlot = player.method_31548().field_7545, false)) != null) {
            toggled = gunClientState.isAiming() != isAiming;
            gunClientState.setAiming(isAiming);
            if (toggled) {
                Platform.getInstance().getNetworkService().sendToServer(new AimingChangeRequestPacket(gunClientState.getId(), activeSlot, isAiming));
            }
        }
        return toggled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryFire(class_746 player) {
        class_1792 class_17922;
        boolean result = false;
        class_1799 heldItemStack = player.method_6047();
        if (heldItemStack != null && (class_17922 = heldItemStack.method_7909()) instanceof GunItem) {
            GunItem gunItem = (GunItem)class_17922;
            if (player.method_6079() != heldItemStack && gunItem.isEnabled()) {
                long minTargetLockTime = gunItem.getTargetLockTimeTicks();
                if (minTargetLockTime == 0L) return gunItem.tryFire((class_1657)player, heldItemStack, this.lockableTarget.getTargetEntity());
                if (!this.lockableTarget.getLockCounter().isAtMax()) return result;
                return gunItem.tryFire((class_1657)player, heldItemStack, this.lockableTarget.getTargetEntity());
            }
        }
        if (heldItemStack == null) return result;
        class_17922 = heldItemStack.method_7909();
        if (!(class_17922 instanceof ThrowableItem)) return result;
        ThrowableItem throwableItem = (ThrowableItem)class_17922;
        if (player.method_6079() == heldItemStack) return result;
        if (!throwableItem.isEnabled()) return result;
        return throwableItem.tryThrow((class_1657)player, heldItemStack, this.lockableTarget.getTargetEntity());
    }

    @SubscribeEvent2
    public void onJump(LivingEvent.LivingJumpEvent event) {
        class_1937 level = MiscUtil.getLevel((class_1297)event.getEntity());
        if (level.field_9236 && event.getEntity() instanceof class_1657) {
            class_1657 player = (class_1657)event.getEntity();
            class_1799 heldItem = player.method_6047();
            if (player == ClientUtil.getClientPlayer() && heldItem.method_7909() instanceof GunItem) {
                GunClientState state = GunClientState.getState(player, heldItem, this.currentInventorySlot, false);
                if (state != null) {
                    state.jump((class_1309)player, heldItem);
                }
                if (this.jumpController != null) {
                    this.jumpController.onJumping((class_1309)player, state, heldItem);
                }
            }
        }
    }

    @SubscribeEvent2
    public void onRenderTooltip(RenderTooltipEvent.Pre event) {
        class_5684 component;
        class_1799 itemStack = event.getItemStack();
        if (itemStack == null || !(itemStack.method_7909() instanceof AttachmentHost)) {
            return;
        }
        event.setCanceled(true);
        class_310 mc = class_310.method_1551();
        class_332 guiGraphics = event.getGraphics();
        List<class_5684> tooltipComponents = event.getComponents();
        int i = 0;
        int j = tooltipComponents.size() == 1 ? -2 : 0;
        for (class_5684 clienttooltipcomponent : tooltipComponents) {
            int k = clienttooltipcomponent.method_32664(event.getFont());
            if (k > i) {
                i = k;
            }
            j += clienttooltipcomponent.method_32661();
        }
        int i2 = i;
        int j2 = j;
        Vector2ic vector2ic = event.getTooltipPositioner().method_47944(guiGraphics.method_51421(), guiGraphics.method_51443(), event.getX(), event.getY(), i2, j2);
        int l = vector2ic.x();
        int i1 = vector2ic.y();
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        guiGraphics.method_51741(() -> {
            int background = 0x50101010;
            int borderStart = 1342218495;
            int borderEnd = 0x50005077;
            if (!(mc.field_1755 instanceof AttachmentManagerScreen)) {
                background = -267382768;
            }
            RenderUtil.renderTooltipBackground(guiGraphics, l, i1, i2, j2, 400, background, background, borderStart, borderEnd);
        });
        poseStack.method_46416(0.0f, 0.0f, 400.0f);
        int k1 = i1;
        for (int l1 = 0; l1 < tooltipComponents.size(); ++l1) {
            component = tooltipComponents.get(l1);
            component.method_32665(event.getFont(), l, k1, poseStack.method_23760().method_23761(), guiGraphics.method_51450());
            k1 += component.method_32661() + (l1 == 0 ? 2 : 0);
        }
        k1 = i1;
        for (int k2 = 0; k2 < tooltipComponents.size(); ++k2) {
            component = tooltipComponents.get(k2);
            component.method_32666(event.getFont(), l, k1, guiGraphics);
            k1 += component.method_32661() + (k2 == 0 ? 2 : 0);
        }
        poseStack.method_22909();
    }

    @SubscribeEvent2
    public void onGatherTooltipComponents(RenderTooltipEvent.GatherComponents event) {
        class_1799 itemStack = event.getItemStack();
        class_1792 item = itemStack.method_7909();
        if (item instanceof FeatureProvider) {
            AttachmentHost attachmentHost;
            Collection<Attachment> collection;
            FeatureProvider featureProvider = (FeatureProvider)item;
            List<Either<class_5348, class_5632>> elements = event.getTooltipElements();
            ArrayList<Object> components = new ArrayList<Object>();
            components.addAll(featureProvider.getDescriptionTooltipLines());
            components.addAll(featureProvider.getFeatureTooltipLines());
            if (item instanceof AttachmentHost && !(collection = (attachmentHost = (AttachmentHost)item).getCompatibleAttachments()).isEmpty()) {
                if (class_437.method_25442()) {
                    components.addAll(attachmentHost.getCompatibleAttachmentTooltipLines(itemStack));
                } else {
                    components.add(class_2561.method_43473());
                    components.add(class_2561.method_43471((String)"message.pointblank.holdShiftForCompatibleAttachments").method_27692(class_124.field_1056).method_27692(class_124.field_1062));
                }
            }
            for (class_2561 class_25612 : components) {
                elements.add((Either<class_5348, class_5632>)Either.left((Object)class_25612));
            }
        }
    }

    @SubscribeEvent2
    public void onRenderLevel(RenderLevelEvent.Pre event) {
        ClientSystem.getInstance().setInverseCameraMatrix(event.getInverseCameraMatrix());
    }

    private float getCrosshairExpansionRatio(class_1657 player, GunClientState gunClientState) {
        float inaccuracy = 2.0f;
        float baseExpansion = 1.0f;
        float speedMultiplier = 4.0f * inaccuracy;
        float rotationMultiplier = 0.05f * inaccuracy;
        float sprintMultiplier = 1.5f * inaccuracy;
        float jumpMultiplier = 1.2f * inaccuracy;
        float sneakMultiplier = 0.8f;
        float crouchMultiplier = 0.7f;
        float fireMultiplier = 2.0f * inaccuracy;
        double horizontalSpeed = class_3532.method_15355((float)((float)(this.playerDeltaX * this.playerDeltaX + this.playerDeltaY * this.playerDeltaY + this.playerDeltaZ * this.playerDeltaZ)));
        float expansionRatio = baseExpansion + (float)horizontalSpeed * speedMultiplier;
        if (player.method_5624()) {
            expansionRatio *= sprintMultiplier;
        }
        if (!player.method_24828()) {
            expansionRatio *= jumpMultiplier;
        }
        if (player.method_20448()) {
            expansionRatio *= sneakMultiplier;
        }
        if (player.method_18276()) {
            expansionRatio *= crouchMultiplier;
        }
        float yawChangeRate = Math.abs(this.playerDeltaYRot);
        float pitchChangeRate = Math.abs(this.playerDeltaXRot);
        expansionRatio += yawChangeRate * rotationMultiplier;
        expansionRatio += pitchChangeRate * rotationMultiplier;
        if (gunClientState.getTotalUninterruptedShots() > 0) {
            expansionRatio *= fireMultiplier;
        }
        return class_3532.method_15363((float)this.crossHairExp.update(expansionRatio), (float)1.0f, (float)7.0f);
    }

    static {
        postPassEffectController = new PostPassEffectController(2000L);
        crossHairOverlay = new class_2960("pointblank", "textures/gui/crosshair.png");
    }
}

