/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client;

import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.controller.BlendingAnimationController;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.util.StateMachine;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_5498;
import net.minecraft.class_746;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.ClientUtils;

public class FirstPersonWalkingAnimationHandler {
    public static final String WALKING_CONTROLLER_NAME = "walking";
    private static final float MIN_SPEED_SQUARED = 1.0E-4f;
    private final StateMachine<PlayerWalkingState, PlayerWalkingStateContext> firstPersonAnimationStateMachine = this.createFirstPersonAnimationStateMachine();
    private long ts;

    private StateMachine<PlayerWalkingState, PlayerWalkingStateContext> createFirstPersonAnimationStateMachine() {
        StateMachine.Builder<PlayerWalkingState, PlayerWalkingStateContext> builder = new StateMachine.Builder<PlayerWalkingState, PlayerWalkingStateContext>();
        class_310 mc = class_310.method_1551();
        builder.withTransition(PlayerWalkingState.NONE, PlayerWalkingState.STANDING, ctx -> mc.field_1690.method_31044() == class_5498.field_26664 && !ctx.state.isDrawing() && System.currentTimeMillis() - this.ts > 100L, StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT, PlayerWalkingState.RUNNING, PlayerWalkingState.PREPARE_RUNNING, PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.OFF_GROUND, PlayerWalkingState.OFF_GROUND_SPRINTING)), PlayerWalkingState.NONE, ctx -> mc.field_1690.method_31044() != class_5498.field_26664, StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT)), PlayerWalkingState.OFF_GROUND, ctx -> !ctx.player.method_24828() && !ctx.player.method_5624(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.OFF_GROUND, ctx -> ctx.speedSquared > 1.0E-4f && !ctx.player.method_24828() && (!ctx.player.method_5624() || ctx.player.method_20303()) && ctx.isMovingForward() && !ctx.state.isAiming() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.RUNNING)), PlayerWalkingState.OFF_GROUND_SPRINTING, ctx -> !ctx.player.method_24828() && ctx.player.method_5624(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.PREPARE_RUNNING, PlayerWalkingState.OFF_GROUND_SPRINTING, ctx -> ctx.player.method_5624() && !ctx.player.method_24828() && !ctx.player.method_20303() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_PREPARE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT)), PlayerWalkingState.WALKING_AIMING, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.method_24828() && !ctx.player.method_5624() && ctx.state.isAiming(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.WALKING_AIMING, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.method_24828() && !ctx.player.method_5624() && ctx.state.isAiming() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND, PlayerWalkingState.STANDING, PlayerWalkingState.WALKING_AIMING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT)), PlayerWalkingState.WALKING, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.method_24828() && !ctx.player.method_5624() && ctx.isMovingForward() && !ctx.state.isAiming(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.WALKING, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.method_24828() && (!ctx.player.method_5624() || ctx.player.method_20303()) && ctx.isMovingForward() && !ctx.state.isAiming() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND, PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_AIMING, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT)), PlayerWalkingState.WALKING_BACKWARDS, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.method_24828() && (!ctx.player.method_5624() || ctx.player.method_20303()) && ctx.isMovingBackward() && !ctx.state.isAiming(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.WALKING_BACKWARDS, ctx -> ctx.speedSquared > 1.0E-4f && (!ctx.player.method_5624() || ctx.player.method_20303()) && ctx.isMovingBackward() && !ctx.state.isAiming() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND, PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_AIMING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_RIGHT)), PlayerWalkingState.WALKING_LEFT, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.method_24828() && (!ctx.player.method_5624() || ctx.player.method_20303()) && ctx.isMovingLeft() && !ctx.state.isAiming(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.WALKING_LEFT, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.method_24828() && (!ctx.player.method_5624() || ctx.player.method_20303()) && ctx.isMovingLeft() && !ctx.state.isAiming() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND, PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_AIMING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT)), PlayerWalkingState.WALKING_RIGHT, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.method_24828() && !ctx.player.method_5624() && !ctx.state.isAiming() && ctx.isMovingRight(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.WALKING_RIGHT, ctx -> ctx.speedSquared > 1.0E-4f && ctx.player.method_24828() && (!ctx.player.method_5624() || ctx.player.method_20303()) && ctx.isMovingRight() && !ctx.state.isAiming() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_AIMING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT)), PlayerWalkingState.STANDING, ctx -> ctx.player.method_24828() && !ctx.player.method_5624() && ctx.speedSquared <= 1.0E-4f, StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.COMPLETE_RUNNING, PlayerWalkingState.STANDING, ctx -> ctx.player.method_24828() && !ctx.player.method_5624() && ctx.speedSquared <= 1.0E-4f && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_COMPLETE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND, PlayerWalkingState.STANDING, PlayerWalkingState.WALKING, PlayerWalkingState.WALKING_AIMING, PlayerWalkingState.WALKING_BACKWARDS, PlayerWalkingState.WALKING_LEFT, PlayerWalkingState.WALKING_RIGHT, PlayerWalkingState.COMPLETE_RUNNING)), PlayerWalkingState.PREPARE_RUNNING, ctx -> ctx.player.method_5624() && !ctx.player.method_20303() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation("animation.model.fire", ctx.itemStack, "fire_controller"), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.OFF_GROUND_SPRINTING)), PlayerWalkingState.RUNNING, ctx -> ctx.player.method_24828(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withTransition(PlayerWalkingState.PREPARE_RUNNING, PlayerWalkingState.RUNNING, ctx -> ctx.player.method_5624() && ctx.player.method_24828() && !ctx.player.method_20303() && !FirstPersonWalkingAnimationHandler.isPlayingAnimation(GunItem.RAW_ANIMATION_PREPARE_RUNNING, ctx.itemStack), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition((PlayerWalkingState)((Object)List.of(PlayerWalkingState.PREPARE_RUNNING, PlayerWalkingState.RUNNING, PlayerWalkingState.OFF_GROUND_SPRINTING)), PlayerWalkingState.COMPLETE_RUNNING, ctx -> !ctx.player.method_5624() || ctx.player.method_20303(), StateMachine.TransitionMode.AUTO, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null, (StateMachine.Action<PlayerWalkingState, PlayerWalkingStateContext>)null);
        builder.withOnChangeStateAction((ctx, f, t) -> {
            long id = GeoItem.getId((class_1799)ctx.itemStack);
            GunItem gunItem = (GunItem)ctx.itemStack.method_7909();
            switch (t) {
                case STANDING: {
                    gunItem.triggerAnim((class_1297)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.standing");
                    break;
                }
                case WALKING_AIMING: {
                    gunItem.triggerAnim((class_1297)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.walking_aiming");
                    break;
                }
                case WALKING: {
                    gunItem.triggerAnim((class_1297)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.walking");
                    break;
                }
                case WALKING_BACKWARDS: {
                    gunItem.triggerAnim((class_1297)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.walking_backwards");
                    break;
                }
                case WALKING_LEFT: {
                    gunItem.triggerAnim((class_1297)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.walking_left");
                    break;
                }
                case WALKING_RIGHT: {
                    gunItem.triggerAnim((class_1297)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.walking_right");
                    break;
                }
                case PREPARE_RUNNING: {
                    gunItem.triggerAnim((class_1297)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.runningstart");
                    break;
                }
                case RUNNING: {
                    gunItem.triggerAnim((class_1297)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.running");
                    break;
                }
                case COMPLETE_RUNNING: {
                    gunItem.triggerAnim((class_1297)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.runningend");
                    break;
                }
                case OFF_GROUND: {
                    gunItem.triggerAnim((class_1297)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.off_ground");
                    break;
                }
                case OFF_GROUND_SPRINTING: {
                    gunItem.triggerAnim((class_1297)ctx.player, id, WALKING_CONTROLLER_NAME, "animation.model.off_ground_sprinting");
                    break;
                }
                case NONE: {
                    AnimationController<GeoAnimatable> controller = gunItem.getGeoAnimationController(WALKING_CONTROLLER_NAME, ctx.itemStack);
                    controller.forceAnimationReset();
                    controller.setAnimation(null);
                    ((BlendingAnimationController)controller).clearAll();
                }
            }
        });
        return builder.build(PlayerWalkingState.STANDING);
    }

    public void handlePlayerFirstPersonMovement(class_1657 player, class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)class_17922;
        class_310 mc = class_310.method_1551();
        class_1657 mainPlayer = ClientUtils.getClientPlayer();
        if (player != mainPlayer) {
            return;
        }
        PlayerWalkingStateContext context = new PlayerWalkingStateContext((class_746)player, itemStack);
        if (mc.field_1690.method_31044() == class_5498.field_26664) {
            this.firstPersonAnimationStateMachine.update(context);
        } else {
            this.firstPersonAnimationStateMachine.update(context);
        }
    }

    public void reset(class_1657 player, class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)class_17922;
        this.ts = System.currentTimeMillis();
        this.firstPersonAnimationStateMachine.resetToState(PlayerWalkingState.NONE);
    }

    public static boolean isPlayingAnimation(RawAnimation rawAnimation, class_1799 itemStack) {
        BlendingAnimationController bac;
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof GunItem)) {
            return false;
        }
        GunItem gunItem = (GunItem)class_17922;
        AnimationController<GeoAnimatable> controller = gunItem.getGeoAnimationController(WALKING_CONTROLLER_NAME, itemStack);
        return (rawAnimation == controller.getCurrentRawAnimation() || controller instanceof BlendingAnimationController && (bac = (BlendingAnimationController)controller).getTriggeredAnimation() == rawAnimation) && controller.getAnimationState() != AnimationController.State.STOPPED;
    }

    public static boolean isPlayingBlendingAnimation(Collection<RawAnimation> rawAnimations, class_1799 itemStack, double minProgress, double maxProgress) {
        boolean result;
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof GunItem)) {
            return false;
        }
        GunItem gunItem = (GunItem)class_17922;
        AnimationController<GeoAnimatable> controller = gunItem.getGeoAnimationController(WALKING_CONTROLLER_NAME, itemStack);
        if (!(controller instanceof BlendingAnimationController)) {
            return false;
        }
        BlendingAnimationController bac = (BlendingAnimationController)controller;
        boolean bl = result = FirstPersonWalkingAnimationHandler.collectionContains(rawAnimations, bac.getTriggeredAnimation()) && bac.getAnimationState() != AnimationController.State.STOPPED;
        if (!result) {
            return false;
        }
        double progress = bac.getAnimationProgress();
        return minProgress <= progress && progress < maxProgress;
    }

    private static <T> boolean collectionContains(Collection<T> items, T item) {
        return item != null && items.contains(item);
    }

    public static boolean isPlayingAnimation(String animationName, class_1799 itemStack, String controllerName) {
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof GunItem)) {
            return false;
        }
        GunItem gunItem = (GunItem)class_17922;
        AnimationController<GeoAnimatable> controller = gunItem.getGeoAnimationController(controllerName, itemStack);
        AnimationProcessor.QueuedAnimation currentAnimation = controller.getCurrentAnimation();
        return currentAnimation != null && animationName.equals(currentAnimation.animation().name()) && controller.getAnimationState() != AnimationController.State.STOPPED;
    }

    private static enum PlayerWalkingState {
        NONE,
        OFF_GROUND,
        OFF_GROUND_SPRINTING,
        STANDING,
        WALKING,
        WALKING_BACKWARDS,
        WALKING_LEFT,
        WALKING_RIGHT,
        WALKING_AIMING,
        PREPARE_RUNNING,
        RUNNING,
        COMPLETE_RUNNING;

    }

    private static class PlayerWalkingStateContext {
        final class_746 player;
        final class_1799 itemStack;
        final float speedSquared;
        final GunClientState state;

        public PlayerWalkingStateContext(class_746 player, class_1799 itemStack) {
            this.player = player;
            this.itemStack = itemStack;
            this.speedSquared = player.field_3913.method_3128().method_35587();
            this.state = GunClientState.getMainHeldState();
        }

        boolean isMovingForward() {
            return this.player.field_3913.field_3910;
        }

        boolean isMovingBackward() {
            return this.player.field_3913.field_3909;
        }

        boolean isMovingLeft() {
            return this.player.field_3913.field_3908 && !this.player.field_3913.field_3910 && !this.player.field_3913.field_3909;
        }

        boolean isMovingRight() {
            return this.player.field_3913.field_3906 && !this.player.field_3913.field_3910 && !this.player.field_3913.field_3909;
        }
    }
}

