/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.controller;

import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.GunStateListener;
import com.vicmatskiv.pointblank.feature.RecoilFeature;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_811;

public class PlayerRecoilController
implements GunStateListener {
    private static double middleProgress = 1.0 - Math.sqrt(2.0) / 2.0;
    private int elapsedTime;
    private double ticksPerTransition;
    private double progress;
    private double prevProgress;
    private boolean isForward;
    private double actualAmplitude;
    private double amplitude;
    private double dPitch;
    private double dPitchResetRatio = 1.0;
    private double startPitch;
    private double maxPitch;
    private double initialPitch;
    private long startTime;
    private long nanoSecPerTransition;
    private long resetDurationNano;
    private State currentState = State.IDLE;

    public PlayerRecoilController(double amplitude, double maxPitch, double duration) {
        this.nanoSecPerTransition = (long)(duration * 1000000.0);
        this.amplitude = amplitude;
        this.actualAmplitude = amplitude;
        this.ticksPerTransition = duration;
        this.maxPitch = -Math.abs(maxPitch);
        this.resetDurationNano = 200000000L;
    }

    @Override
    public void onUpdateState(class_1309 player, GunClientState state) {
        if ((double)this.elapsedTime < this.ticksPerTransition) {
            ++this.elapsedTime;
        }
    }

    @Override
    public void onRenderTick(class_1309 player, GunClientState state, class_1799 itemStack, class_811 itemDisplayContext, float partialTicks) {
        class_310 mc = class_310.method_1551();
        if (!mc.field_1690.method_31044().method_31034()) {
            return;
        }
        if (this.currentState == State.IDLE) {
            return;
        }
        this.prevProgress = this.progress;
        this.progress = this.getProgress(state, partialTicks);
        if (this.currentState == State.RECOILING && this.progress >= 1.0) {
            if (Config.resetAutoFirePitchEnabled && this.resetDurationNano > 0L) {
                this.currentState = State.RESETTING;
                this.startTime = System.nanoTime();
                this.startPitch = player.method_36455();
                this.prevProgress = 0.0;
                this.progress = 0.0;
                this.nanoSecPerTransition = this.resetDurationNano;
            } else {
                this.currentState = State.IDLE;
            }
        }
        if (this.currentState == State.RESETTING) {
            this.progress = 0.5 - 0.5 * Math.cos(Math.PI * this.progress);
            if (this.progress >= 1.0) {
                this.currentState = State.IDLE;
            }
        }
        if (this.currentState == State.RESETTING) {
            double dProgress = this.progress - this.prevProgress;
            float prevPitch = player.method_36455();
            this.dPitch = (this.initialPitch - this.startPitch) * dProgress;
            float newXRot = (float)((double)prevPitch + this.dPitch);
            player.method_36457(newXRot);
            return;
        }
        if (this.isForward && this.progress > middleProgress) {
            this.isForward = false;
        }
        double dProgress = this.progress - this.prevProgress;
        this.dPitch = this.isForward ? -this.actualAmplitude * dProgress / middleProgress : this.dPitchResetRatio * this.actualAmplitude * dProgress / (1.0 - middleProgress);
        float prevPitch = player.method_36455();
        float newXRot = (float)((double)prevPitch + this.dPitch);
        if (!this.isForward) {
            if ((double)newXRot < this.startPitch) {
                player.method_36457(newXRot);
            }
        } else {
            player.method_36457(newXRot);
        }
    }

    @Override
    public void onStartFiring(class_1309 player, GunClientState state, class_1799 itemStack) {
        this.isForward = true;
        this.currentState = State.RECOILING;
        this.elapsedTime = -1;
        this.startTime = System.nanoTime();
        this.startPitch = player.method_36455();
        this.prevProgress = 0.0;
        this.progress = 0.0;
        this.actualAmplitude = state.isAiming() ? this.amplitude * 0.5 : this.amplitude;
        this.actualAmplitude *= (double)RecoilFeature.getRecoilModifier(itemStack);
        if (state.getTotalUninterruptedShots() <= 1 || this.startPitch > this.initialPitch) {
            this.initialPitch = this.startPitch;
        }
        this.dPitchResetRatio = state.getTotalUninterruptedShots() <= 1 || Math.abs(this.startPitch - this.initialPitch) >= Math.abs(this.maxPitch) ? 1.0 : 0.1;
    }

    protected double getProgress(GunClientState gunClientState, float partialTicks) {
        double progress = (double)(System.nanoTime() - this.startTime) / (double)this.nanoSecPerTransition;
        if (progress > 1.0) {
            progress = 1.0;
        }
        return progress;
    }

    private static enum State {
        IDLE,
        RECOILING,
        RESETTING;

    }
}

