/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render;

import com.vicmatskiv.pointblank.client.effect.Effect;
import com.vicmatskiv.pointblank.client.effect.EffectRenderContext;
import com.vicmatskiv.pointblank.client.render.ProjectileItemEntityRenderer;
import com.vicmatskiv.pointblank.client.uv.StaticSpriteUVProvider;
import com.vicmatskiv.pointblank.entity.ProjectileLike;
import com.vicmatskiv.pointblank.item.AmmoItem;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtils;

public class ProjectileItemRenderer
extends GeoItemRenderer<AmmoItem> {
    public static final String BONE_NOZZLE = "nozzle";

    public ProjectileItemRenderer(String resourceName) {
        super((GeoModel)new DefaultedItemGeoModel(new class_2960("pointblank", resourceName)));
        this.addRenderLayer(new EffectsLayer((GeoRenderer<AmmoItem>)this));
    }

    public void renderCubesOfBone(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (!BONE_NOZZLE.equals(bone.getName())) {
            super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    public static class EffectsLayer
    extends GeoRenderLayer<AmmoItem> {
        public EffectsLayer(GeoRenderer<AmmoItem> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(class_4587 poseStack, AmmoItem animatable, BakedGeoModel bakedModel, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
            GeoBone nozzleBone;
            ProjectileLike projectile = ProjectileItemEntityRenderer.getCurrentProjectile();
            class_4587.class_4665 pose = ProjectileItemEntityRenderer.getCurrentPose();
            if (projectile != null && pose != null && (nozzleBone = (GeoBone)bakedModel.getBone(ProjectileItemRenderer.BONE_NOZZLE).orElse(null)) != null) {
                poseStack.method_22903();
                RenderUtils.translateToPivotPoint((class_4587)poseStack, (CoreGeoBone)nozzleBone);
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                List<Effect> attachedEffects = projectile.getActiveAttachedEffects();
                for (Effect attachedEffect : attachedEffects) {
                    EffectRenderContext effectRenderContext = new EffectRenderContext().withPoseStack(poseStack).withProgress(projectile.getProgress(partialTick)).withLightColor(packedLight).withSpriteUVProvider(StaticSpriteUVProvider.INSTANCE).withBufferSource(bufferSource);
                    attachedEffect.render(effectRenderContext);
                }
                poseStack.method_22909();
            }
        }
    }
}

