/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render;

import com.google.gson.JsonObject;
import com.vicmatskiv.pointblank.client.EntityRendererBuilder;
import com.vicmatskiv.pointblank.client.effect.AbstractEffect;
import com.vicmatskiv.pointblank.client.effect.Effect;
import com.vicmatskiv.pointblank.client.uv.LoopingSpriteUVProvider;
import com.vicmatskiv.pointblank.client.uv.PlayOnceSpriteUVProvider;
import com.vicmatskiv.pointblank.client.uv.RandomSpriteUVProvider;
import com.vicmatskiv.pointblank.client.uv.SpriteUVProvider;
import com.vicmatskiv.pointblank.client.uv.StaticSpriteUVProvider;
import com.vicmatskiv.pointblank.entity.ProjectileLike;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class SpriteEntityRenderer<T extends class_1297>
extends class_897<T> {
    private class_2960 texture;
    private class_1921 renderType;
    private SpriteUVProvider spriteUVProvider;
    private float initialRoll;
    private boolean isGlowEnabled;
    private int brightness;
    private float rotationsPerSecond;
    private float width;
    private float height;

    public SpriteEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void method_3936(T projectile, float p_114657_, float partialTick, class_4587 poseStack, class_4597 bufferSource, int lightColor) {
        float progress = (float)((ProjectileLike)projectile).getElapsedTimeMillis() / 1000.0f;
        poseStack.method_22903();
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        poseStack.method_22907(camera.method_23767());
        float[] uv = this.spriteUVProvider.getSpriteUV(progress);
        if (uv == null) {
            return;
        }
        class_4588 vertexConsumer = bufferSource.getBuffer(this.renderType);
        if (this.isGlowEnabled) {
            lightColor = 240;
        }
        float alpha = 1.0f;
        float spriteWidth = uv[2] - uv[0];
        float textureMinU = 0.0f;
        float textureMaxU = 1.0f;
        float minU = uv[0] + spriteWidth * textureMinU;
        float minV = uv[1];
        float maxU = uv[0] + spriteWidth * textureMaxU;
        float maxV = uv[3];
        Quaternionf rotation = new Quaternionf();
        float roll = this.initialRoll + this.rotationsPerSecond * 360.0f * progress;
        rotation.rotateZ((float)Math.PI / 180 * roll);
        poseStack.method_22907(rotation);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        float halfWidth = (this.width > 0.0f ? this.width : projectile.method_17681()) * 0.5f;
        float halfHeight = (this.height > 0.0f ? this.height : projectile.method_17682()) * 0.5f;
        for (int k = 0; k < this.brightness; ++k) {
            vertexConsumer.method_22918(matrix4f, -halfWidth, halfHeight, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(maxU, minV).method_22916(lightColor).method_1344();
            vertexConsumer.method_22918(matrix4f, halfWidth, halfHeight, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(minU, minV).method_22916(lightColor).method_1344();
            vertexConsumer.method_22918(matrix4f, halfWidth, -halfHeight, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(minU, maxV).method_22916(lightColor).method_1344();
            vertexConsumer.method_22918(matrix4f, -halfWidth, -halfHeight, 0.0f).method_22915(1.0f, 1.0f, 1.0f, (float)this.brightness).method_22913(maxU, maxV).method_22916(lightColor).method_1344();
        }
        poseStack.method_22909();
    }

    public class_2960 method_3931(class_1297 entity) {
        return this.texture;
    }

    public static class Builder<T extends class_1297>
    implements EntityRendererBuilder<Builder<T>, T, class_897<T>> {
        private static long counter;
        private static final SpriteUVProvider DEFAULT_SPRITE_UV_PROVIDER;
        private static final String DEFAULT_NAME_PREFIX;
        private static Effect.BlendMode DEFAULT_BLEND_MODE;
        private static final int DEFAULT_BRIGHTNESS = 1;
        private static final float DEFAULT_NUM_ROTATIONS = 0.0f;
        private class_2960 texture;
        private Effect.BlendMode blendMode;
        private boolean isDepthTestEnabled;
        private boolean isGlowEnabled;
        private int brightness;
        private AbstractEffect.SpriteInfo spriteInfo;
        private float numRotations;
        private float width;
        private float height;

        public Builder() {
            ++counter;
            this.blendMode = DEFAULT_BLEND_MODE;
            this.brightness = 1;
            this.numRotations = 0.0f;
            this.width = Float.NEGATIVE_INFINITY;
            this.height = Float.NEGATIVE_INFINITY;
        }

        public Builder withSize(float width, float hight) {
            this.width = width;
            return this;
        }

        public Builder withSize(float size) {
            this.width = size;
            this.height = size;
            return this;
        }

        public Builder withTexture(class_2960 texture) {
            this.texture = texture;
            return this;
        }

        public Builder withTexture(String textureName) {
            this.texture = new class_2960("pointblank", textureName);
            return this;
        }

        public Builder withBlendMode(Effect.BlendMode blendMode) {
            this.blendMode = blendMode;
            return this;
        }

        public Builder withDepthTest(boolean isDepthTestEnabled) {
            this.isDepthTestEnabled = isDepthTestEnabled;
            return this;
        }

        public Builder withGlow(boolean isGlowEnabled) {
            this.isGlowEnabled = isGlowEnabled;
            return this;
        }

        public Builder withBrightness(int brightness) {
            this.brightness = brightness;
            return this;
        }

        public Builder withSprites(int rows, int columns, int spritesPerSecond, AbstractEffect.SpriteAnimationType type) {
            this.spriteInfo = new AbstractEffect.SpriteInfo(rows, columns, spritesPerSecond, type);
            return this;
        }

        public Builder withRotations(double numRotations) {
            this.numRotations = (float)numRotations;
            return this;
        }

        @Override
        public Builder<T> withJsonObject(JsonObject obj) {
            return null;
        }

        @Override
        public class_897<T> build(class_5617.class_5618 context) {
            SpriteEntityRenderer renderer = new SpriteEntityRenderer(context);
            renderer.width = this.width;
            renderer.height = this.height;
            renderer.initialRoll = new Random().nextFloat() * 360.0f;
            renderer.isGlowEnabled = this.isGlowEnabled;
            renderer.brightness = this.brightness;
            renderer.rotationsPerSecond = this.numRotations;
            renderer.texture = this.texture;
            String renderTypeName = DEFAULT_NAME_PREFIX + "." + counter;
            renderer.renderType = EffectRenderType.createRenderType(renderTypeName, this.texture, this.blendMode, this.isDepthTestEnabled);
            if (this.spriteInfo != null) {
                switch (this.spriteInfo.type()) {
                    case STATIC: {
                        renderer.spriteUVProvider = StaticSpriteUVProvider.INSTANCE;
                        break;
                    }
                    case LOOP: {
                        LoopingSpriteUVProvider spriteUVProvider = new LoopingSpriteUVProvider(this.spriteInfo.rows(), this.spriteInfo.columns(), this.spriteInfo.spritesPerSecond(), 1000L);
                        renderer.spriteUVProvider = spriteUVProvider;
                        break;
                    }
                    case RANDOM: {
                        renderer.spriteUVProvider = new RandomSpriteUVProvider(this.spriteInfo.rows(), this.spriteInfo.columns(), this.spriteInfo.spritesPerSecond(), 1000L);
                        break;
                    }
                    case PLAY_ONCE: {
                        PlayOnceSpriteUVProvider spriteUVProvider = new PlayOnceSpriteUVProvider(this.spriteInfo.rows(), this.spriteInfo.columns(), this.spriteInfo.spritesPerSecond(), 1000L);
                        renderer.spriteUVProvider = spriteUVProvider;
                        break;
                    }
                }
            } else {
                renderer.spriteUVProvider = DEFAULT_SPRITE_UV_PROVIDER;
            }
            return renderer;
        }

        static {
            DEFAULT_SPRITE_UV_PROVIDER = StaticSpriteUVProvider.INSTANCE;
            DEFAULT_NAME_PREFIX = "pointblank:" + SpriteEntityRenderer.class.getSimpleName();
            DEFAULT_BLEND_MODE = Effect.BlendMode.NORMAL;
        }
    }

    private static final class EffectRenderType
    extends class_1921 {
        private EffectRenderType(String renderTypeName, class_293 vertexFormat, class_293.class_5596 p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable runnable) {
            super(renderTypeName, vertexFormat, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, runnable);
        }

        private static class_1921 createRenderType(String name, class_2960 texture, Effect.BlendMode blendMode, boolean isDepthTestEnabled) {
            return class_1921.method_24049((String)name, (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23615(switch (blendMode) {
                case Effect.BlendMode.NORMAL -> field_21370;
                default -> field_21367;
            }).method_23604(isDepthTestEnabled ? field_21348 : field_21346).method_23603(field_21345).method_23608(field_21383).method_23611(field_21385).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_34578(class_4668.field_29441).method_23617(false));
        }
    }
}

