/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render;

import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.client.ClientEventHandler;
import com.vicmatskiv.pointblank.client.render.HierarchicalRenderContext;
import com.vicmatskiv.pointblank.client.render.RenderApprover;
import com.vicmatskiv.pointblank.client.render.RenderPass;
import com.vicmatskiv.pointblank.client.render.RenderPassGeoRenderer;
import com.vicmatskiv.pointblank.client.render.RenderPassProvider;
import com.vicmatskiv.pointblank.client.render.RenderTypeProvider;
import com.vicmatskiv.pointblank.client.render.layer.GunHandsItemLayer;
import com.vicmatskiv.pointblank.compat.iris.IrisCompat;
import com.vicmatskiv.pointblank.feature.Feature;
import com.vicmatskiv.pointblank.feature.SkinFeature;
import com.vicmatskiv.pointblank.item.ThrowableItem;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_811;
import org.joml.Quaternionf;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.ClientUtils;

public class ThrowableItemRenderer
extends GeoItemRenderer<ThrowableItem>
implements RenderPassGeoRenderer<ThrowableItem>,
RenderApprover {
    public static final String BONE_RIGHTARM = "rightarm";
    public static final String BONE_LEFTARM = "leftarm";
    public static final String BONE_CAMERA = "_camera_";
    private class_809 transforms;
    private final class_2960 leftHandModelResource = new class_2960("pointblank", "geo/item/left_arm.geo.json");
    private final class_2960 rightHandModelResource = new class_2960("pointblank", "geo/item/right_arm.geo.json");
    private final class_2960 reticleModelResource = new class_2960("pointblank", "geo/item/reticle.geo.json");

    public ThrowableItemRenderer(class_2960 modelResource) {
        super((GeoModel)new DefaultedItemGeoModel(modelResource));
        this.addRenderLayer(new GunHandsItemLayer<ThrowableItem>(this));
    }

    public class_2960 getTextureLocation(ThrowableItem animatable) {
        class_2960 texture = null;
        HierarchicalRenderContext hrc = HierarchicalRenderContext.getRoot();
        if (hrc != null) {
            class_1799 itemStack = hrc.getItemStack();
            texture = SkinFeature.getTexture(itemStack);
        }
        if (texture == null) {
            texture = super.getTextureLocation((class_1792)animatable);
        }
        return texture;
    }

    @Override
    public GeoRenderer<ThrowableItem> getRenderer() {
        return this;
    }

    private BakedGeoModel getLeftHandModel() {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(this.leftHandModelResource);
    }

    private BakedGeoModel getRightHandModel() {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(this.rightHandModelResource);
    }

    private class_1657 getPlayer(class_811 itemDisplayContext) {
        if (itemDisplayContext == class_811.field_4321 || itemDisplayContext == class_811.field_4322 || itemDisplayContext == class_811.field_4318) {
            return ClientUtils.getClientPlayer();
        }
        class_1309 renderedEntity = ClientEventHandler.getCurrentEntityLiving();
        if (renderedEntity instanceof class_1657) {
            return (class_1657)renderedEntity;
        }
        return null;
    }

    public void method_3166(class_1799 stack, class_811 itemDisplayContext, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        if (IrisCompat.getInstance().isRenderingShadows()) {
            return;
        }
        class_1657 player = this.getPlayer(itemDisplayContext);
        if (player == null) {
            return;
        }
        class_4597 wrappedBufferSource = RenderTypeProvider.getInstance().wrapBufferSource(bufferSource);
        try (HierarchicalRenderContext hrc = HierarchicalRenderContext.push(stack, itemDisplayContext);){
            this.renderPass(() -> {
                boolean isFirstPerson = itemDisplayContext == class_811.field_4321 || itemDisplayContext == class_811.field_4322;
                poseStack.method_22903();
                ThrowableItem gunItem = (ThrowableItem)stack.method_7909();
                GeoModel geoModel = this.getGeoModel();
                if (isFirstPerson) {
                    this.initTransforms(player, stack, itemDisplayContext);
                    this.adjustFirstPersonPose(stack, gunItem, poseStack, (GeoModel<ThrowableItem>)geoModel);
                }
                super.method_3166(stack, itemDisplayContext, poseStack, wrappedBufferSource, packedLight, packedOverlay);
                poseStack.method_22909();
            });
        }
    }

    @Override
    public void renderPass(Runnable runnablePass) {
        RenderPass.push(this.getRenderPass());
        try {
            runnablePass.run();
        }
        finally {
            RenderPass.pop();
        }
    }

    private void adjustFirstPersonPose(class_1799 itemStack, ThrowableItem throwableItem, class_4587 poseStack, GeoModel<ThrowableItem> geoModel) {
        if (this.transforms == null) {
            return;
        }
        class_804 fprt = this.transforms.field_4304;
        if (fprt == null) {
            return;
        }
        float v = 1.0f;
        float rescale = throwableItem.getModelScale();
        poseStack.method_46416(0.5f, 0.5f, 0.5f);
        poseStack.method_22907(new Quaternionf().rotationXYZ(-fprt.field_4287.x * ((float)Math.PI / 180), -fprt.field_4287.y * ((float)Math.PI / 180), -fprt.field_4287.z * ((float)Math.PI / 180)));
        poseStack.method_46416(-fprt.field_4286.x, -fprt.field_4286.y, -fprt.field_4286.z);
        poseStack.method_46416(fprt.field_4286.x * rescale, fprt.field_4286.y * rescale, fprt.field_4286.z * rescale);
        poseStack.method_22907(new Quaternionf().rotationXYZ(fprt.field_4287.x * ((float)Math.PI / 180), fprt.field_4287.y * ((float)Math.PI / 180), fprt.field_4287.z * ((float)Math.PI / 180)));
        poseStack.method_22905(rescale, rescale, rescale);
        poseStack.method_46416(-0.5f, -0.5f, -0.5f);
        poseStack.method_46416(0.48f, -1.12f, -0.72f);
        poseStack.method_46416(-0.006f, 0.6f, 0.0f);
    }

    private void initTransforms(class_1657 player, class_1799 stack, class_811 itemDisplayContext) {
        if (this.transforms == null) {
            this.transforms = Platform.getInstance().getItemTransforms(player, stack).apply(itemDisplayContext);
        }
    }

    private boolean shouldRenderBone(String boneName) {
        if (boneName.charAt(0) == '_') {
            return false;
        }
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        class_1799 rootStack = HierarchicalRenderContext.getRoot().getItemStack();
        boolean shouldRender = true;
        for (GeoRenderLayer layer : this.getRenderLayers()) {
            RenderPass renderPass;
            RenderPass renderPass2;
            if (!(layer instanceof RenderApprover)) continue;
            RenderApprover renderApprover = (RenderApprover)layer;
            if (layer instanceof RenderPassProvider) {
                RenderPassProvider rp = (RenderPassProvider)layer;
                renderPass2 = rp.getRenderPass();
            } else {
                renderPass2 = null;
            }
            if (renderApprover.approveRendering(renderPass = renderPass2, boneName, rootStack, current.getItemStack(), current.getPath(), current.getItemDisplayContext())) continue;
            shouldRender = false;
            break;
        }
        return shouldRender;
    }

    public void renderRecursively(class_4587 poseStack, ThrowableItem animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        class_1799 rootStack = HierarchicalRenderContext.getRoot().getItemStack();
        boolean shouldRender = this.approveRendering(this.getRenderPass(), bone.getName(), rootStack, current.getItemStack(), current.getPath(), current.getItemDisplayContext());
        if (shouldRender) {
            super.renderRecursively(poseStack, (class_1792)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    public void renderCubesOfBone(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        RenderPass renderPass = RenderPass.current();
        if (!this.shouldRenderBone(bone.getName())) {
            return;
        }
        HierarchicalRenderContext hrc = HierarchicalRenderContext.current();
        class_811 itemDisplayContext = hrc.getItemDisplayContext();
        boolean isFirstPerson = itemDisplayContext == class_811.field_4321 || itemDisplayContext == class_811.field_4322;
        double aimingProgress = 0.0;
        switch (renderPass) {
            case HANDS: {
                if (bone.getName().equals(BONE_RIGHTARM)) {
                    this.renderRightArm(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    break;
                }
                if (!bone.getName().equals(BONE_LEFTARM)) break;
                this.renderLeftArm(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case MAIN_ITEM: {
                if (!this.canRenderPart(bone.getName())) break;
                super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
    }

    private void renderLeftArm(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        BakedGeoModel handsBakedGeoModel = this.getLeftHandModel();
        GeoBone leftArmBone = handsBakedGeoModel.getBone(BONE_LEFTARM).orElse(null);
        if (leftArmBone != null) {
            poseStack.method_22903();
            this.applyArmRefTransforms(poseStack, bone, leftArmBone);
            super.renderCubesOfBone(poseStack, leftArmBone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.method_22909();
        }
    }

    private void renderRightArm(class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        BakedGeoModel handsBakedGeoModel = this.getRightHandModel();
        GeoBone rightArmBone = handsBakedGeoModel.getBone(BONE_RIGHTARM).orElse(null);
        if (rightArmBone != null) {
            poseStack.method_22903();
            this.applyArmRefTransforms(poseStack, bone, rightArmBone);
            super.renderCubesOfBone(poseStack, rightArmBone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.method_22909();
        }
    }

    private void applyArmRefTransforms(class_4587 poseStack, GeoBone refBone, GeoBone leftArmBone) {
        GeoCube leftArmBoneCube = (GeoCube)leftArmBone.getCubes().get(0);
        GeoCube refCube = (GeoCube)refBone.getCubes().get(0);
        GeoVertex leftArmBoneVertex = leftArmBoneCube.quads()[0].vertices()[0];
        GeoVertex refVertex = refCube.quads()[0].vertices()[0];
        float dx = refVertex.position().x() - leftArmBoneVertex.position().x();
        float dy = refVertex.position().y() - leftArmBoneVertex.position().y();
        float dz = refVertex.position().z() - leftArmBoneVertex.position().z();
        poseStack.method_46416(dx, dy, dz);
    }

    private void applyRefTransforms(class_4587 poseStack, GeoBone refBone, GeoBone actualBone) {
        GeoCube actualArmBoneCube = (GeoCube)actualBone.getCubes().get(0);
        GeoCube refCube = (GeoCube)refBone.getCubes().get(0);
        GeoVertex refQ0v0 = refCube.quads()[2].vertices()[0];
        GeoVertex refQ0v2 = refCube.quads()[2].vertices()[2];
        GeoVertex actualQ0v0 = actualArmBoneCube.quads()[2].vertices()[0];
        GeoVertex actualQ0v2 = actualArmBoneCube.quads()[2].vertices()[2];
        float refSizeX = Math.abs(refQ0v0.position().x - refQ0v2.position().x);
        float actualSizeX = Math.abs(actualQ0v0.position().x - actualQ0v2.position().x);
        float refSizeY = Math.abs(refQ0v0.position().y - refQ0v2.position().y);
        float actualSizeY = Math.abs(actualQ0v0.position().y - actualQ0v2.position().y);
        float refXLeft = refQ0v0.position().x;
        float refZLeft = refQ0v2.position().z;
        float actualXLeft = actualQ0v0.position().x;
        float actualYTop = actualQ0v0.position().y;
        float refYTop = refQ0v0.position().y;
        float actualZLeft = actualQ0v0.position().z;
        float dx = -(actualXLeft + (refXLeft - (refSizeX - actualSizeX) / 2.0f));
        float dy = refYTop + (actualSizeY - refSizeY) / 2.0f - actualYTop;
        float dz = refZLeft - actualZLeft;
        poseStack.method_46416(dx, dy, dz);
    }

    @Override
    public boolean isEffectLayer() {
        return false;
    }

    @Override
    public class_1921 getRenderType() {
        return null;
    }

    @Override
    public boolean isSupportedItemDisplayContext(class_811 context) {
        return true;
    }

    @Override
    public boolean canRenderPart(String boneName) {
        return !boneName.equals(BONE_LEFTARM) && !boneName.equals(BONE_RIGHTARM);
    }

    @Override
    public RenderPass getRenderPass() {
        return RenderPass.MAIN_ITEM;
    }

    @Override
    public Class<? extends Feature> getFeatureType() {
        return null;
    }
}

