/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render.layer;

import com.vicmatskiv.pointblank.client.render.HierarchicalRenderContext;
import com.vicmatskiv.pointblank.client.render.RenderApprover;
import com.vicmatskiv.pointblank.client.render.RenderPass;
import com.vicmatskiv.pointblank.client.render.RenderPassRenderer;
import com.vicmatskiv.pointblank.feature.Feature;
import com.vicmatskiv.pointblank.feature.FeatureProvider;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public abstract class FeaturePassLayer<T extends GeoAnimatable>
extends GeoRenderLayer<T>
implements RenderPassRenderer<T>,
RenderApprover {
    protected static final Collection<String> ALL_PARTS = Collections.emptySet();
    private RenderPass renderPass;
    private Class<? extends Feature> featureType;
    private boolean isEffectLayer;
    private Collection<String> renderedParts;
    protected Object effectId;

    public FeaturePassLayer(GeoRenderer<T> renderer, Class<? extends Feature> featureType, RenderPass renderPass, Collection<String> renderedParts, boolean isEffectLayer, Object effectId) {
        super(renderer);
        this.featureType = featureType;
        this.renderPass = renderPass;
        this.isEffectLayer = isEffectLayer;
        this.effectId = effectId;
        this.renderedParts = renderedParts != ALL_PARTS ? Collections.unmodifiableCollection(renderedParts) : ALL_PARTS;
    }

    public void render(class_4587 poseStack, T animatable, BakedGeoModel bakedModel, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        this.renderPass(() -> {
            class_1921 renderType2 = this.getRenderType();
            this.render(this.getDefaultBakedModel((GeoAnimatable)animatable), poseStack, bufferSource, (GeoAnimatable)animatable, renderType2, bufferSource.getBuffer(renderType2), partialTick, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        });
    }

    @Override
    public RenderPass getRenderPass() {
        return this.renderPass;
    }

    @Override
    public boolean canRenderPart(String partName) {
        return this.renderedParts == ALL_PARTS || this.renderedParts.contains(partName);
    }

    @Override
    public Class<? extends Feature> getFeatureType() {
        return this.featureType;
    }

    @Override
    public boolean isEffectLayer() {
        return this.isEffectLayer;
    }

    public Object getEffectId() {
        return this.effectId;
    }

    public static <F extends Feature> F getFeature(Class<F> featureType) {
        class_1792 class_17922;
        HierarchicalRenderContext hrc = HierarchicalRenderContext.current();
        if (hrc != null && (class_17922 = hrc.getItemStack().method_7909()) instanceof FeatureProvider) {
            FeatureProvider fp = (FeatureProvider)class_17922;
            HierarchicalRenderContext root = HierarchicalRenderContext.getRoot();
            F feature = fp.getFeature(featureType);
            if (feature != null && feature.isEnabledForAttachment(root.getItemStack(), hrc.getItemStack())) {
                return feature;
            }
        }
        return null;
    }
}

