/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.entity;

import com.google.gson.JsonObject;
import com.vicmatskiv.pointblank.client.EntityRendererBuilder;
import com.vicmatskiv.pointblank.client.effect.AbstractEffect;
import com.vicmatskiv.pointblank.client.effect.AttachedProjectileEffect;
import com.vicmatskiv.pointblank.client.effect.Effect;
import com.vicmatskiv.pointblank.client.effect.EffectBuilder;
import com.vicmatskiv.pointblank.client.effect.TrailEffect;
import com.vicmatskiv.pointblank.entity.EntityBuilder;
import com.vicmatskiv.pointblank.entity.ExtraSpawnDataHolder;
import com.vicmatskiv.pointblank.entity.ProjectileLike;
import com.vicmatskiv.pointblank.item.EffectBuilderInfo;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.item.HurtingItem;
import com.vicmatskiv.pointblank.network.ClientBoundAddSpawnEntityDataPacket;
import com.vicmatskiv.pointblank.registry.EntityRegistry;
import com.vicmatskiv.pointblank.util.HitScan;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.TimeUnit;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1682;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2658;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5617;
import net.minecraft.class_897;

public class GenericThrowableProjectile
extends class_1682
implements ProjectileLike,
ExtraSpawnDataHolder {
    private static final float DEFAULT_GRAVITY = 0.05f;
    private static final float DEFAULT_WIDTH = 0.25f;
    private static final float DEFAULT_HEIGHT = 0.25f;
    private static final int DEFAULT_CLIENT_TRACKING_RANGE = 1024;
    private static final int DEFAULT_UPDATE_INTERVAL = 1;
    private static final int DEFAULT_LIFETIME_TICKS = 200;
    private static final double MIN_SPEED_THRESHOLD = 0.01;
    private HurtingItem throwableItem;
    private class_1799 throwableItemStack;
    private double initialVelocityBlocksPerTick;
    private boolean isRicochet;
    private float gravity;
    private int maxLifetimeTicks;
    private List<ProjectileLike.EffectInfo> trailEffects;
    private List<ProjectileLike.EffectInfo> attachedEffects;
    private List<Effect> activeTrailEffects = Collections.emptyList();
    private List<Effect> activeAttachedEffects = Collections.emptyList();

    public static Builder builder() {
        return new Builder();
    }

    public GenericThrowableProjectile(class_1299<? extends GenericThrowableProjectile> entityType, class_1937 level) {
        super(entityType, level);
    }

    public GenericThrowableProjectile(class_1299<? extends GenericThrowableProjectile> entityType, class_1309 owner, class_1937 level) {
        super(entityType, owner, level);
    }

    private void setInitialVelocityBlocksPerTick(double initialVelocityBlocksPerTick) {
        this.initialVelocityBlocksPerTick = initialVelocityBlocksPerTick;
    }

    private void setGravity(float gravity) {
        this.gravity = gravity;
    }

    protected float method_7490() {
        return this.gravity;
    }

    public void setMaxLifetimeTicks(int maxLifetimeTicks) {
        this.maxLifetimeTicks = maxLifetimeTicks;
    }

    @Override
    public class_1799 getItem() {
        return this.throwableItemStack;
    }

    @Override
    public List<Effect> getActiveAttachedEffects() {
        return this.activeTrailEffects;
    }

    @Override
    public float getProgress(float partialTick) {
        return 0.0f;
    }

    @Override
    public long getElapsedTimeMillis() {
        return 0L;
    }

    @Override
    public double getInitialVelocityBlocksPerTick() {
        return this.initialVelocityBlocksPerTick;
    }

    @Override
    public void launchAtTargetEntity(class_1309 player, class_239 hitResult, class_1297 targetEntity) {
        class_243 hitLocation = hitResult.method_17784();
        class_243 muzzleWorldPos = this.method_19538();
        class_243 eyePos = player.method_33571();
        class_243 viewHitVector = hitLocation.method_1020(eyePos);
        class_243 spawnOffset = muzzleWorldPos.method_1020(eyePos);
        class_243 direction = viewHitVector.method_1020(spawnOffset).method_1029();
        this.method_7485(direction.field_1352, direction.field_1351, direction.field_1350, (float)this.getInitialVelocityBlocksPerTick(), 0.0f);
    }

    @Override
    public void launchAtLookTarget(class_1309 player, double inaccuracy, long seed) {
        class_239 hitScanTarget = HitScan.getNearestObjectInCrosshair(player, 0.0f, 150.0, inaccuracy, seed, block -> false, block -> false, new ArrayList<class_2338>());
        class_243 hitLocation = hitScanTarget.method_17784();
        class_243 muzzleWorldPos = this.method_19538();
        class_243 eyePos = player.method_33571();
        class_243 viewHitVector = hitLocation.method_1020(eyePos);
        class_243 spawnOffset = muzzleWorldPos.method_1020(eyePos);
        class_243 direction = viewHitVector.method_1020(spawnOffset).method_1029();
        this.method_7485(direction.field_1352, direction.field_1351, direction.field_1350, (float)this.getInitialVelocityBlocksPerTick(), 0.0f);
    }

    private double getSpeedSqr() {
        return this.method_18798().method_1027();
    }

    protected void method_24920(class_3965 blockHitResult) {
        if (this.isRicochet) {
            class_2338 resultPos = blockHitResult.method_17777();
            class_1937 level = MiscUtil.getLevel((class_1297)this);
            class_2680 state = level.method_8320(resultPos);
            class_3414 event = state.method_26204().method_9573(state).method_10594();
            if (this.getSpeedSqr() > 0.01) {
                level.method_43128(null, blockHitResult.method_17784().field_1352, blockHitResult.method_17784().field_1351, blockHitResult.method_17784().field_1350, event, class_3419.field_15256, 1.0f, 1.0f);
            }
            this.ricochet(blockHitResult.method_17780());
        } else {
            class_1297 owner = this.method_24921();
            if (owner instanceof class_1309) {
                class_1309 player = (class_1309)owner;
                this.throwableItem.handleBlockHit(player, blockHitResult, (class_1297)this);
            }
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 owner = this.method_24921();
        if (this.isRicochet) {
            if (owner instanceof class_1309) {
                class_1297 entity;
                class_1309 player = (class_1309)owner;
                if (this.getSpeedSqr() > 0.01 && !MiscUtil.isProtected(entity = entityHitResult.method_17782())) {
                    entity.method_5643(entity.method_48923().method_48811((class_1297)this, this.method_24921()), 0.5f);
                }
            }
            this.ricochet(class_2350.method_10142((double)this.method_18798().method_10216(), (double)this.method_18798().method_10214(), (double)this.method_18798().method_10215()).method_10153(), 0.3, 1.0, 0.3);
        } else if (owner instanceof class_1309) {
            class_1309 player = (class_1309)owner;
            this.throwableItem.hurtEntity(player, entityHitResult, (class_1297)this, this.throwableItemStack);
        }
    }

    private void ricochet(class_2350 direction) {
        this.ricochet(direction, 1.0, 1.0, 1.0);
    }

    private void ricochet(class_2350 direction, double mx, double my, double mz) {
        class_2350.class_2351 axis = direction.method_10166();
        class_243 delta = this.method_18798();
        delta = delta.method_18805(axis == class_2350.class_2351.field_11048 ? -0.5 : 0.7, axis == class_2350.class_2351.field_11052 ? -0.2 : 0.7, axis == class_2350.class_2351.field_11051 ? -0.5 : 0.7);
        if (axis == class_2350.class_2351.field_11052 && delta.field_1351 < (double)this.method_7490()) {
            delta = new class_243(delta.field_1352, 0.0, delta.field_1350);
        }
        this.method_18799(delta.method_18805(mx, my, mz));
    }

    public boolean method_5740() {
        return false;
    }

    @Override
    public void writeSpawnData(class_2540 buffer) {
        buffer.method_10793(this.throwableItemStack);
    }

    @Override
    public void readSpawnData(class_2540 buffer) {
        this.throwableItemStack = buffer.method_10819();
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6012 >= this.maxLifetimeTicks) {
            this.doDiscard();
        }
        if (MiscUtil.isClientSide((class_1297)this)) {
            this.activeAttachedEffects = this.attachedEffects.stream().filter(ei -> ei.predicate().test(this)).map(ei -> ei.effect()).toList();
            this.activeTrailEffects = this.trailEffects.stream().filter(ei -> ei.predicate().test(this)).map(ei -> ei.effect()).toList();
            class_243 dm = this.method_18798();
            for (Effect trailEffect : this.activeTrailEffects) {
                ((TrailEffect)trailEffect).launchNext((class_1297)this, new class_243(this.method_23317(), this.method_23318(), this.method_23321()), dm);
            }
        }
    }

    public void doDiscard() {
        if (!MiscUtil.isClientSide((class_1297)this)) {
            if (this.throwableItem != null) {
                this.throwableItem.discardProjectile((class_1297)this);
            }
            this.method_31472();
        }
    }

    protected void method_5693() {
    }

    public class_2596<class_2602> method_18002() {
        ClientBoundAddSpawnEntityDataPacket packet = new ClientBoundAddSpawnEntityDataPacket((class_1297)this);
        class_2540 buf = new class_2540(Unpooled.buffer());
        ClientBoundAddSpawnEntityDataPacket.encode(packet, buf);
        return new class_2658(new class_2960("pointblank", "grenade"), buf);
    }

    public static class Builder
    implements EntityBuilder<Builder, GenericThrowableProjectile> {
        private String name;
        private float width = 0.25f;
        private float height = 0.25f;
        private double initialVelocityBlocksPerSecond;
        private int maxLifetimeTicks = 200;
        private float gravity;
        private boolean isRicochet;
        private final List<EffectBuilderInfo> effectBuilderSuppliers = new ArrayList<EffectBuilderInfo>();
        private Supplier<EntityRendererBuilder<?, class_1297, class_897<class_1297>>> rendererBuilder;
        private Supplier<HurtingItem> hurtingItem;

        private Builder() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Builder withItem(Supplier<class_1792> hurtingItem) {
            this.hurtingItem = () -> (HurtingItem)hurtingItem.get();
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withMaxLifetime(long lifetimeMillis) {
            this.maxLifetimeTicks = (int)TimeUnit.MILLISECOND.toTicks(lifetimeMillis);
            return this;
        }

        public Builder withSize(float width, float height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder withInitialVelocity(double initialVelocityBlocksPerSecond) {
            this.initialVelocityBlocksPerSecond = initialVelocityBlocksPerSecond;
            return this;
        }

        public Builder withRenderer(Supplier<EntityRendererBuilder<?, class_1297, class_897<class_1297>>> rendererBuilder2) {
            this.rendererBuilder = rendererBuilder2;
            return this;
        }

        public Builder withRicochet(boolean isRicochet) {
            this.isRicochet = isRicochet;
            return this;
        }

        public Builder withGravity(boolean isGravityEnabled) {
            this.gravity = isGravityEnabled ? 0.05f : 0.0f;
            return this;
        }

        public Builder withGravity(double gravity) {
            this.gravity = class_3532.method_15363((float)((float)gravity), (float)-1.0f, (float)1.0f);
            return this;
        }

        public Builder withEffect(EffectBuilderInfo effectInfo) {
            this.effectBuilderSuppliers.add(effectInfo);
            return this;
        }

        @Override
        public EntityBuilder.EntityTypeExt getEntityTypeExt() {
            return EntityBuilder.EntityTypeExt.PROJECTILE;
        }

        @Override
        public class_1299.class_1300<GenericThrowableProjectile> getEntityTypeBuilder() {
            return class_1299.class_1300.method_5903(this::build, (class_1311)class_1311.field_17715).method_17687(this.width, this.height).method_27299(1024).method_5901().method_19947().method_27300(1);
        }

        public GenericThrowableProjectile build(class_1299<?> entityType, class_1937 level) {
            GenericThrowableProjectile projectile = new GenericThrowableProjectile(entityType, level);
            if (level.field_9236) {
                this.initEffects(projectile);
            }
            if (this.hurtingItem != null) {
                projectile.throwableItem = this.hurtingItem.get();
                projectile.throwableItemStack = new class_1799((class_1935)projectile.throwableItem);
            }
            projectile.maxLifetimeTicks = this.maxLifetimeTicks;
            projectile.isRicochet = this.isRicochet;
            projectile.setInitialVelocityBlocksPerTick(this.initialVelocityBlocksPerSecond * (double)0.05f);
            projectile.setMaxLifetimeTicks(this.maxLifetimeTicks);
            projectile.method_5875(MiscUtil.isNearlyZero(this.gravity));
            projectile.setGravity(this.gravity);
            return projectile;
        }

        @Override
        public GenericThrowableProjectile build(class_1937 level) {
            Supplier<class_1299<?>> entityTypeSupplier = EntityRegistry.getTypeByName(this.name);
            return this.build(entityTypeSupplier.get(), level);
        }

        public void initEffects(GenericThrowableProjectile projectile) {
            ArrayList<ProjectileLike.EffectInfo> trailEffects = new ArrayList<ProjectileLike.EffectInfo>();
            ArrayList<ProjectileLike.EffectInfo> attachedEffects = new ArrayList<ProjectileLike.EffectInfo>();
            GunItem.FirePhase phase = GunItem.FirePhase.FLYING;
            for (EffectBuilderInfo effectBuilderInfo : this.effectBuilderSuppliers) {
                AbstractEffect effect;
                EffectBuilder.Context context;
                EffectBuilder<EffectBuilder<?, ?>, ?> effectBuilder = effectBuilderInfo.effectSupplier().get();
                if (effectBuilder.getCompatiblePhases().contains((Object)GunItem.FirePhase.FLYING)) {
                    context = new EffectBuilder.Context();
                    effect = (TrailEffect)effectBuilder.build(context);
                    trailEffects.add(new ProjectileLike.EffectInfo(effect, effectBuilderInfo.predicate()));
                    continue;
                }
                if (effectBuilder instanceof AttachedProjectileEffect.Builder) {
                    context = new EffectBuilder.Context();
                    effect = (AttachedProjectileEffect)effectBuilder.build(context);
                    attachedEffects.add(new ProjectileLike.EffectInfo(effect, effectBuilderInfo.predicate()));
                    continue;
                }
                throw new IllegalStateException("Effect builder " + effectBuilder + " is not compatible with phase '" + phase + "'. Check how you construct projectile: " + this.getName());
            }
            projectile.trailEffects = Collections.unmodifiableList(trailEffects);
            projectile.attachedEffects = Collections.unmodifiableList(attachedEffects);
        }

        @Override
        public boolean hasRenderer() {
            return this.rendererBuilder != null;
        }

        @Override
        public class_897<class_1297> createEntityRenderer(class_5617.class_5618 context) {
            return this.rendererBuilder.get().build(context);
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            throw new UnsupportedOperationException();
        }
    }
}

