/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.entity;

import com.google.gson.JsonObject;
import com.vicmatskiv.pointblank.NetworkService;
import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.client.EntityRendererBuilder;
import com.vicmatskiv.pointblank.client.effect.AbstractEffect;
import com.vicmatskiv.pointblank.client.effect.AttachedProjectileEffect;
import com.vicmatskiv.pointblank.client.effect.Effect;
import com.vicmatskiv.pointblank.client.effect.EffectBuilder;
import com.vicmatskiv.pointblank.client.effect.TrailEffect;
import com.vicmatskiv.pointblank.entity.EntityBuilder;
import com.vicmatskiv.pointblank.entity.ExtraSpawnDataHolder;
import com.vicmatskiv.pointblank.entity.ProjectileLike;
import com.vicmatskiv.pointblank.item.AmmoItem;
import com.vicmatskiv.pointblank.item.EffectBuilderInfo;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.item.HurtingItem;
import com.vicmatskiv.pointblank.network.ClientBoundAddSpawnEntityDataPacket;
import com.vicmatskiv.pointblank.registry.EntityRegistry;
import com.vicmatskiv.pointblank.util.DirectAttackTrajectory;
import com.vicmatskiv.pointblank.util.HitScan;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.TimeUnit;
import com.vicmatskiv.pointblank.util.TopDownAttackTrajectory;
import com.vicmatskiv.pointblank.util.Trajectory;
import com.vicmatskiv.pointblank.util.TrajectoryProvider;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2658;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SlowProjectile
extends class_1668
implements ProjectileLike,
ExtraSpawnDataHolder {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static final double MAX_RENDER_DISTANCE_SQR = 40000.0;
    private static final float MAX_HIT_SCAN_DISTANCE = 10.0f;
    static final float DEFAULT_MAX_DISTANCE = 150.0f;
    private static final double DEFAULT_GRAVITY = 0.05;
    private static final class_2940<OptionalInt> DATA_ATTACHED_TO_TARGET = class_2945.method_12791(SlowProjectile.class, (class_2941)class_2943.field_17910);
    private static final class_2940<Boolean> DATA_SHOT_AT_ANGLE = class_2945.method_12791(SlowProjectile.class, (class_2941)class_2943.field_13323);
    private double initialVelocityBlocksPerTick;
    private int life;
    private int lifetime;
    private class_239 hitScanTarget;
    private double gravity;
    private class_1309 attachedToEntity;
    private float initialAngle;
    private long startTimeMillis;
    private List<ProjectileLike.EffectInfo> trailEffects;
    private List<ProjectileLike.EffectInfo> attachedEffects;
    private List<Effect> activeTrailEffects = Collections.emptyList();
    private List<Effect> activeAttachedEffects = Collections.emptyList();
    private Trajectory<?> trajectory;
    private class_1297 targetEntity;
    public HurtingItem hurtingItem;
    private class_1799 hurtingItemStack;

    public static Builder builder() {
        return new Builder();
    }

    public SlowProjectile(class_1299<? extends SlowProjectile> entityType, class_1937 level) {
        super(entityType, level);
        this.initialAngle = this.field_5974.method_43057() * 360.0f;
        this.startTimeMillis = System.currentTimeMillis();
    }

    @Override
    public void launchAtLookTarget(class_1309 entity, double inaccuracy, long seed) {
        this.hitScanTarget = HitScan.getNearestObjectInCrosshair(entity, 0.0f, 150.0, inaccuracy, seed, block -> false, block -> false, new ArrayList<class_2338>());
        class_243 hitLocation = this.hitScanTarget.method_17784();
        class_243 muzzleWorldPos = this.method_19538();
        class_243 eyePos = entity.method_33571();
        class_243 viewHitVector = hitLocation.method_1020(eyePos);
        class_243 spawnOffset = muzzleWorldPos.method_1020(eyePos);
        class_243 direction = viewHitVector.method_1020(spawnOffset).method_1029();
        this.shoot(direction.field_1352, direction.field_1351, direction.field_1350, this.getInitialVelocityBlocksPerTick());
    }

    @Override
    public void launchAtTargetEntity(class_1309 player, class_239 hitResult, class_1297 targetEntity) {
        this.hitScanTarget = hitResult;
        this.targetEntity = targetEntity;
        class_243 hitLocation = hitResult.method_17784();
        class_243 muzzleWorldPos = this.method_19538();
        class_243 eyePos = player.method_33571();
        class_243 viewHitVector = hitLocation.method_1020(eyePos);
        class_243 spawnOffset = muzzleWorldPos.method_1020(eyePos);
        class_243 direction = viewHitVector.method_1020(spawnOffset).method_1029();
        this.shoot(direction.field_1352, direction.field_1351, direction.field_1350, this.getInitialVelocityBlocksPerTick());
    }

    public void shoot(double dx, double dy, double dz, double initialSpeed) {
        class_243 deltaMovement = new class_243(dx, dy, dz).method_1029().method_1021(initialSpeed);
        this.method_18799(deltaMovement);
        double horizontalDistance = deltaMovement.method_37267();
        this.method_36456((float)(class_3532.method_15349((double)deltaMovement.field_1352, (double)deltaMovement.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)deltaMovement.field_1351, (double)horizontalDistance) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        LOGGER.debug("{} initializing projectile trajectory", (Object)(System.currentTimeMillis() % 100000L));
        this.initTrajectory(this.hitScanTarget.method_17784());
        LOGGER.debug("{} performed projectile shot", (Object)(System.currentTimeMillis() % 100000L));
    }

    private void initTrajectory(class_243 targetLocation) {
        class_243 startPosition = new class_243(this.method_23317(), this.method_23318(), this.method_23321());
        if (this.hurtingItem instanceof TrajectoryProvider) {
            TrajectoryProvider trajectoryProvider = (TrajectoryProvider)((Object)this.hurtingItem);
            this.trajectory = trajectoryProvider.createTrajectory(this.method_37908(), startPosition, targetLocation);
        }
        if (this.trajectory == null) {
            this.trajectory = new DirectAttackTrajectory(startPosition, this.method_18798(), this.gravity);
        }
    }

    public int getLife() {
        return this.life;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    protected void method_5693() {
        this.field_6011.method_12784(DATA_ATTACHED_TO_TARGET, (Object)OptionalInt.empty());
        this.field_6011.method_12784(DATA_SHOT_AT_ANGLE, (Object)false);
    }

    public boolean method_5640(double distance) {
        return distance < 40000.0;
    }

    public void method_5773() {
        class_1297 entity;
        int entityId;
        class_1937 level = MiscUtil.getLevel((class_1297)this);
        if (MiscUtil.isClientSide((class_1297)this)) {
            class_243 dm = this.method_18798();
            for (Effect trailEffect : this.getActiveTrailEffects()) {
                ((TrailEffect)trailEffect).launchNext((class_1297)this, new class_243(this.method_23317(), this.method_23318(), this.method_23321()), dm);
            }
        }
        if (level.field_9236 && this.attachedToEntity == null && (entityId = ((OptionalInt)this.field_6011.method_12789(DATA_ATTACHED_TO_TARGET)).orElse(-1)) >= 0 && (entity = MiscUtil.getLevel((class_1297)this).method_8469(entityId)) instanceof class_1309) {
            this.attachedToEntity = (class_1309)entity;
        }
        if (this.life > this.getLifetime()) {
            this.method_31472();
        }
        if (this.trajectory != null) {
            this.trajectory.tick();
            if (!level.field_9236 && this.trajectory.isCompleted()) {
                this.explode();
            }
        }
        if (level.field_9236) {
            this.activeAttachedEffects = this.attachedEffects.stream().filter(ei -> ei.predicate().test(this)).map(ei -> ei.effect()).toList();
            this.activeTrailEffects = this.trailEffects.stream().filter(ei -> ei.predicate().test(this)).map(ei -> ei.effect()).toList();
        }
        if (this.targetEntity != null) {
            this.trajectory.setTargetPosition(this.targetEntity.method_30950(0.0f));
        }
        class_1297 entity2 = this.method_24921();
        if (level.field_9236 || (entity2 == null || !entity2.method_31481()) && MiscUtil.getLevel((class_1297)this).method_22340(this.method_24515())) {
            class_239 hitresult = this.getHitResultOnMoveOrViewVector();
            if (hitresult.method_17783() != class_239.class_240.field_1333) {
                this.method_7488(hitresult);
            }
            if (this.trajectory != null) {
                this.method_18799(this.trajectory.getDeltaMovement());
                this.method_33574(this.trajectory.getEndOfTickPosition());
            } else {
                class_243 deltaMovement = this.method_18798();
                double d0 = this.method_23317() + deltaMovement.field_1352;
                double d1 = this.method_23318() + deltaMovement.field_1351;
                double d2 = this.method_23321() + deltaMovement.field_1350;
                this.method_18800(deltaMovement.field_1352, deltaMovement.field_1351 - this.getGravity(), deltaMovement.field_1350);
                this.method_5814(d0, d1, d2);
            }
        } else {
            this.method_31472();
        }
        if (!level.field_9236 && this.life > this.getLifetime()) {
            this.explode();
        }
        ++this.life;
    }

    public double getGravity() {
        return this.gravity;
    }

    public void method_5759(double x, double y, double z, float xRot, float yRot, int p_19901_, boolean p_19902_) {
    }

    public void method_18800(double dx, double dy, double dz) {
        super.method_18800(dx, dy, dz);
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        this.method_36456((float)(class_3532.method_15349((double)dx, (double)dz) * 57.29577951308232));
        this.method_36457((float)(class_3532.method_15349((double)dy, (double)horizontalDistance) * 57.29577951308232));
    }

    public void method_18799(class_243 dm) {
        super.method_18799(dm);
        double horizontalDistance = Math.sqrt(dm.field_1352 * dm.field_1352 + dm.field_1350 * dm.field_1350);
        this.method_36456((float)(class_3532.method_15349((double)dm.field_1352, (double)dm.field_1350) * 57.29577951308232));
        this.method_36457((float)(class_3532.method_15349((double)dm.field_1351, (double)horizontalDistance) * 57.29577951308232));
    }

    private class_239 getHitResultOnMoveOrViewVector() {
        class_1297 owner = this.method_24921();
        class_239 hitResult = class_1675.method_49997((class_1297)this, this::method_26958);
        if (owner != null) {
            class_243 ownerPos = owner.method_19538();
            class_243 originalHitPos = hitResult.method_17784();
            double distanceToOwner = originalHitPos.method_1022(ownerPos);
            if (distanceToOwner <= 10.0 && this.hitScanTarget != null && this.hitScanTarget.method_17784().method_1022(ownerPos) <= 10.0) {
                hitResult = this.hitScanTarget;
            }
        }
        return hitResult;
    }

    protected boolean method_26958(class_1297 entity) {
        return entity != this.method_24921() && super.method_26958(entity) && !entity.field_5960;
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    protected class_3966 findHitEntity(class_243 p_36758_, class_243 p_36759_) {
        return class_1675.method_18077((class_1937)MiscUtil.getLevel((class_1297)this), (class_1297)this, (class_243)p_36758_, (class_243)p_36759_, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), this::method_26958);
    }

    protected void method_7488(class_239 result) {
        super.method_7488(result);
        this.method_31472();
    }

    private void explode() {
        if (this.hurtingItem != null) {
            this.hurtingItem.explodeProjectile((class_1297)this);
        }
        this.method_31472();
    }

    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        class_1297 owner = this.method_24921();
        HurtingItem hurtingItem = this.hurtingItem;
        if (hurtingItem instanceof AmmoItem) {
            AmmoItem ammoItem = (AmmoItem)hurtingItem;
            if (owner instanceof class_1309) {
                this.hurtingItem.hurtEntity((class_1309)owner, entityHitResult, (class_1297)this, new class_1799((class_1935)ammoItem));
            }
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        class_2338 blockpos = new class_2338((class_2382)blockHitResult.method_17777());
        MiscUtil.getLevel((class_1297)this).method_8320(blockpos).method_26178(MiscUtil.getLevel((class_1297)this), blockpos, (class_1297)this);
        class_1297 owner = this.method_24921();
        if (this.hurtingItem != null && !MiscUtil.isClientSide((class_1297)this) && owner instanceof class_1309) {
            this.hurtingItem.handleBlockHit((class_1309)((class_1657)owner), blockHitResult, (class_1297)this);
        }
        super.method_24920(blockHitResult);
    }

    public boolean isShotAtAngle() {
        return (Boolean)this.field_6011.method_12789(DATA_SHOT_AT_ANGLE);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Life", this.life);
        tag.method_10569("LifeTime", this.getLifetime());
        tag.method_10556("ShotAtAngle", ((Boolean)this.field_6011.method_12789(DATA_SHOT_AT_ANGLE)).booleanValue());
    }

    public void method_5749(class_2487 compoundTag) {
        this.method_31472();
    }

    public boolean method_5732() {
        return false;
    }

    public class_2596<class_2602> method_18002() {
        ClientBoundAddSpawnEntityDataPacket packet = new ClientBoundAddSpawnEntityDataPacket((class_1297)this);
        NetworkService networkService = Platform.getInstance().getNetworkService();
        class_2540 buf = new class_2540(Unpooled.buffer());
        ClientBoundAddSpawnEntityDataPacket.encode(packet, buf);
        return new class_2658(new class_2960("pointblank", "slowprojectile"), buf);
    }

    @Override
    public void writeSpawnData(class_2540 buffer) {
        class_243 movement = this.method_18798();
        buffer.writeInt(this.getLifetime());
        buffer.writeDouble(this.method_23317());
        buffer.writeDouble(this.method_23318());
        buffer.writeDouble(this.method_23321());
        buffer.writeDouble(movement.field_1352);
        buffer.writeDouble(movement.field_1351);
        buffer.writeDouble(movement.field_1350);
        buffer.writeFloat(this.method_36455());
        buffer.writeFloat(this.method_5791());
        class_243 targetLocation = this.hitScanTarget != null ? this.hitScanTarget.method_17784() : class_243.field_1353;
        buffer.writeDouble(targetLocation.field_1352);
        buffer.writeDouble(targetLocation.field_1351);
        buffer.writeDouble(targetLocation.field_1350);
        buffer.writeInt(this.targetEntity != null ? this.targetEntity.method_5628() : -1);
    }

    @Override
    public void readSpawnData(class_2540 buffer) {
        this.setLifetime(buffer.readInt());
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        double dx = buffer.readDouble();
        double dy = buffer.readDouble();
        double dz = buffer.readDouble();
        float xRot = buffer.readFloat();
        float yRot = buffer.readFloat();
        double hitLocationX = buffer.readDouble();
        double hitLocationY = buffer.readDouble();
        double hitLocationZ = buffer.readDouble();
        int entityId = buffer.readInt();
        this.method_5641(x, y, z, yRot, xRot);
        this.method_18800(dx, dy, dz);
        this.method_5847(yRot);
        this.method_5636(yRot);
        if (entityId >= 0) {
            this.targetEntity = this.method_37908().method_8469(entityId);
        }
        this.initTrajectory(new class_243(hitLocationX, hitLocationY, hitLocationZ));
    }

    @Override
    public float getProgress(float partialTick) {
        return ((float)this.life + partialTick) / (float)this.getLifetime();
    }

    @Override
    public long getElapsedTimeMillis() {
        return System.currentTimeMillis() - this.startTimeMillis;
    }

    public float getInitialAngle() {
        return this.initialAngle;
    }

    @Override
    public class_1799 getItem() {
        return this.hurtingItemStack;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public double getDefaultGravity() {
        return this.gravity;
    }

    private void setGravity(double gravity) {
        this.gravity = gravity;
    }

    @Override
    public double getInitialVelocityBlocksPerTick() {
        return this.initialVelocityBlocksPerTick;
    }

    private void setInitialVelocityBlocksPerTick(double initialVelocityBlocksPerTick) {
        this.initialVelocityBlocksPerTick = initialVelocityBlocksPerTick;
    }

    @Override
    public List<Effect> getActiveAttachedEffects() {
        return this.activeAttachedEffects;
    }

    public List<Effect> getActiveTrailEffects() {
        return this.activeTrailEffects;
    }

    @Override
    public void setTrailEffects(List<ProjectileLike.EffectInfo> trailEffects) {
        this.trailEffects = trailEffects;
    }

    @Override
    public void setAttachedEffects(List<ProjectileLike.EffectInfo> attachedEffects) {
        this.attachedEffects = attachedEffects;
    }

    @Override
    public Trajectory<?> getTrajectory() {
        return this.trajectory;
    }

    public static Predicate<ProjectileLike> topDownTrajectoryPhasePredicate(Predicate<TopDownAttackTrajectory> tp) {
        return projectile -> {
            TopDownAttackTrajectory tdat;
            Trajectory<?> patt29170$temp;
            return projectile.getTrajectory() != null && (patt29170$temp = projectile.getTrajectory()) instanceof TopDownAttackTrajectory && tp.test(tdat = (TopDownAttackTrajectory)patt29170$temp);
        };
    }

    public static class Builder
    implements EntityBuilder<Builder, SlowProjectile> {
        private static final float DEFAULT_WIDTH = 0.25f;
        private static final float DEFAULT_HEIGHT = 0.25f;
        private static final int DEFAULT_TRACKING_RANGE = 1024;
        private static final int DEFAULT_CLIENT_TRACKING_RANGE = 1024;
        private static final int DEFAULT_UPDATE_INTERVAL = 1;
        private static final int DEFAULT_LIFETIME_TICKS = 200;
        private String name;
        private float width = 0.25f;
        private float height = 0.25f;
        private int clientTrackingRange = 1024;
        private int trackingRange = 1024;
        private int updateInterval = 1;
        private double initialVelocityBlocksPerSecond;
        private int lifetimeTicks = 200;
        private double gravity;
        private List<EffectBuilderInfo> effectBuilderSuppliers = new ArrayList<EffectBuilderInfo>();
        private Supplier<EntityRendererBuilder<?, class_1297, class_897<class_1297>>> rendererBuilder;
        private Supplier<HurtingItem> hurtingItem;

        private Builder() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Builder withItem(Supplier<class_1792> hurtingItem) {
            this.hurtingItem = () -> (HurtingItem)hurtingItem.get();
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withMaxLifetime(long lifetimeMillis) {
            this.lifetimeTicks = (int)TimeUnit.MILLISECOND.toTicks(lifetimeMillis);
            return this;
        }

        public Builder withSize(float width, float height) {
            this.width = width;
            this.height = height;
            return this;
        }

        @Override
        public EntityBuilder<?, ?> withRicochet(boolean ricochet) {
            return this;
        }

        public Builder withInitialVelocity(double initialVelocityBlocksPerSecond) {
            this.initialVelocityBlocksPerSecond = initialVelocityBlocksPerSecond;
            return this;
        }

        public Builder withRenderer(Supplier<EntityRendererBuilder<?, class_1297, class_897<class_1297>>> rendererBuilder2) {
            this.rendererBuilder = rendererBuilder2;
            return this;
        }

        public Builder withGravity(boolean isGravityEnabled) {
            this.gravity = isGravityEnabled ? 0.05 : 0.0;
            return this;
        }

        public Builder withGravity(double gravity) {
            this.gravity = class_3532.method_15350((double)gravity, (double)-1.0, (double)1.0);
            return this;
        }

        public Builder withEffect(EffectBuilderInfo effectInfo) {
            this.effectBuilderSuppliers.add(effectInfo);
            return this;
        }

        @Override
        public EntityBuilder.EntityTypeExt getEntityTypeExt() {
            return EntityBuilder.EntityTypeExt.PROJECTILE;
        }

        @Override
        public class_1299.class_1300<SlowProjectile> getEntityTypeBuilder() {
            return class_1299.class_1300.method_5903(this::create, (class_1311)class_1311.field_17715).method_17687(this.width, this.height).method_27299(this.clientTrackingRange).method_27300(this.updateInterval);
        }

        public SlowProjectile create(class_1299<SlowProjectile> entityType, class_1937 level) {
            SlowProjectile projectile = new SlowProjectile(entityType, level);
            if (level.field_9236) {
                this.initEffects(projectile);
            }
            projectile.setGravity(this.gravity);
            if (this.hurtingItem != null) {
                projectile.hurtingItem = this.hurtingItem.get();
                projectile.hurtingItemStack = new class_1799((class_1935)projectile.hurtingItem);
            }
            return projectile;
        }

        @Override
        public SlowProjectile build(class_1937 level) {
            Supplier<class_1299<?>> entityType = EntityRegistry.getTypeByName(this.name);
            SlowProjectile projectile = new SlowProjectile(entityType.get(), level);
            projectile.setInitialVelocityBlocksPerTick(this.initialVelocityBlocksPerSecond * (double)0.05f);
            projectile.setLifetime(this.lifetimeTicks);
            projectile.method_5875(MiscUtil.isNearlyZero(this.gravity));
            projectile.setGravity(this.gravity);
            if (this.hurtingItem != null) {
                projectile.hurtingItem = this.hurtingItem.get();
                projectile.hurtingItemStack = new class_1799((class_1935)projectile.hurtingItem);
            }
            if (level.field_9236) {
                this.initEffects(projectile);
            }
            return projectile;
        }

        public void initEffects(SlowProjectile projectile) {
            ArrayList<ProjectileLike.EffectInfo> trailEffects = new ArrayList<ProjectileLike.EffectInfo>();
            ArrayList<ProjectileLike.EffectInfo> attachedEffects = new ArrayList<ProjectileLike.EffectInfo>();
            GunItem.FirePhase phase = GunItem.FirePhase.FLYING;
            for (EffectBuilderInfo effectBuilderInfo : this.effectBuilderSuppliers) {
                AbstractEffect effect;
                EffectBuilder.Context context;
                EffectBuilder<EffectBuilder<?, ?>, ?> effectBuilder = effectBuilderInfo.effectSupplier().get();
                if (effectBuilder.getCompatiblePhases().contains((Object)GunItem.FirePhase.FLYING)) {
                    context = new EffectBuilder.Context();
                    effect = (TrailEffect)effectBuilder.build(context);
                    trailEffects.add(new ProjectileLike.EffectInfo(effect, effectBuilderInfo.predicate()));
                    continue;
                }
                if (effectBuilder instanceof AttachedProjectileEffect.Builder) {
                    context = new EffectBuilder.Context();
                    effect = (AttachedProjectileEffect)effectBuilder.build(context);
                    attachedEffects.add(new ProjectileLike.EffectInfo(effect, effectBuilderInfo.predicate()));
                    continue;
                }
                throw new IllegalStateException("Effect builder " + effectBuilder + " is not compatible with phase '" + phase + "'. Check how you construct projectile: " + this.getName());
            }
            projectile.trailEffects = Collections.unmodifiableList(trailEffects);
            projectile.attachedEffects = Collections.unmodifiableList(attachedEffects);
        }

        @Override
        public boolean hasRenderer() {
            return this.rendererBuilder != null;
        }

        @Override
        public class_897<class_1297> createEntityRenderer(class_5617.class_5618 context) {
            return this.rendererBuilder.get().build(context);
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            throw new UnsupportedOperationException();
        }
    }
}

