/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.explosion;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.client.effect.EffectBuilder;
import com.vicmatskiv.pointblank.explosion.ExplosionEvent;
import com.vicmatskiv.pointblank.item.ExplosionDescriptor;
import com.vicmatskiv.pointblank.item.ExplosionProvider;
import com.vicmatskiv.pointblank.registry.SoundRegistry;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.SimpleHitResult;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1900;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4770;
import net.minecraft.class_5361;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_8567;

public class CustomExplosion
extends class_1927 {
    private static final class_5362 EXPLOSION_DAMAGE_CALCULATOR = new class_5362();
    private static final float DEFAULT_SOUND_VOLUME = 4.0f;
    private class_1792 item;
    private class_1937 level;
    private float radius;
    private double x;
    private double y;
    private double z;
    private boolean fire;
    private final ObjectArrayList<class_2338> toBlow = new ObjectArrayList();
    private class_1927.class_4179 blockInteraction;
    private Random random;
    private class_1297 source;
    private class_5362 damageCalculator;
    private final Map<class_1657, class_243> hitPlayers = Maps.newHashMap();
    private class_243 position;

    public CustomExplosion(class_1937 level, class_1792 item, class_1297 entity, class_1282 damageSource, class_5362 calc, double posX, double posY, double posZ, float power, boolean fire, class_1927.class_4179 blockInteraction) {
        super(level, entity, damageSource, calc, posX, posY, posZ, power, fire, blockInteraction);
        this.level = level;
        this.item = item;
        this.source = entity;
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.radius = power;
        this.fire = fire;
        this.blockInteraction = blockInteraction;
        this.random = new Random();
        this.damageCalculator = calc == null ? this.makeDamageCalculator(entity) : calc;
        this.position = new class_243(this.x, this.y, this.z);
    }

    public CustomExplosion(class_1937 level, class_1792 gunItem, class_1297 entity, double x, double y, double z, float power, List<class_2338> toBlow) {
        super(level, entity, x, y, z, power, false, null, toBlow);
        this.level = level;
        this.item = gunItem;
        this.source = entity;
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = power;
        this.toBlow.addAll(toBlow);
        this.position = new class_243(this.x, this.y, this.z);
    }

    private class_5362 makeDamageCalculator(class_1297 entity) {
        return entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new class_5361(entity);
    }

    public class_1792 getItem() {
        return this.item;
    }

    public void finalizeClientExplosion() {
        class_1792 class_17922 = this.item;
        if (class_17922 instanceof ExplosionProvider) {
            ExplosionProvider explosionProvider = (ExplosionProvider)class_17922;
            ExplosionDescriptor explosionDescriptor = explosionProvider.getExplosion();
            Platform.getInstance().getEventBus().postEvent(new ExplosionEvent(new class_243(this.x, this.y, this.z), explosionDescriptor));
            class_3414 soundEvent = null;
            float soundVolume = 4.0f;
            if (explosionDescriptor != null) {
                if (explosionDescriptor.soundName() != null) {
                    soundEvent = SoundRegistry.getSoundEvent(explosionDescriptor.soundName());
                }
                soundVolume = explosionDescriptor.soundVolume();
                this.applyExplosionEffects(explosionDescriptor);
            }
            if (soundEvent == null) {
                soundEvent = class_3417.field_15152;
            }
            if (!MiscUtil.isNearlyZero(soundVolume)) {
                this.playSound(soundEvent, soundVolume);
            }
        }
        this.method_8350(false);
    }

    private void playSound(class_3414 soundEvent, float volume) {
        this.level.method_8486(this.x, this.y, this.z, soundEvent, class_3419.field_15245, volume, (1.0f + (this.level.field_9229.method_43057() - this.level.field_9229.method_43057()) * 0.2f) * 0.7f, false);
    }

    private void applyExplosionEffects(ExplosionDescriptor explosionDescriptor) {
        List<Supplier<EffectBuilder<EffectBuilder<?, ?>, ?>>> effects = explosionDescriptor.effects();
        for (Supplier<EffectBuilder<EffectBuilder<?, ?>, ?>> effectBuilderSupplier : effects) {
            EffectBuilder<EffectBuilder<?, ?>, ?> effectBuilder = effectBuilderSupplier.get();
            EffectBuilder.Context context = new EffectBuilder.Context().withHitResult(new SimpleHitResult(this.position, class_239.class_240.field_1332, class_2350.field_11036, -1));
            Object effect = effectBuilder.build(context);
            effect.launch((class_1297)ClientUtil.getClientPlayer());
        }
    }

    public void method_8350(boolean ignored) {
        boolean flag = this.method_46667();
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            boolean flag1 = this.method_8347() instanceof class_1657;
            class_156.method_43028(this.toBlow, (class_5819)this.level.field_9229);
            for (class_2338 blockpos : this.toBlow) {
                class_1937 $$9;
                class_2680 blockstate = this.level.method_8320(blockpos);
                if (blockstate.method_26215()) continue;
                class_2338 blockpos1 = blockpos.method_10062();
                this.level.method_16107().method_15396("explosion_blocks");
                if (blockstate.method_26204().method_9533((class_1927)this) && ($$9 = this.level) instanceof class_3218) {
                    class_3218 serverlevel = (class_3218)$$9;
                    class_2586 blockentity = blockstate.method_31709() ? this.level.method_8321(blockpos) : null;
                    class_8567.class_8568 lootparams$builder = new class_8567.class_8568(serverlevel).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockpos)).method_51874(class_181.field_1229, (Object)class_1799.field_8037).method_51877(class_181.field_1228, (Object)blockentity).method_51877(class_181.field_1226, (Object)this.source);
                    if (this.blockInteraction == class_1927.class_4179.field_40879) {
                        lootparams$builder.method_51874(class_181.field_1225, (Object)Float.valueOf(this.radius));
                    }
                    blockstate.method_26180(serverlevel, blockpos, class_1799.field_8037, flag1);
                    blockstate.method_26189(lootparams$builder).forEach(p_46074_ -> CustomExplosion.addBlockDrops((ObjectArrayList<Pair<class_1799, class_2338>>)objectarraylist, p_46074_, blockpos1));
                }
                MiscUtil.onBlockExploded(blockstate, this.level, blockpos, this);
                this.level.method_16107().method_15407();
            }
            for (Pair pair : objectarraylist) {
                class_2248.method_9577((class_1937)this.level, (class_2338)((class_2338)pair.getSecond()), (class_1799)((class_1799)pair.getFirst()));
            }
        }
        if (this.fire) {
            for (class_2338 blockpos2 : this.toBlow) {
                if (this.random.nextInt(3) != 0 || !this.level.method_8320(blockpos2).method_26215() || !this.level.method_8320(blockpos2.method_10074()).method_26216((class_1922)this.level, blockpos2.method_10074())) continue;
                this.level.method_8501(blockpos2, class_4770.method_24416((class_1922)this.level, (class_2338)blockpos2));
            }
        }
    }

    private static void addBlockDrops(ObjectArrayList<Pair<class_1799, class_2338>> blockPosToBlow, class_1799 itemStack, class_2338 blockPos) {
        int i = blockPosToBlow.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)blockPosToBlow.get(j);
            class_1799 itemstack = (class_1799)pair.getFirst();
            if (!class_1542.method_24017((class_1799)itemstack, (class_1799)itemStack)) continue;
            class_1799 itemstack1 = class_1542.method_24018((class_1799)itemstack, (class_1799)itemStack, (int)16);
            blockPosToBlow.set(j, (Object)Pair.of((Object)itemstack1, (Object)((class_2338)pair.getSecond())));
            if (!itemStack.method_7960()) continue;
            return;
        }
        blockPosToBlow.add((Object)Pair.of((Object)itemStack, (Object)blockPos));
    }

    private static class_1927.class_4179 getDestroyType(class_1937 level, class_1928.class_4313<class_1928.class_4310> gameRulesKey) {
        return level.method_8450().method_8355(gameRulesKey) ? class_1927.class_4179.field_40879 : class_1927.class_4179.field_18687;
    }

    public static CustomExplosion explode(class_1937 level, class_1792 item, class_1297 entity, class_1282 damageSource, class_5362 calc, double posX, double posY, double posZ, float power, boolean fire, class_1937.class_7867 interaction, boolean particlesEnabled) {
        if (!Config.explosionDestroyBlocksEnabled) {
            interaction = class_1937.class_7867.field_40888;
        }
        CustomExplosion explosion = new CustomExplosion(level, item, entity, damageSource, calc, posX, posY, posZ, power, fire, switch (interaction) {
            case class_1937.class_7867.field_40888 -> class_1927.class_4179.field_40878;
            case class_1937.class_7867.field_40889 -> CustomExplosion.getDestroyType(level, (class_1928.class_4313<class_1928.class_4310>)class_1928.field_40880);
            case class_1937.class_7867.field_40891 -> CustomExplosion.getDestroyType(level, (class_1928.class_4313<class_1928.class_4310>)class_1928.field_40882);
            default -> throw new IncompatibleClassChangeError();
        });
        explosion.method_8348();
        explosion.method_8350(false);
        return explosion;
    }

    public void method_8348() {
        this.level.method_43275(this.source, class_5712.field_28178, new class_243(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.field_9229.method_43057() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        class_2338 blockpos = class_2338.method_49637((double)d4, (double)d6, (double)d8);
                        class_2680 blockstate = this.level.method_8320(blockpos);
                        class_3610 fluidstate = this.level.method_8316(blockpos);
                        if (!this.level.method_24794(blockpos)) continue block2;
                        Optional optional = this.damageCalculator.method_29555((class_1927)this, (class_1922)this.level, blockpos, blockstate, fluidstate);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.method_29554((class_1927)this, (class_1922)this.level, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        float adjustedRadius = this.radius * 2.0f;
        int bbXMin = class_3532.method_15357((double)(this.x - (double)adjustedRadius - 1.0));
        int bbXMax = class_3532.method_15357((double)(this.x + (double)adjustedRadius + 1.0));
        int bbYMin = class_3532.method_15357((double)(this.y - (double)adjustedRadius - 1.0));
        int bbYMax = class_3532.method_15357((double)(this.y + (double)adjustedRadius + 1.0));
        int bbZMin = class_3532.method_15357((double)(this.z - (double)adjustedRadius - 1.0));
        int bbZMax = class_3532.method_15357((double)(this.z + (double)adjustedRadius + 1.0));
        List list = this.level.method_8335(this.source, new class_238((double)bbXMin, (double)bbYMin, (double)bbZMin, (double)bbXMax, (double)bbYMax, (double)bbZMax));
        class_243 thisPos = new class_243(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            class_1657 player;
            double d11;
            double zOffset;
            double yOffset;
            double xOffset;
            double adjustedDistanceToEntity;
            double normalizedDistanceToEntity;
            class_1297 entity = (class_1297)list.get(k2);
            if (entity.method_5659() || MiscUtil.isProtected(entity) || !((normalizedDistanceToEntity = Math.sqrt(entity.method_5707(thisPos)) / (double)adjustedRadius) <= 1.0) || (adjustedDistanceToEntity = Math.sqrt((xOffset = entity.method_23317() - this.x) * xOffset + (yOffset = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.y) * yOffset + (zOffset = entity.method_23321() - this.z) * zOffset)) == 0.0) continue;
            xOffset /= adjustedDistanceToEntity;
            yOffset /= adjustedDistanceToEntity;
            zOffset /= adjustedDistanceToEntity;
            double seenPercent = CustomExplosion.method_17752((class_243)thisPos, (class_1297)entity);
            double damage = (1.0 - normalizedDistanceToEntity) * seenPercent;
            entity.method_5643(this.method_8349(), (float)((int)((damage * damage + damage) / 2.0 * 7.5 * (double)adjustedRadius + 1.0)));
            if (entity instanceof class_1309) {
                class_1309 livingentity = (class_1309)entity;
                d11 = class_1900.method_8237((class_1309)livingentity, (double)damage);
            } else {
                d11 = damage;
            }
            class_243 knockbackMovement = new class_243(xOffset *= d11, yOffset *= d11, zOffset *= d11);
            entity.method_18799(entity.method_18798().method_1019(knockbackMovement));
            if (!(entity instanceof class_1657) || (player = (class_1657)entity).method_7325() || player.method_7337() && player.method_31549().field_7479) continue;
            this.hitPlayers.put(player, knockbackMovement);
        }
    }
}

