/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.attachment.AttachmentModelInfo;
import com.vicmatskiv.pointblank.attachment.Attachments;
import com.vicmatskiv.pointblank.client.GunStateListener;
import com.vicmatskiv.pointblank.feature.ConditionContext;
import com.vicmatskiv.pointblank.feature.ConditionalFeature;
import com.vicmatskiv.pointblank.feature.FeatureBuilder;
import com.vicmatskiv.pointblank.feature.FeatureProvider;
import com.vicmatskiv.pointblank.feature.Features;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.util.Conditions;
import com.vicmatskiv.pointblank.util.JsonUtil;
import java.util.NavigableMap;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public final class AimingFeature
extends ConditionalFeature
implements GunStateListener {
    private static final Matrix4f IDENTITY_MATRIX = new Matrix4f();
    private final float zoom;
    private final float viewBobbing;

    public static void applyAimingPosition(class_1799 itemStack, class_4587 poseStack, float rescale, float aimingProgress) {
        if (!(itemStack.method_7909() instanceof GunItem)) {
            return;
        }
        if (aimingProgress > 0.0f) {
            NavigableMap<String, Pair<class_1799, Matrix4f>> poseMatrices = AttachmentModelInfo.findInverseBoneMatrices(itemStack, "scope", rescale);
            if (!poseMatrices.isEmpty()) {
                Features.EnabledFeature aimingFeature = Features.getFirstEnabledFeature(itemStack, AimingFeature.class);
                Pair<class_1799, Matrix4f> attachmentPos = null;
                if (aimingFeature != null) {
                    attachmentPos = (Pair<class_1799, Matrix4f>)poseMatrices.get(aimingFeature.ownerPath());
                }
                if (attachmentPos == null) {
                    attachmentPos = poseMatrices.firstEntry().getValue();
                }
                if (attachmentPos == null) {
                    return;
                }
                if (aimingProgress < 1.0f) {
                    poseStack.method_34425(AimSwitchAnimation.INSTANCE.update(IDENTITY_MATRIX, (Matrix4f)attachmentPos.getSecond(), aimingProgress));
                } else {
                    poseStack.method_34425(AimSwitchAnimation.INSTANCE.update((Matrix4f)attachmentPos.getSecond()));
                }
            }
            poseStack.method_46416(0.0f, aimingProgress * -0.6095f * rescale, aimingProgress * -0.7f * rescale);
        }
    }

    private AimingFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, float zoom, float viewBobbing) {
        super(owner, predicate);
        this.zoom = zoom;
        this.viewBobbing = viewBobbing;
    }

    public class_5250 getDescription() {
        return class_2561.method_43471((String)"description.pointblank.enablesAimingWithZoom").method_10852((class_2561)class_2561.method_43470((String)String.format(" %.0f%%", Float.valueOf(this.zoom * 100.0f))));
    }

    public float getZoom() {
        return this.zoom;
    }

    public float getViewBobbing() {
        return this.viewBobbing;
    }

    public static float getZoom(class_1799 itemStack) {
        Pair<String, class_1799> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        class_1799 selectedStack = null;
        selectedStack = selected != null ? (class_1799)selected.getSecond() : itemStack;
        class_1792 class_17922 = selectedStack.method_7909();
        if (class_17922 instanceof FeatureProvider) {
            FeatureProvider fp = (FeatureProvider)class_17922;
            AimingFeature feature = fp.getFeature(AimingFeature.class);
            if (feature != null) {
                return feature.getZoom();
            }
        } else {
            class_17922 = selectedStack.method_7909();
            if (class_17922 instanceof GunItem) {
                GunItem gunItem = (GunItem)class_17922;
                return (float)gunItem.getAimingZoom();
            }
        }
        return 0.0f;
    }

    public static float getViewBobbing(class_1799 itemStack) {
        FeatureProvider fp;
        AimingFeature feature;
        Pair<String, class_1799> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        class_1799 selectedStack = null;
        selectedStack = selected != null ? (class_1799)selected.getSecond() : itemStack;
        class_1792 class_17922 = selectedStack.method_7909();
        if (class_17922 instanceof FeatureProvider && (feature = (fp = (FeatureProvider)class_17922).getFeature(AimingFeature.class)) != null) {
            return feature.getViewBobbing();
        }
        return 1.0f;
    }

    private static class AimSwitchAnimation {
        private static final AimSwitchAnimation INSTANCE = new AimSwitchAnimation(200L);
        protected long startTime;
        protected long nanoDuration;
        protected boolean isDone;
        protected Matrix4f fromMatrix;
        protected Matrix4f toMatrix;

        protected AimSwitchAnimation(long durationMillis) {
            this.nanoDuration = durationMillis * 1000000L;
            this.fromMatrix = IDENTITY_MATRIX;
            this.toMatrix = IDENTITY_MATRIX;
        }

        protected float getProgress() {
            double progress = (double)(System.nanoTime() - this.startTime) / (double)this.nanoDuration;
            if (progress > 1.0) {
                progress = 1.0;
            }
            return class_3532.method_15363((float)((float)progress), (float)0.0f, (float)1.0f);
        }

        public void reset() {
            this.isDone = false;
            this.startTime = System.nanoTime();
        }

        public Matrix4f update(Matrix4f matrix) {
            float progress;
            if (this.toMatrix != matrix) {
                this.fromMatrix = this.toMatrix;
                this.toMatrix = matrix;
                this.reset();
            }
            if ((progress = this.getProgress()) >= 1.0f) {
                this.isDone = true;
            }
            if (this.isDone) {
                return this.toMatrix;
            }
            return new Matrix4f((Matrix4fc)this.fromMatrix).lerp((Matrix4fc)this.toMatrix, progress);
        }

        public Matrix4f update(Matrix4f fromMatrix, Matrix4f toMatrix, float progress) {
            Matrix4f resultMatrix = new Matrix4f((Matrix4fc)fromMatrix).lerp((Matrix4fc)toMatrix, progress);
            AimSwitchAnimation.INSTANCE.fromMatrix = fromMatrix;
            AimSwitchAnimation.INSTANCE.toMatrix = toMatrix;
            return resultMatrix;
        }
    }

    public static class Builder
    implements FeatureBuilder<Builder, AimingFeature> {
        private static final float DEFAULT_ZOOM = 0.1f;
        private Predicate<ConditionContext> condition = ctx -> true;
        private float zoom;
        private float viewBobbing = 1.0f;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withZoom(double zoom) {
            this.zoom = (float)zoom;
            return this;
        }

        public Builder withViewBobbing(double viewBobbing) {
            this.viewBobbing = class_3532.method_15363((float)((float)viewBobbing), (float)0.0f, (float)1.0f);
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            this.withZoom(JsonUtil.getJsonFloat(obj, "zoom", 0.1f));
            this.withViewBobbing(JsonUtil.getJsonFloat(obj, "viewBobbing", 1.0f));
            return this;
        }

        @Override
        public AimingFeature build(FeatureProvider featureProvider) {
            return new AimingFeature(featureProvider, this.condition, this.zoom, this.viewBobbing);
        }
    }
}

