/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.inventory;

import com.vicmatskiv.pointblank.Nameable;
import com.vicmatskiv.pointblank.attachment.Attachment;
import com.vicmatskiv.pointblank.attachment.Attachments;
import com.vicmatskiv.pointblank.inventory.Activatable;
import com.vicmatskiv.pointblank.inventory.AttachmentContainerMenu;
import com.vicmatskiv.pointblank.inventory.HierarchicalSlot;
import com.vicmatskiv.pointblank.inventory.SimpleAttachmentContainer;
import com.vicmatskiv.pointblank.inventory.SlotExt;
import com.vicmatskiv.pointblank.inventory.VirtualInventory;
import com.vicmatskiv.pointblank.util.MiscUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttachmentSlot
extends class_1735
implements SlotExt,
Activatable,
HierarchicalSlot {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private AttachmentContainerMenu menu;
    private boolean isActive;
    private SimpleAttachmentContainer container;
    private int slotIndexInContainer;
    private SimpleAttachmentContainer childContainer;
    private HierarchicalSlot parentSlot;

    public AttachmentSlot(class_1657 player, AttachmentContainerMenu menu, SimpleAttachmentContainer container, int index, int x, int y) {
        super((class_1263)container, index, x, y);
        this.slotIndexInContainer = index;
        this.container = container;
        this.menu = menu;
    }

    public SimpleAttachmentContainer getContainer() {
        return this.container;
    }

    @Override
    public boolean method_7682() {
        return this.isActive;
    }

    void clear() {
        this.childContainer = null;
        this.parentSlot = null;
    }

    @Override
    public String getPath() {
        String string;
        class_1792 class_17922;
        String parentPath = this.getParentSlot() != null ? this.getParentSlot().getPath() : "/";
        class_1799 itemStack = this.method_7677();
        if (itemStack != null && (class_17922 = itemStack.method_7909()) instanceof Nameable) {
            Nameable n = (Nameable)class_17922;
            string = n.getName();
        } else {
            string = "?";
        }
        String name = string;
        return parentPath + "/" + name;
    }

    @Override
    public HierarchicalSlot getParentSlot() {
        return this.parentSlot;
    }

    @Override
    public void setParentSlot(HierarchicalSlot parentSlot) {
        this.parentSlot = parentSlot;
    }

    void setChildContainer(SimpleAttachmentContainer childContainer) {
        this.childContainer = childContainer;
    }

    public SimpleAttachmentContainer getChildContainer() {
        return this.childContainer;
    }

    public boolean method_7680(class_1799 newAttachmentStack) {
        if (!this.isActive) {
            return false;
        }
        if (!(newAttachmentStack.method_7909() instanceof Attachment)) {
            return false;
        }
        class_1799 currentItemStack = this.method_7677();
        if (currentItemStack != null && currentItemStack.method_7909() instanceof Attachment) {
            return false;
        }
        VirtualInventory e = this.container.getVirtualInventory();
        return e != null ? e.mayPlace(newAttachmentStack, this) : false;
    }

    public int method_7675() {
        return 1;
    }

    public boolean method_7674(class_1657 player) {
        if (!this.isActive) {
            return false;
        }
        class_1799 currentItemStack = this.method_7677();
        if (currentItemStack == null || currentItemStack.method_7960() || player.method_7337()) {
            return true;
        }
        if (!(currentItemStack.method_7909() instanceof Attachment)) {
            return true;
        }
        return Attachments.isRemoveable(MiscUtil.getTag(currentItemStack));
    }

    @Override
    public void setActive(boolean isActive) {
        if (isActive != this.isActive) {
            LOGGER.debug("Changing status for slot {} in container {} to {},", (Object)this.slotIndexInContainer, (Object)this.container, (Object)isActive);
        }
        this.isActive = isActive;
    }

    public void method_48931(class_1799 itemStack) {
        this.doSet(itemStack);
    }

    private void doSet(class_1799 itemStack) {
        LOGGER.debug("Setting attachment slot {} for container {} to stack {} with tag {}", (Object)this.slotIndexInContainer, (Object)this.container, (Object)itemStack, (Object)MiscUtil.getTag(itemStack));
        super.method_7673(itemStack);
    }

    public void method_7673(class_1799 itemStack) {
        this.doSet(itemStack);
    }

    public void method_7668() {
    }
}

