/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.network;

import com.vicmatskiv.pointblank.NetworkService;
import com.vicmatskiv.pointblank.entity.ExtraSpawnDataHolder;
import com.vicmatskiv.pointblank.util.ClientUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_7923;

public class ClientBoundAddSpawnEntityDataPacket {
    private final class_1297 entity;
    private final int typeId;
    private final int entityId;
    private final UUID uuid;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final byte pitch;
    private final byte yaw;
    private final byte headYaw;
    private final int velX;
    private final int velY;
    private final int velZ;
    private final class_2540 buf;

    public ClientBoundAddSpawnEntityDataPacket(class_1297 e) {
        this.entity = e;
        this.typeId = class_7923.field_41177.method_10206((Object)e.method_5864());
        this.entityId = e.method_5628();
        this.uuid = e.method_5667();
        this.posX = e.method_23317();
        this.posY = e.method_23318();
        this.posZ = e.method_23321();
        this.pitch = (byte)class_3532.method_15375((float)(e.method_36455() * 256.0f / 360.0f));
        this.yaw = (byte)class_3532.method_15375((float)(e.method_36454() * 256.0f / 360.0f));
        this.headYaw = (byte)(e.method_5791() * 256.0f / 360.0f);
        class_243 vec3d = e.method_18798();
        double d1 = class_3532.method_15350((double)vec3d.field_1352, (double)-3.9, (double)3.9);
        double d2 = class_3532.method_15350((double)vec3d.field_1351, (double)-3.9, (double)3.9);
        double d3 = class_3532.method_15350((double)vec3d.field_1350, (double)-3.9, (double)3.9);
        this.velX = (int)(d1 * 8000.0);
        this.velY = (int)(d2 * 8000.0);
        this.velZ = (int)(d3 * 8000.0);
        this.buf = null;
    }

    private ClientBoundAddSpawnEntityDataPacket(int typeId, int entityId, UUID uuid, double posX, double posY, double posZ, byte pitch, byte yaw, byte headYaw, int velX, int velY, int velZ, class_2540 buf) {
        this.entity = null;
        this.typeId = typeId;
        this.entityId = entityId;
        this.uuid = uuid;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.pitch = pitch;
        this.yaw = yaw;
        this.headYaw = headYaw;
        this.velX = velX;
        this.velY = velY;
        this.velZ = velZ;
        this.buf = buf;
    }

    public static void encode(ClientBoundAddSpawnEntityDataPacket msg, class_2540 buf) {
        buf.method_10804(msg.typeId);
        buf.writeInt(msg.entityId);
        buf.writeLong(msg.uuid.getMostSignificantBits());
        buf.writeLong(msg.uuid.getLeastSignificantBits());
        buf.writeDouble(msg.posX);
        buf.writeDouble(msg.posY);
        buf.writeDouble(msg.posZ);
        buf.writeByte((int)msg.pitch);
        buf.writeByte((int)msg.yaw);
        buf.writeByte((int)msg.headYaw);
        buf.writeShort(msg.velX);
        buf.writeShort(msg.velY);
        buf.writeShort(msg.velZ);
        class_1297 class_12972 = msg.entity;
        if (class_12972 instanceof ExtraSpawnDataHolder) {
            ExtraSpawnDataHolder extraSpawnDataHolder = (ExtraSpawnDataHolder)class_12972;
            class_2540 spawnDataBuffer = new class_2540(Unpooled.buffer());
            extraSpawnDataHolder.writeSpawnData(spawnDataBuffer);
            buf.method_10804(spawnDataBuffer.readableBytes());
            buf.writeBytes((ByteBuf)spawnDataBuffer);
            spawnDataBuffer.release();
        } else {
            buf.method_10804(0);
        }
    }

    public static ClientBoundAddSpawnEntityDataPacket decode(class_2540 buf) {
        return new ClientBoundAddSpawnEntityDataPacket(buf.method_10816(), buf.readInt(), new UUID(buf.readLong(), buf.readLong()), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readByte(), buf.readByte(), buf.readByte(), buf.readShort(), buf.readShort(), buf.readShort(), ClientBoundAddSpawnEntityDataPacket.readSpawnDataPacket(buf));
    }

    private static class_2540 readSpawnDataPacket(class_2540 buf) {
        int count = buf.method_10816();
        if (count > 0) {
            class_2540 spawnDataBuffer = new class_2540(Unpooled.buffer());
            spawnDataBuffer.writeBytes((ByteBuf)buf, count);
            return spawnDataBuffer;
        }
        return new class_2540(Unpooled.buffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(ClientBoundAddSpawnEntityDataPacket msg, NetworkService.MessageContext ctx) {
        try {
            class_1299 type = (class_1299)class_7923.field_41177.method_10200(msg.typeId);
            class_1937 clientLevel = ClientUtil.getClientLevel();
            class_1297 entity = type.method_5883(clientLevel);
            if (entity == null) {
                return;
            }
            entity.method_43391(msg.posX, msg.posY, msg.posZ);
            entity.method_5641(msg.posX, msg.posY, msg.posZ, (float)(msg.yaw * 360) / 256.0f, (float)(msg.pitch * 360) / 256.0f);
            entity.method_5847((float)(msg.headYaw * 360) / 256.0f);
            entity.method_5636((float)(msg.headYaw * 360) / 256.0f);
            entity.method_5838(msg.entityId);
            entity.method_5826(msg.uuid);
            ((class_638)clientLevel).method_18114(msg.entityId, entity);
            entity.method_5750((double)msg.velX / 8000.0, (double)msg.velY / 8000.0, (double)msg.velZ / 8000.0);
            if (entity instanceof ExtraSpawnDataHolder) {
                ExtraSpawnDataHolder extraSpawnDataHolder = (ExtraSpawnDataHolder)entity;
                extraSpawnDataHolder.readSpawnData(msg.buf);
            }
        }
        finally {
            msg.buf.release();
        }
    }

    public class_1297 getEntity() {
        return this.entity;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public double getPosX() {
        return this.posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public byte getPitch() {
        return this.pitch;
    }

    public byte getYaw() {
        return this.yaw;
    }

    public byte getHeadYaw() {
        return this.headYaw;
    }

    public int getVelX() {
        return this.velX;
    }

    public int getVelY() {
        return this.velY;
    }

    public int getVelZ() {
        return this.velZ;
    }

    public class_2540 getAdditionalData() {
        return this.buf;
    }
}

