/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.network;

import com.vicmatskiv.pointblank.NetworkService;
import com.vicmatskiv.pointblank.client.ClientEventHandler;
import com.vicmatskiv.pointblank.client.gui.CraftingScreen;
import com.vicmatskiv.pointblank.util.ClientUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class CraftingResponsePacket {
    private class_1799 itemStack;
    private CraftingResult result;
    private boolean isAddedToInventory;

    public CraftingResponsePacket(class_1799 itemStack, CraftingResult result, boolean isAddedToInventory) {
        this.itemStack = itemStack;
        this.result = result;
        this.isAddedToInventory = isAddedToInventory;
    }

    public CraftingResponsePacket() {
    }

    public static void encode(CraftingResponsePacket packet, class_2540 buf) {
        buf.method_10793(packet.itemStack);
        buf.method_10817((Enum)packet.result);
        buf.writeBoolean(packet.isAddedToInventory);
    }

    public static CraftingResponsePacket decode(class_2540 buf) {
        return new CraftingResponsePacket(buf.method_10819(), (CraftingResult)buf.method_10818(CraftingResult.class), buf.readBoolean());
    }

    public static void handle(CraftingResponsePacket packet, NetworkService.MessageContext context) {
        context.enqueueWork(() -> ClientEventHandler.runSyncTick(() -> {
            class_5250 message = null;
            switch (packet.result) {
                case COMPLETED: {
                    if (packet.isAddedToInventory) {
                        message = class_2561.method_43471((String)"").method_10852(packet.itemStack.method_7909().method_7864(packet.itemStack)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"message.pointblank.added_to_the_inventory")).method_27693("!");
                        break;
                    }
                    message = class_2561.method_43471((String)"").method_10852(packet.itemStack.method_7909().method_7864(packet.itemStack)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"message.pointblank.dropped_on_the_gound")).method_27693("!");
                    break;
                }
                case FAILED: {
                    class_310 mc = class_310.method_1551();
                    class_437 patt2752$temp = mc.field_1755;
                    if (patt2752$temp instanceof CraftingScreen) {
                        CraftingScreen craftingScreen = (CraftingScreen)patt2752$temp;
                        craftingScreen.cancelCrafting();
                    }
                    message = class_2561.method_43471((String)"message.pointblank.failed_to_craft");
                    break;
                }
                case CANCELLED: {
                    message = class_2561.method_43471((String)"").method_10852(packet.itemStack.method_7909().method_7864(packet.itemStack)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"message.pointblank.cancelled_to_craft"));
                }
            }
            if (message != null) {
                ClientUtil.notifyUser(message);
            }
        }));
        context.setPacketHandled(true);
    }

    public static enum CraftingResult {
        COMPLETED,
        FAILED,
        CANCELLED;

    }
}

