/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.network;

import com.vicmatskiv.pointblank.NetworkService;
import com.vicmatskiv.pointblank.client.ClientEventHandler;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.util.ClientUtil;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import software.bernie.geckolib.util.ClientUtils;

public class MainHeldSimplifiedStateBroadcastPacket {
    protected class_1657 owner;
    protected GunClientState.FireState simplifiedState;

    public MainHeldSimplifiedStateBroadcastPacket() {
    }

    public MainHeldSimplifiedStateBroadcastPacket(class_1657 owner, UUID stateId, GunClientState.FireState simplifiedState) {
        this.owner = owner;
        this.simplifiedState = simplifiedState;
    }

    public static <T extends MainHeldSimplifiedStateBroadcastPacket> void encode(T packet, class_2540 buffer) {
        buffer.writeInt(packet.owner.method_5628());
        buffer.writeInt(packet.simplifiedState.ordinal());
    }

    public static MainHeldSimplifiedStateBroadcastPacket decode(class_2540 buffer) {
        class_1297 effectOwnerEntity = ClientUtils.getLevel().method_8469(buffer.readInt());
        GunClientState.FireState fireState = GunClientState.FireState.values()[buffer.readInt()];
        return new MainHeldSimplifiedStateBroadcastPacket((class_1657)effectOwnerEntity, null, fireState);
    }

    public static <T extends MainHeldSimplifiedStateBroadcastPacket> void handle(T packet, NetworkService.MessageContext ctx) {
        ctx.enqueueWork(() -> ClientEventHandler.runSyncTick(() -> {
            if (packet.owner == ClientUtil.getClientPlayer()) {
                return;
            }
            GunClientState otherPlayerClientState = GunClientState.getMainHeldState(packet.owner);
            if (otherPlayerClientState != null) {
                otherPlayerClientState.setSimplifiedState(packet.simplifiedState);
            }
        }));
        ctx.setPacketHandled(true);
    }
}

