/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.platform.fabric.mixin;

import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.event.LivingDeathEvent;
import com.vicmatskiv.pointblank.event.PlayerEvent;
import com.vicmatskiv.pointblank.event.TickEvent;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerMixin {
    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void onTickStart(CallbackInfo ci) {
        Platform.getInstance().getEventBus().postEvent(new TickEvent.PlayerTickEvent((class_1657)this, TickEvent.Phase.START));
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void onTickEnd(CallbackInfo ci) {
        Platform.getInstance().getEventBus().postEvent(new TickEvent.PlayerTickEvent((class_1657)this, TickEvent.Phase.END));
    }

    @Inject(method={"hasCorrectToolForDrops"}, at={@At(value="RETURN")}, cancellable=true)
    public void onHasCorrectToolForDrops(class_2680 state, CallbackInfoReturnable<Boolean> cir) {
        PlayerEvent.HarvestCheck event = new PlayerEvent.HarvestCheck((class_1657)this, state, cir.getReturnValueZ());
        Platform.getInstance().getEventBus().postEvent(event);
        cir.setReturnValue((Object)event.canHarvest());
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    public void onLivingDeath(class_1282 damageSource, CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
        LivingDeathEvent event = new LivingDeathEvent(livingEntity, damageSource);
        Platform.getInstance().getEventBus().postEvent(event);
    }
}

