/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.util;

import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.crafting.PointBlankIngredient;
import com.vicmatskiv.pointblank.item.GunItem;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class InventoryUtils {
    public static class_3545<class_1799, GunClientState> getItemStackByStateId(class_1657 player, UUID gunStateId, int slotIndex) {
        GunClientState gunClientState;
        boolean isOffhand;
        class_1799 targetStack = null;
        GunClientState targetGunState = null;
        class_1799 itemStack = player.method_31548().method_5438(slotIndex);
        boolean bl = isOffhand = player.method_6079() == itemStack;
        if (itemStack.method_7909() instanceof GunItem && (gunClientState = GunClientState.getState(player, itemStack, slotIndex, isOffhand)) != null && Objects.equals(GunItem.getItemStackId(itemStack), gunStateId)) {
            targetStack = itemStack;
            targetGunState = gunClientState;
        }
        return targetStack != null ? new class_3545(targetStack, targetGunState) : null;
    }

    public static boolean hasIngredient(class_1657 player, PointBlankIngredient ingredient) {
        return player.method_31548().field_7547.stream().filter(ingredient::matches).collect(Collectors.summarizingInt(class_1799::method_7947)).getSum() >= (long)ingredient.getCount();
    }

    public static boolean removeItem(class_1657 player, Predicate<class_1799> matchingPredicate, int count) {
        class_1661 inventory = player.method_31548();
        int remainingCount = count;
        for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
            class_1799 inventoryItem = (class_1799)inventory.field_7547.get(i);
            if (!matchingPredicate.test(inventoryItem)) continue;
            int availableCount = inventoryItem.method_7947();
            if (availableCount <= remainingCount) {
                remainingCount -= availableCount;
                inventory.field_7547.set(i, (Object)class_1799.field_8037);
            } else {
                inventoryItem.method_7934(remainingCount);
                remainingCount = 0;
            }
            ((class_3222)inventory.field_7546).field_13987.method_14364((class_2596)new class_2653(-2, 0, i, inventory.method_5438(i)));
            if (remainingCount == 0) break;
        }
        return remainingCount <= 0;
    }

    public static int addItem(class_1657 player, class_1792 item, int count) {
        int i;
        class_1661 inventory = player.method_31548();
        class_1799 stackToAdd = new class_1799((class_1935)item, 1);
        int remainingCount = count;
        if (stackToAdd.method_7946()) {
            for (i = 0; i < inventory.field_7547.size(); ++i) {
                class_1799 inventoryStack = (class_1799)inventory.field_7547.get(i);
                if (inventoryStack.method_7909() != item || inventoryStack.method_7947() >= inventoryStack.method_7914()) continue;
                int spaceLeft = inventoryStack.method_7914() - inventoryStack.method_7947();
                int itemsToAdd = Math.min(spaceLeft, remainingCount);
                inventoryStack.method_7933(itemsToAdd);
                ((class_3222)inventory.field_7546).field_13987.method_14364((class_2596)new class_2653(-2, 0, i, inventory.method_5438(i)));
                if ((remainingCount -= itemsToAdd) != 0) continue;
                return 0;
            }
        }
        for (i = 0; i < inventory.field_7547.size(); ++i) {
            if (!inventory.method_5438(i).method_7960()) continue;
            if (stackToAdd.method_7946()) {
                int stackSize = Math.min(stackToAdd.method_7914(), remainingCount);
                inventory.method_5447(i, new class_1799((class_1935)item, stackSize));
                ((class_3222)inventory.field_7546).field_13987.method_14364((class_2596)new class_2653(-2, 0, i, inventory.method_5438(i)));
                remainingCount -= stackSize;
            } else {
                inventory.method_5447(i, stackToAdd.method_7972());
                ((class_3222)inventory.field_7546).field_13987.method_14364((class_2596)new class_2653(-2, 0, i, inventory.method_5438(i)));
                --remainingCount;
            }
            if (remainingCount != 0) continue;
            return 0;
        }
        return remainingCount;
    }
}

