/*
 * Decompiled with CFR 0.152.
 */
package net.lugo.lightoverlay;

import net.lugo.lightoverlay.config.ModConfig;
import net.lugo.lightoverlay.util.ColorHelper;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_9799;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public abstract class OverlayRenderer {
    private final class_1921 renderLayer;
    private final class_4597.class_4598 vcp = class_4597.method_22991((class_9799)new class_9799(8192));
    private final class_4587 matrixStack = new class_4587();
    protected class_4588 vertexConsumer;
    private boolean batchStarted = false;

    protected OverlayRenderer(class_1921 renderLayer) {
        this.renderLayer = renderLayer;
    }

    public final void startBatch() {
        if (this.batchStarted) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.method_1531() == null) {
            return;
        }
        this.vertexConsumer = this.vcp.method_73477(this.renderLayer);
        this.batchStarted = true;
        this.onStartBatch();
    }

    public final void addBlock(class_4184 camera, class_2338 pos, int lightLevel) {
        if (!this.batchStarted) {
            return;
        }
        if (ModConfig.hideGreen && lightLevel >= ModConfig.lightLevelThreshold) {
            return;
        }
        this.getMatrixStack().method_22903();
        this.getMatrixStack().method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(camera.method_19329()));
        this.getMatrixStack().method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        class_243 transformedPos = class_243.method_24954((class_2382)pos).method_1020(camera.method_71156());
        this.getMatrixStack().method_22904(transformedPos.field_1352, transformedPos.field_1351, transformedPos.field_1350);
        Matrix4f positionMatrix = this.getMatrixStack().method_23760().method_23761();
        float[] colorFloats = ColorHelper.getOverlayColorFloats(lightLevel);
        float rf = colorFloats[0];
        float gf = colorFloats[1];
        float bf = colorFloats[2];
        this.onAddBlock(positionMatrix, rf, gf, bf, lightLevel, pos);
        this.getMatrixStack().method_22909();
    }

    public final void endBatch() {
        if (!this.batchStarted) {
            return;
        }
        this.onEndBatch();
        this.vcp.method_22993();
        this.batchStarted = false;
    }

    protected void onStartBatch() {
    }

    protected abstract void onAddBlock(Matrix4f var1, float var2, float var3, float var4, int var5, class_2338 var6);

    protected void onEndBatch() {
    }

    protected class_4587 getMatrixStack() {
        return this.matrixStack;
    }
}

