/*
 * Decompiled with CFR 0.152.
 */
package net.lugo.lightoverlay;

import java.util.ArrayList;
import net.lugo.lightoverlay.OverlayRenderer;
import net.lugo.lightoverlay.config.ModConfig;
import net.lugo.lightoverlay.renderers.CarpetOverlayRenderer;
import net.lugo.lightoverlay.renderers.CrossOverlayRenderer;
import net.lugo.lightoverlay.renderers.MarkerOverlayRenderer;
import net.lugo.lightoverlay.renderers.NumberOverlayRenderer;
import net.lugo.lightoverlay.util.DistanceUtil;
import net.lugo.lightoverlay.util.HudMessage;
import net.lugo.lightoverlay.util.OverlayCache;
import net.lugo.lightoverlay.util.OverlayChecker;
import net.minecraft.class_124;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_5250;

public class OverlayManager {
    private static boolean activated = false;
    private static final class_310 MC = class_310.method_1551();

    public static void toggle() {
        activated = !activated;
        class_5250 message = class_2561.method_43471((String)"text.light-overlay.message.toggle.on");
        if (!activated) {
            message = class_2561.method_43471((String)"text.light-overlay.message.toggle.off");
        }
        HudMessage.show(message, class_124.field_1062);
    }

    public static void renderEnd() {
        if (OverlayManager.MC.field_1724 == null || OverlayManager.MC.field_1687 == null || !ModConfig.showWhenPaused && MC.method_1493() || !activated) {
            return;
        }
        if (ModConfig.enableCache) {
            OverlayManager.renderWithCache();
        } else {
            OverlayManager.renderWithoutCache();
        }
    }

    private static void renderWithCache() {
        OverlayRenderer activeRenderer = ModConfig.rendererType.getRenderer();
        activeRenderer.startBatch();
        int playerChunkX = (int)Math.floor(OverlayManager.MC.field_1724.method_23317() / 16.0);
        int playerChunkZ = (int)Math.floor(OverlayManager.MC.field_1724.method_23321() / 16.0);
        ArrayList<class_4076> sectionsToRender = new ArrayList<class_4076>();
        class_2338 playerPos = OverlayManager.MC.field_1724.method_24515();
        int effectiveChunkScanRange = Math.min(ModConfig.chunkScanRange, OverlayManager.MC.field_1690.method_38521());
        for (int dx = -effectiveChunkScanRange; dx <= effectiveChunkScanRange; ++dx) {
            for (int dz = -effectiveChunkScanRange; dz <= effectiveChunkScanRange; ++dz) {
                if (dx * dx + dz * dz > effectiveChunkScanRange * effectiveChunkScanRange) continue;
                int chunkX = playerChunkX + dx;
                int chunkZ = playerChunkZ + dz;
                for (int sectionY = OverlayManager.MC.field_1687.method_32891(); sectionY <= OverlayManager.MC.field_1687.method_31597(); ++sectionY) {
                    sectionsToRender.add(class_4076.method_18676((int)chunkX, (int)sectionY, (int)chunkZ));
                }
            }
        }
        sectionsToRender.sort((a, b) -> {
            double distA = DistanceUtil.getDistanceSquared(a, playerPos);
            double distB = DistanceUtil.getDistanceSquared(b, playerPos);
            return Double.compare(distA, distB);
        });
        for (class_4076 sectionPos : sectionsToRender) {
            OverlayCache.queueForCompute(sectionPos);
        }
        OverlayCache.processQueue();
        for (class_4076 sectionPos : sectionsToRender) {
            OverlayCache.CacheSectionPosEntry entry = OverlayCache.get(sectionPos);
            if (entry == null || entry.blocks == null) continue;
            for (OverlayCache.CacheBlockPosEntry blockEntry : entry.blocks) {
                class_2338 blockPos = blockEntry.pos();
                int lightLevel = blockEntry.lightLevel();
                activeRenderer.addBlock(OverlayManager.MC.field_1773.method_19418(), blockPos, lightLevel);
            }
        }
        activeRenderer.endBatch();
    }

    @Deprecated
    private static void renderWithoutCache() {
        OverlayRenderer activeRenderer = ModConfig.rendererType.getRenderer();
        activeRenderer.startBatch();
        int playerChunkX = (int)Math.floor(OverlayManager.MC.field_1724.method_23317() / 16.0);
        int playerChunkZ = (int)Math.floor(OverlayManager.MC.field_1724.method_23321() / 16.0);
        int effectiveChunkScanRange = Math.min(ModConfig.chunkScanRange, OverlayManager.MC.field_1690.method_38521());
        for (int dx = -effectiveChunkScanRange; dx <= effectiveChunkScanRange; ++dx) {
            for (int dz = -effectiveChunkScanRange; dz <= effectiveChunkScanRange; ++dz) {
                if (dx * dx + dz * dz > ModConfig.chunkScanRange * ModConfig.chunkScanRange) continue;
                int chunkX = playerChunkX + dx;
                int chunkZ = playerChunkZ + dz;
                for (int sectionY = OverlayManager.MC.field_1687.method_32891(); sectionY <= OverlayManager.MC.field_1687.method_31597(); ++sectionY) {
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            for (int z = 0; z < 16; ++z) {
                                int blockX = chunkX * 16 + x;
                                int blockY = sectionY * 16 + y;
                                int blockZ = chunkZ * 16 + z;
                                class_2338 blockPos = new class_2338(blockX, blockY, blockZ);
                                if (!OverlayChecker.shouldRenderOverlay(blockPos)) continue;
                                int lightLevel = OverlayManager.MC.field_1687.method_8314(class_1944.field_9282, blockPos.method_10084());
                                activeRenderer.addBlock(OverlayManager.MC.field_1773.method_19418(), blockPos, lightLevel);
                            }
                        }
                    }
                }
            }
        }
        activeRenderer.endBatch();
    }

    public static enum OverlayRendererType {
        CARPET(new CarpetOverlayRenderer()),
        CROSS(new CrossOverlayRenderer()),
        NUMBER(new NumberOverlayRenderer()),
        MARKER(new MarkerOverlayRenderer());

        private final OverlayRenderer renderer;

        private OverlayRendererType(OverlayRenderer renderer) {
            this.renderer = renderer;
        }

        public OverlayRenderer getRenderer() {
            return this.renderer;
        }
    }
}

