/*
 * Decompiled with CFR 0.152.
 */
package net.lugo.lightoverlay.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.lugo.lightoverlay.LightOverlay;
import net.lugo.lightoverlay.config.ModConfig;
import net.lugo.lightoverlay.util.DistanceUtil;
import net.lugo.lightoverlay.util.OverlayChecker;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4076;

public class OverlayCache {
    private static final class_310 MC = class_310.method_1551();
    private static final ConcurrentHashMap<class_4076, CacheSectionPosEntry> cache = new ConcurrentHashMap();
    private static int MAX_CACHE_SIZE = 1000;
    private static final Queue<class_4076> computeQueue = new ConcurrentLinkedQueue<class_4076>();
    private static final Set<class_4076> queuedSections = ConcurrentHashMap.newKeySet();

    private static void updateMaxCacheSize() {
        if (OverlayCache.MC.field_1687 == null) {
            return;
        }
        int chunkScanRange = ModConfig.chunkScanRange;
        int horizontalChunks = 0;
        for (int dx = -chunkScanRange; dx <= chunkScanRange; ++dx) {
            for (int dz = -chunkScanRange; dz <= chunkScanRange; ++dz) {
                if (dx * dx + dz * dz > chunkScanRange * chunkScanRange) continue;
                ++horizontalChunks;
            }
        }
        int verticalSections = OverlayCache.MC.field_1687.method_31597() - OverlayCache.MC.field_1687.method_32891() + 1;
        int totalSections = horizontalChunks * verticalSections;
        int requiredSections = totalSections * 2;
        if (requiredSections > MAX_CACHE_SIZE) {
            LightOverlay.LOGGER.info("Resizing MAX_CACHE_SIZE, total sections * 2 ({}) is higher than current limit {}. New size is {}", new Object[]{requiredSections, MAX_CACHE_SIZE, requiredSections});
            MAX_CACHE_SIZE = requiredSections;
        }
    }

    public static void queueForCompute(class_4076 sectionPos) {
        if (cache.containsKey(sectionPos)) {
            return;
        }
        if (!queuedSections.contains(sectionPos)) {
            queuedSections.add(sectionPos);
            computeQueue.offer(sectionPos);
        }
    }

    public static void processQueue() {
        if (OverlayCache.MC.field_1687 == null || OverlayCache.MC.field_1724 == null) {
            return;
        }
        OverlayCache.updateMaxCacheSize();
        if (computeQueue.size() > ModConfig.maxComputationsPerTick * 2) {
            OverlayCache.reprioritizeQueue();
        }
        int processed = 0;
        while (processed < ModConfig.maxComputationsPerTick && !computeQueue.isEmpty()) {
            class_4076 sectionPos = computeQueue.poll();
            if (sectionPos == null) continue;
            queuedSections.remove(sectionPos);
            if (!cache.containsKey(sectionPos)) {
                OverlayCache.compute(sectionPos);
            }
            ++processed;
        }
    }

    private static void reprioritizeQueue() {
        class_4076 pos;
        if (OverlayCache.MC.field_1724 == null) {
            return;
        }
        class_2338 playerPos = OverlayCache.MC.field_1724.method_24515();
        ArrayList<class_4076> sections = new ArrayList<class_4076>();
        while ((pos = computeQueue.poll()) != null) {
            sections.add(pos);
        }
        sections.sort((a, b) -> {
            double distA = DistanceUtil.getDistanceSquared(a, playerPos);
            double distB = DistanceUtil.getDistanceSquared(b, playerPos);
            return Double.compare(distA, distB);
        });
        computeQueue.addAll(sections);
    }

    public static void clear(class_4076 sectionPos) {
        cache.remove(sectionPos);
        queuedSections.remove(sectionPos);
    }

    public static void clearFromBlockPos(class_2338 blockPos) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)blockPos);
        if (sectionPos.method_19528() == blockPos.method_10264()) {
            OverlayCache.clear(sectionPos.method_34591(0, -1, 0));
        }
        OverlayCache.clear(sectionPos);
    }

    private static void removeOldEntries() {
        if (cache.size() > MAX_CACHE_SIZE) {
            int toRemove = cache.size() / 5;
            cache.values().stream().sorted(Comparator.comparingLong(a -> a.lastAccessTime)).limit(toRemove).forEach(entry -> cache.remove(entry.pos));
        }
    }

    public static void compute(class_4076 sectionPos) {
        if (OverlayCache.MC.field_1687 == null) {
            return;
        }
        ArrayList<CacheBlockPosEntry> renderableBlocks = new ArrayList<CacheBlockPosEntry>();
        int minX = class_4076.method_18688((int)sectionPos.method_10263());
        int minY = class_4076.method_18688((int)sectionPos.method_10264());
        int minZ = class_4076.method_18688((int)sectionPos.method_10260());
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    class_2338 blockPos = new class_2338(minX + x, minY + y, minZ + z);
                    boolean shouldRender = OverlayChecker.shouldRenderOverlay(blockPos);
                    if (!shouldRender) continue;
                    int lightLevel = OverlayCache.MC.field_1687.method_8314(class_1944.field_9282, blockPos.method_10084());
                    renderableBlocks.add(new CacheBlockPosEntry(blockPos, lightLevel));
                }
            }
        }
        CacheBlockPosEntry[] blocksArray = renderableBlocks.toArray(new CacheBlockPosEntry[0]);
        cache.put(sectionPos, new CacheSectionPosEntry(sectionPos, blocksArray));
        OverlayCache.removeOldEntries();
    }

    public static CacheSectionPosEntry get(class_4076 sectionPos) {
        CacheSectionPosEntry entry = cache.get(sectionPos);
        if (entry != null) {
            entry.lastAccessTime = System.currentTimeMillis();
        }
        return entry;
    }

    public static void clearAll() {
        cache.clear();
        computeQueue.clear();
        queuedSections.clear();
    }

    public record CacheBlockPosEntry(class_2338 pos, int lightLevel) {
    }

    public static class CacheSectionPosEntry {
        public final class_4076 pos;
        public final CacheBlockPosEntry[] blocks;
        public long lastAccessTime;

        public CacheSectionPosEntry(class_4076 pos, CacheBlockPosEntry[] blocks) {
            this.pos = pos;
            this.blocks = blocks;
            this.lastAccessTime = System.currentTimeMillis();
        }
    }
}

