/*
 * Decompiled with CFR 0.152.
 */
package net.darkunity.customstartinventory;

import java.util.Locale;
import net.darkunity.customstartinventory.CustomStartInventory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CSIConfigScreen
extends Screen {
    private final Screen parent;
    private Button modEnabledButton;
    private Button intelligentScanningButton;
    private Button hideChatMessagesButton;
    private Button accessoriesModeButton;
    private Button doneButton;

    public CSIConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"csi.config.title"));
        this.parent = parent;
    }

    private Component createToggleText(String key, boolean enabled) {
        String status = enabled ? "\u00a7aENABLED" : "\u00a7cDISABLED";
        MutableComponent keyComponent = Component.translatable((String)key);
        return Component.literal((String)(keyComponent.getString() + ": " + status));
    }

    private Component createAccessoriesModeText() {
        String modeName = ((CustomStartInventory.AccessoryMode)((Object)CustomStartInventory.ACCESSORIES_MODE.get())).toString().toLowerCase(Locale.ROOT);
        MutableComponent modeValue = Component.translatable((String)("csi.config.mode." + modeName));
        return Component.translatable((String)"csi.config.accessories_mode").append(": ").append((Component)modeValue);
    }

    protected void init() {
        int y = 40;
        int buttonWidth = 250;
        int buttonHeight = 20;
        int centerX = this.width / 2 - buttonWidth / 2;
        this.modEnabledButton = Button.builder((Component)this.createToggleText("csi.config.mod_enabled", (Boolean)CustomStartInventory.MOD_ENABLED.get()), button -> {
            boolean newValue = (Boolean)CustomStartInventory.MOD_ENABLED.get() == false;
            CustomStartInventory.MOD_ENABLED.set((Object)newValue);
            button.setMessage(this.createToggleText("csi.config.mod_enabled", newValue));
        }).pos(centerX, y).size(buttonWidth, buttonHeight).build();
        this.addRenderableWidget((GuiEventListener)this.modEnabledButton);
        this.intelligentScanningButton = Button.builder((Component)this.createToggleText("csi.config.intelligent_scanning", (Boolean)CustomStartInventory.INTELLIGENT_SCANNING.get()), button -> {
            boolean newValue = (Boolean)CustomStartInventory.INTELLIGENT_SCANNING.get() == false;
            CustomStartInventory.INTELLIGENT_SCANNING.set((Object)newValue);
            button.setMessage(this.createToggleText("csi.config.intelligent_scanning", newValue));
        }).pos(centerX, y += buttonHeight + 2).size(buttonWidth, buttonHeight).build();
        this.addRenderableWidget((GuiEventListener)this.intelligentScanningButton);
        this.hideChatMessagesButton = Button.builder((Component)this.createToggleText("csi.config.hide_chat_messages", (Boolean)CustomStartInventory.HIDE_CHAT_MESSAGES.get()), button -> {
            boolean newValue = (Boolean)CustomStartInventory.HIDE_CHAT_MESSAGES.get() == false;
            CustomStartInventory.HIDE_CHAT_MESSAGES.set((Object)newValue);
            button.setMessage(this.createToggleText("csi.config.hide_chat_messages", newValue));
        }).pos(centerX, y += buttonHeight + 2).size(buttonWidth, buttonHeight).build();
        this.addRenderableWidget((GuiEventListener)this.hideChatMessagesButton);
        this.accessoriesModeButton = Button.builder((Component)this.createAccessoriesModeText(), button -> {
            CustomStartInventory.AccessoryMode currentMode = (CustomStartInventory.AccessoryMode)((Object)((Object)CustomStartInventory.ACCESSORIES_MODE.get()));
            CustomStartInventory.AccessoryMode[] modes = CustomStartInventory.AccessoryMode.values();
            int nextIndex = (currentMode.ordinal() + 1) % modes.length;
            CustomStartInventory.ACCESSORIES_MODE.set((Object)modes[nextIndex]);
            button.setMessage(this.createAccessoriesModeText());
        }).pos(centerX, y += buttonHeight + 2).size(buttonWidth, buttonHeight).build();
        this.addRenderableWidget((GuiEventListener)this.accessoriesModeButton);
        y += buttonHeight + 10;
        this.doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).pos(this.width / 2 - 100, this.height - 29).size(200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.doneButton);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 10, 0xFFFFFF);
        MutableComponent detectedModsBase = Component.translatable((String)"csi.config.detected_apis");
        StringBuilder detectedMods = new StringBuilder("\u00a7f" + detectedModsBase.getString());
        if (CustomStartInventory.hasAccessories) {
            detectedMods.append("\u00a7d").append(Component.translatable((String)"csi.config.api.accessories").getString());
            if (CustomStartInventory.hasCurios) {
                detectedMods.append(" \u00a7f& \u00a76").append(Component.translatable((String)"csi.config.api.curios").getString());
            }
        } else if (CustomStartInventory.hasCurios) {
            detectedMods.append("\u00a76").append(Component.translatable((String)"csi.config.api.curios").getString());
        } else {
            detectedMods.append("\u00a77").append(Component.translatable((String)"csi.config.api.none").getString());
        }
        guiGraphics.drawCenteredString(this.font, detectedMods.toString(), this.width / 2, 22, 0xFFFFFF);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.intelligentScanningButton.isMouseOver((double)mouseX, (double)mouseY)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"csi.config.tooltip.intelligent_scanning"), mouseX, mouseY);
        }
        if (this.hideChatMessagesButton.isMouseOver((double)mouseX, (double)mouseY)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"csi.config.tooltip.hide_chat_messages"), mouseX, mouseY);
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }
}

