/*
 * Decompiled with CFR 0.152.
 */
package net.darkunity.customstartinventory;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.darkunity.customstartinventory.CSIConfigScreen;
import net.darkunity.customstartinventory.ServerInventoryManager;
import net.darkunity.customstartinventory.handlers.CuriosAccessoriesHandler;
import net.darkunity.customstartinventory.handlers.WispForestAccessoriesHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@Mod(value="customstartinventory")
public class CustomStartInventory {
    public static final String MODID = "customstartinventory";
    public static ModConfigSpec.BooleanValue MOD_ENABLED;
    public static ModConfigSpec.BooleanValue INTELLIGENT_SCANNING;
    public static ModConfigSpec.BooleanValue ENABLE_SOUNDS;
    public static ModConfigSpec.BooleanValue SHOW_WELCOME_MESSAGE;
    public static ModConfigSpec.BooleanValue HIDE_CHAT_MESSAGES;
    public static ModConfigSpec.BooleanValue SAVE_ACCESSORIES;
    public static ModConfigSpec.EnumValue<AccessoryMode> ACCESSORIES_MODE;
    public static ModConfigSpec.IntValue MONITORING_DURATION;
    public static ModConfigSpec.BooleanValue REACTIVE_CLEANING;
    public static ModConfigSpec.IntValue MAX_REACTIVE_ATTEMPTS;
    public static ModConfigSpec.BooleanValue GLOBAL_INVENTORY_STORAGE;
    public static ModConfigSpec.BooleanValue SHARE_INVENTORY_BETWEEN_WORLDS;
    public static ModConfigSpec.BooleanValue VERIFY_INVENTORY_MATCH;
    public static ModConfigSpec.BooleanValue VERBOSE_LOGGING;
    public static ModConfigSpec.IntValue SMART_STABILITY_TICKS;
    public static ModConfigSpec.IntValue SMART_TIMEOUT_TICKS;
    public static ModConfigSpec.BooleanValue AGGRESSIVE_SCANNING;
    public static ModConfigSpec.IntValue SCAN_FREQUENCY;
    public static boolean hasCurios;
    public static boolean hasAccessories;
    private static final Map<UUID, PlayerMonitorData> activeMonitors;
    private static final Set<UUID> processedPlayers;
    private static MinecraftServer currentServer;
    private static Path globalStorageDir;
    private static int tickCounter;

    public CustomStartInventory(IEventBus modEventBus, ModContainer modContainer) {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        this.setupConfig(builder);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)builder.build());
        NeoForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (mc, parent) -> new CSIConfigScreen(parent));
    }

    private void setupConfig(ModConfigSpec.Builder builder) {
        builder.push("General");
        MOD_ENABLED = builder.comment(new String[]{"Enable/disable entire mod.", "Toggle the entire mod functionality on/off"}).define("ModEnabled", true);
        INTELLIGENT_SCANNING = builder.comment(new String[]{"Intelligent scanning", "If enabled, inventory is saved only when at least one item is present"}).define("IntelligentScanning", true);
        ENABLE_SOUNDS = builder.comment(new String[]{"Enable sounds", "Play sound effects when saving/loading inventory"}).define("EnableSounds", true);
        SHOW_WELCOME_MESSAGE = builder.comment(new String[]{"Show welcome message", "Show welcome message with information to player"}).define("ShowWelcomeMessage", true);
        HIDE_CHAT_MESSAGES = builder.comment(new String[]{"Hide chat messages", "Hide save/load messages in chat for players (only visible in server logs)"}).define("HideChatMessages", true);
        MONITORING_DURATION = builder.comment(new String[]{"Monitoring duration", "How long to monitor for new items (in ticks, 20 ticks = 1 second). Deprecated - use smart system"}).defineInRange("MonitoringDuration", 20, 60, 200);
        REACTIVE_CLEANING = builder.comment(new String[]{"Reactive cleaning", "Instantly clean any items that appear"}).define("ReactiveCleaning", true);
        MAX_REACTIVE_ATTEMPTS = builder.comment(new String[]{"Max reactive attempts", "Maximum number of reactive cleaning attempts"}).defineInRange("MaxReactiveAttempts", 1, 5, 20);
        GLOBAL_INVENTORY_STORAGE = builder.comment(new String[]{"Global inventory storage", "Save inventory globally (available across all worlds)"}).define("GlobalInventoryStorage", true);
        SHARE_INVENTORY_BETWEEN_WORLDS = builder.comment(new String[]{"Share inventory between worlds", "Use one saved inventory for all world types (survival, creative, etc.)"}).define("ShareInventoryBetweenWorlds", true);
        VERIFY_INVENTORY_MATCH = builder.comment(new String[]{"Verify inventory match", "Check if current inventory matches saved inventory before clearing"}).define("VerifyInventoryMatch", true);
        VERBOSE_LOGGING = builder.comment(new String[]{"Verbose logging", "Enable detailed logging (may create many log messages)"}).define("VerboseLogging", false);
        AGGRESSIVE_SCANNING = builder.comment(new String[]{"Aggressive scanning", "Fast reaction to inventory changes - detects items immediately"}).define("AggressiveScanning", true);
        SCAN_FREQUENCY = builder.comment(new String[]{"Scan frequency", "How often to scan inventory (1 = every tick, 2 = every second tick)"}).defineInRange("ScanFrequency", 1, 1, 10);
        SMART_STABILITY_TICKS = builder.comment(new String[]{"Smart stability ticks", "Ticks without changes to consider inventory stable (20 ticks = 1 second)"}).defineInRange("SmartStabilityTicks", 10, 5, 100);
        SMART_TIMEOUT_TICKS = builder.comment(new String[]{"Smart timeout ticks", "Maximum wait time before giving up (60 ticks = 3 seconds)"}).defineInRange("SmartTimeoutTicks", 60, 20, 200);
        builder.pop();
        builder.push("Accessories");
        SAVE_ACCESSORIES = builder.comment(new String[]{"Save accessories", "Save and load items from accessory slots (Curios/WispForest)"}).define("SaveAccessories", true);
        ACCESSORIES_MODE = builder.comment(new String[]{"Accessories mode", "Which accessory system to use: AUTO (try both), CURIOS, ACCESSORIES (WispForest), BOTH (save both), NONE"}).defineEnum("AccessoriesMode", (Enum)AccessoryMode.AUTO);
        builder.pop();
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        hasCurios = CuriosAccessoriesHandler.hasCurios();
        hasAccessories = WispForestAccessoriesHandler.hasAccessories();
        currentServer = event.getServer();
        if (((Boolean)GLOBAL_INVENTORY_STORAGE.get()).booleanValue()) {
            this.initGlobalStorage();
        }
        ServerInventoryManager.init();
        System.out.println("[CSI] \u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
        System.out.println("[CSI] Curios: " + hasCurios + ", WispForest: " + hasAccessories);
        System.out.println("[CSI] \u0410\u0433\u0440\u0435\u0441\u0441\u0438\u0432\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430: \u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c=" + String.valueOf(SMART_STABILITY_TICKS.get()) + " \u0442\u0438\u043a\u043e\u0432, \u0442\u0430\u0439\u043c-\u0430\u0443\u0442=" + String.valueOf(SMART_TIMEOUT_TICKS.get()) + " \u0442\u0438\u043a\u043e\u0432");
        System.out.println("[CSI] \u0421\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435: \u0430\u0433\u0440\u0435\u0441\u0441\u0438\u0432\u043d\u043e\u0435=" + String.valueOf(AGGRESSIVE_SCANNING.get()) + ", \u0447\u0430\u0441\u0442\u043e\u0442\u0430=" + String.valueOf(SCAN_FREQUENCY.get()));
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        activeMonitors.clear();
        processedPlayers.clear();
        currentServer = null;
        tickCounter = 0;
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        if (currentServer == null || !((Boolean)MOD_ENABLED.get()).booleanValue()) {
            return;
        }
        if (++tickCounter % (Integer)SCAN_FREQUENCY.get() != 0) {
            return;
        }
        this.processActiveMonitors();
    }

    private void processActiveMonitors() {
        Iterator<Map.Entry<UUID, PlayerMonitorData>> iterator = activeMonitors.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean persistentEmpty;
            Map.Entry<UUID, PlayerMonitorData> entry = iterator.next();
            PlayerMonitorData monitor = entry.getValue();
            UUID playerId = entry.getKey();
            ServerPlayer player = currentServer.getPlayerList().getPlayer(playerId);
            if (player == null || !player.isAlive() || player.connection == null) {
                System.out.println("[CSI] \u0418\u0433\u0440\u043e\u043a " + monitor.playerName + " \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u043b\u0441\u044f, \u0443\u0434\u0430\u043b\u044f\u0435\u043c \u043c\u043e\u043d\u0438\u0442\u043e\u0440");
                iterator.remove();
                continue;
            }
            ++monitor.scanCounter;
            int currentHash = CustomStartInventory.getAggressiveInventoryHashStatic(player);
            int itemCount = CustomStartInventory.countAllItemsAggressiveStatic(player);
            if (currentHash != monitor.lastInventoryHash) {
                monitor.stabilityCounter = 0;
                monitor.lastInventoryHash = currentHash;
                boolean bl = monitor.hasItemsAppeared = itemCount > 0;
                if (((Boolean)VERBOSE_LOGGING.get()).booleanValue()) {
                    System.out.println("[CSI] \u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0432 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435 " + player.getName().getString() + " (\u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432: " + itemCount + ", \u0445\u044d\u0448: " + currentHash + ")");
                }
                if (((Boolean)AGGRESSIVE_SCANNING.get()).booleanValue() && itemCount > 0 && ((Boolean)REACTIVE_CLEANING.get()).booleanValue()) {
                    if (((Boolean)VERBOSE_LOGGING.get()).booleanValue()) {
                        System.out.println("[CSI] \u0410\u0433\u0440\u0435\u0441\u0441\u0438\u0432\u043d\u0430\u044f \u0440\u0435\u0430\u043a\u0446\u0438\u044f \u043d\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b \u0443 " + player.getName().getString());
                    }
                    if (!((Boolean)VERIFY_INVENTORY_MATCH.get()).booleanValue() || !this.inventoryMatchesSaved(player)) {
                        this.performReactiveCleaning(player, monitor);
                    }
                }
            } else {
                ++monitor.stabilityCounter;
                monitor.consecutiveEmptyScans = itemCount == 0 ? ++monitor.consecutiveEmptyScans : 0;
            }
            --monitor.maxMonitoringTicks;
            boolean stabilityReached = monitor.stabilityCounter >= (Integer)SMART_STABILITY_TICKS.get();
            boolean timeoutReached = monitor.maxMonitoringTicks <= 0;
            boolean bl = persistentEmpty = monitor.consecutiveEmptyScans >= 5;
            if ((!monitor.hasItemsAppeared || !stabilityReached) && !timeoutReached && !persistentEmpty) continue;
            String reason = persistentEmpty ? "\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e \u043f\u0443\u0441\u0442\u043e\u0439" : (timeoutReached ? "\u0422\u0430\u0439\u043c-\u0430\u0443\u0442" : "\u0421\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442\u0430");
            System.out.println("[CSI] \u0410\u0433\u0440\u0435\u0441\u0441\u0438\u0432\u043d\u0430\u044f \u0432\u044b\u0434\u0430\u0447\u0430 \u0434\u043b\u044f " + player.getName().getString() + " (\u041f\u0440\u0438\u0447\u0438\u043d\u0430: " + reason + ", \u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c: " + monitor.stabilityCounter + " \u0442\u0438\u043a\u043e\u0432, \u043f\u0443\u0441\u0442\u044b\u0445 \u0441\u043a\u0430\u043d\u043e\u0432: " + monitor.consecutiveEmptyScans + ")");
            if (((Boolean)VERIFY_INVENTORY_MATCH.get()).booleanValue() && this.inventoryMatchesSaved(player)) {
                System.out.println("[CSI] \u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c \u0443\u0436\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u043c, \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c \u0432\u044b\u0434\u0430\u0447\u0443");
                monitor.hasGivenInventory = true;
            } else {
                this.executeAggressiveInventorySwap(player);
                monitor.hasGivenInventory = true;
            }
            iterator.remove();
            processedPlayers.add(playerId);
        }
    }

    private void performReactiveCleaning(ServerPlayer player, PlayerMonitorData monitor) {
        if (((Boolean)VERIFY_INVENTORY_MATCH.get()).booleanValue() && this.inventoryMatchesSaved(player)) {
            System.out.println("[CSI] \u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c \u0443\u0436\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u043c, \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c \u043e\u0447\u0438\u0441\u0442\u043a\u0443");
            monitor.hasGivenInventory = true;
            return;
        }
        System.out.println("[CSI] === \u0410\u0413\u0420\u0415\u0421\u0421\u0418\u0412\u041d\u0410\u042f \u0420\u0415\u0410\u041a\u0422\u0418\u0412\u041d\u0410\u042f \u041e\u0427\u0418\u0421\u0422\u041a\u0410 ===");
        System.out.println("[CSI] \u0418\u0433\u0440\u043e\u043a: " + player.getName().getString());
        this.fastClearInventory(player);
        this.giveSavedInventory(player);
        monitor.hasGivenInventory = true;
        System.out.println("[CSI] === \u0420\u0415\u0410\u041a\u0422\u0418\u0412\u041d\u0410\u042f \u041e\u0427\u0418\u0421\u0422\u041a\u0410 \u0417\u0410\u0412\u0415\u0420\u0428\u0415\u041d\u0410 ===");
    }

    private void executeAggressiveInventorySwap(ServerPlayer player) {
        System.out.println("[CSI] === \u0410\u0413\u0420\u0415\u0421\u0421\u0418\u0412\u041d\u0410\u042f \u041e\u041f\u0415\u0420\u0410\u0426\u0418\u042f ===");
        System.out.println("[CSI] \u0418\u0433\u0440\u043e\u043a: " + player.getName().getString());
        this.aggressiveClearInventory(player);
        this.giveSavedInventory(player);
        player.containerMenu.broadcastFullState();
        System.out.println("[CSI] === \u041e\u041f\u0415\u0420\u0410\u0426\u0418\u042f \u0417\u0410\u0412\u0415\u0420\u0428\u0415\u041d\u0410 ===");
    }

    private static int getAggressiveInventoryHashStatic(ServerPlayer player) {
        ItemStack stack;
        int i;
        Inventory inventory = player.getInventory();
        int hash = 0;
        for (i = 0; i < Math.min(9, inventory.items.size()); ++i) {
            stack = (ItemStack)inventory.items.get(i);
            if (stack.isEmpty()) continue;
            hash += i * 1000 + stack.getItem().hashCode() + stack.getCount();
        }
        for (i = 0; i < inventory.armor.size(); ++i) {
            stack = (ItemStack)inventory.armor.get(i);
            if (stack.isEmpty()) continue;
            hash += (100 + i) * 1000 + stack.getItem().hashCode() + stack.getCount();
        }
        if (!((ItemStack)inventory.offhand.get(0)).isEmpty()) {
            ItemStack stack2 = (ItemStack)inventory.offhand.get(0);
            hash += 106000 + stack2.getItem().hashCode() + stack2.getCount();
        }
        return hash;
    }

    private static int countAllItemsAggressiveStatic(ServerPlayer player) {
        int i;
        Inventory inventory = player.getInventory();
        int count = 0;
        for (i = 0; i < Math.min(9, inventory.items.size()); ++i) {
            if (((ItemStack)inventory.items.get(i)).isEmpty()) continue;
            ++count;
        }
        for (i = 0; i < inventory.armor.size(); ++i) {
            if (((ItemStack)inventory.armor.get(i)).isEmpty()) continue;
            ++count;
        }
        if (!((ItemStack)inventory.offhand.get(0)).isEmpty()) {
            ++count;
        }
        return count;
    }

    private int getAggressiveInventoryHash(ServerPlayer player) {
        return CustomStartInventory.getAggressiveInventoryHashStatic(player);
    }

    private int countAllItemsAggressive(ServerPlayer player) {
        return CustomStartInventory.countAllItemsAggressiveStatic(player);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (!((Boolean)MOD_ENABLED.get()).booleanValue() || !((player = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        System.out.println("[CSI] \u0418\u0433\u0440\u043e\u043a " + player2.getName().getString() + " \u0432\u043e\u0448\u0435\u043b \u0432 \u0438\u0433\u0440\u0443");
        processedPlayers.remove(player2.getUUID());
        activeMonitors.remove(player2.getUUID());
        if (this.shouldGiveStarterKit(player2)) {
            ServerInventoryManager.giveDefaultKitOnFirstJoin(player2);
            this.markStarterKitReceived(player2);
            return;
        }
        if (!this.shouldGiveInventoryOnWorldJoin(player2)) {
            System.out.println("[CSI] \u0418\u0433\u0440\u043e\u043a\u0443 " + player2.getName().getString() + " \u043d\u0435 \u043d\u0443\u0436\u043d\u043e \u0432\u044b\u0434\u0430\u0432\u0430\u0442\u044c \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c");
            processedPlayers.add(player2.getUUID());
            return;
        }
        System.out.println("[CSI] \u0410\u0433\u0440\u0435\u0441\u0441\u0438\u0432\u043d\u0430\u044f \u043e\u0447\u0438\u0441\u0442\u043a\u0430 \u043f\u0440\u0438 \u0432\u0445\u043e\u0434\u0435 \u0434\u043b\u044f " + player2.getName().getString());
        this.fastClearInventory(player2);
        this.startAggressiveMonitoring(player2);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player;
        if (!((Boolean)MOD_ENABLED.get()).booleanValue() || !((player = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        System.out.println("[CSI] \u0418\u0433\u0440\u043e\u043a " + player2.getName().getString() + " \u0432\u043e\u0437\u0440\u043e\u0434\u0438\u043b\u0441\u044f");
        processedPlayers.remove(player2.getUUID());
        activeMonitors.remove(player2.getUUID());
        if (!this.shouldGiveInventoryOnWorldJoin(player2)) {
            return;
        }
        this.fastClearInventory(player2);
        this.startAggressiveMonitoring(player2);
    }

    @SubscribeEvent
    public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player;
        if (!((Boolean)MOD_ENABLED.get()).booleanValue() || !((player = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        System.out.println("[CSI] \u0418\u0433\u0440\u043e\u043a " + player2.getName().getString() + " \u0441\u043c\u0435\u043d\u0438\u043b \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0435");
        processedPlayers.remove(player2.getUUID());
        activeMonitors.remove(player2.getUUID());
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!((Boolean)MOD_ENABLED.get()).booleanValue() || !event.isWasDeath()) {
            return;
        }
        Player player = event.getOriginal();
        if (player instanceof ServerPlayer) {
            ServerPlayer original = (ServerPlayer)player;
            player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer newPlayer = (ServerPlayer)player;
                CompoundTag originalData = original.getPersistentData();
                CompoundTag originalPersistent = originalData.getCompound("PlayerPersisted");
                CompoundTag newPlayerData = newPlayer.getPersistentData();
                CompoundTag newPersistent = newPlayerData.getCompound("PlayerPersisted");
                if (originalPersistent.getBoolean("csi_inventory_received")) {
                    newPersistent.putBoolean("csi_inventory_received", true);
                }
                newPlayerData.put("PlayerPersisted", (Tag)newPersistent);
            }
        }
    }

    private void startAggressiveMonitoring(ServerPlayer player) {
        PlayerMonitorData monitor = new PlayerMonitorData(player);
        activeMonitors.put(player.getUUID(), monitor);
        System.out.println("[CSI] \u0417\u0430\u043f\u0443\u0449\u0435\u043d \u0430\u0433\u0440\u0435\u0441\u0441\u0438\u0432\u043d\u044b\u0439 \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0438\u043d\u0433 \u0434\u043b\u044f " + player.getName().getString() + " (\u0442\u0430\u0439\u043c-\u0430\u0443\u0442: " + String.valueOf(SMART_TIMEOUT_TICKS.get()) + " \u0442\u0438\u043a\u043e\u0432, \u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c: " + String.valueOf(SMART_STABILITY_TICKS.get()) + " \u0442\u0438\u043a\u043e\u0432, \u0447\u0430\u0441\u0442\u043e\u0442\u0430: " + String.valueOf(SCAN_FREQUENCY.get()) + ")");
    }

    private void fastClearInventory(ServerPlayer player) {
        int i;
        Inventory inventory = player.getInventory();
        int clearedCount = 0;
        for (i = 0; i < Math.min(9, inventory.items.size()); ++i) {
            if (((ItemStack)inventory.items.get(i)).isEmpty()) continue;
            inventory.items.set(i, (Object)ItemStack.EMPTY);
            ++clearedCount;
        }
        for (i = 0; i < inventory.armor.size(); ++i) {
            if (((ItemStack)inventory.armor.get(i)).isEmpty()) continue;
            inventory.armor.set(i, (Object)ItemStack.EMPTY);
            ++clearedCount;
        }
        if (!((ItemStack)inventory.offhand.get(0)).isEmpty()) {
            inventory.offhand.set(0, (Object)ItemStack.EMPTY);
            ++clearedCount;
        }
        if (clearedCount > 0) {
            player.inventoryMenu.slotsChanged((Container)inventory);
            player.containerMenu.broadcastFullState();
        }
        if (((Boolean)VERBOSE_LOGGING.get()).booleanValue() && clearedCount > 0) {
            System.out.println("[CSI] \u0411\u044b\u0441\u0442\u0440\u0430\u044f \u043e\u0447\u0438\u0441\u0442\u043a\u0430: " + clearedCount + " \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432 \u0443 " + player.getName().getString());
        }
    }

    private void aggressiveClearInventory(ServerPlayer player) {
        int i;
        System.out.println("[CSI] === \u0410\u0413\u0420\u0415\u0421\u0421\u0418\u0412\u041d\u0410\u042f \u041e\u0427\u0418\u0421\u0422\u041a\u0410 ===");
        System.out.println("[CSI] \u0418\u0433\u0440\u043e\u043a: " + player.getName().getString());
        Inventory inventory = player.getInventory();
        int clearedCount = 0;
        for (i = 0; i < inventory.items.size(); ++i) {
            if (((ItemStack)inventory.items.get(i)).isEmpty()) continue;
            inventory.items.set(i, (Object)ItemStack.EMPTY);
            ++clearedCount;
        }
        for (i = 0; i < inventory.armor.size(); ++i) {
            if (((ItemStack)inventory.armor.get(i)).isEmpty()) continue;
            inventory.armor.set(i, (Object)ItemStack.EMPTY);
            ++clearedCount;
        }
        if (!inventory.offhand.isEmpty() && !((ItemStack)inventory.offhand.get(0)).isEmpty()) {
            inventory.offhand.set(0, (Object)ItemStack.EMPTY);
            ++clearedCount;
        }
        if (((Boolean)SAVE_ACCESSORIES.get()).booleanValue()) {
            this.clearAccessories(player);
        }
        player.inventoryMenu.slotsChanged((Container)inventory);
        player.containerMenu.broadcastFullState();
        System.out.println("[CSI] \u041e\u0447\u0438\u0449\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432: " + clearedCount);
        System.out.println("[CSI] === \u041e\u0427\u0418\u0421\u0422\u041a\u0410 \u0417\u0410\u0412\u0415\u0420\u0428\u0415\u041d\u0410 ===");
    }

    private void giveSavedInventory(ServerPlayer player) {
        boolean loaded;
        System.out.println("[CSI] \u0412\u044b\u0434\u0430\u0447\u0430 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044f \u0434\u043b\u044f " + player.getName().getString());
        if (this.countAllItems(player) > 0) {
            System.out.println("[CSI] \u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435: \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c \u043d\u0435 \u043f\u0443\u0441\u0442 \u043f\u0435\u0440\u0435\u0434 \u0432\u044b\u0434\u0430\u0447\u0435\u0439!");
            this.fastClearInventory(player);
        }
        if (loaded = this.loadInventory(player)) {
            this.markInventoryReceived(player);
            if (((Boolean)SHOW_WELCOME_MESSAGE.get()).booleanValue() && !((Boolean)HIDE_CHAT_MESSAGES.get()).booleanValue()) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7a[CSI] \u00a7fStarting inventory received!"));
            }
            if (((Boolean)ENABLE_SOUNDS.get()).booleanValue()) {
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            System.out.println("[CSI] \u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u044b\u0434\u0430\u043d");
        } else {
            System.out.println("[CSI] \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c");
        }
    }

    private int countAllItems(ServerPlayer player) {
        Inventory inventory = player.getInventory();
        int count = 0;
        for (ItemStack item : inventory.items) {
            if (item.isEmpty()) continue;
            ++count;
        }
        for (ItemStack item : inventory.armor) {
            if (item.isEmpty()) continue;
            ++count;
        }
        for (ItemStack item : inventory.offhand) {
            if (item.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    private void clearAccessories(ServerPlayer player) {
        if (hasCurios && (ACCESSORIES_MODE.get() == AccessoryMode.CURIOS || ACCESSORIES_MODE.get() == AccessoryMode.AUTO || ACCESSORIES_MODE.get() == AccessoryMode.BOTH)) {
            CuriosAccessoriesHandler.clearAccessories(player);
        }
        if (hasAccessories && (ACCESSORIES_MODE.get() == AccessoryMode.ACCESSORIES || ACCESSORIES_MODE.get() == AccessoryMode.AUTO || ACCESSORIES_MODE.get() == AccessoryMode.BOTH)) {
            WispForestAccessoriesHandler.clearAccessories(player);
        }
    }

    private boolean inventoryMatchesSaved(ServerPlayer player) {
        int currentItemCount;
        if (!((Boolean)VERIFY_INVENTORY_MATCH.get()).booleanValue()) {
            return false;
        }
        CompoundTag savedData = this.loadFromFile(player);
        if (!savedData.contains("Inventory")) {
            return false;
        }
        int savedItemCount = savedData.getList("Inventory", 10).size();
        if (savedItemCount != (currentItemCount = this.countAllItems(player))) {
            return false;
        }
        ListTag savedItems = savedData.getList("Inventory", 10);
        Inventory currentInventory = player.getInventory();
        for (int i = 0; i < savedItems.size(); ++i) {
            CompoundTag itemTag;
            ItemStack savedStack;
            CompoundTag slotTag = savedItems.getCompound(i);
            int slot = slotTag.getByte("Slot") & 0xFF;
            int type = slotTag.getByte("Type") & 0xFF;
            if (!slotTag.contains("Item") || (savedStack = this.loadItemStackSimple(player, itemTag = slotTag.getCompound("Item"))).isEmpty()) continue;
            ItemStack currentStack = ItemStack.EMPTY;
            switch (type) {
                case 0: {
                    if (slot >= currentInventory.items.size()) break;
                    currentStack = (ItemStack)currentInventory.items.get(slot);
                    break;
                }
                case 1: {
                    if (slot >= currentInventory.armor.size()) break;
                    currentStack = (ItemStack)currentInventory.armor.get(slot);
                    break;
                }
                case 2: {
                    if (slot >= currentInventory.offhand.size()) break;
                    currentStack = (ItemStack)currentInventory.offhand.get(slot);
                }
            }
            if (this.itemsMatchFast(currentStack, savedStack)) continue;
            return false;
        }
        return true;
    }

    private boolean itemsMatchFast(ItemStack stack1, ItemStack stack2) {
        if (stack1.isEmpty() != stack2.isEmpty()) {
            return false;
        }
        if (stack1.isEmpty()) {
            return true;
        }
        return stack1.getItem() == stack2.getItem() && stack1.getCount() == stack2.getCount();
    }

    private void initGlobalStorage() {
        try {
            Path minecraftDir = Paths.get(".", new String[0]);
            globalStorageDir = minecraftDir.resolve("csi_storage");
            if (!Files.exists(globalStorageDir, new LinkOption[0])) {
                Files.createDirectories(globalStorageDir, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            System.out.println("[CSI] \u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430: " + e.getMessage());
        }
    }

    private Path getPlayerSavePath(ServerPlayer player, boolean useGlobalStorage) {
        if (useGlobalStorage && globalStorageDir != null) {
            return globalStorageDir.resolve(player.getUUID().toString() + ".dat");
        }
        return null;
    }

    private boolean saveToFile(ServerPlayer player, CompoundTag data) {
        if (!((Boolean)GLOBAL_INVENTORY_STORAGE.get()).booleanValue()) {
            CompoundTag playerData = player.getPersistentData();
            if (!playerData.contains("PlayerPersisted")) {
                playerData.put("PlayerPersisted", (Tag)new CompoundTag());
            }
            CompoundTag persisted = playerData.getCompound("PlayerPersisted");
            persisted.put(MODID, (Tag)data);
            return true;
        }
        try {
            Path savePath = this.getPlayerSavePath(player, true);
            if (savePath == null) {
                return false;
            }
            NbtIo.write((CompoundTag)data, (Path)savePath);
            CompoundTag playerData = player.getPersistentData();
            if (!playerData.contains("PlayerPersisted")) {
                playerData.put("PlayerPersisted", (Tag)new CompoundTag());
            }
            CompoundTag persisted = playerData.getCompound("PlayerPersisted");
            persisted.put(MODID, (Tag)data);
            return true;
        }
        catch (Exception e) {
            System.out.println("[CSI] \u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f: " + e.getMessage());
            return false;
        }
    }

    private CompoundTag loadFromFile(ServerPlayer player) {
        CompoundTag playerData;
        if (((Boolean)GLOBAL_INVENTORY_STORAGE.get()).booleanValue()) {
            try {
                Path savePath = this.getPlayerSavePath(player, true);
                if (savePath != null && Files.exists(savePath, new LinkOption[0]) && Files.size(savePath) > 0L) {
                    return NbtIo.read((Path)savePath);
                }
            }
            catch (Exception savePath) {
                // empty catch block
            }
        }
        if (!(playerData = player.getPersistentData()).contains("PlayerPersisted")) {
            return new CompoundTag();
        }
        CompoundTag persisted = playerData.getCompound("PlayerPersisted");
        if (!persisted.contains(MODID)) {
            return new CompoundTag();
        }
        return persisted.getCompound(MODID);
    }

    private boolean hasSavedInventory(ServerPlayer player) {
        CompoundTag persisted;
        CompoundTag playerData;
        Path savePath;
        if (((Boolean)GLOBAL_INVENTORY_STORAGE.get()).booleanValue() && (savePath = this.getPlayerSavePath(player, true)) != null && Files.exists(savePath, new LinkOption[0])) {
            try {
                return Files.size(savePath) > 0L;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((playerData = player.getPersistentData()).contains("PlayerPersisted") && (persisted = playerData.getCompound("PlayerPersisted")).contains(MODID)) {
            CompoundTag csiData = persisted.getCompound(MODID);
            return csiData.contains("Inventory") || csiData.contains("Accessories");
        }
        return false;
    }

    private boolean shouldGiveInventoryOnWorldJoin(ServerPlayer player) {
        CompoundTag persisted;
        if (!this.hasSavedInventory(player)) {
            return false;
        }
        CompoundTag playerData = player.getPersistentData();
        return !playerData.contains("PlayerPersisted") || !(persisted = playerData.getCompound("PlayerPersisted")).getBoolean("csi_inventory_received");
    }

    private void markInventoryReceived(ServerPlayer player) {
        CompoundTag playerData = player.getPersistentData();
        if (!playerData.contains("PlayerPersisted")) {
            playerData.put("PlayerPersisted", (Tag)new CompoundTag());
        }
        CompoundTag persisted = playerData.getCompound("PlayerPersisted");
        persisted.putBoolean("csi_inventory_received", true);
    }

    private boolean shouldGiveStarterKit(ServerPlayer player) {
        CompoundTag persisted;
        CompoundTag playerData = player.getPersistentData();
        if (playerData.contains("PlayerPersisted") && (persisted = playerData.getCompound("PlayerPersisted")).getBoolean("csi_starter_kit_received")) {
            return false;
        }
        if (this.hasSavedInventory(player)) {
            return false;
        }
        return ServerInventoryManager.getDefaultKit() != null;
    }

    private void markStarterKitReceived(ServerPlayer player) {
        CompoundTag playerData = player.getPersistentData();
        if (!playerData.contains("PlayerPersisted")) {
            playerData.put("PlayerPersisted", (Tag)new CompoundTag());
        }
        CompoundTag persisted = playerData.getCompound("PlayerPersisted");
        persisted.putBoolean("csi_starter_kit_received", true);
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"csi").requires(source -> source.hasPermission(3))).then(((LiteralArgumentBuilder)Commands.literal((String)"save").executes(context -> this.handleSave((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> this.handleSave((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"load").executes(context -> this.handleLoad((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> this.handleLoad((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").executes(context -> this.handleRemove((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> this.handleRemove((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kit").requires(source -> source.hasPermission(3))).then(Commands.literal((String)"create").then(Commands.argument((String)"kitname", (ArgumentType)StringArgumentType.word()).executes(context -> this.handleKitCreate((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)context, (String)"kitname")))))).then(((RequiredArgumentBuilder)Commands.argument((String)"kitname", (ArgumentType)StringArgumentType.word()).executes(context -> this.handleKitGive((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)context, (String)"kitname")))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> this.handleKitGive((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), StringArgumentType.getString((CommandContext)context, (String)"kitname")))))).then(Commands.literal((String)"list").executes(context -> this.handleKitList((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").then(((RequiredArgumentBuilder)Commands.argument((String)"kitname", (ArgumentType)StringArgumentType.word()).executes(context -> this.handleKitRemove((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"kitname")))).then(Commands.literal((String)"confirm").executes(context -> this.handleKitRemoveConfirm((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"kitname")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"all").executes(context -> this.handleKitRemoveAll((CommandSourceStack)context.getSource()))).then(Commands.literal((String)"confirm").executes(context -> this.handleKitRemoveAllConfirm((CommandSourceStack)context.getSource())))))).then(Commands.literal((String)"reload").executes(context -> this.handleKitReload((CommandSourceStack)context.getSource()))))).then(Commands.literal((String)"help").executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"csi.command.help.header"), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"csi.command.help.save"), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"csi.command.help.load"), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"csi.command.help.remove"), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"csi.command.help.kit.create"), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"csi.command.help.kit.give"), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"csi.command.help.kit.list"), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"csi.command.help.kit.remove"), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"csi.command.help.kit.removeall"), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"csi.command.help.kit.reload"), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"csi.command.help.autosystem"), false);
            return 1;
        })));
    }

    private int handleSave(CommandSourceStack source, ServerPlayer target) {
        if (!((Boolean)MOD_ENABLED.get()).booleanValue()) {
            source.sendFailure((Component)Component.translatable((String)"csi.message.mod.disabled"));
            return 0;
        }
        if (((Boolean)INTELLIGENT_SCANNING.get()).booleanValue() && this.countAllItems(target) == 0) {
            source.sendFailure((Component)Component.translatable((String)"csi.command.save.empty"));
            return 0;
        }
        boolean saved = this.saveInventory(target);
        if (saved) {
            if (source.getEntity() == target) {
                source.sendSuccess(() -> Component.translatable((String)"csi.command.save.self"), false);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"csi.command.save.success", (Object[])new Object[]{target.getName().getString()}), false);
            }
            if (((Boolean)ENABLE_SOUNDS.get()).booleanValue()) {
                this.playSound(source, target, (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value());
            }
            return 1;
        }
        source.sendFailure((Component)Component.translatable((String)"csi.command.save.failure"));
        return 0;
    }

    private int handleLoad(CommandSourceStack source, ServerPlayer target) {
        if (!((Boolean)MOD_ENABLED.get()).booleanValue()) {
            source.sendFailure((Component)Component.translatable((String)"csi.message.mod.disabled"));
            return 0;
        }
        source.sendSuccess(() -> Component.translatable((String)"csi.command.load.clearing"), false);
        this.aggressiveClearInventory(target);
        boolean loaded = this.loadInventory(target);
        if (loaded) {
            if (source.getEntity() == target) {
                source.sendSuccess(() -> Component.translatable((String)"csi.command.load.self"), false);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"csi.command.load.success", (Object[])new Object[]{target.getName().getString()}), false);
            }
            if (((Boolean)ENABLE_SOUNDS.get()).booleanValue()) {
                this.playSound(source, target, SoundEvents.EXPERIENCE_ORB_PICKUP);
            }
            this.markInventoryReceived(target);
            return 1;
        }
        source.sendFailure((Component)Component.translatable((String)"csi.command.load.failure"));
        return 0;
    }

    private int handleRemove(CommandSourceStack source, ServerPlayer target) {
        CompoundTag playerData;
        Path savePath;
        if (!((Boolean)MOD_ENABLED.get()).booleanValue()) {
            source.sendFailure((Component)Component.translatable((String)"csi.message.mod.disabled"));
            return 0;
        }
        if (((Boolean)GLOBAL_INVENTORY_STORAGE.get()).booleanValue() && (savePath = this.getPlayerSavePath(target, true)) != null && Files.exists(savePath, new LinkOption[0])) {
            try {
                Files.delete(savePath);
                source.sendSuccess(() -> Component.translatable((String)"csi.command.remove.global_deleted"), false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((playerData = target.getPersistentData()).contains("PlayerPersisted")) {
            CompoundTag persisted = playerData.getCompound("PlayerPersisted");
            persisted.remove(MODID);
            persisted.remove("csi_inventory_received");
            source.sendSuccess(() -> Component.translatable((String)"csi.command.remove.local_deleted"), false);
        }
        if (source.getEntity() == target) {
            source.sendSuccess(() -> Component.translatable((String)"csi.command.remove.self"), false);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"csi.command.remove.success", (Object[])new Object[]{target.getName().getString()}), false);
        }
        if (((Boolean)ENABLE_SOUNDS.get()).booleanValue()) {
            this.playSound(source, target, (SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value());
        }
        return 1;
    }

    private int handleKitCreate(CommandSourceStack source, ServerPlayer player, String kitName) {
        if (!((Boolean)MOD_ENABLED.get()).booleanValue()) {
            source.sendFailure((Component)Component.translatable((String)"csi.message.mod.disabled"));
            return 0;
        }
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.create.saving", (Object[])new Object[]{kitName}), false);
        boolean success = ServerInventoryManager.createKitFromInventory(player, kitName);
        if (success) {
            source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.create.success", (Object[])new Object[]{kitName}), false);
            source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.create.saved"), false);
        } else {
            source.sendFailure((Component)Component.translatable((String)"csi.command.kit.create.exists", (Object[])new Object[]{kitName}));
        }
        return success ? 1 : 0;
    }

    private int handleKitGive(CommandSourceStack source, ServerPlayer target, String kitName) {
        if (!((Boolean)MOD_ENABLED.get()).booleanValue()) {
            source.sendFailure((Component)Component.translatable((String)"csi.message.mod.disabled"));
            return 0;
        }
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.give.clearing"), false);
        this.aggressiveClearInventory(target);
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.give.loading", (Object[])new Object[]{kitName}), false);
        boolean success = ServerInventoryManager.giveKitToPlayer(target, kitName);
        if (success) {
            if (source.getEntity() == target) {
                source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.give.self", (Object[])new Object[]{kitName}), false);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.give.success", (Object[])new Object[]{kitName, target.getName().getString()}), false);
            }
        } else {
            source.sendFailure((Component)Component.translatable((String)"csi.command.kit.give.notfound", (Object[])new Object[]{kitName}));
        }
        return success ? 1 : 0;
    }

    private int handleKitList(CommandSourceStack source) {
        if (!((Boolean)MOD_ENABLED.get()).booleanValue()) {
            source.sendFailure((Component)Component.translatable((String)"csi.message.mod.disabled"));
            return 0;
        }
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.list.loading"), false);
        List<ServerInventoryManager.StarterKit> kits = ServerInventoryManager.getAllKits();
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.list.header"), false);
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.list.count", (Object[])new Object[]{kits.size()}), false);
        if (kits.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.list.empty"), false);
            source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.list.instruction"), false);
        } else {
            for (ServerInventoryManager.StarterKit kit : kits) {
                String autoGive = kit.giveOnFirstJoin ? Component.translatable((String)"csi.command.kit.auto").getString() : Component.translatable((String)"csi.command.kit.manual").getString();
                int totalItems = kit.items.size() + kit.armor.size() + kit.offhand.size();
                source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.list.format", (Object[])new Object[]{kit.kitName, autoGive, totalItems}), false);
            }
        }
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.commands"), false);
        source.sendSuccess(() -> Component.translatable((String)"csi.command.help.kit.create"), false);
        source.sendSuccess(() -> Component.translatable((String)"csi.command.help.kit.give"), false);
        source.sendSuccess(() -> Component.translatable((String)"csi.command.help.kit.list"), false);
        source.sendSuccess(() -> Component.translatable((String)"csi.command.help.kit.remove"), false);
        source.sendSuccess(() -> Component.translatable((String)"csi.command.help.kit.removeall"), false);
        source.sendSuccess(() -> Component.translatable((String)"csi.command.help.kit.reload"), false);
        return kits.size();
    }

    private int handleKitRemove(CommandSourceStack source, String kitName) {
        if (!((Boolean)MOD_ENABLED.get()).booleanValue()) {
            source.sendFailure((Component)Component.translatable((String)"csi.message.mod.disabled"));
            return 0;
        }
        if (kitName.equalsIgnoreCase("all")) {
            return this.handleKitRemoveAll(source);
        }
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.remove.confirm", (Object[])new Object[]{kitName}), false);
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.remove.warning"), false);
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.remove.instructions", (Object[])new Object[]{kitName}), false);
        return 0;
    }

    private int handleKitRemoveConfirm(CommandSourceStack source, String kitName) {
        if (!((Boolean)MOD_ENABLED.get()).booleanValue()) {
            source.sendFailure((Component)Component.translatable((String)"csi.message.mod.disabled"));
            return 0;
        }
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.remove.removing", (Object[])new Object[]{kitName}), false);
        boolean success = ServerInventoryManager.removeKit(kitName);
        if (success) {
            source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.remove.success", (Object[])new Object[]{kitName}), false);
            source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.remove.config_updated"), false);
        } else {
            source.sendFailure((Component)Component.translatable((String)"csi.command.kit.remove.not_found", (Object[])new Object[]{kitName}));
        }
        return success ? 1 : 0;
    }

    private int handleKitRemoveAll(CommandSourceStack source) {
        if (!((Boolean)MOD_ENABLED.get()).booleanValue()) {
            source.sendFailure((Component)Component.translatable((String)"csi.message.mod.disabled"));
            return 0;
        }
        List<ServerInventoryManager.StarterKit> kits = ServerInventoryManager.getAllKits();
        if (kits.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.removeall.empty"), false);
            return 0;
        }
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.removeall.warning"), false);
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.removeall.count", (Object[])new Object[]{kits.size()}), false);
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.removeall.confirm"), false);
        return 0;
    }

    private int handleKitRemoveAllConfirm(CommandSourceStack source) {
        if (!((Boolean)MOD_ENABLED.get()).booleanValue()) {
            source.sendFailure((Component)Component.translatable((String)"csi.message.mod.disabled"));
            return 0;
        }
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.removeall.processing"), false);
        boolean success = ServerInventoryManager.removeAllKits();
        if (success) {
            source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.removeall.success"), false);
        } else {
            source.sendFailure((Component)Component.translatable((String)"csi.command.kit.removeall.error"));
        }
        return success ? 1 : 0;
    }

    private int handleKitReload(CommandSourceStack source) {
        if (!((Boolean)MOD_ENABLED.get()).booleanValue()) {
            source.sendFailure((Component)Component.translatable((String)"csi.message.mod.disabled"));
            return 0;
        }
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.reload.processing"), false);
        ServerInventoryManager.reloadConfig();
        List<ServerInventoryManager.StarterKit> kits = ServerInventoryManager.getAllKits();
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.reload.success"), false);
        source.sendSuccess(() -> Component.translatable((String)"csi.command.kit.reload.loaded", (Object[])new Object[]{kits.size()}), false);
        return 1;
    }

    private boolean saveInventory(ServerPlayer player) {
        CompoundTag slotTag;
        CompoundTag itemTag;
        ItemStack item;
        int i;
        CompoundTag csiTag = new CompoundTag();
        Inventory inventory = player.getInventory();
        ListTag inventoryTag = new ListTag();
        for (i = 0; i < inventory.items.size(); ++i) {
            item = (ItemStack)inventory.items.get(i);
            if (item.isEmpty() || (itemTag = this.saveItemStackSimple(player, item)).isEmpty()) continue;
            slotTag = new CompoundTag();
            slotTag.putByte("Slot", (byte)i);
            slotTag.putByte("Type", (byte)0);
            slotTag.put("Item", (Tag)itemTag);
            inventoryTag.add((Object)slotTag);
        }
        for (i = 0; i < inventory.armor.size(); ++i) {
            item = (ItemStack)inventory.armor.get(i);
            if (item.isEmpty() || (itemTag = this.saveItemStackSimple(player, item)).isEmpty()) continue;
            slotTag = new CompoundTag();
            slotTag.putByte("Slot", (byte)i);
            slotTag.putByte("Type", (byte)1);
            slotTag.put("Item", (Tag)itemTag);
            inventoryTag.add((Object)slotTag);
        }
        for (i = 0; i < inventory.offhand.size(); ++i) {
            item = (ItemStack)inventory.offhand.get(i);
            if (item.isEmpty() || (itemTag = this.saveItemStackSimple(player, item)).isEmpty()) continue;
            slotTag = new CompoundTag();
            slotTag.putByte("Slot", (byte)i);
            slotTag.putByte("Type", (byte)2);
            slotTag.put("Item", (Tag)itemTag);
            inventoryTag.add((Object)slotTag);
        }
        csiTag.put("Inventory", (Tag)inventoryTag);
        if (((Boolean)SAVE_ACCESSORIES.get()).booleanValue()) {
            CompoundTag wispData;
            ListTag curiosList;
            CompoundTag accessoriesTag = new CompoundTag();
            if (hasCurios && (ACCESSORIES_MODE.get() == AccessoryMode.CURIOS || ACCESSORIES_MODE.get() == AccessoryMode.AUTO || ACCESSORIES_MODE.get() == AccessoryMode.BOTH) && !(curiosList = CuriosAccessoriesHandler.saveCurios(player)).isEmpty()) {
                accessoriesTag.put("Curios", (Tag)curiosList);
            }
            if (hasAccessories && (ACCESSORIES_MODE.get() == AccessoryMode.ACCESSORIES || ACCESSORIES_MODE.get() == AccessoryMode.AUTO || ACCESSORIES_MODE.get() == AccessoryMode.BOTH) && !(wispData = WispForestAccessoriesHandler.saveAccessories(player)).isEmpty()) {
                accessoriesTag.put("WispForest", (Tag)wispData);
            }
            if (!accessoriesTag.isEmpty()) {
                csiTag.put("Accessories", (Tag)accessoriesTag);
            }
        }
        return this.saveToFile(player, csiTag);
    }

    private boolean loadInventory(ServerPlayer player) {
        CompoundTag csiTag = this.loadFromFile(player);
        if (!csiTag.contains("Inventory") && !csiTag.contains("Accessories")) {
            return false;
        }
        boolean inventoryLoaded = false;
        if (csiTag.contains("Inventory")) {
            ListTag inventoryTag = csiTag.getList("Inventory", 10);
            Inventory inventory = player.getInventory();
            block5: for (int i = 0; i < inventoryTag.size(); ++i) {
                CompoundTag itemTag;
                ItemStack stack;
                CompoundTag slotTag = inventoryTag.getCompound(i);
                int slot = slotTag.getByte("Slot") & 0xFF;
                int type = slotTag.getByte("Type") & 0xFF;
                if (!slotTag.contains("Item") || (stack = this.loadItemStackSimple(player, itemTag = slotTag.getCompound("Item"))).isEmpty()) continue;
                switch (type) {
                    case 0: {
                        if (slot < 0 || slot >= inventory.items.size()) continue block5;
                        inventory.items.set(slot, (Object)stack);
                        continue block5;
                    }
                    case 1: {
                        if (slot < 0 || slot >= inventory.armor.size()) continue block5;
                        inventory.armor.set(slot, (Object)stack);
                        continue block5;
                    }
                    case 2: {
                        if (slot < 0 || slot >= inventory.offhand.size()) continue block5;
                        inventory.offhand.set(slot, (Object)stack);
                    }
                }
            }
            player.inventoryMenu.slotsChanged((Container)inventory);
            boolean bl = inventoryLoaded = !inventoryTag.isEmpty();
        }
        if (((Boolean)SAVE_ACCESSORIES.get()).booleanValue() && csiTag.contains("Accessories")) {
            CompoundTag accessoriesTag = csiTag.getCompound("Accessories");
            if (hasCurios && (ACCESSORIES_MODE.get() == AccessoryMode.CURIOS || ACCESSORIES_MODE.get() == AccessoryMode.AUTO || ACCESSORIES_MODE.get() == AccessoryMode.BOTH) && accessoriesTag.contains("Curios")) {
                CompoundTag curiosData = new CompoundTag();
                curiosData.put("CuriosList", (Tag)accessoriesTag.getList("Curios", 10));
                CuriosAccessoriesHandler.loadCurios(player, curiosData);
            }
            if (hasAccessories && (ACCESSORIES_MODE.get() == AccessoryMode.ACCESSORIES || ACCESSORIES_MODE.get() == AccessoryMode.AUTO || ACCESSORIES_MODE.get() == AccessoryMode.BOTH) && accessoriesTag.contains("WispForest")) {
                WispForestAccessoriesHandler.loadAccessories(player, accessoriesTag.getCompound("WispForest"));
            }
        }
        return inventoryLoaded;
    }

    private CompoundTag saveItemStackSimple(ServerPlayer player, ItemStack stack) {
        if (stack.isEmpty()) {
            return new CompoundTag();
        }
        try {
            Tag savedTag = stack.save((HolderLookup.Provider)player.registryAccess());
            if (savedTag instanceof CompoundTag) {
                return (CompoundTag)savedTag;
            }
            CompoundTag tag = new CompoundTag();
            stack.save((HolderLookup.Provider)player.registryAccess(), (Tag)tag);
            return tag;
        }
        catch (Exception e) {
            return new CompoundTag();
        }
    }

    private ItemStack loadItemStackSimple(ServerPlayer player, CompoundTag tag) {
        try {
            if (tag.isEmpty()) {
                return ItemStack.EMPTY;
            }
            Optional optionalStack = ItemStack.parse((HolderLookup.Provider)player.registryAccess(), (Tag)tag);
            return optionalStack.orElse(ItemStack.EMPTY);
        }
        catch (Exception e) {
            return ItemStack.EMPTY;
        }
    }

    private void playSound(CommandSourceStack source, ServerPlayer player, SoundEvent sound) {
        if (player != null && source.getLevel() != null) {
            source.getLevel().playSound(null, player.getX(), player.getY(), player.getZ(), sound, SoundSource.PLAYERS, 0.5f, 1.0f);
        }
    }

    static {
        hasCurios = false;
        hasAccessories = false;
        activeMonitors = new HashMap<UUID, PlayerMonitorData>();
        processedPlayers = new HashSet<UUID>();
        tickCounter = 0;
    }

    public static enum AccessoryMode {
        AUTO,
        CURIOS,
        ACCESSORIES,
        BOTH,
        NONE;

    }

    private static class PlayerMonitorData {
        final ServerPlayer player;
        final String playerName;
        int stabilityCounter = 0;
        int lastInventoryHash = 0;
        int maxMonitoringTicks;
        boolean hasItemsAppeared = false;
        boolean hasGivenInventory = false;
        int scanCounter = 0;
        int consecutiveEmptyScans = 0;

        PlayerMonitorData(ServerPlayer player) {
            this.player = player;
            this.playerName = player.getName().getString();
            this.lastInventoryHash = CustomStartInventory.getAggressiveInventoryHashStatic(player);
            this.maxMonitoringTicks = (Integer)SMART_TIMEOUT_TICKS.get();
            this.consecutiveEmptyScans = CustomStartInventory.countAllItemsAggressiveStatic(player) == 0 ? 1 : 0;
        }
    }

    private static class ItemSnapshot {
        final String itemId;
        final int slot;
        final int count;
        final long timestamp;

        ItemSnapshot(String itemId, int slot, int count) {
            this.itemId = itemId;
            this.slot = slot;
            this.count = count;
            this.timestamp = System.currentTimeMillis();
        }

        public String toString() {
            return this.slot + ":" + this.itemId + "x" + this.count;
        }
    }
}

