/*
 * Decompiled with CFR 0.152.
 */
package net.darkunity.customstartinventory;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.darkunity.customstartinventory.CustomStartInventory;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ServerInventoryManager {
    private static final String CONFIG_FILE_NAME = "starter-kits.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Path configPath;
    private static StarterKit defaultStarterKit;

    public static void init() {
        try {
            Path configDir = Paths.get("config", "customstartinventory");
            configPath = configDir.resolve(CONFIG_FILE_NAME);
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            if (!Files.exists(configPath, new LinkOption[0])) {
                ServerInventoryManager.createExampleConfig();
                System.out.println("[CSI] \u0421\u043e\u0437\u0434\u0430\u043d \u043f\u0443\u0441\u0442\u043e\u0439 \u0444\u0430\u0439\u043b \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 starter-kits.json");
                System.out.println("[CSI] \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b:");
                System.out.println("[CSI]   /csi kit create <name> - \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u0430\u0431\u043e\u0440 \u0438\u0437 \u0432\u0430\u0448\u0435\u0433\u043e \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044f");
                System.out.println("[CSI]   /csi kit <name> - \u0432\u044b\u0434\u0430\u0442\u044c \u043d\u0430\u0431\u043e\u0440 \u0441\u0435\u0431\u0435");
                System.out.println("[CSI]   /csi kit <name> <player> - \u0432\u044b\u0434\u0430\u0442\u044c \u043d\u0430\u0431\u043e\u0440 \u0434\u0440\u0443\u0433\u043e\u043c\u0443 \u0438\u0433\u0440\u043e\u043a\u0443");
                System.out.println("[CSI]   /csi kit list - \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u043d\u0430\u0431\u043e\u0440\u043e\u0432");
            }
            ServerInventoryManager.loadConfig();
        }
        catch (Exception e) {
            System.out.println("[CSI] \u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 ServerInventoryManager: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void createExampleConfig() throws IOException {
        ArrayList<StarterKit> kits = new ArrayList<StarterKit>();
        ServerInventoryManager.saveConfig(kits);
    }

    private static void loadConfig() {
        try {
            if (!Files.exists(configPath, new LinkOption[0])) {
                defaultStarterKit = null;
                return;
            }
            try (FileReader reader = new FileReader(configPath.toFile());){
                List kits = (List)GSON.fromJson((Reader)reader, new TypeToken<List<StarterKit>>(){}.getType());
                if (kits != null) {
                    for (StarterKit kit : kits) {
                        if (!kit.giveOnFirstJoin) continue;
                        defaultStarterKit = kit;
                        System.out.println("[CSI] \u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u043d\u0430\u0431\u043e\u0440 \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0432\u044b\u0434\u0430\u0447\u0438: " + kit.kitName);
                        break;
                    }
                    System.out.println("[CSI] \u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + kits.size() + " \u043d\u0430\u0431\u043e\u0440\u043e\u0432 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432");
                }
            }
        }
        catch (Exception e) {
            System.out.println("[CSI] \u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void saveConfig(List<StarterKit> kits) throws IOException {
        String json = GSON.toJson(kits);
        Files.writeString(configPath, (CharSequence)json, new OpenOption[0]);
    }

    public static List<StarterKit> getAllKits() {
        List list;
        if (!Files.exists(configPath, new LinkOption[0])) {
            return new ArrayList<StarterKit>();
        }
        FileReader reader = new FileReader(configPath.toFile());
        try {
            List kits = (List)GSON.fromJson((Reader)reader, new TypeToken<List<StarterKit>>(){}.getType());
            list = kits != null ? kits : new ArrayList();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                System.out.println("[CSI] \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u043d\u0430\u0431\u043e\u0440\u043e\u0432: " + e.getMessage());
                return new ArrayList<StarterKit>();
            }
        }
        ((Reader)reader).close();
        return list;
    }

    public static StarterKit getKit(String kitName) {
        List<StarterKit> kits = ServerInventoryManager.getAllKits();
        for (StarterKit kit : kits) {
            if (!kit.kitName.equalsIgnoreCase(kitName)) continue;
            return kit;
        }
        return null;
    }

    public static StarterKit getDefaultKit() {
        return defaultStarterKit;
    }

    public static boolean createKitFromInventory(ServerPlayer player, String kitName) {
        try {
            ItemStack stack;
            KitItem item;
            ResourceLocation itemId;
            ItemStack stack2;
            int i;
            List<StarterKit> kits = ServerInventoryManager.getAllKits();
            for (StarterKit kit : kits) {
                if (!kit.kitName.equalsIgnoreCase(kitName)) continue;
                return false;
            }
            StarterKit newKit = new StarterKit(kitName);
            newKit.kitName = kitName;
            newKit.giveOnFirstJoin = false;
            for (i = 0; i < player.getInventory().items.size(); ++i) {
                stack2 = (ItemStack)player.getInventory().items.get(i);
                if (stack2.isEmpty()) continue;
                itemId = BuiltInRegistries.ITEM.getKey((Object)stack2.getItem());
                item = new KitItem(itemId.toString(), i, stack2.getCount());
                newKit.items.add(item);
            }
            for (i = 0; i < player.getInventory().armor.size(); ++i) {
                stack2 = (ItemStack)player.getInventory().armor.get(i);
                if (stack2.isEmpty()) continue;
                itemId = BuiltInRegistries.ITEM.getKey((Object)stack2.getItem());
                item = new KitItem(itemId.toString(), i, stack2.getCount());
                newKit.armor.add(item);
            }
            if (!player.getInventory().offhand.isEmpty() && !(stack = (ItemStack)player.getInventory().offhand.get(0)).isEmpty()) {
                ResourceLocation itemId2 = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                KitItem item2 = new KitItem(itemId2.toString(), 0, stack.getCount());
                newKit.offhand.add(item2);
            }
            kits.add(newKit);
            ServerInventoryManager.saveConfig(kits);
            ServerInventoryManager.loadConfig();
            System.out.println("[CSI] \u0421\u043e\u0437\u0434\u0430\u043d \u043d\u043e\u0432\u044b\u0439 \u043d\u0430\u0431\u043e\u0440: " + kitName + " \u0438\u0437 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044f " + player.getName().getString());
            return true;
        }
        catch (Exception e) {
            System.out.println("[CSI] \u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043d\u0430\u0431\u043e\u0440\u0430: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean removeKit(String kitName) {
        try {
            List<StarterKit> kits = ServerInventoryManager.getAllKits();
            boolean found = false;
            StarterKit kitToRemove = null;
            for (StarterKit kit : kits) {
                if (!kit.kitName.equalsIgnoreCase(kitName)) continue;
                kitToRemove = kit;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            kits.remove(kitToRemove);
            ServerInventoryManager.saveConfig(kits);
            ServerInventoryManager.loadConfig();
            System.out.println("[CSI] \u041d\u0430\u0431\u043e\u0440 \u0443\u0434\u0430\u043b\u0435\u043d: " + kitName);
            return true;
        }
        catch (Exception e) {
            System.out.println("[CSI] \u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u0431\u043e\u0440\u0430: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean removeAllKits() {
        try {
            ArrayList<StarterKit> kits = new ArrayList<StarterKit>();
            ServerInventoryManager.saveConfig(kits);
            ServerInventoryManager.loadConfig();
            System.out.println("[CSI] \u0412\u0441\u0435 \u043d\u0430\u0431\u043e\u0440\u044b \u0443\u0434\u0430\u043b\u0435\u043d\u044b");
            return true;
        }
        catch (Exception e) {
            System.out.println("[CSI] \u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0432\u0441\u0435\u0445 \u043d\u0430\u0431\u043e\u0440\u043e\u0432: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean giveKitToPlayer(ServerPlayer player, String kitName) {
        StarterKit kit = ServerInventoryManager.getKit(kitName);
        if (kit == null) {
            return false;
        }
        System.out.println("[CSI] \u0412\u044b\u0434\u0430\u0447\u0430 \u043d\u0430\u0431\u043e\u0440\u0430 '" + kit.kitName + "' \u0438\u0433\u0440\u043e\u043a\u0443 " + player.getName().getString());
        try {
            for (KitItem kitItem : kit.items) {
                ServerInventoryManager.giveItemToSlot(player, kitItem, false);
            }
            for (KitItem kitItem : kit.armor) {
                ServerInventoryManager.giveItemToSlot(player, kitItem, true);
            }
            for (KitItem kitItem : kit.offhand) {
                ServerInventoryManager.giveOffhandItem(player, kitItem);
            }
            player.inventoryMenu.slotsChanged((Container)player.getInventory());
            System.out.println("[CSI] \u041d\u0430\u0431\u043e\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u044b\u0434\u0430\u043d");
            return true;
        }
        catch (Exception e) {
            System.out.println("[CSI] \u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0434\u0430\u0447\u0438 \u043d\u0430\u0431\u043e\u0440\u0430: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static void giveDefaultKitOnFirstJoin(ServerPlayer player) {
        if (defaultStarterKit != null) {
            System.out.println("[CSI] \u0412\u044b\u0434\u0430\u0447\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0433\u043e \u043d\u0430\u0431\u043e\u0440\u0430 \u043d\u043e\u0432\u043e\u043c\u0443 \u0438\u0433\u0440\u043e\u043a\u0443: " + player.getName().getString());
            ServerInventoryManager.giveKitToPlayer(player, ServerInventoryManager.defaultStarterKit.kitName);
            if (!((Boolean)CustomStartInventory.HIDE_CHAT_MESSAGES.get()).booleanValue()) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7a[CSI] \u00a7f\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0439 \u043d\u0430\u0431\u043e\u0440!"));
            }
        }
    }

    private static void giveItemToSlot(ServerPlayer player, KitItem kitItem, boolean isArmor) {
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)kitItem.itemId);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item == null || item == Items.AIR) {
                System.out.println("[CSI] \u041f\u0440\u0435\u0434\u043c\u0435\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + kitItem.itemId);
                return;
            }
            ItemStack stack = new ItemStack((ItemLike)item, kitItem.count);
            if (isArmor) {
                if (kitItem.slot >= 0 && kitItem.slot < player.getInventory().armor.size()) {
                    player.getInventory().armor.set(kitItem.slot, (Object)stack);
                }
            } else if (kitItem.slot >= 0 && kitItem.slot < player.getInventory().items.size()) {
                player.getInventory().items.set(kitItem.slot, (Object)stack);
            }
        }
        catch (Exception e) {
            System.out.println("[CSI] \u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0434\u0430\u0447\u0438 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430: " + kitItem.itemId + " - " + e.getMessage());
        }
    }

    private static void giveOffhandItem(ServerPlayer player, KitItem kitItem) {
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)kitItem.itemId);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item == null || item == Items.AIR) {
                System.out.println("[CSI] \u041f\u0440\u0435\u0434\u043c\u0435\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + kitItem.itemId);
                return;
            }
            ItemStack stack = new ItemStack((ItemLike)item, kitItem.count);
            if (!player.getInventory().offhand.isEmpty()) {
                player.getInventory().offhand.set(0, (Object)stack);
            }
        }
        catch (Exception e) {
            System.out.println("[CSI] \u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0434\u0430\u0447\u0438 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 \u0432 \u043e\u0444\u0444\u0445\u0435\u043d\u0434: " + kitItem.itemId + " - " + e.getMessage());
        }
    }

    public static void reloadConfig() {
        ServerInventoryManager.loadConfig();
        System.out.println("[CSI] \u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043d\u0430\u0431\u043e\u0440\u043e\u0432 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430");
    }

    public static class StarterKit {
        public String kitName;
        public boolean giveOnFirstJoin;
        public List<KitItem> items = new ArrayList<KitItem>();
        public List<KitItem> armor = new ArrayList<KitItem>();
        public List<KitItem> offhand = new ArrayList<KitItem>();

        public StarterKit() {
        }

        public StarterKit(String name) {
            this();
            this.kitName = name;
            this.giveOnFirstJoin = false;
        }
    }

    public static class KitItem {
        public String itemId;
        public int slot;
        public int count;

        public KitItem() {
        }

        public KitItem(String itemId, int slot, int count) {
            this.itemId = itemId;
            this.slot = slot;
            this.count = count;
        }
    }
}

