/*
 * Decompiled with CFR 0.152.
 */
package net.darkunity.customstartinventory.handlers;

import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class CuriosAccessoriesHandler {
    private static final String CURIOS_API_CLASS = "top.theillusivec4.curios.api.CuriosApi";

    public static boolean hasCurios() {
        try {
            Class.forName(CURIOS_API_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static ListTag saveCurios(ServerPlayer player) {
        ListTag curiosList = new ListTag();
        if (!CuriosAccessoriesHandler.hasCurios()) {
            return curiosList;
        }
        try {
            Class<?> apiClass = Class.forName(CURIOS_API_CLASS);
            Object helper = apiClass.getMethod("getCuriosHelper", new Class[0]).invoke(null, new Object[0]);
            Object optionalHandler = helper.getClass().getMethod("getCuriosHandler", LivingEntity.class).invoke(helper, player);
            Optional opt = (Optional)optionalHandler;
            if (opt.isEmpty()) {
                return curiosList;
            }
            Object handler = opt.get();
            Map curiosMap = (Map)handler.getClass().getMethod("getCurios", new Class[0]).invoke(handler, new Object[0]);
            for (Map.Entry entry : curiosMap.entrySet()) {
                String slotId = (String)entry.getKey();
                Object stacksHandler = entry.getValue();
                Object inventory = stacksHandler.getClass().getMethod("getStacks", new Class[0]).invoke(stacksHandler, new Object[0]);
                int slots = (Integer)inventory.getClass().getMethod("getSlots", new Class[0]).invoke(inventory, new Object[0]);
                for (int i = 0; i < slots; ++i) {
                    ItemStack stack = (ItemStack)inventory.getClass().getMethod("getStackInSlot", Integer.TYPE).invoke(inventory, i);
                    if (stack.isEmpty()) continue;
                    CompoundTag itemEntry = new CompoundTag();
                    itemEntry.putString("SlotId", slotId);
                    itemEntry.putInt("SlotIndex", i);
                    itemEntry.put("Item", stack.save((HolderLookup.Provider)player.registryAccess()));
                    curiosList.add((Object)itemEntry);
                }
            }
        }
        catch (Exception e) {
            System.err.println("[CSI-Curios] Error during save: " + e.getMessage());
        }
        return curiosList;
    }

    public static boolean loadCurios(ServerPlayer player, CompoundTag accessoriesData) {
        if (!CuriosAccessoriesHandler.hasCurios() || !accessoriesData.contains("CuriosList")) {
            return false;
        }
        ListTag list = accessoriesData.getList("CuriosList", 10);
        try {
            Class<?> apiClass = Class.forName(CURIOS_API_CLASS);
            Object helper = apiClass.getMethod("getCuriosHelper", new Class[0]).invoke(null, new Object[0]);
            Object optionalHandler = helper.getClass().getMethod("getCuriosHandler", LivingEntity.class).invoke(helper, player);
            Optional opt = (Optional)optionalHandler;
            if (opt.isEmpty()) {
                return false;
            }
            Object handler = opt.get();
            Map curiosMap = (Map)handler.getClass().getMethod("getCurios", new Class[0]).invoke(handler, new Object[0]);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entryTag = list.getCompound(i);
                String slotId = entryTag.getString("SlotId");
                int index = entryTag.getInt("SlotIndex");
                Optional stackOpt = ItemStack.parse((HolderLookup.Provider)player.registryAccess(), (Tag)entryTag.getCompound("Item"));
                if (!stackOpt.isPresent() || !curiosMap.containsKey(slotId)) continue;
                Object stacksHandler = curiosMap.get(slotId);
                Object inventory = stacksHandler.getClass().getMethod("getStacks", new Class[0]).invoke(stacksHandler, new Object[0]);
                inventory.getClass().getMethod("setStackInSlot", Integer.TYPE, ItemStack.class).invoke(inventory, index, stackOpt.get());
            }
            helper.getClass().getMethod("onInventoryTick", LivingEntity.class).invoke(helper, player);
            return true;
        }
        catch (Exception e) {
            System.err.println("[CSI-Curios] Error during load: " + e.getMessage());
            return false;
        }
    }

    public static void clearAccessories(ServerPlayer player) {
        if (!CuriosAccessoriesHandler.hasCurios()) {
            return;
        }
        try {
            Class<?> apiClass = Class.forName(CURIOS_API_CLASS);
            Object helper = apiClass.getMethod("getCuriosHelper", new Class[0]).invoke(null, new Object[0]);
            Object optionalHandler = helper.getClass().getMethod("getCuriosHandler", LivingEntity.class).invoke(helper, player);
            Optional opt = (Optional)optionalHandler;
            if (opt.isEmpty()) {
                return;
            }
            Object handler = opt.get();
            Map curiosMap = (Map)handler.getClass().getMethod("getCurios", new Class[0]).invoke(handler, new Object[0]);
            for (Object stacksHandler : curiosMap.values()) {
                Object inventory = stacksHandler.getClass().getMethod("getStacks", new Class[0]).invoke(stacksHandler, new Object[0]);
                int slots = (Integer)inventory.getClass().getMethod("getSlots", new Class[0]).invoke(inventory, new Object[0]);
                for (int i = 0; i < slots; ++i) {
                    inventory.getClass().getMethod("setStackInSlot", Integer.TYPE, ItemStack.class).invoke(inventory, i, ItemStack.EMPTY);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

