/*
 * Decompiled with CFR 0.152.
 */
package net.darkunity.customstartinventory.handlers;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class WispForestAccessoriesHandler {
    private static final String ACC_API_CLASS = "io.wispforest.accessories.api.AccessoriesAPI";
    private static final String ACCESSORIES_HOLDER_CLASS = "io.wispforest.accessories.api.AccessoriesHolder";
    private static Boolean apiAvailableCache = null;
    private static Method cachedGetHolderMethod = null;
    private static Class<?> accessoriesHolderClassCache = null;
    private static boolean isEntityMethodCache = false;
    private static ListAccessor cachedListAccessor = null;
    private static final String[] NBT_METHODS_PROVIDER = new String[]{"serializeNBT", "deserializeNBT"};
    private static final String[] NBT_METHODS_NO_PROVIDER = new String[]{"toNbt", "writeNbt", "writeToNbt", "write", "save", "toTag", "serializeNBT", "readNbt", "readFromNbt", "read", "load", "fromTag", "deserializeNBT"};
    private static final String CONTAINER_TAG_KEY = "CSI_Accessories_Fallback_Inventory";

    public static boolean hasAccessories() {
        if (apiAvailableCache == null) {
            try {
                Class.forName(ACC_API_CLASS);
                accessoriesHolderClassCache = Class.forName(ACCESSORIES_HOLDER_CLASS);
                apiAvailableCache = true;
                System.out.println("[WispForestHandler] Accessories API is available");
            }
            catch (ClassNotFoundException e) {
                apiAvailableCache = false;
                System.out.println("[WispForestHandler] Accessories API or Holder class not found");
            }
        }
        return apiAvailableCache;
    }

    private static Optional<Method> findAndCacheGetHolderMethod(ServerPlayer player) {
        if (cachedGetHolderMethod != null) {
            return Optional.of(cachedGetHolderMethod);
        }
        try {
            Class<?> entityClass = player.getClass();
            for (Method method : entityClass.getMethods()) {
                if (method.getParameterTypes().length != 0 || !method.getName().contains("accessories") && !method.getName().contains("Accessories") && !method.getName().contains("Holder") || !Optional.class.isAssignableFrom(method.getReturnType()) && !accessoriesHolderClassCache.isAssignableFrom(method.getReturnType())) continue;
                cachedGetHolderMethod = method;
                isEntityMethodCache = true;
                System.out.println("[WispForestHandler] FOUND INJECTED METHOD: " + method.getName() + "() in LivingEntity.");
                return Optional.of(cachedGetHolderMethod);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static Optional<?> getAccessoryHolder(ServerPlayer player) throws Exception {
        Object[] objectArray;
        ServerPlayer targetInstance;
        if (!WispForestAccessoriesHandler.hasAccessories()) {
            return Optional.empty();
        }
        Optional<Method> methodOpt = WispForestAccessoriesHandler.findAndCacheGetHolderMethod(player);
        if (methodOpt.isEmpty()) {
            System.out.println("[WispForestHandler] ERROR: No valid accessor method found.");
            return Optional.empty();
        }
        Method getHolderMethod = methodOpt.get();
        Object object = targetInstance = isEntityMethodCache ? player : null;
        if (isEntityMethodCache) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = player;
        }
        Object[] args = objectArray;
        System.out.println("[WispForestHandler] Attempting to invoke accessor method: " + getHolderMethod.getName() + "()...");
        try {
            Object result = getHolderMethod.invoke((Object)targetInstance, args);
            if (result != null && accessoriesHolderClassCache.isInstance(result)) {
                System.out.println("[WispForestHandler] SUCCESS: Retrieved holder directly via " + getHolderMethod.getName() + "().");
                return Optional.of(result);
            }
        }
        catch (InvocationTargetException e) {
            System.out.println("[WispForestHandler] FATAL: " + getHolderMethod.getName() + "() FAILED INTERNALLY. Cause: " + e.getCause().getMessage());
            e.getCause().printStackTrace();
        }
        System.out.println("[WispForestHandler] Failed to retrieve accessory holder (returned null or unexpected type).");
        return Optional.empty();
    }

    private static boolean initializeAccessors(Object capability) throws Exception {
        Class<?> containerClassL3;
        if (cachedListAccessor != null) {
            return true;
        }
        Class<?> capabilityClass = capability.getClass();
        Method getContainersMethod = capabilityClass.getDeclaredMethod("getSlotContainers", new Class[0]);
        getContainersMethod.setAccessible(true);
        Map containersMap = (Map)getContainersMethod.invoke(capability, new Object[0]);
        if (containersMap == null || containersMap.isEmpty()) {
            System.out.println("[WispForestHandler] Slot containers map is empty. Cannot proceed with initialization.");
            return false;
        }
        Object firstContainerL2 = containersMap.values().iterator().next();
        Class<?> containerClassL2 = firstContainerL2.getClass();
        Method getAccessoriesMethod = containerClassL2.getDeclaredMethod("getAccessories", new Class[0]);
        getAccessoriesMethod.setAccessible(true);
        Object firstContainerL3 = getAccessoriesMethod.invoke(firstContainerL2, new Object[0]);
        for (Class<?> currentClass = containerClassL3 = firstContainerL3.getClass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (String fieldName : new String[]{"items", "stacks", "list", "inventory"}) {
                try {
                    Field listField = currentClass.getDeclaredField(fieldName);
                    if (!Collection.class.isAssignableFrom(listField.getType())) continue;
                    listField.setAccessible(true);
                    cachedListAccessor = new ListAccessor();
                    WispForestAccessoriesHandler.cachedListAccessor.listAccessor = listField;
                    WispForestAccessoriesHandler.cachedListAccessor.isField = true;
                    System.out.println("[WispForestHandler] FINAL ACCESSOR SUCCESS (Field:" + fieldName + ") found in class hierarchy: " + currentClass.getName());
                    return true;
                }
                catch (NoSuchFieldException listField) {
                    // empty catch block
                }
            }
            for (String methodName : new String[]{"getStacks", "getItems", "getList"}) {
                try {
                    Method listMethod = currentClass.getDeclaredMethod(methodName, new Class[0]);
                    if (!Collection.class.isAssignableFrom(listMethod.getReturnType())) continue;
                    listMethod.setAccessible(true);
                    cachedListAccessor = new ListAccessor();
                    WispForestAccessoriesHandler.cachedListAccessor.listAccessor = listMethod;
                    WispForestAccessoriesHandler.cachedListAccessor.isField = false;
                    System.out.println("[WispForestHandler] FINAL ACCESSOR SUCCESS (Method:" + methodName + ") found in class hierarchy: " + currentClass.getName());
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        System.out.println("[WispForestHandler] Search for internal item list failed. Starting TARGETED DEBUG DUMP on " + containerClassL3.getName() + "...");
        List<String> failedMethods = Arrays.stream(containerClassL3.getDeclaredMethods()).map(m -> "  Method: " + m.getName() + "(" + Arrays.stream(m.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ") -> " + m.getReturnType().getSimpleName()).collect(Collectors.toList());
        List<String> failedFields = Arrays.stream(containerClassL3.getDeclaredFields()).map(f -> "  Field: " + f.getName() + " -> " + f.getType().getSimpleName()).collect(Collectors.toList());
        System.out.println("[WispForestHandler] --- L3 Container Declared Methods (" + failedMethods.size() + ") ---");
        failedMethods.forEach(System.out::println);
        System.out.println("[WispForestHandler] --- L3 Container Declared Fields (" + failedFields.size() + ") ---");
        failedFields.forEach(System.out::println);
        System.out.println("[WispForestHandler] --------------------------");
        System.out.println("[WispForestHandler] FATAL: Failed to find L4 item list accessor in L3 container class: " + containerClassL3.getName());
        return false;
    }

    private static Optional<Collection<ItemStack>> getInternalItemCollectionL4(Object containerL3) throws Exception {
        if (cachedListAccessor == null) {
            return Optional.empty();
        }
        Object accessor = WispForestAccessoriesHandler.cachedListAccessor.listAccessor;
        if (WispForestAccessoriesHandler.cachedListAccessor.isField) {
            Field field = (Field)accessor;
            Object stacksObject = field.get(containerL3);
            if (stacksObject instanceof Collection) {
                return Optional.of((Collection)stacksObject);
            }
        } else {
            Method method = (Method)accessor;
            Object stacksObject = method.invoke(containerL3, new Object[0]);
            if (stacksObject instanceof Collection) {
                return Optional.of((Collection)stacksObject);
            }
        }
        return Optional.empty();
    }

    private static CompoundTag saveAccessoriesFallback(ServerPlayer player, Object capability) {
        try {
            if (!WispForestAccessoriesHandler.initializeAccessors(capability)) {
                System.out.println("[WispForestHandler] Failed to initialize container accessors. Aborting save.");
                return new CompoundTag();
            }
            Method getContainersMethod = capability.getClass().getDeclaredMethod("getSlotContainers", new Class[0]);
            getContainersMethod.setAccessible(true);
            Map containersMap = (Map)getContainersMethod.invoke(capability, new Object[0]);
            Class<?> containerClassL2 = containersMap.values().iterator().next().getClass();
            Method getAccessoriesMethod = containerClassL2.getDeclaredMethod("getAccessories", new Class[0]);
            Method getCosmeticAccessoriesMethod = containerClassL2.getDeclaredMethod("getCosmeticAccessories", new Class[0]);
            getAccessoriesMethod.setAccessible(true);
            getCosmeticAccessoriesMethod.setAccessible(true);
            NonNullList itemsToSave = NonNullList.create();
            for (Object containerL2 : containersMap.values()) {
                Object containerL3_main = getAccessoriesMethod.invoke(containerL2, new Object[0]);
                Optional<Collection<ItemStack>> itemsMain = WispForestAccessoriesHandler.getInternalItemCollectionL4(containerL3_main);
                if (!itemsMain.isPresent()) {
                    System.out.println("[WispForestHandler] Failed to extract main item collection from L3 container. Skipping save.");
                    return new CompoundTag();
                }
                itemsToSave.addAll(itemsMain.get());
                Object containerL3_cosmetic = getCosmeticAccessoriesMethod.invoke(containerL2, new Object[0]);
                Optional<Collection<ItemStack>> itemsCosmetic = WispForestAccessoriesHandler.getInternalItemCollectionL4(containerL3_cosmetic);
                if (itemsCosmetic.isPresent()) {
                    itemsToSave.addAll(itemsCosmetic.get());
                    continue;
                }
                System.out.println("[WispForestHandler] Failed to extract cosmetic item collection from L3 container. Skipping save.");
                return new CompoundTag();
            }
            CompoundTag containerTag = new CompoundTag();
            ContainerHelper.saveAllItems((CompoundTag)containerTag, (NonNullList)itemsToSave, (HolderLookup.Provider)player.registryAccess());
            System.out.println("[WispForestHandler] Saved Accessories using ULTIMATE Fallback (Total Size: " + itemsToSave.size() + ").");
            CompoundTag finalTag = new CompoundTag();
            finalTag.put(CONTAINER_TAG_KEY, (Tag)containerTag);
            return finalTag;
        }
        catch (Exception e) {
            System.out.println("[WispForestHandler] ULTIMATE Fallback Save crashed: " + e.getMessage());
            e.printStackTrace();
            return new CompoundTag();
        }
    }

    private static boolean loadAccessoriesFallback(ServerPlayer player, Object capability, CompoundTag accessoriesTag) {
        try {
            if (!accessoriesTag.contains(CONTAINER_TAG_KEY)) {
                return false;
            }
            if (!WispForestAccessoriesHandler.initializeAccessors(capability)) {
                System.out.println("[WispForestHandler] Failed to initialize container accessors. Aborting load.");
                return false;
            }
            Method getContainersMethod = capability.getClass().getDeclaredMethod("getSlotContainers", new Class[0]);
            getContainersMethod.setAccessible(true);
            Map containersMap = (Map)getContainersMethod.invoke(capability, new Object[0]);
            Class<?> containerClassL2 = containersMap.values().iterator().next().getClass();
            Method getAccessoriesMethod = containerClassL2.getDeclaredMethod("getAccessories", new Class[0]);
            Method getCosmeticAccessoriesMethod = containerClassL2.getDeclaredMethod("getCosmeticAccessories", new Class[0]);
            getAccessoriesMethod.setAccessible(true);
            getCosmeticAccessoriesMethod.setAccessible(true);
            ArrayList<List> internalLists = new ArrayList<List>();
            int totalSize = 0;
            for (Object containerL2 : containersMap.values()) {
                Object containerL3_main = getAccessoriesMethod.invoke(containerL2, new Object[0]);
                Optional<Collection<ItemStack>> itemsMain = WispForestAccessoriesHandler.getInternalItemCollectionL4(containerL3_main);
                if (itemsMain.isPresent() && itemsMain.get() instanceof List) {
                    List list = (List)itemsMain.get();
                    internalLists.add(list);
                    totalSize += list.size();
                } else {
                    System.out.println("[WispForestHandler] Failed to extract main item list L4 or it's not a List. Skipping load.");
                    return false;
                }
                Object containerL3_cosmetic = getCosmeticAccessoriesMethod.invoke(containerL2, new Object[0]);
                Optional<Collection<ItemStack>> itemsCosmetic = WispForestAccessoriesHandler.getInternalItemCollectionL4(containerL3_cosmetic);
                if (itemsCosmetic.isPresent() && itemsCosmetic.get() instanceof List) {
                    List list = (List)itemsCosmetic.get();
                    internalLists.add(list);
                    totalSize += list.size();
                    continue;
                }
                System.out.println("[WispForestHandler] Failed to extract cosmetic item list L4 or it's not a List. Skipping load.");
                return false;
            }
            CompoundTag containerTag = accessoriesTag.getCompound(CONTAINER_TAG_KEY);
            NonNullList loadedItems = NonNullList.withSize((int)totalSize, (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)containerTag, (NonNullList)loadedItems, (HolderLookup.Provider)player.registryAccess());
            int loadedItemIndex = 0;
            for (List internalList : internalLists) {
                for (int i = 0; i < internalList.size(); ++i) {
                    if (loadedItemIndex < loadedItems.size()) {
                        internalList.set(i, (ItemStack)loadedItems.get(loadedItemIndex++));
                        continue;
                    }
                    internalList.set(i, ItemStack.EMPTY);
                }
            }
            System.out.println("[WispForestHandler] Loaded Accessories using ULTIMATE Fallback (Distributed).");
            WispForestAccessoriesHandler.syncAccessories(player, capability);
            return true;
        }
        catch (Exception e) {
            System.out.println("[WispForestHandler] ULTIMATE Fallback Load crashed: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static CompoundTag saveAccessories(ServerPlayer player) {
        if (!WispForestAccessoriesHandler.hasAccessories()) {
            return new CompoundTag();
        }
        try {
            Optional<?> optionalCapability = WispForestAccessoriesHandler.getAccessoryHolder(player);
            if (optionalCapability.isPresent()) {
                Object capability = optionalCapability.get();
                for (String name : NBT_METHODS_PROVIDER) {
                    try {
                        Method serializeMethod = capability.getClass().getDeclaredMethod(name, HolderLookup.Provider.class);
                        serializeMethod.setAccessible(true);
                        CompoundTag tag = (CompoundTag)serializeMethod.invoke(capability, player.registryAccess());
                        System.out.println("[WispForestHandler] Saved Accessories using " + name + "(Provider).");
                        return tag;
                    }
                    catch (NoSuchMethodException serializeMethod) {
                    }
                }
                for (String name : NBT_METHODS_NO_PROVIDER) {
                    try {
                        Method serializeMethod = capability.getClass().getDeclaredMethod(name, new Class[0]);
                        serializeMethod.setAccessible(true);
                        CompoundTag tag = (CompoundTag)serializeMethod.invoke(capability, new Object[0]);
                        System.out.println("[WispForestHandler] Saved Accessories using " + name + "().");
                        return tag;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
                CompoundTag fallbackTag = WispForestAccessoriesHandler.saveAccessoriesFallback(player, capability);
                if (!fallbackTag.isEmpty()) {
                    return fallbackTag;
                }
                System.out.println("[WispForestHandler] Warning: No NBT serialization method found. Accessories not saved.");
            }
        }
        catch (Exception e) {
            System.out.println("[WispForestHandler] Error saving Accessories: " + e.getMessage());
            e.printStackTrace();
        }
        return new CompoundTag();
    }

    public static boolean loadAccessories(ServerPlayer player, CompoundTag accessoriesTag) {
        if (!WispForestAccessoriesHandler.hasAccessories() || accessoriesTag.isEmpty()) {
            return false;
        }
        try {
            Optional<?> optionalCapability = WispForestAccessoriesHandler.getAccessoryHolder(player);
            if (optionalCapability.isPresent()) {
                Object capability = optionalCapability.get();
                for (String name : NBT_METHODS_PROVIDER) {
                    try {
                        Method deserializeMethod = capability.getClass().getDeclaredMethod(name, HolderLookup.Provider.class, CompoundTag.class);
                        deserializeMethod.setAccessible(true);
                        deserializeMethod.invoke(capability, player.registryAccess(), accessoriesTag);
                        System.out.println("[WispForestHandler] Loaded Accessories using " + name + "(Provider, CompoundTag).");
                        WispForestAccessoriesHandler.syncAccessories(player, capability);
                        return true;
                    }
                    catch (NoSuchMethodException deserializeMethod) {
                    }
                }
                for (String name : NBT_METHODS_NO_PROVIDER) {
                    try {
                        Method deserializeMethod = capability.getClass().getDeclaredMethod(name, CompoundTag.class);
                        deserializeMethod.setAccessible(true);
                        deserializeMethod.invoke(capability, accessoriesTag);
                        System.out.println("[WispForestHandler] Loaded Accessories using " + name + "(CompoundTag).");
                        WispForestAccessoriesHandler.syncAccessories(player, capability);
                        return true;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
                if (WispForestAccessoriesHandler.loadAccessoriesFallback(player, capability, accessoriesTag)) {
                    return true;
                }
                System.out.println("[WispForestHandler] Failed to find any deserialization method. Accessories not loaded.");
            }
        }
        catch (Exception e) {
            System.out.println("[WispForestHandler] Error loading Accessories: " + e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    private static void syncAccessories(ServerPlayer player, Object capability) {
        boolean synced = false;
        for (String methodName : new String[]{"sync", "update", "refresh", "markDirty"}) {
            if (synced) break;
            try {
                Method syncMethod = null;
                try {
                    syncMethod = capability.getClass().getMethod(methodName, LivingEntity.class);
                    syncMethod.invoke(capability, player);
                }
                catch (NoSuchMethodException e) {
                    syncMethod = capability.getClass().getMethod(methodName, new Class[0]);
                    syncMethod.invoke(capability, new Object[0]);
                }
                System.out.println("[WispForestHandler] Synced Accessories data via " + methodName + "()");
                synced = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!synced) {
            try {
                Method markChangedMethod = capability.getClass().getDeclaredMethod("markChanged", Boolean.TYPE);
                markChangedMethod.setAccessible(true);
                markChangedMethod.invoke(capability, true);
                System.out.println("[WispForestHandler] Synced Accessories data via markChanged(true) fallback.");
                synced = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (synced || player.containerMenu != null) {
            player.containerMenu.broadcastChanges();
            if (!synced) {
                System.out.println("[WispForestHandler] Synced Accessories data via broadcastChanges().");
            }
        }
        if (!synced) {
            System.out.println("[WispForestHandler] Warning: No sync method found - accessories may not appear immediately");
        }
    }

    public static void clearAccessories(ServerPlayer player) {
        block20: {
            if (!WispForestAccessoriesHandler.hasAccessories()) {
                return;
            }
            try {
                Optional<?> optionalCapability = WispForestAccessoriesHandler.getAccessoryHolder(player);
                if (!optionalCapability.isPresent()) break block20;
                Object capability = optionalCapability.get();
                boolean cleared = false;
                for (String methodName : new String[]{"clear", "clearContent", "empty", "clearInventory"}) {
                    try {
                        Method clearMethod = capability.getClass().getMethod(methodName, new Class[0]);
                        clearMethod.invoke(capability, new Object[0]);
                        System.out.println("[WispForestHandler] Cleared Accessories using " + methodName + "()");
                        cleared = true;
                        break;
                    }
                    catch (NoSuchMethodException clearMethod) {
                    }
                }
                if (!cleared) {
                    try {
                        if (!WispForestAccessoriesHandler.initializeAccessors(capability)) {
                            System.out.println("[WispForestHandler] Failed to initialize container accessors. Aborting clear.");
                            return;
                        }
                        Method getContainersMethod = capability.getClass().getDeclaredMethod("getSlotContainers", new Class[0]);
                        getContainersMethod.setAccessible(true);
                        Map containersMap = (Map)getContainersMethod.invoke(capability, new Object[0]);
                        Class<?> containerClassL2 = containersMap.values().iterator().next().getClass();
                        Method getAccessoriesMethod = containerClassL2.getDeclaredMethod("getAccessories", new Class[0]);
                        Method getCosmeticAccessoriesMethod = containerClassL2.getDeclaredMethod("getCosmeticAccessories", new Class[0]);
                        getAccessoriesMethod.setAccessible(true);
                        getCosmeticAccessoriesMethod.setAccessible(true);
                        int totalCleared = 0;
                        boolean success = true;
                        for (Object containerL2 : containersMap.values()) {
                            int i;
                            List list;
                            Object containerL3_main = getAccessoriesMethod.invoke(containerL2, new Object[0]);
                            Optional<Collection<ItemStack>> itemsMain = WispForestAccessoriesHandler.getInternalItemCollectionL4(containerL3_main);
                            Object containerL3_cosmetic = getCosmeticAccessoriesMethod.invoke(containerL2, new Object[0]);
                            Optional<Collection<ItemStack>> itemsCosmetic = WispForestAccessoriesHandler.getInternalItemCollectionL4(containerL3_cosmetic);
                            if (itemsMain.isPresent() && itemsMain.get() instanceof List) {
                                list = (List)itemsMain.get();
                                for (i = 0; i < list.size(); ++i) {
                                    list.set(i, ItemStack.EMPTY);
                                    ++totalCleared;
                                }
                            } else {
                                success = false;
                                break;
                            }
                            if (itemsCosmetic.isPresent() && itemsCosmetic.get() instanceof List) {
                                list = (List)itemsCosmetic.get();
                                for (i = 0; i < list.size(); ++i) {
                                    list.set(i, ItemStack.EMPTY);
                                    ++totalCleared;
                                }
                                continue;
                            }
                            success = false;
                            break;
                        }
                        if (success) {
                            System.out.println("[WispForestHandler] Cleared " + totalCleared + " accessory slots via ULTIMATE Fallback (Distributed).");
                            cleared = true;
                        } else {
                            System.out.println("[WispForestHandler] Failed to clear item lists (Internal collection is not a List or list not found).");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("[WispForestHandler] ULTIMATE Fallback Clear crashed/failed: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                if (cleared) {
                    WispForestAccessoriesHandler.syncAccessories(player, capability);
                } else {
                    System.out.println("[WispForestHandler] Warning: Accessories not cleared. [FINAL FALLBACK FAILED]");
                }
            }
            catch (Exception e) {
                System.out.println("[CSI] Error clearing Accessories: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static class ListAccessor {
        public Object listAccessor;
        public boolean isField;

        private ListAccessor() {
        }
    }
}

