/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pwmatrix.world.teleporter;

import java.util.Optional;
import java.util.function.Predicate;
import net.mcreator.pwmatrix.init.PwmatrixModBlocks;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2423;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4970;
import net.minecraft.class_5459;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class MatrixDementionPortalShape {
    private static final int MIN_WIDTH = 2;
    public static final int MAX_WIDTH = 21;
    private static final int MIN_HEIGHT = 3;
    public static final int MAX_HEIGHT = 21;
    private static final class_4970.class_4973 FRAME = (blockState, blockGetter, blockPos) -> blockState.method_27852(PwmatrixModBlocks.MATRIX_BLOCK);
    private static final float SAFE_TRAVEL_MAX_ENTITY_XY = 4.0f;
    private static final double SAFE_TRAVEL_MAX_VERTICAL_DELTA = 1.0;
    private final class_2350.class_2351 axis;
    private final class_2350 rightDir;
    private final int numPortalBlocks;
    private final class_2338 bottomLeft;
    private final int height;
    private final int width;

    public MatrixDementionPortalShape(class_2350.class_2351 axis, int i, class_2350 direction, class_2338 blockPos, int j, int k) {
        this.axis = axis;
        this.numPortalBlocks = i;
        this.rightDir = direction;
        this.bottomLeft = blockPos;
        this.width = j;
        this.height = k;
    }

    public static Optional<MatrixDementionPortalShape> findEmptyPortalShape(class_1936 levelAccessor, class_2338 blockPos, class_2350.class_2351 axis) {
        return MatrixDementionPortalShape.findPortalShape(levelAccessor, blockPos, portalShape -> portalShape.isValid() && portalShape.numPortalBlocks == 0, axis);
    }

    public static Optional<MatrixDementionPortalShape> findPortalShape(class_1936 levelAccessor, class_2338 blockPos, Predicate<MatrixDementionPortalShape> predicate, class_2350.class_2351 axis) {
        Optional<MatrixDementionPortalShape> optional = Optional.of(MatrixDementionPortalShape.findAnyShape((class_1922)levelAccessor, blockPos, axis)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        class_2350.class_2351 axis2 = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        return Optional.of(MatrixDementionPortalShape.findAnyShape((class_1922)levelAccessor, blockPos, axis2)).filter(predicate);
    }

    public static MatrixDementionPortalShape findAnyShape(class_1922 blockGetter, class_2338 blockPos, class_2350.class_2351 axis) {
        class_2350 direction = axis == class_2350.class_2351.field_11048 ? class_2350.field_11039 : class_2350.field_11035;
        class_2338 blockPos2 = MatrixDementionPortalShape.calculateBottomLeft(blockGetter, direction, blockPos);
        if (blockPos2 == null) {
            return new MatrixDementionPortalShape(axis, 0, direction, blockPos, 0, 0);
        }
        int i = MatrixDementionPortalShape.calculateWidth(blockGetter, blockPos2, direction);
        if (i == 0) {
            return new MatrixDementionPortalShape(axis, 0, direction, blockPos2, 0, 0);
        }
        MutableInt mutableInt = new MutableInt();
        int j = MatrixDementionPortalShape.calculateHeight(blockGetter, blockPos2, direction, i, mutableInt);
        return new MatrixDementionPortalShape(axis, mutableInt.getValue(), direction, blockPos2, i, j);
    }

    @Nullable
    private static class_2338 calculateBottomLeft(class_1922 blockGetter, class_2350 direction, class_2338 blockPos) {
        int i = Math.max(blockGetter.method_31607(), blockPos.method_10264() - 21);
        while (blockPos.method_10264() > i && MatrixDementionPortalShape.isEmpty(blockGetter.method_8320(blockPos.method_10074()))) {
            blockPos = blockPos.method_10074();
        }
        class_2350 direction2 = direction.method_10153();
        int j = MatrixDementionPortalShape.getDistanceUntilEdgeAboveFrame(blockGetter, blockPos, direction2) - 1;
        if (j < 0) {
            return null;
        }
        return blockPos.method_10079(direction2, j);
    }

    private static int calculateWidth(class_1922 blockGetter, class_2338 blockPos, class_2350 direction) {
        int i = MatrixDementionPortalShape.getDistanceUntilEdgeAboveFrame(blockGetter, blockPos, direction);
        if (i < 2 || i > 21) {
            return 0;
        }
        return i;
    }

    private static int getDistanceUntilEdgeAboveFrame(class_1922 blockGetter, class_2338 blockPos, class_2350 direction) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int i = 0; i <= 21; ++i) {
            mutableBlockPos.method_10101((class_2382)blockPos).method_10104(direction, i);
            class_2680 blockState = blockGetter.method_8320((class_2338)mutableBlockPos);
            if (!MatrixDementionPortalShape.isEmpty(blockState)) {
                if (!FRAME.test(blockState, blockGetter, (class_2338)mutableBlockPos)) break;
                return i;
            }
            class_2680 blockState2 = blockGetter.method_8320((class_2338)mutableBlockPos.method_10098(class_2350.field_11033));
            if (!FRAME.test(blockState2, blockGetter, (class_2338)mutableBlockPos)) break;
        }
        return 0;
    }

    private static int calculateHeight(class_1922 blockGetter, class_2338 blockPos, class_2350 direction, int i, MutableInt mutableInt) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int j = MatrixDementionPortalShape.getDistanceUntilTop(blockGetter, blockPos, direction, mutableBlockPos, i, mutableInt);
        if (j < 3 || j > 21 || !MatrixDementionPortalShape.hasTopFrame(blockGetter, blockPos, direction, mutableBlockPos, i, j)) {
            return 0;
        }
        return j;
    }

    private static boolean hasTopFrame(class_1922 blockGetter, class_2338 blockPos, class_2350 direction, class_2338.class_2339 mutableBlockPos, int i, int j) {
        for (int k = 0; k < i; ++k) {
            class_2338.class_2339 mutableBlockPos2 = mutableBlockPos.method_10101((class_2382)blockPos).method_10104(class_2350.field_11036, j).method_10104(direction, k);
            if (FRAME.test(blockGetter.method_8320((class_2338)mutableBlockPos2), blockGetter, (class_2338)mutableBlockPos2)) continue;
            return false;
        }
        return true;
    }

    private static int getDistanceUntilTop(class_1922 blockGetter, class_2338 blockPos, class_2350 direction, class_2338.class_2339 mutableBlockPos, int i, MutableInt mutableInt) {
        for (int j = 0; j < 21; ++j) {
            mutableBlockPos.method_10101((class_2382)blockPos).method_10104(class_2350.field_11036, j).method_10104(direction, -1);
            if (!FRAME.test(blockGetter.method_8320((class_2338)mutableBlockPos), blockGetter, (class_2338)mutableBlockPos)) {
                return j;
            }
            mutableBlockPos.method_10101((class_2382)blockPos).method_10104(class_2350.field_11036, j).method_10104(direction, i);
            if (!FRAME.test(blockGetter.method_8320((class_2338)mutableBlockPos), blockGetter, (class_2338)mutableBlockPos)) {
                return j;
            }
            for (int k = 0; k < i; ++k) {
                mutableBlockPos.method_10101((class_2382)blockPos).method_10104(class_2350.field_11036, j).method_10104(direction, k);
                class_2680 blockState = blockGetter.method_8320((class_2338)mutableBlockPos);
                if (!MatrixDementionPortalShape.isEmpty(blockState)) {
                    return j;
                }
                if (!blockState.method_27852(PwmatrixModBlocks.MATRIX_DEMENTION_PORTAL)) continue;
                mutableInt.increment();
            }
        }
        return 21;
    }

    private static boolean isEmpty(class_2680 blockState) {
        return blockState.method_26215() || blockState.method_26164(class_3481.field_21952) || blockState.method_27852(PwmatrixModBlocks.MATRIX_DEMENTION_PORTAL);
    }

    public boolean isValid() {
        return this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void createPortalBlocks(class_1936 levelAccessor) {
        class_2680 blockState = (class_2680)PwmatrixModBlocks.MATRIX_DEMENTION_PORTAL.method_9564().method_11657((class_2769)class_2423.field_11310, (Comparable)this.axis);
        class_2338.method_10097((class_2338)this.bottomLeft, (class_2338)this.bottomLeft.method_10079(class_2350.field_11036, this.height - 1).method_10079(this.rightDir, this.width - 1)).forEach(blockPos -> levelAccessor.method_8652(blockPos, blockState, 18));
    }

    public boolean isComplete() {
        return this.isValid() && this.numPortalBlocks == this.width * this.height;
    }

    public static class_243 getRelativePosition(class_5459.class_5460 foundRectangle, class_2350.class_2351 axis, class_243 vec3, class_4048 entityDimensions) {
        class_2350.class_2351 axis2;
        double g;
        double f;
        double d = (double)foundRectangle.field_25937 - (double)entityDimensions.comp_2185();
        double e = (double)foundRectangle.field_25938 - (double)entityDimensions.comp_2186();
        class_2338 blockPos = foundRectangle.field_25936;
        if (d > 0.0) {
            f = (double)blockPos.method_30558(axis) + (double)entityDimensions.comp_2185() / 2.0;
            g = class_3532.method_15350((double)class_3532.method_15370((double)(vec3.method_18043(axis) - f), (double)0.0, (double)d), (double)0.0, (double)1.0);
        } else {
            g = 0.5;
        }
        if (e > 0.0) {
            axis2 = class_2350.class_2351.field_11052;
            f = class_3532.method_15350((double)class_3532.method_15370((double)(vec3.method_18043(axis2) - (double)blockPos.method_30558(axis2)), (double)0.0, (double)e), (double)0.0, (double)1.0);
        } else {
            f = 0.0;
        }
        axis2 = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        double h = vec3.method_18043(axis2) - ((double)blockPos.method_30558(axis2) + 0.5);
        return new class_243(g, f, h);
    }

    public static class_243 findCollisionFreePosition(class_243 vec32, class_3218 serverLevel, class_1297 entity, class_4048 entityDimensions) {
        if (entityDimensions.comp_2185() > 4.0f || entityDimensions.comp_2186() > 4.0f) {
            return vec32;
        }
        double d = (double)entityDimensions.comp_2186() / 2.0;
        class_243 vec322 = vec32.method_1031(0.0, d, 0.0);
        class_265 voxelShape = class_259.method_1078((class_238)class_238.method_30048((class_243)vec322, (double)entityDimensions.comp_2185(), (double)0.0, (double)entityDimensions.comp_2185()).method_1012(0.0, 1.0, 0.0).method_1014(1.0E-6));
        Optional optional = serverLevel.method_33594(entity, voxelShape, vec322, (double)entityDimensions.comp_2185(), (double)entityDimensions.comp_2186(), (double)entityDimensions.comp_2185());
        Optional<class_243> optional2 = optional.map(vec3 -> vec3.method_1023(0.0, d, 0.0));
        return optional2.orElse(vec32);
    }
}

