/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.winter_comforts.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.wanmine.winter_comforts.datagen.WinComBlockStateProvider;
import net.wanmine.winter_comforts.datagen.WinComBlockTagGenerator;
import net.wanmine.winter_comforts.datagen.WinComItemModelProvider;
import net.wanmine.winter_comforts.datagen.WinComItemTagGenerator;
import net.wanmine.winter_comforts.datagen.WinComLootTableProvider;
import net.wanmine.winter_comforts.datagen.WinComRecipeProvider;
import net.wanmine.winter_comforts.datagen.WinComWorldGenProvider;

@Mod.EventBusSubscriber(modid="winter_comforts", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WinComDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new WinComRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)WinComLootTableProvider.create(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new WinComBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new WinComItemModelProvider(packOutput, existingFileHelper));
        WinComBlockTagGenerator blockTagGenerator = (WinComBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new WinComBlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new WinComItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new WinComWorldGenProvider(packOutput, lookupProvider));
    }
}

