/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.winter_comforts.world.registry;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.wanmine.winter_comforts.block.custom.BlackTeaCrop;
import net.wanmine.winter_comforts.block.custom.CardamomCrop;
import net.wanmine.winter_comforts.block.custom.CloveCrop;
import net.wanmine.winter_comforts.block.custom.CookieDoughBlock;
import net.wanmine.winter_comforts.block.custom.GingerCrop;
import net.wanmine.winter_comforts.block.custom.GreenTeaCrop;
import net.wanmine.winter_comforts.block.custom.NutmegLeavesBlock;
import net.wanmine.winter_comforts.block.custom.OrangeLeavesBlock;
import net.wanmine.winter_comforts.block.custom.StarAniseCrop;
import net.wanmine.winter_comforts.block.custom.WhitePineLeavesBlock;
import net.wanmine.winter_comforts.block.custom.WinComFlammableRotatedPillarBlock;
import net.wanmine.winter_comforts.world.registry.WinComItems;
import net.wanmine.winter_comforts.worldgen.tree.CinnamonTreeGrower;
import net.wanmine.winter_comforts.worldgen.tree.NutmegTreeGrower;
import net.wanmine.winter_comforts.worldgen.tree.OrangeTreeGrower;
import net.wanmine.winter_comforts.worldgen.tree.WhitePineTreeGrower;

public class WinComBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"winter_comforts");
    public static final RegistryObject<Block> COOKIE_DOUGH_BLOCK = WinComBlocks.registerBlock("cookie_dough_block", () -> new CookieDoughBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60918_(SoundType.f_222471_)));
    public static final RegistryObject<Block> ORANGE_LOG = WinComBlocks.registerBlock("orange_log", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_)));
    public static final RegistryObject<Block> ORANGE_WOOD = WinComBlocks.registerBlock("orange_wood", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)));
    public static final RegistryObject<Block> STRIPPED_ORANGE_LOG = WinComBlocks.registerBlock("stripped_orange_log", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_)));
    public static final RegistryObject<Block> STRIPPED_ORANGE_WOOD = WinComBlocks.registerBlock("stripped_orange_wood", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50044_)));
    public static final RegistryObject<Block> ORANGE_PLANKS = WinComBlocks.registerBlock("orange_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final RegistryObject<Block> ORANGE_LEAVES = WinComBlocks.registerBlock("orange_leaves", () -> new OrangeLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }
    });
    public static final RegistryObject<Block> ORANGE_STAIRS = WinComBlocks.registerBlock("orange_stairs", () -> new StairBlock(() -> ((Block)ORANGE_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50086_)));
    public static final RegistryObject<Block> ORANGE_SLAB = WinComBlocks.registerBlock("orange_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)));
    public static final RegistryObject<Block> ORANGE_FENCE = WinComBlocks.registerBlock("orange_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_)));
    public static final RegistryObject<Block> ORANGE_FENCE_GATE = WinComBlocks.registerBlock("orange_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50192_), SoundEvents.f_11873_, SoundEvents.f_11872_));
    public static final RegistryObject<Block> ORANGE_DOOR = WinComBlocks.registerBlock("orange_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_), BlockSetType.f_271198_));
    public static final RegistryObject<Block> ORANGE_TRAPDOOR = WinComBlocks.registerBlock("orange_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_), BlockSetType.f_271198_));
    public static final RegistryObject<Block> ORANGE_PRESSURE_PLATE = WinComBlocks.registerBlock("orange_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_), BlockSetType.f_271198_));
    public static final RegistryObject<Block> ORANGE_BUTTON = WinComBlocks.registerBlock("orange_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_), BlockSetType.f_271198_, 20, true));
    public static final RegistryObject<Block> ORANGE_SAPLING = WinComBlocks.registerBlock("orange_sapling", () -> new SaplingBlock((AbstractTreeGrower)new OrangeTreeGrower(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)));
    public static final RegistryObject<Block> WHITE_PINE_LOG = WinComBlocks.registerBlock("white_pine_log", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_)));
    public static final RegistryObject<Block> WHITE_PINE_WOOD = WinComBlocks.registerBlock("white_pine_wood", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)));
    public static final RegistryObject<Block> STRIPPED_WHITE_PINE_LOG = WinComBlocks.registerBlock("stripped_white_pine_log", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_)));
    public static final RegistryObject<Block> STRIPPED_WHITE_PINE_WOOD = WinComBlocks.registerBlock("stripped_white_pine_wood", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50044_)));
    public static final RegistryObject<Block> WHITE_PINE_PLANKS = WinComBlocks.registerBlock("white_pine_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final RegistryObject<Block> WHITE_PINE_LEAVES = WinComBlocks.registerBlock("white_pine_leaves", () -> new WhitePineLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }
    });
    public static final RegistryObject<Block> WHITE_PINE_STAIRS = WinComBlocks.registerBlock("white_pine_stairs", () -> new StairBlock(() -> ((Block)ORANGE_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50086_)));
    public static final RegistryObject<Block> WHITE_PINE_SLAB = WinComBlocks.registerBlock("white_pine_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)));
    public static final RegistryObject<Block> WHITE_PINE_FENCE = WinComBlocks.registerBlock("white_pine_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_)));
    public static final RegistryObject<Block> WHITE_PINE_FENCE_GATE = WinComBlocks.registerBlock("white_pine_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50192_), SoundEvents.f_11873_, SoundEvents.f_11872_));
    public static final RegistryObject<Block> WHITE_PINE_DOOR = WinComBlocks.registerBlock("white_pine_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_), BlockSetType.f_271198_));
    public static final RegistryObject<Block> WHITE_PINE_TRAPDOOR = WinComBlocks.registerBlock("white_pine_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_), BlockSetType.f_271198_));
    public static final RegistryObject<Block> WHITE_PINE_PRESSURE_PLATE = WinComBlocks.registerBlock("white_pine_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_), BlockSetType.f_271198_));
    public static final RegistryObject<Block> WHITE_PINE_BUTTON = WinComBlocks.registerBlock("white_pine_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_), BlockSetType.f_271198_, 20, true));
    public static final RegistryObject<Block> WHITE_PINE_SAPLING = WinComBlocks.registerBlock("white_pine_sapling", () -> new SaplingBlock((AbstractTreeGrower)new WhitePineTreeGrower(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)));
    public static final RegistryObject<Block> CINNAMON_LOG = WinComBlocks.registerBlock("cinnamon_log", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_)));
    public static final RegistryObject<Block> CINNAMON_WOOD = WinComBlocks.registerBlock("cinnamon_wood", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)));
    public static final RegistryObject<Block> STRIPPED_CINNAMON_LOG = WinComBlocks.registerBlock("stripped_cinnamon_log", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_)));
    public static final RegistryObject<Block> STRIPPED_CINNAMON_WOOD = WinComBlocks.registerBlock("stripped_cinnamon_wood", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50044_)));
    public static final RegistryObject<Block> CINNAMON_PLANKS = WinComBlocks.registerBlock("cinnamon_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final RegistryObject<Block> CINNAMON_LEAVES = WinComBlocks.registerBlock("cinnamon_leaves", () -> new WhitePineLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }
    });
    public static final RegistryObject<Block> CINNAMON_STAIRS = WinComBlocks.registerBlock("cinnamon_stairs", () -> new StairBlock(() -> ((Block)ORANGE_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50086_)));
    public static final RegistryObject<Block> CINNAMON_SLAB = WinComBlocks.registerBlock("cinnamon_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)));
    public static final RegistryObject<Block> CINNAMON_FENCE = WinComBlocks.registerBlock("cinnamon_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_)));
    public static final RegistryObject<Block> CINNAMON_FENCE_GATE = WinComBlocks.registerBlock("cinnamon_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50192_), SoundEvents.f_11873_, SoundEvents.f_11872_));
    public static final RegistryObject<Block> CINNAMON_DOOR = WinComBlocks.registerBlock("cinnamon_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_), BlockSetType.f_271198_));
    public static final RegistryObject<Block> CINNAMON_TRAPDOOR = WinComBlocks.registerBlock("cinnamon_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_), BlockSetType.f_271198_));
    public static final RegistryObject<Block> CINNAMON_PRESSURE_PLATE = WinComBlocks.registerBlock("cinnamon_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_), BlockSetType.f_271198_));
    public static final RegistryObject<Block> CINNAMON_BUTTON = WinComBlocks.registerBlock("cinnamon_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_), BlockSetType.f_271198_, 20, true));
    public static final RegistryObject<Block> CINNAMON_SAPLING = WinComBlocks.registerBlock("cinnamon_sapling", () -> new SaplingBlock((AbstractTreeGrower)new CinnamonTreeGrower(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)));
    public static final RegistryObject<Block> NUTMEG_LOG = WinComBlocks.registerBlock("nutmeg_log", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_)));
    public static final RegistryObject<Block> NUTMEG_WOOD = WinComBlocks.registerBlock("nutmeg_wood", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)));
    public static final RegistryObject<Block> STRIPPED_NUTMEG_LOG = WinComBlocks.registerBlock("stripped_nutmeg_log", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_)));
    public static final RegistryObject<Block> STRIPPED_NUTMEG_WOOD = WinComBlocks.registerBlock("stripped_nutmeg_wood", () -> new WinComFlammableRotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50044_)));
    public static final RegistryObject<Block> NUTMEG_PLANKS = WinComBlocks.registerBlock("nutmeg_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final RegistryObject<Block> NUTMEG_LEAVES = WinComBlocks.registerBlock("nutmeg_leaves", () -> new NutmegLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }
    });
    public static final RegistryObject<Block> NUTMEG_STAIRS = WinComBlocks.registerBlock("nutmeg_stairs", () -> new StairBlock(() -> ((Block)ORANGE_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50086_)));
    public static final RegistryObject<Block> NUTMEG_SLAB = WinComBlocks.registerBlock("nutmeg_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)));
    public static final RegistryObject<Block> NUTMEG_FENCE = WinComBlocks.registerBlock("nutmeg_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_)));
    public static final RegistryObject<Block> NUTMEG_FENCE_GATE = WinComBlocks.registerBlock("nutmeg_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50192_), SoundEvents.f_11873_, SoundEvents.f_11872_));
    public static final RegistryObject<Block> NUTMEG_DOOR = WinComBlocks.registerBlock("nutmeg_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_), BlockSetType.f_271198_));
    public static final RegistryObject<Block> NUTMEG_TRAPDOOR = WinComBlocks.registerBlock("nutmeg_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_), BlockSetType.f_271198_));
    public static final RegistryObject<Block> NUTMEG_PRESSURE_PLATE = WinComBlocks.registerBlock("nutmeg_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_), BlockSetType.f_271198_));
    public static final RegistryObject<Block> NUTMEG_BUTTON = WinComBlocks.registerBlock("nutmeg_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_), BlockSetType.f_271198_, 20, true));
    public static final RegistryObject<Block> NUTMEG_SAPLING = WinComBlocks.registerBlock("nutmeg_sapling", () -> new SaplingBlock((AbstractTreeGrower)new NutmegTreeGrower(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)));
    public static final RegistryObject<Block> GINGER_CROP = BLOCKS.register("ginger_crop", () -> new GingerCrop(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60955_().m_60910_()));
    public static final RegistryObject<Block> STAR_ANISE_CROP = BLOCKS.register("star_anise_crop", () -> new StarAniseCrop(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60955_().m_60910_()));
    public static final RegistryObject<Block> CLOVE_CROP = BLOCKS.register("clove_crop", () -> new CloveCrop(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60955_().m_60910_()));
    public static final RegistryObject<Block> GREEN_TEA_CROP = BLOCKS.register("green_tea_crop", () -> new GreenTeaCrop(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60955_().m_60910_()));
    public static final RegistryObject<Block> BLACK_TEA_CROP = BLOCKS.register("black_tea_crop", () -> new BlackTeaCrop(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60955_().m_60910_()));
    public static final RegistryObject<Block> CARDAMOM_CROP = BLOCKS.register("cardamom_crop", () -> new CardamomCrop(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60955_().m_60910_()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        WinComBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return WinComItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

