/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.block;

import de.sarocesch.plushie.block.PlushieBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class PlushieBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)13.0, (double)12.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)11.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)5.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)11.0, (double)13.0, (double)12.0);

    public PlushieBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && player.m_6144_() && (blockEntity = level.m_7702_(pos)) instanceof PlushieBlockEntity) {
            PlushieBlockEntity plushieEntity = (PlushieBlockEntity)blockEntity;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)plushieEntity, (BlockPos)pos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PlushieBlockEntity(pos, state);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof PlushieBlockEntity) {
                PlushieBlockEntity plushieEntity = (PlushieBlockEntity)blockEntity;
                ItemStack mainHand = plushieEntity.getMainHandItem();
                ItemStack offHand = plushieEntity.getOffHandItem();
                if (!mainHand.m_41619_()) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)mainHand);
                }
                if (!offHand.m_41619_()) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)offHand);
                }
            }
            super.m_6810_(state, level, pos, newState, movedByPiston);
        }
    }
}

