/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.block;

import de.sarocesch.plushie.block.PlushiePose;
import de.sarocesch.plushie.menu.PlushieMenu;
import de.sarocesch.plushie.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PlushieBlockEntity
extends BlockEntity
implements MenuProvider {
    private String playerName = "";
    private boolean showNameTag = false;
    private boolean showHeart = false;
    private boolean isHighRes = true;
    private boolean showSkinLayers = true;
    private boolean slimArms = false;
    private String skinUrl = "";
    private String heartText = "";
    private PlushiePose pose = new PlushiePose();
    private ItemStack mainHandItem = ItemStack.f_41583_;
    private ItemStack offHandItem = ItemStack.f_41583_;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float offsetZ = 0.0f;
    private float baseRotation = 0.0f;
    private float mainHandItemOffsetX = 0.07f;
    private float mainHandItemOffsetY = -0.25f;
    private float mainHandItemOffsetZ = -0.13f;
    private float mainHandItemRotX = -120.0f;
    private float mainHandItemRotY = 54.0f;
    private float mainHandItemRotZ = 0.0f;
    private float offHandItemOffsetX = -0.07f;
    private float offHandItemOffsetY = -0.25f;
    private float offHandItemOffsetZ = -0.13f;
    private float offHandItemRotX = -120.0f;
    private float offHandItemRotY = -54.0f;
    private float offHandItemRotZ = 0.0f;
    private transient SkinLoadingStatus skinLoadingStatus = SkinLoadingStatus.NONE;
    private transient long statusSetTime = 0L;
    private static final long STATUS_DISPLAY_DURATION = 3000L;

    public PlushieBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PLUSHIE.get(), pos, state);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public boolean isShowNameTag() {
        return this.showNameTag;
    }

    public boolean isShowHeart() {
        return this.showHeart;
    }

    public boolean isHighRes() {
        return this.isHighRes;
    }

    public String getSkinUrl() {
        return this.skinUrl;
    }

    public PlushiePose getPose() {
        return this.pose;
    }

    public boolean isShowSkinLayers() {
        return this.showSkinLayers;
    }

    public boolean isSlimArms() {
        return this.slimArms;
    }

    public String getHeartText() {
        return this.heartText;
    }

    public ItemStack getMainHandItem() {
        return this.mainHandItem;
    }

    public ItemStack getOffHandItem() {
        return this.offHandItem;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getOffsetZ() {
        return this.offsetZ;
    }

    public float getBaseRotation() {
        return this.baseRotation;
    }

    public float getMainHandItemOffsetX() {
        return this.mainHandItemOffsetX;
    }

    public float getMainHandItemOffsetY() {
        return this.mainHandItemOffsetY;
    }

    public float getMainHandItemOffsetZ() {
        return this.mainHandItemOffsetZ;
    }

    public float getMainHandItemRotX() {
        return this.mainHandItemRotX;
    }

    public float getMainHandItemRotY() {
        return this.mainHandItemRotY;
    }

    public float getMainHandItemRotZ() {
        return this.mainHandItemRotZ;
    }

    public float getOffHandItemOffsetX() {
        return this.offHandItemOffsetX;
    }

    public float getOffHandItemOffsetY() {
        return this.offHandItemOffsetY;
    }

    public float getOffHandItemOffsetZ() {
        return this.offHandItemOffsetZ;
    }

    public float getOffHandItemRotX() {
        return this.offHandItemRotX;
    }

    public float getOffHandItemRotY() {
        return this.offHandItemRotY;
    }

    public float getOffHandItemRotZ() {
        return this.offHandItemRotZ;
    }

    public SkinLoadingStatus getSkinLoadingStatus() {
        if ((this.skinLoadingStatus == SkinLoadingStatus.SUCCESS || this.skinLoadingStatus == SkinLoadingStatus.FAILED) && System.currentTimeMillis() - this.statusSetTime > 3000L) {
            this.skinLoadingStatus = SkinLoadingStatus.NONE;
        }
        return this.skinLoadingStatus;
    }

    public void setSkinLoadingStatus(SkinLoadingStatus status) {
        this.skinLoadingStatus = status;
        this.statusSetTime = System.currentTimeMillis();
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName != null ? playerName : "";
        this.m_6596_();
        this.syncToClient();
    }

    public void setShowNameTag(boolean showNameTag) {
        this.showNameTag = showNameTag;
        this.m_6596_();
        this.syncToClient();
    }

    public void setShowHeart(boolean showHeart) {
        this.showHeart = showHeart;
        this.m_6596_();
        this.syncToClient();
    }

    public void setHighRes(boolean isHighRes) {
        this.isHighRes = isHighRes;
        this.m_6596_();
        this.syncToClient();
    }

    public void setSkinUrl(String skinUrl) {
        this.skinUrl = skinUrl != null ? skinUrl : "";
        this.m_6596_();
        this.syncToClient();
    }

    public void setPose(PlushiePose pose) {
        this.pose = pose != null ? new PlushiePose(pose) : new PlushiePose();
        this.m_6596_();
        this.syncToClient();
    }

    public void setShowSkinLayers(boolean showSkinLayers) {
        this.showSkinLayers = showSkinLayers;
        this.m_6596_();
        this.syncToClient();
    }

    public void setSlimArms(boolean slimArms) {
        this.slimArms = slimArms;
        this.m_6596_();
        this.syncToClient();
    }

    public void setHeartText(String heartText) {
        this.heartText = heartText != null ? heartText : "";
        this.m_6596_();
        this.syncToClient();
    }

    public void setMainHandItem(ItemStack item) {
        this.mainHandItem = item != null ? item : ItemStack.f_41583_;
        this.m_6596_();
        this.syncToClient();
    }

    public void setOffHandItem(ItemStack item) {
        this.offHandItem = item != null ? item : ItemStack.f_41583_;
        this.m_6596_();
        this.syncToClient();
    }

    public void setOffsetX(float offsetX) {
        this.offsetX = offsetX;
        this.m_6596_();
        this.syncToClient();
    }

    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
        this.m_6596_();
        this.syncToClient();
    }

    public void setOffsetZ(float offsetZ) {
        this.offsetZ = offsetZ;
        this.m_6596_();
        this.syncToClient();
    }

    public void setBaseRotation(float baseRotation) {
        this.baseRotation = baseRotation;
        this.m_6596_();
        this.syncToClient();
    }

    public void setPosition(float offsetX, float offsetY, float offsetZ, float baseRotation) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.baseRotation = baseRotation;
        this.m_6596_();
        this.syncToClient();
    }

    public void setMainHandItemPosition(float offX, float offY, float offZ, float rotX, float rotY, float rotZ) {
        this.mainHandItemOffsetX = offX;
        this.mainHandItemOffsetY = offY;
        this.mainHandItemOffsetZ = offZ;
        this.mainHandItemRotX = rotX;
        this.mainHandItemRotY = rotY;
        this.mainHandItemRotZ = rotZ;
        this.m_6596_();
        this.syncToClient();
    }

    public void setOffHandItemPosition(float offX, float offY, float offZ, float rotX, float rotY, float rotZ) {
        this.offHandItemOffsetX = offX;
        this.offHandItemOffsetY = offY;
        this.offHandItemOffsetZ = offZ;
        this.offHandItemRotX = rotX;
        this.offHandItemRotY = rotY;
        this.offHandItemRotZ = rotZ;
        this.m_6596_();
        this.syncToClient();
    }

    public void updateAll(String playerName, boolean showNameTag, boolean showHeart, boolean isHighRes) {
        this.playerName = playerName != null ? playerName : "";
        this.showNameTag = showNameTag;
        this.showHeart = showHeart;
        this.isHighRes = isHighRes;
        this.m_6596_();
        this.syncToClient();
    }

    private void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("PlayerName", this.playerName);
        tag.m_128379_("ShowNameTag", this.showNameTag);
        tag.m_128379_("ShowHeart", this.showHeart);
        tag.m_128379_("IsHighRes", this.isHighRes);
        tag.m_128379_("ShowSkinLayers", this.showSkinLayers);
        tag.m_128379_("SlimArms", this.slimArms);
        tag.m_128359_("SkinUrl", this.skinUrl);
        tag.m_128359_("HeartText", this.heartText);
        CompoundTag poseTag = new CompoundTag();
        this.pose.saveToNBT(poseTag);
        tag.m_128365_("Pose", (Tag)poseTag);
        tag.m_128350_("OffsetX", this.offsetX);
        tag.m_128350_("OffsetY", this.offsetY);
        tag.m_128350_("OffsetZ", this.offsetZ);
        tag.m_128350_("BaseRotation", this.baseRotation);
        tag.m_128365_("MainHandItem", (Tag)this.mainHandItem.m_41739_(new CompoundTag()));
        tag.m_128365_("OffHandItem", (Tag)this.offHandItem.m_41739_(new CompoundTag()));
        tag.m_128350_("MainHandItemOffsetX", this.mainHandItemOffsetX);
        tag.m_128350_("MainHandItemOffsetY", this.mainHandItemOffsetY);
        tag.m_128350_("MainHandItemOffsetZ", this.mainHandItemOffsetZ);
        tag.m_128350_("MainHandItemRotX", this.mainHandItemRotX);
        tag.m_128350_("MainHandItemRotY", this.mainHandItemRotY);
        tag.m_128350_("MainHandItemRotZ", this.mainHandItemRotZ);
        tag.m_128350_("OffHandItemOffsetX", this.offHandItemOffsetX);
        tag.m_128350_("OffHandItemOffsetY", this.offHandItemOffsetY);
        tag.m_128350_("OffHandItemOffsetZ", this.offHandItemOffsetZ);
        tag.m_128350_("OffHandItemRotX", this.offHandItemRotX);
        tag.m_128350_("OffHandItemRotY", this.offHandItemRotY);
        tag.m_128350_("OffHandItemRotZ", this.offHandItemRotZ);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.playerName = tag.m_128461_("PlayerName");
        this.showNameTag = tag.m_128471_("ShowNameTag");
        this.showHeart = tag.m_128471_("ShowHeart");
        this.isHighRes = tag.m_128441_("IsHighRes") ? tag.m_128471_("IsHighRes") : true;
        this.showSkinLayers = tag.m_128441_("ShowSkinLayers") ? tag.m_128471_("ShowSkinLayers") : true;
        this.slimArms = tag.m_128471_("SlimArms");
        this.skinUrl = tag.m_128461_("SkinUrl");
        this.heartText = tag.m_128461_("HeartText");
        if (tag.m_128441_("Pose")) {
            this.pose.loadFromNBT(tag.m_128469_("Pose"));
        } else {
            this.pose.reset();
        }
        this.offsetX = tag.m_128457_("OffsetX");
        this.offsetY = tag.m_128457_("OffsetY");
        this.offsetZ = tag.m_128457_("OffsetZ");
        this.baseRotation = tag.m_128457_("BaseRotation");
        this.mainHandItem = tag.m_128441_("MainHandItem") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("MainHandItem")) : ItemStack.f_41583_;
        this.offHandItem = tag.m_128441_("OffHandItem") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("OffHandItem")) : ItemStack.f_41583_;
        this.mainHandItemOffsetX = tag.m_128441_("MainHandItemOffsetX") ? tag.m_128457_("MainHandItemOffsetX") : 0.07f;
        this.mainHandItemOffsetY = tag.m_128441_("MainHandItemOffsetY") ? tag.m_128457_("MainHandItemOffsetY") : -0.25f;
        this.mainHandItemOffsetZ = tag.m_128441_("MainHandItemOffsetZ") ? tag.m_128457_("MainHandItemOffsetZ") : -0.13f;
        this.mainHandItemRotX = tag.m_128441_("MainHandItemRotX") ? tag.m_128457_("MainHandItemRotX") : -120.0f;
        this.mainHandItemRotY = tag.m_128441_("MainHandItemRotY") ? tag.m_128457_("MainHandItemRotY") : 54.0f;
        this.mainHandItemRotZ = tag.m_128441_("MainHandItemRotZ") ? tag.m_128457_("MainHandItemRotZ") : 0.0f;
        this.offHandItemOffsetX = tag.m_128441_("OffHandItemOffsetX") ? tag.m_128457_("OffHandItemOffsetX") : -0.07f;
        this.offHandItemOffsetY = tag.m_128441_("OffHandItemOffsetY") ? tag.m_128457_("OffHandItemOffsetY") : -0.25f;
        this.offHandItemOffsetZ = tag.m_128441_("OffHandItemOffsetZ") ? tag.m_128457_("OffHandItemOffsetZ") : -0.13f;
        this.offHandItemRotX = tag.m_128441_("OffHandItemRotX") ? tag.m_128457_("OffHandItemRotX") : -120.0f;
        this.offHandItemRotY = tag.m_128441_("OffHandItemRotY") ? tag.m_128457_("OffHandItemRotY") : -54.0f;
        this.offHandItemRotZ = tag.m_128441_("OffHandItemRotZ") ? tag.m_128457_("OffHandItemRotZ") : 0.0f;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.sarosplayerplushiemod.plushie");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new PlushieMenu(containerId, playerInventory, this);
    }

    public static enum SkinLoadingStatus {
        NONE,
        LOADING,
        SUCCESS,
        FAILED;

    }
}

