/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.block;

import net.minecraft.nbt.CompoundTag;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PlushiePose {
    private Vector3f headRotation = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f bodyRotation = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f leftArmRotation = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f rightArmRotation = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f leftLegRotation = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f rightLegRotation = new Vector3f(0.0f, 0.0f, 0.0f);

    public PlushiePose() {
    }

    public PlushiePose(PlushiePose other) {
        this.headRotation = new Vector3f((Vector3fc)other.headRotation);
        this.bodyRotation = new Vector3f((Vector3fc)other.bodyRotation);
        this.leftArmRotation = new Vector3f((Vector3fc)other.leftArmRotation);
        this.rightArmRotation = new Vector3f((Vector3fc)other.rightArmRotation);
        this.leftLegRotation = new Vector3f((Vector3fc)other.leftLegRotation);
        this.rightLegRotation = new Vector3f((Vector3fc)other.rightLegRotation);
    }

    public Vector3f getHeadRotation() {
        return this.headRotation;
    }

    public Vector3f getBodyRotation() {
        return this.bodyRotation;
    }

    public Vector3f getLeftArmRotation() {
        return this.leftArmRotation;
    }

    public Vector3f getRightArmRotation() {
        return this.rightArmRotation;
    }

    public Vector3f getLeftLegRotation() {
        return this.leftLegRotation;
    }

    public Vector3f getRightLegRotation() {
        return this.rightLegRotation;
    }

    public void setHeadRotation(float x, float y, float z) {
        this.headRotation.set(x, y, z);
    }

    public void setBodyRotation(float x, float y, float z) {
        this.bodyRotation.set(x, y, z);
    }

    public void setLeftArmRotation(float x, float y, float z) {
        this.leftArmRotation.set(x, y, z);
    }

    public void setRightArmRotation(float x, float y, float z) {
        this.rightArmRotation.set(x, y, z);
    }

    public void setLeftLegRotation(float x, float y, float z) {
        this.leftLegRotation.set(x, y, z);
    }

    public void setRightLegRotation(float x, float y, float z) {
        this.rightLegRotation.set(x, y, z);
    }

    public void saveToNBT(CompoundTag tag) {
        this.saveVector("Head", this.headRotation, tag);
        this.saveVector("Body", this.bodyRotation, tag);
        this.saveVector("LeftArm", this.leftArmRotation, tag);
        this.saveVector("RightArm", this.rightArmRotation, tag);
        this.saveVector("LeftLeg", this.leftLegRotation, tag);
        this.saveVector("RightLeg", this.rightLegRotation, tag);
    }

    public void loadFromNBT(CompoundTag tag) {
        this.headRotation = this.loadVector("Head", tag);
        this.bodyRotation = this.loadVector("Body", tag);
        this.leftArmRotation = this.loadVector("LeftArm", tag);
        this.rightArmRotation = this.loadVector("RightArm", tag);
        this.leftLegRotation = this.loadVector("LeftLeg", tag);
        this.rightLegRotation = this.loadVector("RightLeg", tag);
    }

    private void saveVector(String name, Vector3f vec, CompoundTag tag) {
        tag.m_128350_(name + "X", vec.x);
        tag.m_128350_(name + "Y", vec.y);
        tag.m_128350_(name + "Z", vec.z);
    }

    private Vector3f loadVector(String name, CompoundTag tag) {
        float x = tag.m_128457_(name + "X");
        float y = tag.m_128457_(name + "Y");
        float z = tag.m_128457_(name + "Z");
        return new Vector3f(x, y, z);
    }

    public void reset() {
        this.headRotation.set(0.0f, 0.0f, 0.0f);
        this.bodyRotation.set(0.0f, 0.0f, 0.0f);
        this.leftArmRotation.set(0.0f, 0.0f, 0.0f);
        this.rightArmRotation.set(0.0f, 0.0f, 0.0f);
        this.leftLegRotation.set(0.0f, 0.0f, 0.0f);
        this.rightLegRotation.set(0.0f, 0.0f, 0.0f);
    }

    public void copyFrom(PlushiePose other) {
        this.headRotation.set((Vector3fc)other.headRotation);
        this.bodyRotation.set((Vector3fc)other.bodyRotation);
        this.leftArmRotation.set((Vector3fc)other.leftArmRotation);
        this.rightArmRotation.set((Vector3fc)other.rightArmRotation);
        this.leftLegRotation.set((Vector3fc)other.leftLegRotation);
        this.rightLegRotation.set((Vector3fc)other.rightLegRotation);
    }
}

