/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;

public class SkinCacheManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CACHE_FOLDER = "data/sarosplushiemod/skins";

    private static Path getCacheDir() {
        IntegratedServer server = Minecraft.m_91087_().m_91092_();
        if (server != null) {
            return server.m_129843_(LevelResource.f_78182_).resolve(CACHE_FOLDER);
        }
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection != null) {
            String serverName = connection.m_104910_().m_129523_().toString().replaceAll("[^a-zA-Z0-9.-]", "_");
            return Minecraft.m_91087_().f_91069_.toPath().resolve("plushie_cache").resolve(serverName);
        }
        return Minecraft.m_91087_().f_91069_.toPath().resolve("plushie_cache/default");
    }

    private static Path getSkinPath(String playerName) {
        return SkinCacheManager.getCacheDir().resolve(playerName.toLowerCase() + ".png");
    }

    public static boolean isSkinCached(String playerName) {
        if (playerName == null || playerName.isEmpty()) {
            return false;
        }
        return Files.exists(SkinCacheManager.getSkinPath(playerName), new LinkOption[0]);
    }

    public static NativeImage loadCachedSkin(String playerName) {
        NativeImage nativeImage;
        block10: {
            if (playerName == null || playerName.isEmpty()) {
                return null;
            }
            Path skinPath = SkinCacheManager.getSkinPath(playerName);
            if (!Files.exists(skinPath, new LinkOption[0])) {
                return null;
            }
            InputStream is = Files.newInputStream(skinPath, new OpenOption[0]);
            try {
                LOGGER.debug("Loading cached skin for {} from disk", (Object)playerName);
                nativeImage = NativeImage.m_85058_((InputStream)is);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to load cached skin for {}: {}", (Object)playerName, (Object)e.getMessage());
                    return null;
                }
            }
            is.close();
        }
        return nativeImage;
    }

    public static void saveSkinToCache(String playerName, NativeImage image) {
        if (playerName == null || playerName.isEmpty() || image == null) {
            return;
        }
        Path skinPath = SkinCacheManager.getSkinPath(playerName);
        try {
            Files.createDirectories(skinPath.getParent(), new FileAttribute[0]);
            int width = image.m_84982_();
            int height = image.m_85084_();
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = image.m_84985_(x, y);
                    int a = pixel >> 24 & 0xFF;
                    int b = pixel >> 16 & 0xFF;
                    int g = pixel >> 8 & 0xFF;
                    int r = pixel & 0xFF;
                    bufferedImage.setRGB(x, y, a << 24 | r << 16 | g << 8 | b);
                }
            }
            try (OutputStream os = Files.newOutputStream(skinPath, new OpenOption[0]);){
                ImageIO.write((RenderedImage)bufferedImage, "PNG", os);
                LOGGER.debug("Saved skin for {} to disk cache", (Object)playerName);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to save skin for {} to cache: {}", (Object)playerName, (Object)e.getMessage());
        }
    }

    public static void deleteCachedSkin(String playerName) {
        if (playerName == null || playerName.isEmpty()) {
            return;
        }
        Path skinPath = SkinCacheManager.getSkinPath(playerName);
        try {
            if (Files.deleteIfExists(skinPath)) {
                LOGGER.debug("Deleted cached skin for {}", (Object)playerName);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete cached skin for {}: {}", (Object)playerName, (Object)e.getMessage());
        }
    }

    public static void clearAllCache() {
        Path cacheDir = SkinCacheManager.getCacheDir();
        if (!Files.exists(cacheDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> files = Files.list(cacheDir);){
            files.filter(p -> p.toString().endsWith(".png")).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to delete cached file: {}", p);
                }
            });
            LOGGER.info("Cleared skin cache");
        }
        catch (IOException e) {
            LOGGER.warn("Failed to clear skin cache: {}", (Object)e.getMessage());
        }
    }
}

