/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.client.gui;

import de.sarocesch.plushie.block.PlushieBlockEntity;
import de.sarocesch.plushie.client.gui.components.ModernButton;
import de.sarocesch.plushie.client.gui.components.ModernSlider;
import de.sarocesch.plushie.network.ItemPositionPacket;
import de.sarocesch.plushie.network.ModNetworking;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class PlushieItemPositionScreen
extends Screen {
    private final PlushieBlockEntity blockEntity;
    private final BlockPos blockPos;
    private final Screen parentScreen;
    private final float[] originalMainHand = new float[6];
    private final float[] originalOffHand = new float[6];
    private final List<ItemSlider> mainHandSliders = new ArrayList<ItemSlider>();
    private final List<ItemSlider> offHandSliders = new ArrayList<ItemSlider>();

    public PlushieItemPositionScreen(PlushieBlockEntity blockEntity, Screen parentScreen) {
        super((Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.item_position"));
        this.blockEntity = blockEntity;
        this.blockPos = blockEntity.m_58899_();
        this.parentScreen = parentScreen;
        this.originalMainHand[0] = blockEntity.getMainHandItemOffsetX();
        this.originalMainHand[1] = blockEntity.getMainHandItemOffsetY();
        this.originalMainHand[2] = blockEntity.getMainHandItemOffsetZ();
        this.originalMainHand[3] = blockEntity.getMainHandItemRotX();
        this.originalMainHand[4] = blockEntity.getMainHandItemRotY();
        this.originalMainHand[5] = blockEntity.getMainHandItemRotZ();
        this.originalOffHand[0] = blockEntity.getOffHandItemOffsetX();
        this.originalOffHand[1] = blockEntity.getOffHandItemOffsetY();
        this.originalOffHand[2] = blockEntity.getOffHandItemOffsetZ();
        this.originalOffHand[3] = blockEntity.getOffHandItemRotX();
        this.originalOffHand[4] = blockEntity.getOffHandItemRotY();
        this.originalOffHand[5] = blockEntity.getOffHandItemRotZ();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.mainHandSliders.clear();
        this.offHandSliders.clear();
        int sliderWidth = 150;
        int sliderHeight = 16;
        int spacing = 22;
        int startY = 35;
        int leftX = 20;
        this.offHandSliders.add(this.addSlider(leftX, startY, sliderWidth, sliderHeight, this.blockEntity.getOffHandItemOffsetX(), -0.5, 0.5, "X", this::updateOffHand));
        this.offHandSliders.add(this.addSlider(leftX, startY + spacing, sliderWidth, sliderHeight, this.blockEntity.getOffHandItemOffsetY(), -0.5, 0.5, "Y", this::updateOffHand));
        this.offHandSliders.add(this.addSlider(leftX, startY + spacing * 2, sliderWidth, sliderHeight, this.blockEntity.getOffHandItemOffsetZ(), -0.5, 0.5, "Z", this::updateOffHand));
        this.offHandSliders.add(this.addSlider(leftX, startY + spacing * 3, sliderWidth, sliderHeight, this.blockEntity.getOffHandItemRotX(), -180.0, 180.0, "\u00b0X", this::updateOffHand));
        this.offHandSliders.add(this.addSlider(leftX, startY + spacing * 4, sliderWidth, sliderHeight, this.blockEntity.getOffHandItemRotY(), -180.0, 180.0, "\u00b0Y", this::updateOffHand));
        this.offHandSliders.add(this.addSlider(leftX, startY + spacing * 5, sliderWidth, sliderHeight, this.blockEntity.getOffHandItemRotZ(), -180.0, 180.0, "\u00b0Z", this::updateOffHand));
        int rightX = this.f_96543_ - 170;
        this.mainHandSliders.add(this.addSlider(rightX, startY, sliderWidth, sliderHeight, this.blockEntity.getMainHandItemOffsetX(), -0.5, 0.5, "X", this::updateMainHand));
        this.mainHandSliders.add(this.addSlider(rightX, startY + spacing, sliderWidth, sliderHeight, this.blockEntity.getMainHandItemOffsetY(), -0.5, 0.5, "Y", this::updateMainHand));
        this.mainHandSliders.add(this.addSlider(rightX, startY + spacing * 2, sliderWidth, sliderHeight, this.blockEntity.getMainHandItemOffsetZ(), -0.5, 0.5, "Z", this::updateMainHand));
        this.mainHandSliders.add(this.addSlider(rightX, startY + spacing * 3, sliderWidth, sliderHeight, this.blockEntity.getMainHandItemRotX(), -180.0, 180.0, "\u00b0X", this::updateMainHand));
        this.mainHandSliders.add(this.addSlider(rightX, startY + spacing * 4, sliderWidth, sliderHeight, this.blockEntity.getMainHandItemRotY(), -180.0, 180.0, "\u00b0Y", this::updateMainHand));
        this.mainHandSliders.add(this.addSlider(rightX, startY + spacing * 5, sliderWidth, sliderHeight, this.blockEntity.getMainHandItemRotZ(), -180.0, 180.0, "\u00b0Z", this::updateMainHand));
        int buttonY = this.f_96544_ - 30;
        int buttonWidth = 50;
        int totalButtonWidth = buttonWidth * 3 + 10;
        int buttonStartX = (this.f_96543_ - totalButtonWidth) / 2;
        this.m_142416_((GuiEventListener)new ModernButton(buttonStartX, buttonY, buttonWidth, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.reset"), button -> this.resetPositions()));
        this.m_142416_((GuiEventListener)new ModernButton(buttonStartX + buttonWidth + 5, buttonY, buttonWidth, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.apply"), button -> this.applyAndClose()));
        this.m_142416_((GuiEventListener)new ModernButton(buttonStartX + buttonWidth * 2 + 10, buttonY, buttonWidth, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.cancel"), button -> this.cancelAndClose()));
    }

    private ItemSlider addSlider(int x, int y, int w, int h, double val, double min, double max, String suffix, Runnable onChange) {
        ItemSlider slider = new ItemSlider(x, y, w, h, val, min, max, suffix, onChange);
        this.m_142416_((GuiEventListener)slider);
        return slider;
    }

    private void updateMainHand() {
        this.blockEntity.setMainHandItemPosition((float)this.mainHandSliders.get(0).getValue(), (float)this.mainHandSliders.get(1).getValue(), (float)this.mainHandSliders.get(2).getValue(), (float)this.mainHandSliders.get(3).getValue(), (float)this.mainHandSliders.get(4).getValue(), (float)this.mainHandSliders.get(5).getValue());
    }

    private void updateOffHand() {
        this.blockEntity.setOffHandItemPosition((float)this.offHandSliders.get(0).getValue(), (float)this.offHandSliders.get(1).getValue(), (float)this.offHandSliders.get(2).getValue(), (float)this.offHandSliders.get(3).getValue(), (float)this.offHandSliders.get(4).getValue(), (float)this.offHandSliders.get(5).getValue());
    }

    private void resetPositions() {
        this.blockEntity.setMainHandItemPosition(0.07f, -0.25f, -0.13f, -120.0f, 54.0f, 0.0f);
        this.blockEntity.setOffHandItemPosition(-0.07f, -0.25f, -0.13f, -120.0f, -54.0f, 0.0f);
        this.m_232761_();
    }

    private void applyAndClose() {
        ModNetworking.CHANNEL.sendToServer((Object)new ItemPositionPacket(this.blockPos, this.blockEntity.getMainHandItemOffsetX(), this.blockEntity.getMainHandItemOffsetY(), this.blockEntity.getMainHandItemOffsetZ(), this.blockEntity.getMainHandItemRotX(), this.blockEntity.getMainHandItemRotY(), this.blockEntity.getMainHandItemRotZ(), this.blockEntity.getOffHandItemOffsetX(), this.blockEntity.getOffHandItemOffsetY(), this.blockEntity.getOffHandItemOffsetZ(), this.blockEntity.getOffHandItemRotX(), this.blockEntity.getOffHandItemRotY(), this.blockEntity.getOffHandItemRotZ()));
        Minecraft.m_91087_().m_91152_(this.parentScreen);
    }

    private void cancelAndClose() {
        this.blockEntity.setMainHandItemPosition(this.originalMainHand[0], this.originalMainHand[1], this.originalMainHand[2], this.originalMainHand[3], this.originalMainHand[4], this.originalMainHand[5]);
        this.blockEntity.setOffHandItemPosition(this.originalOffHand[0], this.originalOffHand[1], this.originalOffHand[2], this.originalOffHand[3], this.originalOffHand[4], this.originalOffHand[5]);
        Minecraft.m_91087_().m_91152_(this.parentScreen);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int sidebarWidth = 180;
        graphics.m_280024_(0, 0, sidebarWidth, this.f_96544_, -232907228, -233696747);
        graphics.m_280509_(sidebarWidth - 1, 0, sidebarWidth, this.f_96544_, -11908516);
        int rightSidebarX = this.f_96543_ - sidebarWidth;
        graphics.m_280024_(rightSidebarX, 0, this.f_96543_, this.f_96544_, -232907228, -233696747);
        graphics.m_280509_(rightSidebarX, 0, rightSidebarX + 1, this.f_96544_, -11908516);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        int leftX = 20;
        int rightX = this.f_96543_ - 170;
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.left_hand_item"), leftX, 22, 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.right_hand_item"), rightX, 22, 0xFFFFFF, false);
    }

    public boolean m_7043_() {
        return false;
    }

    static class ItemSlider
    extends ModernSlider {
        private final double minValue;
        private final double maxValue;
        private final String suffix;
        private final Runnable onChange;

        public ItemSlider(int x, int y, int w, int h, double val, double min, double max, String suffix, Runnable onChange) {
            super(x, y, w, h, (Component)Component.m_237119_(), (val - min) / (max - min));
            this.minValue = min;
            this.maxValue = max;
            this.suffix = suffix;
            this.onChange = onChange;
            this.m_5695_();
        }

        public double getValue() {
            return Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue);
        }

        protected void m_5695_() {
            String formatted = String.format("%.2f%s", this.getValue(), this.suffix);
            this.m_93666_((Component)Component.m_237113_((String)formatted));
        }

        protected void m_5697_() {
            if (this.onChange != null) {
                this.onChange.run();
            }
        }
    }
}

