/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.client.gui;

import de.sarocesch.plushie.block.PlushieBlockEntity;
import de.sarocesch.plushie.block.PlushiePose;
import de.sarocesch.plushie.client.gui.PoseLoadScreen;
import de.sarocesch.plushie.client.gui.PoseSavePopup;
import de.sarocesch.plushie.client.gui.components.ModernButton;
import de.sarocesch.plushie.client.gui.components.ModernSlider;
import de.sarocesch.plushie.network.ModNetworking;
import de.sarocesch.plushie.network.PlushiePosePacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class PlushiePoseScreen
extends Screen {
    private final PlushieBlockEntity blockEntity;
    private final BlockPos blockPos;
    private final PlushiePose pose;
    private final PlushiePose originalPose;
    private final Screen parentScreen;
    private final List<RotationSlider> sliders = new ArrayList<RotationSlider>();

    public PlushiePoseScreen(PlushieBlockEntity blockEntity, Screen parentScreen) {
        super((Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.pose_editor"));
        this.blockEntity = blockEntity;
        this.blockPos = blockEntity.m_58899_();
        this.pose = blockEntity.getPose();
        this.originalPose = new PlushiePose(blockEntity.getPose());
        this.parentScreen = parentScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.sliders.clear();
        int sliderWidth = 100;
        int sliderHeight = 14;
        int spacing = 16;
        int leftX = 10;
        int startY = 40;
        this.addLabel("Head", leftX, startY - 12);
        this.sliders.add(this.addSlider(leftX, startY, sliderWidth, sliderHeight, "X", this.pose.getHeadRotation().x));
        this.sliders.add(this.addSlider(leftX, startY + spacing, sliderWidth, sliderHeight, "Y", this.pose.getHeadRotation().y));
        this.sliders.add(this.addSlider(leftX, startY + spacing * 2, sliderWidth, sliderHeight, "Z", this.pose.getHeadRotation().z));
        int bodyY = startY + spacing * 4;
        this.addLabel("Body", leftX, bodyY - 12);
        this.sliders.add(this.addSlider(leftX, bodyY, sliderWidth, sliderHeight, "X", this.pose.getBodyRotation().x));
        this.sliders.add(this.addSlider(leftX, bodyY + spacing, sliderWidth, sliderHeight, "Y", this.pose.getBodyRotation().y));
        this.sliders.add(this.addSlider(leftX, bodyY + spacing * 2, sliderWidth, sliderHeight, "Z", this.pose.getBodyRotation().z));
        int lArmY = bodyY + spacing * 4;
        this.addLabel("L.Arm", leftX, lArmY - 12);
        this.sliders.add(this.addSlider(leftX, lArmY, sliderWidth, sliderHeight, "X", this.pose.getLeftArmRotation().x));
        this.sliders.add(this.addSlider(leftX, lArmY + spacing, sliderWidth, sliderHeight, "Y", this.pose.getLeftArmRotation().y));
        this.sliders.add(this.addSlider(leftX, lArmY + spacing * 2, sliderWidth, sliderHeight, "Z", this.pose.getLeftArmRotation().z));
        int rightX = this.f_96543_ - sliderWidth - 10;
        this.addLabel("R.Arm", rightX, startY - 12);
        this.sliders.add(this.addSlider(rightX, startY, sliderWidth, sliderHeight, "X", this.pose.getRightArmRotation().x));
        this.sliders.add(this.addSlider(rightX, startY + spacing, sliderWidth, sliderHeight, "Y", this.pose.getRightArmRotation().y));
        this.sliders.add(this.addSlider(rightX, startY + spacing * 2, sliderWidth, sliderHeight, "Z", this.pose.getRightArmRotation().z));
        int lLegY = startY + spacing * 4;
        this.addLabel("L.Leg", rightX, lLegY - 12);
        this.sliders.add(this.addSlider(rightX, lLegY, sliderWidth, sliderHeight, "X", this.pose.getLeftLegRotation().x));
        this.sliders.add(this.addSlider(rightX, lLegY + spacing, sliderWidth, sliderHeight, "Y", this.pose.getLeftLegRotation().y));
        this.sliders.add(this.addSlider(rightX, lLegY + spacing * 2, sliderWidth, sliderHeight, "Z", this.pose.getLeftLegRotation().z));
        int rLegY = lLegY + spacing * 4;
        this.addLabel("R.Leg", rightX, rLegY - 12);
        this.sliders.add(this.addSlider(rightX, rLegY, sliderWidth, sliderHeight, "X", this.pose.getRightLegRotation().x));
        this.sliders.add(this.addSlider(rightX, rLegY + spacing, sliderWidth, sliderHeight, "Y", this.pose.getRightLegRotation().y));
        this.sliders.add(this.addSlider(rightX, rLegY + spacing * 2, sliderWidth, sliderHeight, "Z", this.pose.getRightLegRotation().z));
        int buttonY = this.f_96544_ - 30;
        int buttonWidth = 60;
        this.m_142416_((GuiEventListener)new ModernButton(this.f_96543_ / 2 - buttonWidth - 35, buttonY, buttonWidth, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.apply"), button -> this.applyAndClose()));
        this.m_142416_((GuiEventListener)new ModernButton(this.f_96543_ / 2 - buttonWidth / 2, buttonY, buttonWidth, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.reset"), button -> this.resetPose()));
        this.m_142416_((GuiEventListener)new ModernButton(this.f_96543_ / 2 + buttonWidth / 2 + 10, buttonY, 30, 20, (Component)Component.m_237113_((String)"X"), button -> this.cancelAndClose()));
        this.m_142416_((GuiEventListener)new ModernButton(leftX, buttonY, sliderWidth, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.save_pose"), button -> this.openSavePopup()));
        this.m_142416_((GuiEventListener)new ModernButton(rightX, buttonY, sliderWidth, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.load_pose"), button -> this.openLoadScreen()));
    }

    private void addLabel(String text, int x, int y) {
    }

    private RotationSlider addSlider(int x, int y, int width, int height, String axis, float initialValue) {
        RotationSlider slider = new RotationSlider(x, y, width, height, axis, initialValue, this::onSliderChanged);
        this.m_142416_((GuiEventListener)slider);
        return slider;
    }

    private void onSliderChanged() {
        this.updatePoseFromSliders();
    }

    private void applyAndClose() {
        this.updatePoseFromSliders();
        ModNetworking.CHANNEL.sendToServer((Object)new PlushiePosePacket(this.blockPos, this.pose));
        this.m_7379_();
    }

    private void cancelAndClose() {
        this.pose.copyFrom(this.originalPose);
        this.m_7379_();
    }

    private void updatePoseFromSliders() {
        if (this.sliders.size() >= 18) {
            this.pose.setHeadRotation(this.sliders.get(0).getRotationValue(), this.sliders.get(1).getRotationValue(), this.sliders.get(2).getRotationValue());
            this.pose.setBodyRotation(this.sliders.get(3).getRotationValue(), this.sliders.get(4).getRotationValue(), this.sliders.get(5).getRotationValue());
            this.pose.setLeftArmRotation(this.sliders.get(6).getRotationValue(), this.sliders.get(7).getRotationValue(), this.sliders.get(8).getRotationValue());
            this.pose.setRightArmRotation(this.sliders.get(9).getRotationValue(), this.sliders.get(10).getRotationValue(), this.sliders.get(11).getRotationValue());
            this.pose.setLeftLegRotation(this.sliders.get(12).getRotationValue(), this.sliders.get(13).getRotationValue(), this.sliders.get(14).getRotationValue());
            this.pose.setRightLegRotation(this.sliders.get(15).getRotationValue(), this.sliders.get(16).getRotationValue(), this.sliders.get(17).getRotationValue());
        }
    }

    private void resetPose() {
        this.pose.reset();
        this.m_169413_();
        this.m_7856_();
    }

    private void openSavePopup() {
        this.updatePoseFromSliders();
        Minecraft.m_91087_().m_91152_((Screen)new PoseSavePopup(this, this.pose, null));
    }

    private void openLoadScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new PoseLoadScreen(this, this::applyLoadedPose));
    }

    private void applyLoadedPose(PlushiePose loadedPose) {
        this.pose.copyFrom(loadedPose);
        this.m_169413_();
        this.m_7856_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int leftPanelWidth = 120;
        graphics.m_280024_(0, 0, leftPanelWidth, this.f_96544_, -233696747, -232907228);
        graphics.m_280509_(leftPanelWidth - 1, 0, leftPanelWidth, this.f_96544_, -11908516);
        int rightPanelWidth = 120;
        int rightPanelX = this.f_96543_ - rightPanelWidth;
        graphics.m_280024_(rightPanelX, 0, this.f_96543_, this.f_96544_, -232907228, -233696747);
        graphics.m_280509_(rightPanelX, 0, rightPanelX + 1, this.f_96544_, -11908516);
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_) + 20;
        int folderX = (this.f_96543_ - titleWidth) / 2;
        graphics.m_280024_(folderX, 0, folderX + titleWidth, 24, -232907228, 1973796);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        int leftX = 10;
        int rightX = this.f_96543_ - 110;
        int startY = 40;
        int spacing = 16;
        int greenGroup = 0xAAFFAA;
        int redGroup = 0xFFAAAA;
        int blueGroup = 0xAAAAFF;
        graphics.m_280056_(this.f_96547_, "Head", leftX, startY - 12, greenGroup, false);
        graphics.m_280056_(this.f_96547_, "Body", leftX, startY + spacing * 4 - 12, greenGroup, false);
        graphics.m_280056_(this.f_96547_, "L.Arm", leftX, startY + spacing * 8 - 12, greenGroup, false);
        graphics.m_280056_(this.f_96547_, "R.Arm", rightX, startY - 12, redGroup, false);
        graphics.m_280056_(this.f_96547_, "L.Leg", rightX, startY + spacing * 4 - 12, blueGroup, false);
        graphics.m_280056_(this.f_96547_, "R.Leg", rightX, startY + spacing * 8 - 12, blueGroup, false);
        int dockWidth = 220;
        int dockHeight = 40;
        int dockX = (this.f_96543_ - dockWidth) / 2;
        int dockY = this.f_96544_ - dockHeight;
        graphics.m_280024_(dockX, dockY, dockX + dockWidth, this.f_96544_, 1973796, -232907228);
        graphics.m_280509_(dockX, dockY, dockX + dockWidth, dockY + 1, 0x40FFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_280273_(GuiGraphics graphics) {
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    public boolean m_7043_() {
        return false;
    }

    private static class RotationSlider
    extends ModernSlider {
        private static final float MIN_VALUE = -180.0f;
        private static final float MAX_VALUE = 180.0f;
        private final String axis;
        private final Runnable onChangeCallback;

        public RotationSlider(int x, int y, int width, int height, String axis, float initialValue, Runnable onChangeCallback) {
            super(x, y, width, height, (Component)Component.m_237113_((String)(axis + ": " + String.format("%.0f", Float.valueOf(initialValue)) + "\u00b0")), (initialValue - -180.0f) / 360.0f);
            this.axis = axis;
            this.onChangeCallback = onChangeCallback;
        }

        protected void m_5695_() {
            float val = this.getRotationValue();
            this.m_93666_((Component)Component.m_237113_((String)(this.axis + ": " + String.format("%.0f", Float.valueOf(val)) + "\u00b0")));
        }

        protected void m_5697_() {
            if (this.onChangeCallback != null) {
                this.onChangeCallback.run();
            }
        }

        public float getRotationValue() {
            return (float)(-180.0 + 360.0 * this.f_93577_);
        }
    }
}

