/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.client.gui;

import de.sarocesch.plushie.block.PlushieBlockEntity;
import de.sarocesch.plushie.client.gui.components.ModernButton;
import de.sarocesch.plushie.client.gui.components.ModernSlider;
import de.sarocesch.plushie.network.ModNetworking;
import de.sarocesch.plushie.network.PlushiePositionPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class PlushiePositionScreen
extends Screen {
    private final PlushieBlockEntity blockEntity;
    private final BlockPos blockPos;
    private final Screen parentScreen;
    private float originalOffsetX;
    private float originalOffsetY;
    private float originalOffsetZ;
    private float originalRotation;
    private final List<PositionSlider> sliders = new ArrayList<PositionSlider>();

    public PlushiePositionScreen(PlushieBlockEntity blockEntity, Screen parentScreen) {
        super((Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.position_editor"));
        this.blockEntity = blockEntity;
        this.blockPos = blockEntity.m_58899_();
        this.parentScreen = parentScreen;
        this.originalOffsetX = blockEntity.getOffsetX();
        this.originalOffsetY = blockEntity.getOffsetY();
        this.originalOffsetZ = blockEntity.getOffsetZ();
        this.originalRotation = blockEntity.getBaseRotation();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.sliders.clear();
        int rightX = this.f_96543_ - 170;
        int startY = 40;
        int sliderWidth = 150;
        int sliderHeight = 20;
        int spacing = 45;
        this.sliders.add(this.addSlider(rightX, startY, sliderWidth, sliderHeight, this.blockEntity.getOffsetX(), -8.0, 8.0, "X", this::onOffsetXChanged));
        this.sliders.add(this.addSlider(rightX, startY + spacing, sliderWidth, sliderHeight, this.blockEntity.getOffsetY(), -8.0, 8.0, "Y", this::onOffsetYChanged));
        this.sliders.add(this.addSlider(rightX, startY + spacing * 2, sliderWidth, sliderHeight, this.blockEntity.getOffsetZ(), -8.0, 8.0, "Z", this::onOffsetZChanged));
        this.sliders.add(this.addSlider(rightX, startY + spacing * 3, sliderWidth, sliderHeight, this.blockEntity.getBaseRotation(), -180.0, 180.0, "\u00b0", this::onRotationChanged));
        int buttonY = this.f_96544_ - 30;
        int buttonWidth = 45;
        this.m_142416_((GuiEventListener)new ModernButton(rightX, buttonY, buttonWidth, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.reset"), button -> this.resetPosition()));
        this.m_142416_((GuiEventListener)new ModernButton(rightX + buttonWidth + 5, buttonY, buttonWidth, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.apply"), button -> this.applyAndClose()));
        this.m_142416_((GuiEventListener)new ModernButton(rightX + buttonWidth * 2 + 10, buttonY, 30, 20, (Component)Component.m_237113_((String)"X"), button -> this.cancelAndClose()));
    }

    private PositionSlider addSlider(int x, int y, int width, int height, double value, double min, double max, String suffix, Runnable onChange) {
        PositionSlider slider = new PositionSlider(x, y, width, height, value, min, max, suffix, onChange);
        this.m_142416_((GuiEventListener)slider);
        return slider;
    }

    private void onOffsetXChanged() {
        this.blockEntity.setOffsetX((float)this.sliders.get(0).getValue());
    }

    private void onOffsetYChanged() {
        this.blockEntity.setOffsetY((float)this.sliders.get(1).getValue());
    }

    private void onOffsetZChanged() {
        this.blockEntity.setOffsetZ((float)this.sliders.get(2).getValue());
    }

    private void onRotationChanged() {
        this.blockEntity.setBaseRotation((float)this.sliders.get(3).getValue());
    }

    private void resetPosition() {
        this.blockEntity.setPosition(0.0f, 0.0f, 0.0f, 0.0f);
        this.m_232761_();
    }

    private void applyAndClose() {
        PlushiePositionPacket packet = new PlushiePositionPacket(this.blockPos, this.blockEntity.getOffsetX(), this.blockEntity.getOffsetY(), this.blockEntity.getOffsetZ(), this.blockEntity.getBaseRotation());
        ModNetworking.CHANNEL.sendToServer((Object)packet);
        Minecraft.m_91087_().m_91152_(this.parentScreen);
    }

    private void cancelAndClose() {
        this.blockEntity.setPosition(this.originalOffsetX, this.originalOffsetY, this.originalOffsetZ, this.originalRotation);
        Minecraft.m_91087_().m_91152_(this.parentScreen);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int sidebarWidth = 180;
        int sidebarX = this.f_96543_ - sidebarWidth;
        graphics.m_280024_(sidebarX, 0, this.f_96543_, this.f_96544_, -232907228, -233696747);
        graphics.m_280509_(sidebarX, 0, sidebarX + 1, this.f_96544_, -11908516);
        int rightX = this.f_96543_ - 170;
        int startY = 40;
        int spacing = 45;
        graphics.m_280653_(this.f_96547_, this.f_96539_, sidebarX + sidebarWidth / 2, 15, 0xFFFFFF);
        graphics.m_280509_(sidebarX + 10, 28, this.f_96543_ - 10, 29, -11908516);
        int labelColor = -3355444;
        graphics.m_280488_(this.f_96547_, "X (Left/Right)", rightX, startY - 12, labelColor);
        graphics.m_280488_(this.f_96547_, "Y (Up/Down)", rightX, startY + spacing - 12, labelColor);
        graphics.m_280488_(this.f_96547_, "Z (Front/Back)", rightX, startY + spacing * 2 - 12, labelColor);
        graphics.m_280488_(this.f_96547_, "Rotation", rightX, startY + spacing * 3 - 12, labelColor);
        String hint = "Look at your plushie!";
        int hintWidth = this.f_96547_.m_92895_(hint);
        int hintX = (this.f_96543_ - sidebarWidth) / 2;
        int hintY = this.f_96544_ - 40;
        graphics.m_280509_(hintX - hintWidth / 2 - 6, hintY - 6, hintX + hintWidth / 2 + 6, hintY + 14, Integer.MIN_VALUE);
        graphics.m_280137_(this.f_96547_, hint, hintX, hintY, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_280273_(GuiGraphics graphics) {
    }

    public boolean m_7043_() {
        return false;
    }

    static class PositionSlider
    extends ModernSlider {
        private final double minValue;
        private final double maxValue;
        private final String suffix;
        private final Runnable onChange;

        public PositionSlider(int x, int y, int width, int height, double value, double min, double max, String suffix, Runnable onChange) {
            super(x, y, width, height, (Component)Component.m_237119_(), (value - min) / (max - min));
            this.minValue = min;
            this.maxValue = max;
            this.suffix = suffix;
            this.onChange = onChange;
            this.m_5695_();
        }

        public double getValue() {
            return Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue);
        }

        protected void m_5695_() {
            double val = this.getValue();
            String formatted = String.format("%.1f%s", val, this.suffix);
            this.m_93666_((Component)Component.m_237113_((String)formatted));
        }

        protected void m_5697_() {
            if (this.onChange != null) {
                this.onChange.run();
            }
        }
    }
}

