/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.client.gui;

import de.sarocesch.plushie.block.PlushieBlockEntity;
import de.sarocesch.plushie.client.gui.PlushiePoseScreen;
import de.sarocesch.plushie.client.gui.PlushiePositionScreen;
import de.sarocesch.plushie.client.gui.components.ModernButton;
import de.sarocesch.plushie.client.gui.components.ModernCheckbox;
import de.sarocesch.plushie.client.gui.components.ModernEditBox;
import de.sarocesch.plushie.menu.PlushieMenu;
import de.sarocesch.plushie.network.ModNetworking;
import de.sarocesch.plushie.network.OpenInventoryPacket;
import de.sarocesch.plushie.network.PlushieUpdatePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PlushieScreen
extends AbstractContainerScreen<PlushieMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("sarosplayerplushiemod", "textures/gui/plushie_screen.png");
    private static final int GUI_WIDTH = 200;
    private static final int GUI_HEIGHT = 205;
    private ModernEditBox playerNameField;
    private ModernEditBox heartTextField;
    private ModernCheckbox showNameTagCheckbox;
    private ModernCheckbox showHeartCheckbox;
    private ModernCheckbox highResCheckbox;
    private ModernCheckbox skinLayersCheckbox;
    private ModernButton poseEditorButton;
    private ModernButton positionButton;
    private ModernButton inventoryButton;
    private ModernButton applyButton;

    public PlushieScreen(PlushieMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 200;
        this.f_97727_ = 205;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = (this.f_96543_ - 200) / 2;
        int centerY = (this.f_96544_ - 205) / 2;
        this.playerNameField = new ModernEditBox(this.f_96547_, centerX + 20, centerY + 30, 160, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.player_name"));
        this.playerNameField.m_94199_(16);
        this.playerNameField.m_94144_(((PlushieMenu)this.f_97732_).getBlockEntity().getPlayerName());
        this.playerNameField.m_257771_((Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.player_name_hint"));
        this.m_142416_((GuiEventListener)this.playerNameField);
        this.showNameTagCheckbox = new ModernCheckbox(centerX + 20, centerY + 58, 160, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.show_name_tag"), ((PlushieMenu)this.f_97732_).getBlockEntity().isShowNameTag());
        this.m_142416_((GuiEventListener)this.showNameTagCheckbox);
        this.showHeartCheckbox = new ModernCheckbox(centerX + 20, centerY + 78, 160, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.show_heart"), ((PlushieMenu)this.f_97732_).getBlockEntity().isShowHeart());
        this.m_142416_((GuiEventListener)this.showHeartCheckbox);
        this.heartTextField = new ModernEditBox(this.f_96547_, centerX + 20, centerY + 98, 160, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.heart_text"));
        this.heartTextField.m_94199_(16);
        this.heartTextField.m_94144_(((PlushieMenu)this.f_97732_).getBlockEntity().getHeartText());
        this.heartTextField.m_257771_((Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.heart_text_hint"));
        this.m_142416_((GuiEventListener)this.heartTextField);
        this.highResCheckbox = new ModernCheckbox(centerX + 20, centerY + 123, 160, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.is_high_res"), !((PlushieMenu)this.f_97732_).getBlockEntity().isHighRes());
        this.m_142416_((GuiEventListener)this.highResCheckbox);
        this.skinLayersCheckbox = new ModernCheckbox(centerX + 20, centerY + 143, 160, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.show_skin_layers"), ((PlushieMenu)this.f_97732_).getBlockEntity().isShowSkinLayers());
        this.m_142416_((GuiEventListener)this.skinLayersCheckbox);
        this.poseEditorButton = new ModernButton(centerX + 20, centerY + 163, 40, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.pose_editor"), button -> this.openPoseEditor());
        this.m_142416_((GuiEventListener)this.poseEditorButton);
        this.positionButton = new ModernButton(centerX + 65, centerY + 163, 40, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.position_editor"), button -> this.openPositionEditor());
        this.m_142416_((GuiEventListener)this.positionButton);
        this.inventoryButton = new ModernButton(centerX + 110, centerY + 163, 40, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.inventory"), button -> this.openInventory());
        this.m_142416_((GuiEventListener)this.inventoryButton);
        this.applyButton = new ModernButton(centerX + 155, centerY + 163, 25, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.apply_short"), button -> this.applyChanges());
        this.m_142416_((GuiEventListener)this.applyButton);
        this.updatePoseButtonVisibility();
    }

    private void updatePoseButtonVisibility() {
        boolean showHeart;
        boolean isHighRes;
        this.poseEditorButton.f_93623_ = true;
        this.skinLayersCheckbox.f_93623_ = isHighRes = !this.highResCheckbox.m_93840_();
        this.showHeartCheckbox.f_93623_ = isHighRes;
        if (!isHighRes && this.showHeartCheckbox.m_93840_()) {
            this.showHeartCheckbox.setSelected(false);
        }
        this.heartTextField.f_93624_ = showHeart = this.showHeartCheckbox.m_93840_() && isHighRes;
        this.heartTextField.f_93623_ = showHeart;
        this.repositionComponents();
    }

    private void repositionComponents() {
        int centerY = (this.f_96544_ - 205) / 2;
        int startY = centerY + 78;
        int currentY = startY + 20;
        if (this.heartTextField.f_93624_) {
            this.heartTextField.m_253211_(currentY);
            currentY += 25;
        }
        this.highResCheckbox.m_253211_(currentY);
        this.skinLayersCheckbox.m_253211_(currentY += 20);
        this.poseEditorButton.m_253211_(currentY += 20);
        this.positionButton.m_253211_(currentY);
        this.inventoryButton.m_253211_(currentY);
        this.applyButton.m_253211_(currentY);
    }

    private void openPoseEditor() {
        this.applyChangesWithoutClosing();
        PlushieBlockEntity blockEntity = ((PlushieMenu)this.f_97732_).getBlockEntity();
        Minecraft.m_91087_().m_91152_((Screen)new PlushiePoseScreen(blockEntity, (Screen)this));
    }

    private void openPositionEditor() {
        this.applyChangesWithoutClosing();
        PlushieBlockEntity blockEntity = ((PlushieMenu)this.f_97732_).getBlockEntity();
        Minecraft.m_91087_().m_91152_((Screen)new PlushiePositionScreen(blockEntity, (Screen)this));
    }

    private void openInventory() {
        this.applyChangesWithoutClosing();
        PlushieBlockEntity blockEntity = ((PlushieMenu)this.f_97732_).getBlockEntity();
        if (Minecraft.m_91087_().f_91074_ != null) {
            ModNetworking.CHANNEL.sendToServer((Object)new OpenInventoryPacket(blockEntity.m_58899_()));
        }
    }

    private void applyChanges() {
        this.applyChangesWithoutClosing();
        this.m_7379_();
    }

    private void applyChangesWithoutClosing() {
        PlushieUpdatePacket packet = new PlushieUpdatePacket(((PlushieMenu)this.f_97732_).getBlockPos(), this.playerNameField.m_94155_(), this.showNameTagCheckbox.m_93840_(), this.showHeartCheckbox.m_93840_(), !this.highResCheckbox.m_93840_(), this.skinLayersCheckbox.m_93840_(), this.heartTextField.m_94155_());
        ModNetworking.CHANNEL.sendToServer((Object)packet);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.updatePoseButtonVisibility();
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.f_96543_ - 200) / 2;
        int y = (this.f_96544_ - 205) / 2;
        int mainBgColor = -233696750;
        int headerColorStart = -13816515;
        int headerColorEnd = -14803412;
        graphics.m_280509_(x, y, x + 200, y + 205, mainBgColor);
        graphics.m_280024_(x + 1, y + 1, x + 200 - 1, y + 24, headerColorStart, headerColorEnd);
        graphics.m_280509_(x + 1, y + 24, x + 200 - 1, y + 25, -11908516);
        int border = -11908516;
        graphics.m_280509_(x, y, x + 200, y + 1, border);
        graphics.m_280509_(x, y + 205 - 1, x + 200, y + 205, border);
        graphics.m_280509_(x, y, x + 1, y + 205, border);
        graphics.m_280509_(x + 200 - 1, y, x + 200, y + 205, border);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        int centerY = (this.f_96544_ - 205) / 2;
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, centerY + 8, 0xFFFFFF);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.playerNameField.m_93696_() || this.heartTextField.m_93696_()) {
            if (keyCode == 256) {
                this.m_7379_();
                return true;
            }
            if (this.playerNameField.m_93696_() && this.playerNameField.m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (this.heartTextField.m_93696_() && this.heartTextField.m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }
}

