/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.client.gui;

import de.sarocesch.plushie.block.PlushiePose;
import de.sarocesch.plushie.client.gui.components.ModernButton;
import de.sarocesch.plushie.client.pose.SavedPose;
import de.sarocesch.plushie.client.pose.SavedPoseManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class PoseLoadScreen
extends Screen {
    private static final int SCREEN_WIDTH = 200;
    private static final int SCREEN_HEIGHT = 180;
    private static final int ENTRY_HEIGHT = 24;
    private static final int MAX_VISIBLE_ENTRIES = 5;
    private final Screen parentScreen;
    private final Consumer<PlushiePose> onLoadCallback;
    private List<SavedPose> poses = new ArrayList<SavedPose>();
    private int scrollOffset = 0;

    public PoseLoadScreen(Screen parentScreen, Consumer<PlushiePose> onLoadCallback) {
        super((Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.load_pose"));
        this.parentScreen = parentScreen;
        this.onLoadCallback = onLoadCallback;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.refreshPoseList();
    }

    private void refreshPoseList() {
        this.m_169413_();
        this.poses = SavedPoseManager.getInstance().getAllPoses();
        int screenX = (this.f_96543_ - 200) / 2;
        int screenY = (this.f_96544_ - 180) / 2;
        int listY = screenY + 30;
        int visibleCount = Math.min(this.poses.size() - this.scrollOffset, 5);
        for (int i = 0; i < visibleCount; ++i) {
            int poseIndex = this.scrollOffset + i;
            SavedPose pose = this.poses.get(poseIndex);
            int buttonY = listY + i * 24;
            this.m_142416_((GuiEventListener)new ModernButton(screenX + 10, buttonY, 140, 20, (Component)Component.m_237113_((String)pose.getName()), button -> this.loadPose(pose)));
            this.m_142416_((GuiEventListener)new ModernButton(screenX + 200 - 45, buttonY, 35, 20, (Component)Component.m_237113_((String)"X"), button -> this.deletePose(pose.getName())));
        }
        if (this.scrollOffset > 0) {
            this.m_142416_((GuiEventListener)new ModernButton(screenX + 100 - 15, listY - 18, 30, 16, (Component)Component.m_237113_((String)"\u25b2"), button -> this.scroll(-1)));
        }
        if (this.scrollOffset + 5 < this.poses.size()) {
            this.m_142416_((GuiEventListener)new ModernButton(screenX + 100 - 15, listY + 120 + 2, 30, 16, (Component)Component.m_237113_((String)"\u25bc"), button -> this.scroll(1)));
        }
        this.m_142416_((GuiEventListener)new ModernButton(screenX + 100 - 30, screenY + 180 - 28, 60, 20, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.close"), button -> this.m_7379_()));
    }

    private void scroll(int direction) {
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset + direction, this.poses.size() - 5));
        this.refreshPoseList();
    }

    private void loadPose(SavedPose pose) {
        if (this.onLoadCallback != null) {
            this.onLoadCallback.accept(pose.getPose());
        }
        this.m_7379_();
    }

    private void deletePose(String name) {
        SavedPoseManager.getInstance().deletePose(name);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.poses.size() - 1 - 5));
        this.refreshPoseList();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE);
        int screenX = (this.f_96543_ - 200) / 2;
        int screenY = (this.f_96544_ - 180) / 2;
        graphics.m_280024_(screenX, screenY, screenX + 200, screenY + 180, -233696747, -232907228);
        int border = -11908516;
        graphics.m_280509_(screenX, screenY, screenX + 200, screenY + 1, border);
        graphics.m_280509_(screenX, screenY + 180 - 1, screenX + 200, screenY + 180, border);
        graphics.m_280509_(screenX, screenY, screenX + 1, screenY + 180, border);
        graphics.m_280509_(screenX + 200 - 1, screenY, screenX + 200, screenY + 180, border);
        graphics.m_280024_(screenX + 1, screenY + 1, screenX + 200 - 1, screenY + 24, -13816515, -14803412);
        graphics.m_280509_(screenX + 1, screenY + 24, screenX + 200 - 1, screenY + 25, -11908516);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, screenY + 8, 0xFFFFFF);
        if (this.poses.isEmpty()) {
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.sarosplayerplushiemod.no_saved_poses"), this.f_96543_ / 2, screenY + 80, 0xAAAAAA);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            this.scroll(-1);
        } else if (delta < 0.0) {
            this.scroll(1);
        }
        return true;
    }
}

