/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.sarocesch.plushie.block.PlushiePose;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class PlushieModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("sarosplayerplushiemod", "plushie"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightArmSlim;
    private final ModelPart leftArmSlim;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart heart;

    public PlushieModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.rightArmSlim = root.m_171324_("right_arm_slim");
        this.leftArmSlim = root.m_171324_("left_arm_slim");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
        this.heart = root.m_171324_("heart");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(3, 3).m_171481_(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(20, 18).m_171481_(-2.0f, 0.0f, -1.0f, 4.0f, 5.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(43, 18).m_171481_(-1.0f, -2.5f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.m_171423_((float)3.0f, (float)19.25f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(35, 50).m_171481_(-1.0f, -2.5f, -1.0f, 2.0f, 5.0f, 2.0f), PartPose.m_171423_((float)-3.0f, (float)19.25f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        partdefinition.m_171599_("right_arm_slim", CubeListBuilder.m_171558_().m_171514_(44, 18).m_171481_(-0.75f, -2.5f, -1.0f, 1.5f, 5.0f, 2.0f), PartPose.m_171423_((float)3.0f, (float)19.25f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        partdefinition.m_171599_("left_arm_slim", CubeListBuilder.m_171558_().m_171514_(36, 50).m_171481_(-0.75f, -2.5f, -1.0f, 1.5f, 5.0f, 2.0f), PartPose.m_171423_((float)-3.0f, (float)19.25f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171481_(-1.0f, -1.0f, -2.25f, 2.0f, 2.0f, 4.75f), PartPose.m_171423_((float)1.75f, (float)23.0f, (float)-0.75f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 47).m_171481_(-1.0f, -1.0f, -2.25f, 2.0f, 2.0f, 4.75f), PartPose.m_171423_((float)-1.75f, (float)23.0f, (float)-0.75f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition heartPart = partdefinition.m_171599_("heart", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-2.5f));
        heartPart.m_171599_("heart_main", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 1.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void applyPose(PlushiePose pose, boolean slimArms) {
        if (pose == null) {
            return;
        }
        float degToRad = (float)Math.PI / 180;
        this.head.f_104203_ = pose.getHeadRotation().x * degToRad;
        this.head.f_104204_ = pose.getHeadRotation().y * degToRad;
        this.head.f_104205_ = pose.getHeadRotation().z * degToRad;
        this.body.f_104203_ = pose.getBodyRotation().x * degToRad;
        this.body.f_104204_ = pose.getBodyRotation().y * degToRad;
        this.body.f_104205_ = pose.getBodyRotation().z * degToRad;
        float leftArmXRot = pose.getLeftArmRotation().x * degToRad;
        float leftArmYRot = pose.getLeftArmRotation().y * degToRad;
        float leftArmZRot = -0.3927f + pose.getLeftArmRotation().z * degToRad;
        float rightArmXRot = pose.getRightArmRotation().x * degToRad;
        float rightArmYRot = pose.getRightArmRotation().y * degToRad;
        float rightArmZRot = 0.3927f + pose.getRightArmRotation().z * degToRad;
        this.leftArm.f_104203_ = leftArmXRot;
        this.leftArm.f_104204_ = leftArmYRot;
        this.leftArm.f_104205_ = leftArmZRot;
        this.rightArm.f_104203_ = rightArmXRot;
        this.rightArm.f_104204_ = rightArmYRot;
        this.rightArm.f_104205_ = rightArmZRot;
        this.leftArmSlim.f_104203_ = leftArmXRot;
        this.leftArmSlim.f_104204_ = leftArmYRot;
        this.leftArmSlim.f_104205_ = leftArmZRot;
        this.rightArmSlim.f_104203_ = rightArmXRot;
        this.rightArmSlim.f_104204_ = rightArmYRot;
        this.rightArmSlim.f_104205_ = rightArmZRot;
        this.leftLeg.f_104203_ = pose.getLeftLegRotation().x * degToRad;
        this.leftLeg.f_104204_ = 0.3927f + pose.getLeftLegRotation().y * degToRad;
        this.leftLeg.f_104205_ = pose.getLeftLegRotation().z * degToRad;
        this.rightLeg.f_104203_ = pose.getRightLegRotation().x * degToRad;
        this.rightLeg.f_104204_ = -0.3927f + pose.getRightLegRotation().y * degToRad;
        this.rightLeg.f_104205_ = pose.getRightLegRotation().z * degToRad;
    }

    public void renderAll(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, boolean showHeart, PlushiePose pose) {
        this.renderAll(poseStack, buffer, packedLight, packedOverlay, showHeart, pose, false);
    }

    public void renderAll(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, boolean showHeart, PlushiePose pose, boolean slimArms) {
        this.applyPose(pose, slimArms);
        this.head.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        if (slimArms) {
            this.rightArmSlim.m_104301_(poseStack, buffer, packedLight, packedOverlay);
            this.leftArmSlim.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        } else {
            this.rightArm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
            this.leftArm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        }
        this.rightLeg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.leftLeg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public void renderHeart(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        this.heart.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

