/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class PlushieQuadRenderer {
    private static final float TEX_WIDTH = 64.0f;
    private static final float TEX_HEIGHT = 64.0f;
    private static final float UV_SCALE = 4.0f;

    public static void renderBody(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        PlushieQuadRenderer.renderHead(matrix, normal, buffer, packedLight, packedOverlay);
        PlushieQuadRenderer.renderBodyPart(matrix, normal, buffer, packedLight, packedOverlay);
        PlushieQuadRenderer.renderRightArm(poseStack, buffer, packedLight, packedOverlay);
        PlushieQuadRenderer.renderLeftArm(poseStack, buffer, packedLight, packedOverlay);
        PlushieQuadRenderer.renderLeftLeg(poseStack, buffer, packedLight, packedOverlay);
        PlushieQuadRenderer.renderRightLeg(poseStack, buffer, packedLight, packedOverlay);
    }

    private static void renderHead(Matrix4f matrix, Matrix3f normal, VertexConsumer buffer, int packedLight, int packedOverlay) {
        float x1 = 0.3125f;
        float y1 = 0.4375f;
        float z1 = 0.375f;
        float x2 = 0.6875f;
        float y2 = 0.8125f;
        float z2 = 0.75f;
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x2, y1, z1, x1, y1, z1, x1, y2, z1, x2, y2, z1, 0.0f, 0.0f, -1.0f, PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(2.0f), PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(2.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x2, y1, z2, x2, y1, z1, x2, y2, z1, x2, y2, z2, 1.0f, 0.0f, 0.0f, PlushieQuadRenderer.uvX(0.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(2.0f), PlushieQuadRenderer.uvX(0.0f), PlushieQuadRenderer.uvY(2.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2, 0.0f, 0.0f, 1.0f, PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(8.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(8.0f), PlushieQuadRenderer.uvY(2.0f), PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(2.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z1, x1, y1, z2, x1, y2, z2, x1, y2, z1, -1.0f, 0.0f, 0.0f, PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(2.0f), PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(2.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1, 0.0f, 1.0f, 0.0f, PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(0.0f), PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(0.0f), PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(2.0f), PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(2.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z2, x1, y1, z1, x2, y1, z1, x2, y1, z2, 0.0f, -1.0f, 0.0f, PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(2.0f), PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(2.0f), PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(0.0f), PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(0.0f));
    }

    private static void renderBodyPart(Matrix4f matrix, Matrix3f normal, VertexConsumer buffer, int packedLight, int packedOverlay) {
        float x1 = 0.375f;
        float y1 = 0.125f;
        float z1 = 0.5f;
        float x2 = 0.625f;
        float y2 = 0.4375f;
        float z2 = 0.625f;
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x2, y1, z1, x1, y1, z1, x1, y2, z1, x2, y2, z1, 0.0f, 0.0f, -1.0f, PlushieQuadRenderer.uvX(5.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(5.0f), PlushieQuadRenderer.uvY(5.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x2, y1, z2, x2, y1, z1, x2, y2, z1, x2, y2, z2, 1.0f, 0.0f, 0.0f, PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(5.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(5.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(5.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2, 0.0f, 0.0f, 1.0f, PlushieQuadRenderer.uvX(8.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(10.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(10.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(8.0f), PlushieQuadRenderer.uvY(5.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z1, x1, y1, z2, x1, y2, z2, x1, y2, z1, -1.0f, 0.0f, 0.0f, PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(8.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(8.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(5.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1, 0.0f, 1.0f, 0.0f, PlushieQuadRenderer.uvX(5.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(5.0f), PlushieQuadRenderer.uvY(5.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z2, x1, y1, z1, x2, y1, z1, x2, y1, z2, 0.0f, -1.0f, 0.0f, PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(9.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(9.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(4.0f));
    }

    private static void renderRightArm(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.6875f, 0.296875f, 0.5625f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(22.5f));
        poseStack.m_252880_(-0.6875f, -0.296875f, -0.5625f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float x1 = 0.625f;
        float y1 = 0.140625f;
        float z1 = 0.5f;
        float x2 = 0.75f;
        float y2 = 0.453125f;
        float z2 = 0.625f;
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x2, y1, z1, x1, y1, z1, x1, y2, z1, x2, y2, z1, 0.0f, 0.0f, -1.0f, PlushieQuadRenderer.uvX(11.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(12.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(12.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(11.0f), PlushieQuadRenderer.uvY(5.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x2, y1, z2, x2, y1, z1, x2, y2, z1, x2, y2, z2, 1.0f, 0.0f, 0.0f, PlushieQuadRenderer.uvX(10.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(11.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(11.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(10.0f), PlushieQuadRenderer.uvY(5.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2, 0.0f, 0.0f, 1.0f, PlushieQuadRenderer.uvX(13.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(14.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(14.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(13.0f), PlushieQuadRenderer.uvY(5.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z1, x1, y1, z2, x1, y2, z2, x1, y2, z1, -1.0f, 0.0f, 0.0f, PlushieQuadRenderer.uvX(12.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(13.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(13.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(12.0f), PlushieQuadRenderer.uvY(5.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1, 0.0f, 1.0f, 0.0f, PlushieQuadRenderer.uvX(11.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(12.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(12.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(11.0f), PlushieQuadRenderer.uvY(5.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z2, x1, y1, z1, x2, y1, z1, x2, y1, z2, 0.0f, -1.0f, 0.0f, PlushieQuadRenderer.uvX(12.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(13.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(13.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(12.0f), PlushieQuadRenderer.uvY(4.0f));
        poseStack.m_85849_();
    }

    private static void renderLeftArm(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.3125f, 0.296875f, 0.5625f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-22.5f));
        poseStack.m_252880_(-0.3125f, -0.296875f, -0.5625f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float x1 = 0.25f;
        float y1 = 0.140625f;
        float z1 = 0.5f;
        float x2 = 0.375f;
        float y2 = 0.453125f;
        float z2 = 0.625f;
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x2, y1, z1, x1, y1, z1, x1, y2, z1, x2, y2, z1, 0.0f, 0.0f, -1.0f, PlushieQuadRenderer.uvX(9.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(10.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(10.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(9.0f), PlushieQuadRenderer.uvY(13.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x2, y1, z2, x2, y1, z1, x2, y2, z1, x2, y2, z2, 1.0f, 0.0f, 0.0f, PlushieQuadRenderer.uvX(8.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(9.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(9.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(8.0f), PlushieQuadRenderer.uvY(13.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2, 0.0f, 0.0f, 1.0f, PlushieQuadRenderer.uvX(11.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(12.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(12.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(11.0f), PlushieQuadRenderer.uvY(13.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z1, x1, y1, z2, x1, y2, z2, x1, y2, z1, -1.0f, 0.0f, 0.0f, PlushieQuadRenderer.uvX(10.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(11.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(11.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(10.0f), PlushieQuadRenderer.uvY(13.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1, 0.0f, 1.0f, 0.0f, PlushieQuadRenderer.uvX(9.0f), PlushieQuadRenderer.uvY(12.0f), PlushieQuadRenderer.uvX(10.0f), PlushieQuadRenderer.uvY(12.0f), PlushieQuadRenderer.uvX(10.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(9.0f), PlushieQuadRenderer.uvY(13.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z2, x1, y1, z1, x2, y1, z1, x2, y1, z2, 0.0f, -1.0f, 0.0f, PlushieQuadRenderer.uvX(10.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(11.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(11.0f), PlushieQuadRenderer.uvY(12.0f), PlushieQuadRenderer.uvX(10.0f), PlushieQuadRenderer.uvY(12.0f));
        poseStack.m_85849_();
    }

    private static void renderLeftLeg(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.390625f, 0.0625f, 0.453125f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(22.5f));
        poseStack.m_252880_(-0.390625f, -0.0625f, -0.453125f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float x1 = 0.328125f;
        float y1 = 0.0f;
        float z1 = 0.3125f;
        float x2 = 0.453125f;
        float y2 = 0.125f;
        float z2 = 0.609375f;
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x2, y1, z1, x1, y1, z1, x1, y2, z1, x2, y2, z1, 0.0f, 0.0f, -1.0f, PlushieQuadRenderer.uvX(5.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(12.0f), PlushieQuadRenderer.uvX(5.0f), PlushieQuadRenderer.uvY(12.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x2, y1, z2, x2, y1, z1, x2, y2, z1, x2, y2, z2, 1.0f, 0.0f, 0.0f, PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(5.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(5.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(13.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2, 0.0f, 0.0f, 1.0f, PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(12.0f), PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(12.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z1, x1, y1, z2, x1, y2, z2, x1, y2, z1, -1.0f, 0.0f, 0.0f, PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(13.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1, 0.0f, 1.0f, 0.0f, PlushieQuadRenderer.uvX(5.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(6.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(5.0f), PlushieQuadRenderer.uvY(13.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z2, x1, y1, z1, x2, y1, z1, x2, y1, z2, 0.0f, -1.0f, 0.0f, PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(8.0f), PlushieQuadRenderer.uvY(16.0f), PlushieQuadRenderer.uvX(8.0f), PlushieQuadRenderer.uvY(13.0f), PlushieQuadRenderer.uvX(7.0f), PlushieQuadRenderer.uvY(13.0f));
        poseStack.m_85849_();
    }

    private static void renderRightLeg(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.609375f, 0.0625f, 0.453125f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-22.5f));
        poseStack.m_252880_(-0.609375f, -0.0625f, -0.453125f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float x1 = 0.546875f;
        float y1 = 0.0f;
        float z1 = 0.3125f;
        float x2 = 0.671875f;
        float y2 = 0.125f;
        float z2 = 0.609375f;
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x2, y1, z1, x1, y1, z1, x1, y2, z1, x2, y2, z1, 0.0f, 0.0f, -1.0f, PlushieQuadRenderer.uvX(1.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(1.0f), PlushieQuadRenderer.uvY(4.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x2, y1, z2, x2, y1, z1, x2, y2, z1, x2, y2, z2, 1.0f, 0.0f, 0.0f, PlushieQuadRenderer.uvX(0.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(1.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(1.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(0.0f), PlushieQuadRenderer.uvY(5.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2, 0.0f, 0.0f, 1.0f, PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(3.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(3.0f), PlushieQuadRenderer.uvY(4.0f), PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(4.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z1, x1, y1, z2, x1, y2, z2, x1, y2, z1, -1.0f, 0.0f, 0.0f, PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(3.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(3.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(5.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1, 0.0f, 1.0f, 0.0f, PlushieQuadRenderer.uvX(1.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(2.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(1.0f), PlushieQuadRenderer.uvY(5.0f));
        PlushieQuadRenderer.renderQuad(matrix, normal, buffer, packedLight, packedOverlay, x1, y1, z2, x1, y1, z1, x2, y1, z1, x2, y1, z2, 0.0f, -1.0f, 0.0f, PlushieQuadRenderer.uvX(3.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(8.0f), PlushieQuadRenderer.uvX(4.0f), PlushieQuadRenderer.uvY(5.0f), PlushieQuadRenderer.uvX(3.0f), PlushieQuadRenderer.uvY(5.0f));
        poseStack.m_85849_();
    }

    private static float uvX(float blockbenchU) {
        return blockbenchU * 4.0f / 64.0f;
    }

    private static float uvY(float blockbenchV) {
        return blockbenchV * 4.0f / 64.0f;
    }

    private static void renderQuad(Matrix4f matrix, Matrix3f normalMatrix, VertexConsumer buffer, int packedLight, int packedOverlay, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float nx, float ny, float nz, float u1, float v1, float u2, float v2, float u3, float v3, float u4, float v4) {
        PlushieQuadRenderer.vertex(buffer, matrix, normalMatrix, x1, y1, z1, u1, v1, nx, ny, nz, packedLight, packedOverlay);
        PlushieQuadRenderer.vertex(buffer, matrix, normalMatrix, x2, y2, z2, u2, v2, nx, ny, nz, packedLight, packedOverlay);
        PlushieQuadRenderer.vertex(buffer, matrix, normalMatrix, x3, y3, z3, u3, v3, nx, ny, nz, packedLight, packedOverlay);
        PlushieQuadRenderer.vertex(buffer, matrix, normalMatrix, x4, y4, z4, u4, v4, nx, ny, nz, packedLight, packedOverlay);
    }

    private static void vertex(VertexConsumer buffer, Matrix4f matrix, Matrix3f normalMatrix, float x, float y, float z, float u, float v, float nx, float ny, float nz, int packedLight, int packedOverlay) {
        buffer.m_252986_(matrix, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normalMatrix, nx, ny, nz).m_5752_();
    }
}

