/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.client.pose;

import de.sarocesch.plushie.block.PlushiePose;
import org.joml.Vector3f;

public class SavedPose {
    private final String name;
    private final PlushiePose pose;

    public SavedPose(String name, PlushiePose pose) {
        this.name = name;
        this.pose = new PlushiePose(pose);
    }

    public String getName() {
        return this.name;
    }

    public PlushiePose getPose() {
        return new PlushiePose(this.pose);
    }

    public float[] getHeadRotation() {
        Vector3f v = this.pose.getHeadRotation();
        return new float[]{v.x, v.y, v.z};
    }

    public float[] getBodyRotation() {
        Vector3f v = this.pose.getBodyRotation();
        return new float[]{v.x, v.y, v.z};
    }

    public float[] getLeftArmRotation() {
        Vector3f v = this.pose.getLeftArmRotation();
        return new float[]{v.x, v.y, v.z};
    }

    public float[] getRightArmRotation() {
        Vector3f v = this.pose.getRightArmRotation();
        return new float[]{v.x, v.y, v.z};
    }

    public float[] getLeftLegRotation() {
        Vector3f v = this.pose.getLeftLegRotation();
        return new float[]{v.x, v.y, v.z};
    }

    public float[] getRightLegRotation() {
        Vector3f v = this.pose.getRightLegRotation();
        return new float[]{v.x, v.y, v.z};
    }

    public static SavedPose fromArrays(String name, float[] head, float[] body, float[] leftArm, float[] rightArm, float[] leftLeg, float[] rightLeg) {
        PlushiePose pose = new PlushiePose();
        pose.setHeadRotation(head[0], head[1], head[2]);
        pose.setBodyRotation(body[0], body[1], body[2]);
        pose.setLeftArmRotation(leftArm[0], leftArm[1], leftArm[2]);
        pose.setRightArmRotation(rightArm[0], rightArm[1], rightArm[2]);
        pose.setLeftLegRotation(leftLeg[0], leftLeg[1], leftLeg[2]);
        pose.setRightLegRotation(rightLeg[0], rightLeg[1], rightLeg[2]);
        return new SavedPose(name, pose);
    }
}

