/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.client.pose;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import de.sarocesch.plushie.block.PlushiePose;
import de.sarocesch.plushie.client.pose.SavedPose;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.slf4j.Logger;

public class SavedPoseManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CONFIG_FILE = "saros_plushie_poses.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static SavedPoseManager instance;
    private final List<SavedPose> savedPoses = new ArrayList<SavedPose>();
    private final File configFile;

    private SavedPoseManager() {
        File configDir = new File(Minecraft.m_91087_().f_91069_, "config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        this.configFile = new File(configDir, CONFIG_FILE);
        this.loadFromFile();
    }

    public static SavedPoseManager getInstance() {
        if (instance == null) {
            instance = new SavedPoseManager();
        }
        return instance;
    }

    public List<SavedPose> getAllPoses() {
        return new ArrayList<SavedPose>(this.savedPoses);
    }

    public void savePose(String name, PlushiePose pose) {
        this.savedPoses.removeIf(p -> p.getName().equals(name));
        this.savedPoses.add(new SavedPose(name, pose));
        this.saveToFile();
    }

    public SavedPose getPose(String name) {
        return this.savedPoses.stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
    }

    public void deletePose(String name) {
        this.savedPoses.removeIf(p -> p.getName().equals(name));
        this.saveToFile();
    }

    public boolean poseExists(String name) {
        return this.savedPoses.stream().anyMatch(p -> p.getName().equals(name));
    }

    private void saveToFile() {
        try (FileWriter writer = new FileWriter(this.configFile);){
            JsonArray array = new JsonArray();
            for (SavedPose pose : this.savedPoses) {
                JsonObject obj = new JsonObject();
                obj.addProperty("name", pose.getName());
                obj.add("head", (JsonElement)this.toJsonArray(pose.getHeadRotation()));
                obj.add("body", (JsonElement)this.toJsonArray(pose.getBodyRotation()));
                obj.add("leftArm", (JsonElement)this.toJsonArray(pose.getLeftArmRotation()));
                obj.add("rightArm", (JsonElement)this.toJsonArray(pose.getRightArmRotation()));
                obj.add("leftLeg", (JsonElement)this.toJsonArray(pose.getLeftLegRotation()));
                obj.add("rightLeg", (JsonElement)this.toJsonArray(pose.getRightLegRotation()));
                array.add((JsonElement)obj);
            }
            GSON.toJson((JsonElement)array, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save poses", (Throwable)e);
        }
    }

    private void loadFromFile() {
        if (!this.configFile.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(this.configFile);){
            JsonArray array = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            this.savedPoses.clear();
            for (JsonElement element : array) {
                JsonObject obj = element.getAsJsonObject();
                String name = obj.get("name").getAsString();
                float[] head = this.fromJsonArray(obj.getAsJsonArray("head"));
                float[] body = this.fromJsonArray(obj.getAsJsonArray("body"));
                float[] leftArm = this.fromJsonArray(obj.getAsJsonArray("leftArm"));
                float[] rightArm = this.fromJsonArray(obj.getAsJsonArray("rightArm"));
                float[] leftLeg = this.fromJsonArray(obj.getAsJsonArray("leftLeg"));
                float[] rightLeg = this.fromJsonArray(obj.getAsJsonArray("rightLeg"));
                this.savedPoses.add(SavedPose.fromArrays(name, head, body, leftArm, rightArm, leftLeg, rightLeg));
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load poses", (Throwable)e);
        }
    }

    private JsonArray toJsonArray(float[] arr) {
        JsonArray jsonArr = new JsonArray();
        for (float f : arr) {
            jsonArr.add((Number)Float.valueOf(f));
        }
        return jsonArr;
    }

    private float[] fromJsonArray(JsonArray arr) {
        float[] result = new float[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            result[i] = arr.get(i).getAsFloat();
        }
        return result;
    }
}

