/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.sarocesch.plushie.block.PlushieBlock;
import de.sarocesch.plushie.block.PlushieBlockEntity;
import de.sarocesch.plushie.block.PlushiePose;
import de.sarocesch.plushie.client.model.PlushieModel;
import de.sarocesch.plushie.client.renderer.SkinTextureManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class PlushieBlockEntityRenderer
implements BlockEntityRenderer<PlushieBlockEntity> {
    private static final ResourceLocation DEFAULT_SKIN = new ResourceLocation("sarosplayerplushiemod", "textures/block/skin.png");
    private static final ResourceLocation HEART_TEXTURE = new ResourceLocation("sarosplayerplushiemod", "textures/block/heart.png");
    private static final ResourceLocation HIGHRES_MODEL = new ResourceLocation("sarosplayerplushiemod", "block/plushie_highres");
    private static final ResourceLocation HIGHRES_LAYERS_MODEL = new ResourceLocation("sarosplayerplushiemod", "block/plushie_highres_layers");
    private static final ResourceLocation MODEL_HEAD = new ResourceLocation("sarosplayerplushiemod", "block/plushie_head");
    private static final ResourceLocation MODEL_BODY = new ResourceLocation("sarosplayerplushiemod", "block/plushie_body");
    private static final ResourceLocation MODEL_ARM_LEFT = new ResourceLocation("sarosplayerplushiemod", "block/plushie_arm_left");
    private static final ResourceLocation MODEL_ARM_RIGHT = new ResourceLocation("sarosplayerplushiemod", "block/plushie_arm_right");
    private static final ResourceLocation MODEL_ARM_LEFT_SLIM = new ResourceLocation("sarosplayerplushiemod", "block/plushie_arm_left_slim");
    private static final ResourceLocation MODEL_ARM_RIGHT_SLIM = new ResourceLocation("sarosplayerplushiemod", "block/plushie_arm_right_slim");
    private static final ResourceLocation MODEL_LEG_LEFT = new ResourceLocation("sarosplayerplushiemod", "block/plushie_leg_left");
    private static final ResourceLocation MODEL_LEG_RIGHT = new ResourceLocation("sarosplayerplushiemod", "block/plushie_leg_right");
    private static final ResourceLocation MODEL_HEART = new ResourceLocation("sarosplayerplushiemod", "block/plushie_heart");
    private static final int ELEMENT_HEAD = 0;
    private static final int ELEMENT_BODY = 1;
    private static final int ELEMENT_RIGHT_ARM = 2;
    private static final int ELEMENT_LEFT_ARM = 3;
    private static final int ELEMENT_LEFT_LEG = 4;
    private static final int ELEMENT_RIGHT_LEG = 5;
    private static final Vector3f PIVOT_HEAD = new Vector3f(8.0f, 10.0f, 9.0f);
    private static final Vector3f PIVOT_BODY = new Vector3f(8.0f, 4.9f, 8.0f);
    private static final Vector3f PIVOT_RIGHT_ARM = new Vector3f(10.025f, 7.05f, 9.0f);
    private static final Vector3f PIVOT_LEFT_ARM = new Vector3f(6.0f, 7.1f, 9.0f);
    private static final Vector3f PIVOT_LEFT_LEG = new Vector3f(7.175f, 1.0f, 9.6f);
    private static final Vector3f PIVOT_RIGHT_LEG = new Vector3f(8.8f, 1.0f, 9.575f);
    private final PlushieModel modelStandard;
    private final Font font;
    private final SkinTextureManager skinManager;

    public PlushieBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.modelStandard = new PlushieModel(context.m_173582_(PlushieModel.LAYER_LOCATION));
        this.font = context.m_173586_();
        this.skinManager = SkinTextureManager.getInstance();
    }

    public void render(PlushieBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.isHighRes()) {
            this.renderHighRes(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        } else {
            this.renderStandard(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        }
        if (blockEntity.isShowNameTag() && !blockEntity.getPlayerName().isEmpty()) {
            this.renderNameTag(blockEntity, poseStack, bufferSource, packedLight);
        }
        this.renderLoadingStatus(blockEntity, poseStack, bufferSource, packedLight);
    }

    private void renderHighRes(PlushieBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)PlushieBlock.FACING);
        float rotation = switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        float baseRot = blockEntity.getBaseRotation();
        if (baseRot != 0.0f) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(baseRot));
        }
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        float offsetX = blockEntity.getOffsetX() / 16.0f;
        float offsetY = blockEntity.getOffsetY() / 16.0f;
        float offsetZ = blockEntity.getOffsetZ() / 16.0f;
        if (offsetX != 0.0f || offsetY != 0.0f || offsetZ != 0.0f) {
            poseStack.m_252880_(offsetX, offsetY, offsetZ);
        }
        PlushiePose pose = blockEntity.getPose();
        if (blockEntity.isShowHeart()) {
            this.renderHeartModel(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        } else {
            this.renderHighResWithPose(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, pose);
        }
        poseStack.m_85849_();
    }

    private void renderHeartModel(PlushieBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BakedModel heartModel = Minecraft.m_91087_().m_91304_().getModel(MODEL_HEART);
        if (heartModel == null || heartModel == Minecraft.m_91087_().m_91304_().m_119409_()) {
            this.renderHighResWithPose(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, blockEntity.getPose());
            return;
        }
        PlushiePose pose = blockEntity.getPose();
        ResourceLocation skinTexture = this.getSkinTexture(blockEntity);
        VertexConsumer skinConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)skinTexture));
        BlockState blockState = blockEntity.m_58900_();
        boolean showLayers = blockEntity.isShowSkinLayers();
        boolean slimArms = blockEntity.isSlimArms();
        this.renderBodyPart(poseStack, skinConsumer, MODEL_HEAD, blockState, PIVOT_HEAD, pose.getHeadRotation(), packedLight, packedOverlay, showLayers);
        this.renderBodyPart(poseStack, skinConsumer, MODEL_BODY, blockState, PIVOT_BODY, pose.getBodyRotation(), packedLight, packedOverlay, showLayers);
        this.renderBodyPart(poseStack, skinConsumer, MODEL_LEG_LEFT, blockState, PIVOT_LEFT_LEG, pose.getLeftLegRotation(), packedLight, packedOverlay, showLayers);
        this.renderBodyPart(poseStack, skinConsumer, MODEL_LEG_RIGHT, blockState, PIVOT_RIGHT_LEG, pose.getRightLegRotation(), packedLight, packedOverlay, showLayers);
        Vector3f heartArmPose = new Vector3f(45.0f, 0.0f, 0.0f);
        ResourceLocation leftArmModel = slimArms ? MODEL_ARM_LEFT_SLIM : MODEL_ARM_LEFT;
        ResourceLocation rightArmModel = slimArms ? MODEL_ARM_RIGHT_SLIM : MODEL_ARM_RIGHT;
        this.renderBodyPart(poseStack, skinConsumer, leftArmModel, blockState, PIVOT_LEFT_ARM, heartArmPose, packedLight, packedOverlay, showLayers);
        this.renderBodyPart(poseStack, skinConsumer, rightArmModel, blockState, PIVOT_RIGHT_ARM, heartArmPose, packedLight, packedOverlay, showLayers);
        VertexConsumer heartConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)HEART_TEXTURE));
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        RandomSource random = RandomSource.m_216327_();
        for (Direction dir : Direction.values()) {
            random.m_188584_(42L);
            List quads = heartModel.getQuads(blockState, dir, random, ModelData.EMPTY, null);
            for (BakedQuad quad : quads) {
                this.renderQuadWithCustomTexture(heartConsumer, matrix, normalMatrix, quad, packedLight, packedOverlay);
            }
        }
        random.m_188584_(42L);
        List unculledQuads = heartModel.getQuads(blockState, null, random, ModelData.EMPTY, null);
        for (BakedQuad quad : unculledQuads) {
            this.renderQuadWithCustomTexture(heartConsumer, matrix, normalMatrix, quad, packedLight, packedOverlay);
        }
        String heartText = blockEntity.getHeartText();
        if (heartText != null && !heartText.isEmpty()) {
            this.renderHeartText(poseStack, bufferSource, heartText, packedLight);
        }
    }

    private void renderHeartText(PoseStack poseStack, MultiBufferSource bufferSource, String text, int packedLight) {
        Font font = Minecraft.m_91087_().f_91062_;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.3305, 0.324);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        float scale = 0.005f;
        poseStack.m_85841_(scale, -scale, scale);
        int textWidth = font.m_92895_(text);
        float xOffset = (float)(-textWidth) / 2.0f;
        font.m_271703_(text, xOffset, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.m_85849_();
    }

    private boolean hasPoseValues(PlushiePose pose) {
        if (pose == null) {
            return false;
        }
        return !this.isZeroVector(pose.getHeadRotation()) || !this.isZeroVector(pose.getBodyRotation()) || !this.isZeroVector(pose.getLeftArmRotation()) || !this.isZeroVector(pose.getRightArmRotation()) || !this.isZeroVector(pose.getLeftLegRotation()) || !this.isZeroVector(pose.getRightLegRotation());
    }

    private boolean isZeroVector(Vector3f v) {
        return v.x == 0.0f && v.y == 0.0f && v.z == 0.0f;
    }

    private void renderHighResOriginal(PlushieBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BakedModel bakedModel = Minecraft.m_91087_().m_91304_().getModel(HIGHRES_MODEL);
        if (bakedModel != null && bakedModel != Minecraft.m_91087_().m_91304_().m_119409_()) {
            BakedModel layersModel;
            ResourceLocation skinTexture = this.getSkinTexture(blockEntity);
            VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)skinTexture));
            BlockState blockState = blockEntity.m_58900_();
            this.renderElementsWithPose(poseStack, consumer, bakedModel, blockState, null, packedLight, packedOverlay);
            if (blockEntity.isShowSkinLayers() && (layersModel = Minecraft.m_91087_().m_91304_().getModel(HIGHRES_LAYERS_MODEL)) != null && layersModel != Minecraft.m_91087_().m_91304_().m_119409_()) {
                VertexConsumer layerConsumer = bufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)skinTexture));
                this.renderElementsWithPose(poseStack, layerConsumer, layersModel, blockState, null, packedLight, packedOverlay);
            }
        }
    }

    private void renderHighResWithPose(PlushieBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, PlushiePose pose) {
        ResourceLocation skinTexture = this.getSkinTexture(blockEntity);
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)skinTexture));
        BlockState blockState = blockEntity.m_58900_();
        boolean showLayers = blockEntity.isShowSkinLayers();
        boolean slimArms = blockEntity.isSlimArms();
        this.renderBodyPart(poseStack, consumer, MODEL_HEAD, blockState, PIVOT_HEAD, pose.getHeadRotation(), packedLight, packedOverlay, showLayers);
        this.renderBodyPart(poseStack, consumer, MODEL_BODY, blockState, PIVOT_BODY, pose.getBodyRotation(), packedLight, packedOverlay, showLayers);
        ResourceLocation leftArmModel = slimArms ? MODEL_ARM_LEFT_SLIM : MODEL_ARM_LEFT;
        ResourceLocation rightArmModel = slimArms ? MODEL_ARM_RIGHT_SLIM : MODEL_ARM_RIGHT;
        this.renderBodyPart(poseStack, consumer, leftArmModel, blockState, PIVOT_LEFT_ARM, pose.getLeftArmRotation(), packedLight, packedOverlay, showLayers);
        this.renderBodyPart(poseStack, consumer, rightArmModel, blockState, PIVOT_RIGHT_ARM, pose.getRightArmRotation(), packedLight, packedOverlay, showLayers);
        this.renderBodyPart(poseStack, consumer, MODEL_LEG_LEFT, blockState, PIVOT_LEFT_LEG, pose.getLeftLegRotation(), packedLight, packedOverlay, showLayers);
        this.renderBodyPart(poseStack, consumer, MODEL_LEG_RIGHT, blockState, PIVOT_RIGHT_LEG, pose.getRightLegRotation(), packedLight, packedOverlay, showLayers);
        this.renderHandItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, pose);
    }

    private void renderBodyPart(PoseStack poseStack, VertexConsumer consumer, ResourceLocation modelLocation, BlockState blockState, Vector3f pivot, Vector3f rotation, int packedLight, int packedOverlay, boolean showLayers) {
        BakedModel model = Minecraft.m_91087_().m_91304_().getModel(modelLocation);
        if (model == null || model == Minecraft.m_91087_().m_91304_().m_119409_()) {
            return;
        }
        poseStack.m_85836_();
        float pivotX = pivot.x / 16.0f;
        float pivotY = pivot.y / 16.0f;
        float pivotZ = pivot.z / 16.0f;
        poseStack.m_252880_(pivotX, pivotY, pivotZ);
        if (rotation.x != 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(rotation.x));
        }
        if (rotation.y != 0.0f) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation.y));
        }
        if (rotation.z != 0.0f) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation.z));
        }
        poseStack.m_252880_(-pivotX, -pivotY, -pivotZ);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        RandomSource random = RandomSource.m_216327_();
        int quadIndex = 0;
        int quadsPerElement = 6;
        for (Direction dir : Direction.values()) {
            random.m_188584_(42L);
            List quads = model.getQuads(blockState, dir, random, ModelData.EMPTY, null);
            for (BakedQuad quad : quads) {
                boolean isLayer;
                boolean bl = isLayer = quadIndex < quadsPerElement;
                if (!isLayer || showLayers) {
                    this.renderQuadWithCustomTexture(consumer, matrix, normalMatrix, quad, packedLight, packedOverlay);
                }
                ++quadIndex;
            }
        }
        random.m_188584_(42L);
        List unculledQuads = model.getQuads(blockState, null, random, ModelData.EMPTY, null);
        for (BakedQuad quad : unculledQuads) {
            boolean isLayer;
            boolean bl = isLayer = quadIndex < quadsPerElement;
            if (!isLayer || showLayers) {
                this.renderQuadWithCustomTexture(consumer, matrix, normalMatrix, quad, packedLight, packedOverlay);
            }
            ++quadIndex;
        }
        poseStack.m_85849_();
    }

    private String getElementNameFromQuad(BakedQuad quad) {
        return null;
    }

    private void renderElementsWithPose(PoseStack poseStack, VertexConsumer consumer, BakedModel bakedModel, BlockState blockState, PlushiePose pose, int packedLight, int packedOverlay) {
        RandomSource random = RandomSource.m_216327_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        for (Direction dir : Direction.values()) {
            random.m_188584_(42L);
            List quads = bakedModel.getQuads(blockState, dir, random, ModelData.EMPTY, null);
            for (BakedQuad quad : quads) {
                this.renderQuadWithCustomTexture(consumer, matrix, normalMatrix, quad, packedLight, packedOverlay);
            }
        }
        random.m_188584_(42L);
        List unculledQuads = bakedModel.getQuads(blockState, null, random, ModelData.EMPTY, null);
        for (BakedQuad quad : unculledQuads) {
            this.renderQuadWithCustomTexture(consumer, matrix, normalMatrix, quad, packedLight, packedOverlay);
        }
    }

    private void renderQuadWithCustomTexture(VertexConsumer consumer, Matrix4f matrix, Matrix3f normalMatrix, BakedQuad quad, int packedLight, int packedOverlay) {
        int[] vertexData = quad.m_111303_();
        int vertexSize = 8;
        TextureAtlasSprite sprite = quad.m_173410_();
        for (int i = 0; i < 4; ++i) {
            int offset = i * vertexSize;
            float x = Float.intBitsToFloat(vertexData[offset]);
            float y = Float.intBitsToFloat(vertexData[offset + 1]);
            float z = Float.intBitsToFloat(vertexData[offset + 2]);
            int packedColor = vertexData[offset + 3];
            int r = packedColor & 0xFF;
            int g = packedColor >> 8 & 0xFF;
            int b = packedColor >> 16 & 0xFF;
            int a = packedColor >> 24 & 0xFF;
            float atlasU = Float.intBitsToFloat(vertexData[offset + 4]);
            float atlasV = Float.intBitsToFloat(vertexData[offset + 5]);
            float normalizedU = (atlasU - sprite.m_118409_()) / (sprite.m_118410_() - sprite.m_118409_());
            float normalizedV = (atlasV - sprite.m_118411_()) / (sprite.m_118412_() - sprite.m_118411_());
            int packedNormal = vertexData[offset + 7];
            float nx = (float)((byte)(packedNormal & 0xFF)) / 127.0f;
            float ny = (float)((byte)(packedNormal >> 8 & 0xFF)) / 127.0f;
            float nz = (float)((byte)(packedNormal >> 16 & 0xFF)) / 127.0f;
            consumer.m_252986_(matrix, x, y, z).m_6122_(r, g, b, a).m_7421_(normalizedU, normalizedV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normalMatrix, nx, ny, nz).m_5752_();
        }
    }

    private void renderStandard(PlushieBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)PlushieBlock.FACING);
        float rotation = switch (facing) {
            case Direction.NORTH -> 180.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> -90.0f;
            case Direction.EAST -> 90.0f;
            default -> 0.0f;
        };
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        float baseRot = blockEntity.getBaseRotation();
        if (baseRot != 0.0f) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(baseRot));
        }
        float offsetX = blockEntity.getOffsetX() / 16.0f;
        float offsetY = blockEntity.getOffsetY() / 16.0f;
        float offsetZ = blockEntity.getOffsetZ() / 16.0f;
        if (offsetX != 0.0f || offsetY != 0.0f || offsetZ != 0.0f) {
            poseStack.m_252880_(offsetX, offsetY, offsetZ);
        }
        poseStack.m_85837_(0.0, 1.5, 0.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        ResourceLocation skinTexture = this.getSkinTexture(blockEntity);
        VertexConsumer bodyConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)skinTexture));
        this.modelStandard.renderAll(poseStack, bodyConsumer, packedLight, OverlayTexture.f_118083_, false, blockEntity.getPose(), blockEntity.isSlimArms());
        if (blockEntity.isShowHeart()) {
            VertexConsumer heartConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)HEART_TEXTURE));
            this.modelStandard.renderHeart(poseStack, heartConsumer, packedLight, OverlayTexture.f_118083_);
        }
        poseStack.m_85849_();
    }

    private void renderHandItemsLowRes(PlushieBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float scale;
        Vector3f armRot;
        ItemStack mainHand = blockEntity.getMainHandItem();
        ItemStack offHand = blockEntity.getOffHandItem();
        if (mainHand.m_41619_() && offHand.m_41619_()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        PlushiePose pose = blockEntity.getPose();
        if (!mainHand.m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.19f, 0.24f, 0.06f);
            armRot = pose.getRightArmRotation();
            poseStack.m_252781_(Axis.f_252403_.m_252977_(22.500051f + armRot.z));
            if (armRot.x != 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(armRot.x));
            }
            if (armRot.y != 0.0f) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(armRot.y));
            }
            poseStack.m_252880_(0.0f, 0.15f, 0.0f);
            scale = 0.2f;
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            itemRenderer.m_269128_(mainHand, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.m_58904_(), 0);
            poseStack.m_85849_();
        }
        if (!offHand.m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_252880_(-0.19f, 0.24f, 0.06f);
            armRot = pose.getLeftArmRotation();
            poseStack.m_252781_(Axis.f_252403_.m_252977_(-22.500051f + armRot.z));
            if (armRot.x != 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(armRot.x));
            }
            if (armRot.y != 0.0f) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(armRot.y));
            }
            poseStack.m_252880_(0.0f, 0.15f, 0.0f);
            scale = 0.2f;
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            itemRenderer.m_269128_(offHand, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.m_58904_(), 0);
            poseStack.m_85849_();
        }
    }

    private ResourceLocation getSkinTexture(PlushieBlockEntity blockEntity) {
        ResourceLocation dynTexture;
        String skinUrl = blockEntity.getSkinUrl();
        String playerName = blockEntity.getPlayerName();
        if (skinUrl != null && !skinUrl.isEmpty() && (dynTexture = this.skinManager.getOrLoadTexture(skinUrl, playerName)) != null) {
            return dynTexture;
        }
        return DEFAULT_SKIN;
    }

    private void renderNameTag(PlushieBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        MutableComponent name = Component.m_237113_((String)blockEntity.getPlayerName());
        float offsetX = blockEntity.getOffsetX() / 16.0f;
        float offsetY = blockEntity.getOffsetY() / 16.0f;
        float offsetZ = blockEntity.getOffsetZ() / 16.0f;
        poseStack.m_85837_(0.5 + (double)offsetX, 1.0 + (double)offsetY, 0.5 + (double)offsetZ);
        poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        poseStack.m_85841_(-0.02f, -0.02f, 0.02f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float bgOpacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int bgColor = (int)(bgOpacity * 255.0f) << 24;
        float textWidth = this.font.m_92852_((FormattedText)name);
        float x = -textWidth / 2.0f;
        this.font.m_272077_((Component)name, x, 0.0f, -1, false, matrix, bufferSource, Font.DisplayMode.SEE_THROUGH, bgColor, packedLight);
        this.font.m_272077_((Component)name, x, 0.0f, -1, false, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(PlushieBlockEntity blockEntity) {
        return true;
    }

    private void renderHandItems(PlushieBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, PlushiePose pose) {
        float scale;
        Vector3f armRot;
        float pivotZ;
        float pivotY;
        float pivotX;
        ItemStack mainHand = blockEntity.getMainHandItem();
        ItemStack offHand = blockEntity.getOffHandItem();
        if (mainHand.m_41619_() && offHand.m_41619_()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        if (!mainHand.m_41619_()) {
            poseStack.m_85836_();
            pivotX = PlushieBlockEntityRenderer.PIVOT_RIGHT_ARM.x / 16.0f;
            pivotY = PlushieBlockEntityRenderer.PIVOT_RIGHT_ARM.y / 16.0f;
            pivotZ = PlushieBlockEntityRenderer.PIVOT_RIGHT_ARM.z / 16.0f;
            poseStack.m_252880_(pivotX, pivotY, pivotZ);
            armRot = pose.getRightArmRotation();
            if (armRot.x != 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(armRot.x));
            }
            if (armRot.y != 0.0f) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(armRot.y));
            }
            if (armRot.z != 0.0f) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(armRot.z));
            }
            poseStack.m_252880_(blockEntity.getMainHandItemOffsetX(), blockEntity.getMainHandItemOffsetY(), blockEntity.getMainHandItemOffsetZ());
            scale = 0.25f;
            poseStack.m_85841_(scale, scale, scale);
            float mainRotX = blockEntity.getMainHandItemRotX();
            float mainRotY = blockEntity.getMainHandItemRotY();
            float mainRotZ = blockEntity.getMainHandItemRotZ();
            if (mainRotX != 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(mainRotX));
            }
            if (mainRotY != 0.0f) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(mainRotY));
            }
            if (mainRotZ != 0.0f) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(mainRotZ));
            }
            itemRenderer.m_269128_(mainHand, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.m_58904_(), 0);
            poseStack.m_85849_();
        }
        if (!offHand.m_41619_()) {
            poseStack.m_85836_();
            pivotX = PlushieBlockEntityRenderer.PIVOT_LEFT_ARM.x / 16.0f;
            pivotY = PlushieBlockEntityRenderer.PIVOT_LEFT_ARM.y / 16.0f;
            pivotZ = PlushieBlockEntityRenderer.PIVOT_LEFT_ARM.z / 16.0f;
            poseStack.m_252880_(pivotX, pivotY, pivotZ);
            armRot = pose.getLeftArmRotation();
            if (armRot.x != 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(armRot.x));
            }
            if (armRot.y != 0.0f) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(armRot.y));
            }
            if (armRot.z != 0.0f) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(armRot.z));
            }
            poseStack.m_252880_(blockEntity.getOffHandItemOffsetX(), blockEntity.getOffHandItemOffsetY(), blockEntity.getOffHandItemOffsetZ());
            scale = 0.25f;
            poseStack.m_85841_(scale, scale, scale);
            float offRotX = blockEntity.getOffHandItemRotX();
            float offRotY = blockEntity.getOffHandItemRotY();
            float offRotZ = blockEntity.getOffHandItemRotZ();
            if (offRotX != 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(offRotX));
            }
            if (offRotY != 0.0f) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(offRotY));
            }
            if (offRotZ != 0.0f) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(offRotZ));
            }
            itemRenderer.m_269128_(offHand, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.m_58904_(), 0);
            poseStack.m_85849_();
        }
    }

    private void renderLoadingStatus(PlushieBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        int color;
        MutableComponent statusText;
        String skinUrl = blockEntity.getSkinUrl();
        if (blockEntity.getPlayerName().isEmpty()) {
            return;
        }
        Enum status = null;
        if (skinUrl != null && !skinUrl.isEmpty() && (status = this.skinManager.getLoadStatus(skinUrl)) == null && this.skinManager.isLoading(skinUrl)) {
            status = SkinTextureManager.LoadStatus.LOADING;
        }
        if (status == null) {
            return;
        }
        switch (1.$SwitchMap$de$sarocesch$plushie$client$renderer$SkinTextureManager$LoadStatus[status.ordinal()]) {
            case 1: {
                statusText = Component.m_237115_((String)"gui.sarosplayerplushiemod.skin_loading");
                color = -22016;
                break;
            }
            case 2: {
                statusText = Component.m_237115_((String)"gui.sarosplayerplushiemod.skin_success");
                color = -16711936;
                break;
            }
            case 3: {
                statusText = Component.m_237115_((String)"gui.sarosplayerplushiemod.skin_failed");
                color = -65536;
                break;
            }
            default: {
                return;
            }
        }
        poseStack.m_85836_();
        float yOffset = blockEntity.isShowNameTag() && !blockEntity.getPlayerName().isEmpty() ? 1.3f : 1.0f;
        poseStack.m_85837_(0.5, (double)yOffset, 0.5);
        poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        poseStack.m_85841_(-0.015f, -0.015f, 0.015f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float bgOpacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int bgColor = (int)(bgOpacity * 255.0f) << 24;
        float textWidth = this.font.m_92852_((FormattedText)statusText);
        float x = -textWidth / 2.0f;
        this.font.m_272077_((Component)statusText, x, 0.0f, color, false, matrix, bufferSource, Font.DisplayMode.SEE_THROUGH, bgColor, packedLight);
        this.font.m_272077_((Component)statusText, x, 0.0f, color, false, matrix, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.m_85849_();
    }
}

