/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.client.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import de.sarocesch.plushie.client.SkinCacheManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class SkinTextureManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static SkinTextureManager instance;
    private final Map<String, ResourceLocation> loadedTextures = new ConcurrentHashMap<String, ResourceLocation>();
    private final Map<String, LoadStatus> loadingStatus = new ConcurrentHashMap<String, LoadStatus>();
    private final Map<String, Long> statusTimes = new ConcurrentHashMap<String, Long>();
    private final Set<String> loadingInProgress = ConcurrentHashMap.newKeySet();
    private static final long STATUS_DISPLAY_DURATION = 2000L;

    private SkinTextureManager() {
    }

    public static SkinTextureManager getInstance() {
        if (instance == null) {
            instance = new SkinTextureManager();
        }
        return instance;
    }

    public LoadStatus getLoadStatus(String skinUrl) {
        if (skinUrl == null || skinUrl.isEmpty()) {
            return null;
        }
        LoadStatus status = this.loadingStatus.get(skinUrl);
        if (status == null) {
            return null;
        }
        if (status == LoadStatus.LOADING) {
            return status;
        }
        Long setTime = this.statusTimes.get(skinUrl);
        if (setTime != null && System.currentTimeMillis() - setTime > 2000L) {
            this.loadingStatus.remove(skinUrl);
            this.statusTimes.remove(skinUrl);
            return null;
        }
        return status;
    }

    public boolean isLoading(String skinUrl) {
        return skinUrl != null && this.loadingInProgress.contains(skinUrl);
    }

    public ResourceLocation getOrLoadTexture(String skinUrl, String playerName) {
        if (skinUrl == null || skinUrl.isEmpty()) {
            return null;
        }
        if (this.loadedTextures.containsKey(skinUrl)) {
            return this.loadedTextures.get(skinUrl);
        }
        if (!this.loadingInProgress.contains(skinUrl)) {
            this.loadingInProgress.add(skinUrl);
            this.loadingStatus.put(skinUrl, LoadStatus.LOADING);
            this.statusTimes.put(skinUrl, System.currentTimeMillis());
            this.loadTextureAsync(skinUrl, playerName);
        }
        return null;
    }

    private void loadTextureAsync(String skinUrl, String playerName) {
        CompletableFuture.runAsync(() -> {
            try {
                NativeImage image = null;
                if (playerName != null && !playerName.isEmpty() && (image = SkinCacheManager.loadCachedSkin(playerName)) != null) {
                    LOGGER.debug("Loaded skin from disk cache for: {}", (Object)playerName);
                }
                if (image == null && (image = this.downloadImage(skinUrl)) != null && playerName != null && !playerName.isEmpty()) {
                    SkinCacheManager.saveSkinToCache(playerName, image);
                }
                if (image != null) {
                    NativeImage finalImage = image;
                    Minecraft.m_91087_().execute(() -> {
                        try {
                            DynamicTexture dynamicTexture = new DynamicTexture(finalImage);
                            ResourceLocation location = Minecraft.m_91087_().m_91097_().m_118490_("plushie_skin_" + skinUrl.hashCode(), dynamicTexture);
                            this.loadedTextures.put(skinUrl, location);
                            this.setStatus(skinUrl, LoadStatus.SUCCESS);
                            LOGGER.debug("Loaded skin texture for URL: {}", (Object)skinUrl);
                        }
                        catch (Exception e) {
                            this.setStatus(skinUrl, LoadStatus.FAILED);
                            LOGGER.warn("Failed to register skin texture: {}", (Object)e.getMessage());
                        }
                        finally {
                            this.loadingInProgress.remove(skinUrl);
                        }
                    });
                } else {
                    this.setStatus(skinUrl, LoadStatus.FAILED);
                    this.loadingInProgress.remove(skinUrl);
                }
            }
            catch (Exception e) {
                this.setStatus(skinUrl, LoadStatus.FAILED);
                this.loadingInProgress.remove(skinUrl);
                LOGGER.warn("Failed to download skin from {}: {}", (Object)skinUrl, (Object)e.getMessage());
            }
        });
    }

    private void setStatus(String skinUrl, LoadStatus status) {
        this.loadingStatus.put(skinUrl, status);
        this.statusTimes.put(skinUrl, System.currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NativeImage downloadImage(String urlString) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("User-Agent", "SarosPlushieMod/1.0");
            if (connection.getResponseCode() != 200) {
                return null;
            }
            try (InputStream inputStream = connection.getInputStream();){
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                if (bufferedImage == null) {
                    NativeImage nativeImage2 = null;
                    return nativeImage2;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "PNG", baos);
                byte[] bytes = baos.toByteArray();
                NativeImage nativeImage = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(bytes));
                return nativeImage;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error downloading image: {}", (Object)e.getMessage());
            return null;
        }
    }

    public void clearCache() {
        this.loadedTextures.values().forEach(location -> Minecraft.m_91087_().m_91097_().m_118513_(location));
        this.loadedTextures.clear();
        this.loadingInProgress.clear();
        this.loadingStatus.clear();
        this.statusTimes.clear();
    }

    public static enum LoadStatus {
        LOADING,
        SUCCESS,
        FAILED;

    }
}

