/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.menu;

import de.sarocesch.plushie.block.PlushieBlockEntity;
import de.sarocesch.plushie.registry.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class PlushieInventoryMenu
extends AbstractContainerMenu {
    private final PlushieBlockEntity blockEntity;
    private final ItemStackHandler handItemsHandler;
    private final Level level;
    private boolean initialized = false;
    public static final int MAIN_HAND_SLOT = 0;
    public static final int OFF_HAND_SLOT = 1;

    public PlushieInventoryMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, PlushieInventoryMenu.getBlockEntity(playerInventory, extraData));
    }

    public PlushieInventoryMenu(int containerId, Inventory playerInventory, final PlushieBlockEntity blockEntity) {
        super((MenuType)ModMenus.PLUSHIE_INVENTORY.get(), containerId);
        this.blockEntity = blockEntity;
        this.level = playerInventory.f_35978_.m_9236_();
        this.handItemsHandler = new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (PlushieInventoryMenu.this.initialized && !PlushieInventoryMenu.this.level.m_5776_()) {
                    blockEntity.setMainHandItem(this.getStackInSlot(0).m_41777_());
                    blockEntity.setOffHandItem(this.getStackInSlot(1).m_41777_());
                }
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        this.handItemsHandler.setStackInSlot(0, blockEntity.getMainHandItem().m_41777_());
        this.handItemsHandler.setStackInSlot(1, blockEntity.getOffHandItem().m_41777_());
        this.initialized = true;
        this.m_38897_((Slot)new DisableableHandSlot(this.handItemsHandler, 0, 97, 20, blockEntity));
        this.m_38897_((Slot)new DisableableHandSlot(this.handItemsHandler, 1, 61, 20, blockEntity));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 51 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 109));
        }
    }

    private static PlushieBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf extraData) {
        BlockPos pos = extraData.m_130135_();
        Level level = playerInventory.f_35978_.m_9236_();
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof PlushieBlockEntity) {
            PlushieBlockEntity plushieEntity = (PlushieBlockEntity)entity;
            return plushieEntity;
        }
        throw new IllegalStateException("BlockEntity at " + String.valueOf(pos) + " is not a PlushieBlockEntity!");
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!this.level.m_5776_()) {
            this.blockEntity.setMainHandItem(this.handItemsHandler.getStackInSlot(0).m_41777_());
            this.blockEntity.setOffHandItem(this.handItemsHandler.getStackInSlot(1).m_41777_());
        }
    }

    public PlushieBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public ItemStack m_7648_(Player player, int index) {
        if (!this.blockEntity.isHighRes() && index >= 2) {
            return ItemStack.f_41583_;
        }
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            result = stackInSlot.m_41777_();
            if (index < 2) {
                if (!this.m_38903_(stackInSlot, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (!this.blockEntity.isHighRes()) {
                    return ItemStack.f_41583_;
                }
                ItemStack singleItem = stackInSlot.m_41777_();
                singleItem.m_41764_(1);
                if (this.handItemsHandler.getStackInSlot(0).m_41619_()) {
                    this.handItemsHandler.setStackInSlot(0, singleItem);
                    stackInSlot.m_41774_(1);
                } else if (this.handItemsHandler.getStackInSlot(1).m_41619_()) {
                    this.handItemsHandler.setStackInSlot(1, singleItem);
                    stackInSlot.m_41774_(1);
                } else {
                    return ItemStack.f_41583_;
                }
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return result;
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity.m_58899_().m_203195_((Position)player.m_20182_(), 8.0);
    }

    static class DisableableHandSlot
    extends SlotItemHandler {
        private final PlushieBlockEntity blockEntity;

        public DisableableHandSlot(ItemStackHandler handler, int index, int x, int y, PlushieBlockEntity blockEntity) {
            super((IItemHandler)handler, index, x, y);
            this.blockEntity = blockEntity;
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return this.blockEntity.isHighRes() && super.m_5857_(stack);
        }

        public boolean m_8010_(Player player) {
            return this.blockEntity.isHighRes() && super.m_8010_(player);
        }

        public boolean m_6659_() {
            return this.blockEntity.isHighRes();
        }
    }
}

