/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.network;

import de.sarocesch.plushie.block.PlushieBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ItemPositionPacket {
    private final BlockPos pos;
    private final float mainOffX;
    private final float mainOffY;
    private final float mainOffZ;
    private final float mainRotX;
    private final float mainRotY;
    private final float mainRotZ;
    private final float offOffX;
    private final float offOffY;
    private final float offOffZ;
    private final float offRotX;
    private final float offRotY;
    private final float offRotZ;

    public ItemPositionPacket(BlockPos pos, float mainOffX, float mainOffY, float mainOffZ, float mainRotX, float mainRotY, float mainRotZ, float offOffX, float offOffY, float offOffZ, float offRotX, float offRotY, float offRotZ) {
        this.pos = pos;
        this.mainOffX = mainOffX;
        this.mainOffY = mainOffY;
        this.mainOffZ = mainOffZ;
        this.mainRotX = mainRotX;
        this.mainRotY = mainRotY;
        this.mainRotZ = mainRotZ;
        this.offOffX = offOffX;
        this.offOffY = offOffY;
        this.offOffZ = offOffZ;
        this.offRotX = offRotX;
        this.offRotY = offRotY;
        this.offRotZ = offRotZ;
    }

    public static void encode(ItemPositionPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeFloat(msg.mainOffX);
        buf.writeFloat(msg.mainOffY);
        buf.writeFloat(msg.mainOffZ);
        buf.writeFloat(msg.mainRotX);
        buf.writeFloat(msg.mainRotY);
        buf.writeFloat(msg.mainRotZ);
        buf.writeFloat(msg.offOffX);
        buf.writeFloat(msg.offOffY);
        buf.writeFloat(msg.offOffZ);
        buf.writeFloat(msg.offRotX);
        buf.writeFloat(msg.offRotY);
        buf.writeFloat(msg.offRotZ);
    }

    public static ItemPositionPacket decode(FriendlyByteBuf buf) {
        return new ItemPositionPacket(buf.m_130135_(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public static void handle(ItemPositionPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            if (!msg.pos.m_203195_((Position)player.m_20182_(), 8.0)) {
                return;
            }
            BlockEntity entity = player.m_9236_().m_7702_(msg.pos);
            if (entity instanceof PlushieBlockEntity) {
                PlushieBlockEntity plushie = (PlushieBlockEntity)entity;
                plushie.setMainHandItemPosition(msg.mainOffX, msg.mainOffY, msg.mainOffZ, msg.mainRotX, msg.mainRotY, msg.mainRotZ);
                plushie.setOffHandItemPosition(msg.offOffX, msg.offOffY, msg.offOffZ, msg.offRotX, msg.offRotY, msg.offRotZ);
            }
        });
        ctx.setPacketHandled(true);
    }
}

