/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.plushie.network;

import de.sarocesch.plushie.block.PlushieBlockEntity;
import de.sarocesch.plushie.menu.PlushieInventoryMenu;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class OpenInventoryPacket {
    private final BlockPos pos;

    public OpenInventoryPacket(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(OpenInventoryPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
    }

    public static OpenInventoryPacket decode(FriendlyByteBuf buf) {
        return new OpenInventoryPacket(buf.m_130135_());
    }

    public static void handle(OpenInventoryPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            if (!msg.pos.m_203195_((Position)player.m_20182_(), 8.0)) {
                return;
            }
            BlockEntity entity = player.m_9236_().m_7702_(msg.pos);
            if (entity instanceof PlushieBlockEntity) {
                final PlushieBlockEntity plushieEntity = (PlushieBlockEntity)entity;
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237115_((String)"gui.sarosplayerplushiemod.plushie_inventory");
                    }

                    public AbstractContainerMenu m_7208_(int containerId, Inventory inv, Player p) {
                        return new PlushieInventoryMenu(containerId, inv, plushieEntity);
                    }
                }, (BlockPos)msg.pos);
            }
        });
        ctx.setPacketHandled(true);
    }
}

